/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webclient.api;

import io.helidon.common.uri.UriFragment;
import io.helidon.common.uri.UriInfo;
import io.helidon.common.uri.UriPath;
import io.helidon.common.uri.UriQuery;
import io.helidon.common.uri.UriQueryWriteable;
import java.net.URI;

public class ClientUri
implements UriInfo {
    private final UriInfo base;
    private final UriQueryWriteable query;
    private UriInfo.Builder uriBuilder;
    private boolean skipUriEncoding = false;

    private ClientUri() {
        this.base = null;
        this.query = UriQueryWriteable.create();
        this.uriBuilder = UriInfo.builder();
    }

    private ClientUri(ClientUri baseUri) {
        this.base = baseUri;
        this.uriBuilder = UriInfo.builder((UriInfo)this.base);
        this.skipUriEncoding = baseUri.skipUriEncoding;
        this.query = UriQueryWriteable.create().from(baseUri.query());
    }

    private ClientUri(UriInfo baseUri) {
        this.base = baseUri;
        this.uriBuilder = UriInfo.builder((UriInfo)baseUri);
        this.skipUriEncoding = false;
        this.query = UriQueryWriteable.create().from(baseUri.query());
    }

    public static ClientUri create() {
        return new ClientUri();
    }

    public static ClientUri create(ClientUri baseUri) {
        return new ClientUri(baseUri);
    }

    public static ClientUri create(UriInfo baseUri) {
        return new ClientUri(baseUri);
    }

    public static ClientUri create(URI baseUri) {
        return ClientUri.create().resolve(baseUri);
    }

    public String toString() {
        UriInfo info = ((UriInfo.Builder)this.uriBuilder.query((UriQuery)this.query)).build();
        String encodedPath = this.pathWithQueryAndFragment();
        return info.scheme() + "://" + info.authority() + (encodedPath.startsWith("/") ? "" : "/") + encodedPath;
    }

    public URI toUri() {
        UriInfo info = this.uriBuilder.build();
        return URI.create(info.scheme() + "://" + info.authority() + this.pathWithQueryAndFragment());
    }

    public ClientUri scheme(String scheme) {
        this.uriBuilder.scheme(scheme);
        return this;
    }

    public ClientUri host(String host) {
        this.uriBuilder.host(host);
        return this;
    }

    public ClientUri port(int port) {
        this.uriBuilder.port(port);
        return this;
    }

    public ClientUri path(String path) {
        this.uriBuilder.path(this.extractQuery(path));
        return this;
    }

    public ClientUri skipUriEncoding(boolean skipUriEncoding) {
        this.skipUriEncoding = skipUriEncoding;
        return this;
    }

    public ClientUri resolve(URI uri) {
        if (uri.isAbsolute()) {
            this.uriBuilder = UriInfo.builder();
            this.query.clear();
        }
        if (uri.getScheme() != null) {
            this.uriBuilder.scheme(uri.getScheme());
        }
        if (uri.getHost() != null) {
            this.uriBuilder.host(uri.getHost());
        }
        if (uri.getPort() != -1) {
            this.uriBuilder.port(uri.getPort());
        }
        this.uriBuilder.path(this.resolvePath(this.uriBuilder.path().path(), uri.getPath()));
        String queryString = uri.getRawQuery();
        if (queryString != null) {
            this.query.fromQueryString(queryString.replaceAll("\\+", "%20"));
        }
        if (uri.getRawFragment() != null) {
            this.uriBuilder.fragment(UriFragment.create((String)uri.getRawFragment()));
        }
        return this;
    }

    public ClientUri resolvePath(String path) {
        this.uriBuilder.path(this.resolvePath(this.uriBuilder.path().path(), path));
        return this;
    }

    public ClientUri resolve(ClientUri uri) {
        this.uriBuilder.from((UriInfo)uri);
        return this;
    }

    public String scheme() {
        return this.uriBuilder.scheme();
    }

    public String host() {
        return this.uriBuilder.host();
    }

    public UriQuery query() {
        return this.query;
    }

    public UriFragment fragment() {
        return this.uriBuilder.fragment();
    }

    public String authority() {
        return this.uriBuilder.build().authority();
    }

    public int port() {
        return this.uriBuilder.build().port();
    }

    public UriPath path() {
        return this.uriBuilder.path();
    }

    public ClientUri fragment(UriFragment fragment) {
        this.uriBuilder.fragment(fragment);
        return this;
    }

    public ClientUri fragment(String fragment) {
        return this.fragment(UriFragment.createFromDecoded((String)fragment));
    }

    public UriQueryWriteable writeableQuery() {
        return this.query;
    }

    public String pathWithQueryAndFragment() {
        boolean hasQuery;
        UriInfo info = ((UriInfo.Builder)this.uriBuilder.query((UriQuery)this.query)).build();
        String queryString = this.skipUriEncoding ? info.query().value() : info.query().rawValue();
        Object path = this.skipUriEncoding ? info.path().path() : info.path().rawPath();
        boolean bl = hasQuery = !queryString.isEmpty();
        if (((String)path).isEmpty()) {
            path = "/";
        }
        if (hasQuery) {
            path = (String)path + "?" + queryString;
        }
        if (info.fragment().hasValue()) {
            String fragmentValue = this.skipUriEncoding ? info.fragment().value() : info.fragment().rawValue();
            path = (String)path + "#" + fragmentValue;
        }
        return path;
    }

    private String extractQuery(String path) {
        int i;
        if (path != null && (i = path.indexOf(63)) > -1) {
            String queryString = path.substring(i + 1);
            this.query.fromQueryString(queryString);
            path = path.substring(0, i);
        }
        return path;
    }

    private String resolvePath(String path, String resolvePath) {
        boolean pathStartsWith;
        if (resolvePath == null) {
            return path;
        }
        if (resolvePath.isEmpty()) {
            return path;
        }
        if (path == null) {
            return resolvePath;
        }
        boolean pathEndsWith = !path.isEmpty() && path.charAt(path.length() - 1) == '/';
        boolean bl = pathStartsWith = resolvePath.charAt(0) == '/';
        if (pathEndsWith && pathStartsWith) {
            return path + String.valueOf(resolvePath.subSequence(1, resolvePath.length()));
        }
        if (pathEndsWith || pathStartsWith) {
            return path + resolvePath;
        }
        if (path.isEmpty()) {
            return resolvePath;
        }
        return path + "/" + resolvePath;
    }
}

