/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webclient.api;

import io.helidon.common.buffers.BufferData;
import io.helidon.common.buffers.DataReader;
import io.helidon.common.buffers.DataWriter;
import io.helidon.common.socket.HelidonSocket;
import io.helidon.common.socket.PlainSocket;
import io.helidon.common.socket.TlsSocket;
import io.helidon.common.tls.Tls;
import io.helidon.webclient.api.ClientConnection;
import io.helidon.webclient.api.ConnectionKey;
import io.helidon.webclient.api.WebClient;
import io.helidon.webclient.api.WebClientConfig;
import io.helidon.webclient.spi.DnsResolver;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.util.HexFormat;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;

public class TcpClientConnection
implements ClientConnection {
    private static final System.Logger LOGGER = System.getLogger(TcpClientConnection.class.getName());
    private final WebClient webClient;
    private final ConnectionKey connectionKey;
    private final List<String> tcpProtocolIds;
    private final Function<TcpClientConnection, Boolean> releaseFunction;
    private final Consumer<TcpClientConnection> closeConsumer;
    private String channelId;
    private Socket socket;
    private HelidonSocket helidonSocket;
    private DataReader reader;
    private DataWriter writer;
    private boolean closed;
    private boolean allowExpectContinue = true;

    private TcpClientConnection(WebClient webClient, ConnectionKey connectionKey, List<String> tcpProtocolIds, Function<TcpClientConnection, Boolean> releaseFunction, Consumer<TcpClientConnection> closeConsumer) {
        this.webClient = webClient;
        this.connectionKey = connectionKey;
        this.tcpProtocolIds = tcpProtocolIds;
        this.releaseFunction = releaseFunction;
        this.closeConsumer = closeConsumer;
    }

    public static TcpClientConnection create(WebClient webClient, ConnectionKey connectionKey, List<String> tcpProtocolIds, Function<TcpClientConnection, Boolean> releaseFunction, Consumer<TcpClientConnection> closeConsumer) {
        return new TcpClientConnection(webClient, connectionKey, tcpProtocolIds, releaseFunction, closeConsumer);
    }

    public TcpClientConnection connect() {
        Tls tls = this.connectionKey.tls();
        InetSocketAddress targetAddress = this.inetSocketAddress();
        this.socket = this.connectionKey.proxy().tcpSocket(this.webClient, targetAddress, ((WebClientConfig)this.webClient.prototype()).socketOptions(), tls.enabled());
        this.channelId = this.createChannelId(this.socket);
        if (LOGGER.isLoggable(System.Logger.Level.DEBUG)) {
            LOGGER.log(System.Logger.Level.DEBUG, String.format("[client %s] client connected %s:%d %s", this.channelId, this.socket.getLocalAddress().getHostAddress(), this.socket.getLocalPort(), Thread.currentThread().getName()));
        }
        if (tls.enabled()) {
            SSLSocket sslSocket = tls.createSocket(this.tcpProtocolIds, this.socket, targetAddress);
            try {
                sslSocket.startHandshake();
            }
            catch (IOException e) {
                try {
                    sslSocket.close();
                }
                catch (IOException ex) {
                    e.addSuppressed(ex);
                }
                throw new UncheckedIOException("Failed to execute SSL handshake", e);
            }
            if (LOGGER.isLoggable(System.Logger.Level.TRACE)) {
                this.debugTls(sslSocket);
            }
            this.helidonSocket = TlsSocket.client((SSLSocket)sslSocket, (String)this.channelId);
        } else {
            this.helidonSocket = PlainSocket.client((Socket)this.socket, (String)this.channelId);
        }
        this.reader = new DataReader((Supplier)this.helidonSocket);
        this.writer = new DirectDatatWriter(this.helidonSocket);
        return this;
    }

    @Override
    public DataReader reader() {
        if (this.closed) {
            throw new IllegalStateException("Attempt to call reader() on a closed connection");
        }
        if (this.reader == null) {
            throw new IllegalStateException("Attempt to call reader() on a connection that is not connected");
        }
        return this.reader;
    }

    @Override
    public DataWriter writer() {
        if (this.closed) {
            throw new IllegalStateException("Attempt to call writer() on a closed connection");
        }
        if (this.writer == null) {
            throw new IllegalStateException("Attempt to call writer() on a connection that is not connected");
        }
        return this.writer;
    }

    @Override
    public void releaseResource() {
        if (this.closed) {
            return;
        }
        if (!this.releaseFunction.apply(this).booleanValue()) {
            this.closeResource();
        }
    }

    @Override
    public void closeResource() {
        if (this.closed) {
            return;
        }
        try {
            this.socket.close();
        }
        catch (IOException e) {
            LOGGER.log(System.Logger.Level.TRACE, "Failed to close a client socket", (Throwable)e);
        }
        this.closed = true;
        this.closeConsumer.accept(this);
    }

    @Override
    public String channelId() {
        if (this.channelId == null) {
            return "not-connected";
        }
        return this.channelId;
    }

    @Override
    public void readTimeout(Duration readTimeout) {
        if (this.closed) {
            throw new IllegalStateException("Attempt to call readTimeout(Duration) on a closed connection");
        }
        if (this.socket == null) {
            throw new IllegalStateException("Attempt to call readTimeout(Duration) on a connection that is not connected");
        }
        try {
            this.socket.setSoTimeout((int)readTimeout.toMillis());
        }
        catch (SocketException e) {
            throw new UncheckedIOException("Could not set read timeout to the connection with the channel id: " + this.channelId, e);
        }
    }

    @Override
    public HelidonSocket helidonSocket() {
        return this.helidonSocket;
    }

    public boolean isConnected() {
        return this.socket != null && this.socket.isConnected() && this.helidonSocket().isConnected();
    }

    @Override
    public boolean allowExpectContinue() {
        return this.allowExpectContinue;
    }

    @Override
    public void allowExpectContinue(boolean allowExpectContinue) {
        this.allowExpectContinue = allowExpectContinue;
    }

    Socket socket() {
        return this.socket;
    }

    private String createChannelId(Socket socket) {
        return "0x" + HexFormat.of().toHexDigits(System.identityHashCode(socket));
    }

    private InetSocketAddress inetSocketAddress() {
        DnsResolver dnsResolver = this.connectionKey.dnsResolver();
        InetAddress address = dnsResolver.resolveAddress(this.connectionKey.host(), this.connectionKey.dnsAddressLookup());
        return new InetSocketAddress(address, this.connectionKey.port());
    }

    private void debugTls(SSLSocket sslSocket) {
        SSLSession sslSession = sslSocket.getSession();
        if (sslSession == null) {
            LOGGER.log(System.Logger.Level.TRACE, "No SSL session");
            return;
        }
        String msg = "[client " + this.channelId + "] TLS negotiated:\nApplication protocol: " + sslSocket.getApplicationProtocol() + "\nHandshake application protocol: " + sslSocket.getHandshakeApplicationProtocol() + "\nProtocol: " + sslSession.getProtocol() + "\nCipher Suite: " + sslSession.getCipherSuite() + "\nPeer host: " + sslSession.getPeerHost() + "\nPeer port: " + sslSession.getPeerPort() + "\nApplication buffer size: " + sslSession.getApplicationBufferSize() + "\nPacket buffer size: " + sslSession.getPacketBufferSize() + "\nLocal principal: " + String.valueOf(sslSession.getLocalPrincipal()) + "\n";
        try {
            msg = msg + "Peer principal: " + String.valueOf(sslSession.getPeerPrincipal()) + "\n";
            msg = msg + "Peer certs: " + this.certsToString(sslSession.getPeerCertificates()) + "\n";
        }
        catch (SSLPeerUnverifiedException e) {
            msg = msg + "Peer not verified";
        }
        LOGGER.log(System.Logger.Level.TRACE, msg);
    }

    private String certsToString(Certificate[] peerCertificates) {
        CharSequence[] certs = new String[peerCertificates.length];
        for (int i = 0; i < peerCertificates.length; ++i) {
            Certificate peerCertificate = peerCertificates[i];
            if (peerCertificate instanceof X509Certificate) {
                X509Certificate x509 = (X509Certificate)peerCertificate;
                certs[i] = "type=" + peerCertificate.getType() + ";key=" + peerCertificate.getPublicKey().getAlgorithm() + "(" + peerCertificate.getPublicKey().getFormat() + ");x509=V" + x509.getVersion() + ";from=" + String.valueOf(x509.getNotBefore()) + ";to=" + String.valueOf(x509.getNotAfter()) + ";serial=" + x509.getSerialNumber().toString(16);
                continue;
            }
            certs[i] = "type=" + peerCertificate.getType() + ";key=" + String.valueOf(peerCertificate.getPublicKey());
        }
        return String.join((CharSequence)", ", certs);
    }

    private static class DirectDatatWriter
    implements DataWriter {
        private final HelidonSocket helidonSocket;

        DirectDatatWriter(HelidonSocket helidonSocket) {
            this.helidonSocket = helidonSocket;
        }

        public void write(BufferData ... buffers) {
            this.writeNow(buffers);
        }

        public void write(BufferData buffer) {
            this.writeNow(buffer);
        }

        public void writeNow(BufferData ... buffers) {
            for (BufferData buffer : buffers) {
                this.writeNow(buffer);
            }
        }

        public void writeNow(BufferData buffer) {
            this.helidonSocket.write(buffer);
        }
    }
}

