/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webclient.api;

import io.helidon.builder.api.Option;
import io.helidon.builder.api.Prototype;
import io.helidon.common.config.Config;
import io.helidon.common.media.type.ParserMode;
import io.helidon.common.socket.SocketOptions;
import io.helidon.common.uri.UriFragment;
import io.helidon.common.uri.UriQuery;
import io.helidon.http.ClientRequestHeaders;
import io.helidon.http.Header;
import io.helidon.http.WritableHeaders;
import io.helidon.http.encoding.ContentEncodingContext;
import io.helidon.http.media.MediaContext;
import io.helidon.http.media.MediaSupport;
import io.helidon.webclient.api.ClientUri;
import io.helidon.webclient.api.DnsAddressLookup;
import io.helidon.webclient.api.HttpClientConfigSupport;
import io.helidon.webclient.api.HttpConfigBaseBlueprint;
import io.helidon.webclient.api.WebClientCookieManager;
import io.helidon.webclient.spi.DnsResolver;
import io.helidon.webclient.spi.WebClientService;
import io.helidon.webclient.spi.WebClientServiceProvider;
import java.net.URI;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;

@Prototype.Configured
@Prototype.Blueprint(decorator=HttpClientConfigSupport.HttpBuilderDecorator.class)
@Prototype.CustomMethods(value=HttpClientConfigSupport.HttpCustomMethods.class)
interface HttpClientConfigBlueprint
extends HttpConfigBaseBlueprint {
    @Prototype.FactoryMethod
    public static ClientUri createBaseUri(Config config) {
        return (ClientUri)config.as(URI.class).map(ClientUri::create).orElseThrow();
    }

    @Option.Configured
    public Optional<ClientUri> baseUri();

    public Optional<UriQuery> baseQuery();

    public Optional<UriFragment> baseFragment();

    @Option.Configured
    public SocketOptions socketOptions();

    public DnsResolver dnsResolver();

    public DnsAddressLookup dnsAddressLookup();

    @Option.Configured(value="default-headers")
    public Map<String, String> defaultHeadersMap();

    @Option.Singular
    public Set<Header> headers();

    default public ClientRequestHeaders defaultRequestHeaders() {
        WritableHeaders headers = WritableHeaders.create();
        this.headers().forEach(arg_0 -> ((WritableHeaders)headers).set(arg_0));
        return ClientRequestHeaders.create((WritableHeaders)headers);
    }

    @Option.Configured
    @Option.Default(value={"STRICT"})
    public ParserMode mediaTypeParserMode();

    @Option.Configured
    public ContentEncodingContext contentEncoding();

    @Option.Configured
    @Option.Default(value={"create()"})
    public MediaContext mediaContext();

    @Option.Singular
    public List<MediaSupport> mediaSupports();

    @Option.Singular
    @Option.Configured
    @Option.Provider(value=WebClientServiceProvider.class)
    public List<WebClientService> services();

    @Option.Configured
    @Option.DefaultBoolean(value={false})
    public boolean relativeUris();

    public ExecutorService executor();

    @Option.Configured
    @Option.DefaultBoolean(value={true})
    public boolean sendExpectContinue();

    @Option.Configured
    @Option.DefaultInt(value={256})
    public int connectionCacheSize();

    @Option.Configured
    public Optional<WebClientCookieManager> cookieManager();

    @Option.Configured
    @Option.Default(value={"PT1S"})
    public Duration readContinueTimeout();

    @Option.Configured
    @Option.DefaultBoolean(value={true})
    public boolean shareConnectionCache();

    @Option.Configured
    @Option.DefaultInt(value={131072})
    public int maxInMemoryEntity();
}

