/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webclient.api;

import io.helidon.common.configurable.LruCache;
import io.helidon.common.socket.HelidonSocket;
import io.helidon.common.tls.Tls;
import io.helidon.http.Method;
import io.helidon.webclient.api.ClientRequest;
import io.helidon.webclient.api.ClientRequestBase;
import io.helidon.webclient.api.ClientUri;
import io.helidon.webclient.api.ConnectionKey;
import io.helidon.webclient.api.HttpClientResponse;
import io.helidon.webclient.api.LoomClient;
import io.helidon.webclient.api.Proxy;
import io.helidon.webclient.api.TcpClientConnection;
import io.helidon.webclient.api.WebClient;
import io.helidon.webclient.api.WebClientConfig;
import io.helidon.webclient.spi.HttpClientSpi;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class HttpClientRequest
extends ClientRequestBase<HttpClientRequest, HttpClientResponse> {
    private static final System.Logger LOGGER = System.getLogger(HttpClientRequest.class.getName());
    private final LruCache<EndpointKey, HttpClientSpi> clientSpiCache = LruCache.create();
    private final WebClient webClient;
    private final Map<String, LoomClient.ProtocolSpi> clients;
    private final List<LoomClient.ProtocolSpi> tcpProtocols;
    private final List<String> tcpProtocolIds;
    private final List<LoomClient.ProtocolSpi> protocols;
    private String preferredProtocolId;

    HttpClientRequest(WebClient webClient, WebClientConfig clientConfig, Method method, ClientUri clientUri, Map<String, LoomClient.ProtocolSpi> protocolsToClients, List<LoomClient.ProtocolSpi> protocols, List<LoomClient.ProtocolSpi> tcpProtocols, List<String> tcpProtocolIds) {
        super(clientConfig, webClient.cookieManager(), "any", method, clientUri, clientConfig.properties());
        this.webClient = webClient;
        this.clients = protocolsToClients;
        this.protocols = protocols;
        this.tcpProtocols = tcpProtocols;
        this.tcpProtocolIds = tcpProtocolIds;
    }

    public HttpClientRequest protocolId(String protocol) {
        this.preferredProtocolId = protocol;
        return this;
    }

    @Override
    protected HttpClientResponse doSubmit(Object entity) {
        return this.discoverHttpImplementation().submit(entity);
    }

    @Override
    protected HttpClientResponse doOutputStream(ClientRequest.OutputStreamHandler outputStreamConsumer) {
        return this.discoverHttpImplementation().outputStream(outputStreamConsumer);
    }

    /*
     * Enabled aggressive block sorting
     */
    private ClientRequest<?> discoverHttpImplementation() {
        ClientUri resolvedUri = this.resolvedUri();
        if (this.preferredProtocolId != null) {
            LoomClient.ProtocolSpi httpClientSpi = this.clients.get(this.preferredProtocolId);
            if (httpClientSpi == null) {
                throw new IllegalArgumentException("Requested protocol with id \"" + this.preferredProtocolId + "\", which is not available on classpath. Available protocols: " + String.valueOf(this.clients.keySet()));
            }
            return httpClientSpi.spi().clientRequest(this, resolvedUri);
        }
        EndpointKey endpointKey = new EndpointKey(resolvedUri.scheme(), resolvedUri.authority(), this.tls(), this.proxy());
        Optional spi = this.clientSpiCache.get((Object)endpointKey);
        if (spi.isPresent()) {
            return ((HttpClientSpi)spi.get()).clientRequest(this, resolvedUri);
        }
        HttpClientSpi compatible = null;
        HttpClientSpi unknown = null;
        for (LoomClient.ProtocolSpi protocol : this.protocols) {
            HttpClientSpi client = protocol.spi();
            HttpClientSpi.SupportLevel supports = client.supports(this, resolvedUri);
            if (supports == HttpClientSpi.SupportLevel.SUPPORTED) {
                this.clientSpiCache.put((Object)endpointKey, (Object)client);
                return client.clientRequest(this, resolvedUri);
            }
            if (supports == HttpClientSpi.SupportLevel.COMPATIBLE && compatible == null) {
                compatible = client;
            }
            if (supports != HttpClientSpi.SupportLevel.UNKNOWN || unknown != null) continue;
            unknown = client;
        }
        if ("https".equals(resolvedUri.scheme()) && this.tls().enabled() && !this.tcpProtocols.isEmpty()) {
            ConnectionKey connectionKey = new ConnectionKey(resolvedUri.scheme(), resolvedUri.host(), resolvedUri.port(), this.tls(), this.clientConfig().dnsResolver(), this.clientConfig().dnsAddressLookup(), this.proxy());
            TcpClientConnection connection = TcpClientConnection.create(this.webClient, connectionKey, this.tcpProtocolIds, conn -> true, conn -> {});
            connection.connect();
            HelidonSocket socket = connection.helidonSocket();
            if (socket.protocolNegotiated()) {
                String negotiatedProtocol = socket.protocol();
                LoomClient.ProtocolSpi protocolSpi = this.clients.get(negotiatedProtocol);
                if (protocolSpi != null) {
                    this.clientSpiCache.put((Object)endpointKey, (Object)protocolSpi.spi());
                    this.connection(connection);
                    return protocolSpi.spi().clientRequest(this, resolvedUri);
                }
                if (LOGGER.isLoggable(System.Logger.Level.TRACE)) {
                    LOGGER.log(System.Logger.Level.TRACE, "Attempted to negotiate a protocol (" + String.valueOf(this.tcpProtocolIds) + "), but got an unsupported protocol back: " + negotiatedProtocol);
                }
                connection.closeResource();
            } else {
                if (LOGGER.isLoggable(System.Logger.Level.TRACE)) {
                    LOGGER.log(System.Logger.Level.TRACE, "Attempted to negotiate a protocol (" + String.valueOf(this.tcpProtocolIds) + "), but did not get a negotiated protocol back, ignoring.");
                }
                connection.closeResource();
            }
        }
        if (compatible != null) {
            this.clientSpiCache.put((Object)endpointKey, compatible);
            return compatible.clientRequest(this, resolvedUri);
        }
        if (unknown != null) {
            return unknown.clientRequest(this, resolvedUri);
        }
        throw new IllegalArgumentException("Cannot handle request to " + String.valueOf(resolvedUri) + ", did not discover any HTTP version willing to handle it. HTTP versions supported: " + String.valueOf(this.clients.keySet()));
    }

    private record EndpointKey(String scheme, String authority, Tls tlsConfig, Proxy proxy) {
    }
}

