/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webclient.api;

import io.helidon.common.LazyValue;
import io.helidon.webclient.api.DnsAddressLookup;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;

final class DefaultAddressLookupFinder {
    private static final System.Logger LOGGER = System.getLogger(DefaultAddressLookupFinder.class.getName());
    private static final LazyValue<Boolean> IPV4_PREFERRED = LazyValue.create(() -> Boolean.getBoolean("java.net.preferIPv4Stack"));
    private static final LazyValue<Boolean> IPV6_PREFERRED = LazyValue.create(() -> Boolean.getBoolean("java.net.preferIPv6Addresses"));
    private static final LazyValue<DnsAddressLookup> DEFAULT_IP_VERSION = LazyValue.create(() -> {
        if (((Boolean)IPV4_PREFERRED.get()).booleanValue() || !DefaultAddressLookupFinder.anyInterfaceSupportsIpV6()) {
            return DnsAddressLookup.IPV4;
        }
        if (((Boolean)IPV6_PREFERRED.get()).booleanValue()) {
            return DnsAddressLookup.IPV6_PREFERRED;
        }
        return DnsAddressLookup.IPV4_PREFERRED;
    });

    private DefaultAddressLookupFinder() {
        throw new IllegalStateException("This class should not be instantiated");
    }

    static DnsAddressLookup defaultDnsAddressLookup() {
        return (DnsAddressLookup)((Object)DEFAULT_IP_VERSION.get());
    }

    private static boolean anyInterfaceSupportsIpV6() {
        block4: {
            try {
                Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
                while (interfaces.hasMoreElements()) {
                    NetworkInterface networkInterface = interfaces.nextElement();
                    Enumeration<InetAddress> addresses = networkInterface.getInetAddresses();
                    while (addresses.hasMoreElements()) {
                        InetAddress inetAddress = addresses.nextElement();
                        if (!(inetAddress instanceof Inet6Address) || inetAddress.isAnyLocalAddress() || inetAddress.isLoopbackAddress() || inetAddress.isLinkLocalAddress()) continue;
                        return true;
                    }
                }
            }
            catch (SocketException ignore) {
                if (!LOGGER.isLoggable(System.Logger.Level.INFO)) break block4;
                LOGGER.log(System.Logger.Level.INFO, "Unable to detect if any interface supports IPv6, assuming IPv4-only", (Throwable)ignore);
            }
        }
        return false;
    }
}

