/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.openapi;

import io.helidon.common.LazyValue;
import io.helidon.microprofile.openapi.ExpandedTypeDescription;
import io.helidon.microprofile.openapi.SnakeYAMLParserHelper;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.microprofile.openapi.models.Operation;
import org.eclipse.microprofile.openapi.models.PathItem;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.eclipse.microprofile.openapi.models.servers.ServerVariable;
import org.yaml.snakeyaml.introspector.Property;
import org.yaml.snakeyaml.introspector.PropertySubstitute;

final class OpenApiHelper {
    @Deprecated(since="4.3.2", forRemoval=true)
    private static final String WARNINGS_ENABLED_PROPERTY_NAME = "openapi.parsing.warnings.enabled";
    private static final System.Logger LOGGER = System.getLogger(OpenApiHelper.class.getName());
    @Deprecated(since="4.3.2", forRemoval=true)
    private static final Logger SNAKE_YAML_INTROSPECTOR_LOGGER = Logger.getLogger(PropertySubstitute.class.getPackage().getName());
    private static final LazyValue<OpenApiHelper> INSTANCE = LazyValue.create(OpenApiHelper::new);
    private final SnakeYAMLParserHelper<ExpandedTypeDescription> generatedHelper;

    private OpenApiHelper() {
        OpenApiHelper.suppressWarningsIfRequested();
        this.generatedHelper = SnakeYAMLParserHelper.create(ExpandedTypeDescription::create);
        OpenApiHelper.adjustTypeDescriptions(this.generatedHelper.types());
    }

    static Map<Class<?>, ExpandedTypeDescription> types() {
        return ((OpenApiHelper)OpenApiHelper.INSTANCE.get()).generatedHelper.types();
    }

    @Deprecated(since="4.3.2", forRemoval=true)
    private static void suppressWarningsIfRequested() {
        String warningsEnabledText = System.getProperty(WARNINGS_ENABLED_PROPERTY_NAME);
        if (warningsEnabledText != null) {
            LOGGER.log(System.Logger.Level.INFO, String.format("Use of the property %s  + \" is deprecated. Helidon logs parsing warnings by default but honors the property setting.", WARNINGS_ENABLED_PROPERTY_NAME));
            boolean warningsEnabled = Boolean.parseBoolean(warningsEnabledText);
            if (SNAKE_YAML_INTROSPECTOR_LOGGER.isLoggable(Level.WARNING) && !warningsEnabled) {
                SNAKE_YAML_INTROSPECTOR_LOGGER.setLevel(Level.SEVERE);
            }
        }
    }

    private static void adjustTypeDescriptions(Map<Class<?>, ExpandedTypeDescription> types) {
        ExpandedTypeDescription pathItemTD = types.get(PathItem.class);
        for (PathItem.HttpMethod m : PathItem.HttpMethod.values()) {
            pathItemTD.substituteProperty(m.name().toLowerCase(), Operation.class, OpenApiHelper.getter(m), OpenApiHelper.setter(m), new Class[0]);
            pathItemTD.addExcludes(m.name());
        }
        Set.of(Schema.class, ServerVariable.class).forEach(c -> {
            ExpandedTypeDescription tdWithEnumeration = (ExpandedTypeDescription)((Object)((Object)types.get(c)));
            tdWithEnumeration.substituteProperty("enum", List.class, "getEnumeration", "setEnumeration", new Class[0]);
            tdWithEnumeration.addPropertyParameters("enum", new Class[]{String.class});
            tdWithEnumeration.addExcludes("enumeration");
        });
        for (ExpandedTypeDescription td : types.values()) {
            Property defaultProperty = td.defaultProperty();
            if (defaultProperty == null) continue;
            td.substituteProperty("default", defaultProperty.getType(), "getDefaultValue", "setDefaultValue", new Class[0]);
            td.addExcludes("defaultValue");
        }
    }

    private static String getter(PathItem.HttpMethod method) {
        return OpenApiHelper.methodName("get", method);
    }

    private static String setter(PathItem.HttpMethod method) {
        return OpenApiHelper.methodName("set", method);
    }

    private static String methodName(String operation, PathItem.HttpMethod method) {
        return operation + method.name();
    }
}

