/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.openapi;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Generated;
import io.helidon.common.config.Config;
import io.helidon.common.config.ConfigBuilderSupport;
import io.helidon.microprofile.openapi.MpOpenApiManagerConfigBlueprint;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

@Generated(value="io.helidon.builder.codegen.BuilderCodegen", trigger="io.helidon.microprofile.openapi.MpOpenApiManagerConfigBlueprint")
public interface MpOpenApiManagerConfig
extends MpOpenApiManagerConfigBlueprint,
Prototype.Api {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(MpOpenApiManagerConfig instance) {
        return (Builder)MpOpenApiManagerConfig.builder().from(instance);
    }

    public static MpOpenApiManagerConfig create(Config config) {
        return ((Builder)MpOpenApiManagerConfig.builder().config(config)).buildPrototype();
    }

    public static MpOpenApiManagerConfig create() {
        return MpOpenApiManagerConfig.builder().buildPrototype();
    }

    public static class Builder
    extends BuilderBase<Builder, MpOpenApiManagerConfig>
    implements io.helidon.common.Builder<Builder, MpOpenApiManagerConfig> {
        private Builder() {
        }

        public MpOpenApiManagerConfig buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.MpOpenApiManagerConfigImpl(this);
        }

        public MpOpenApiManagerConfig build() {
            return this.buildPrototype();
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends MpOpenApiManagerConfig>
    implements ConfigBuilderSupport.ConfiguredBuilder<BUILDER, PROTOTYPE> {
        private final List<String> indexPaths = new ArrayList<String>(List.of("META-INF/jandex.idx"));
        private boolean isIndexPathsMutated;
        private boolean useJaxRsSemantics;
        private Config config;

        protected BuilderBase() {
        }

        public BUILDER from(MpOpenApiManagerConfig prototype) {
            this.useJaxRsSemantics(prototype.useJaxRsSemantics());
            if (!this.isIndexPathsMutated) {
                this.indexPaths.clear();
            }
            this.addIndexPaths(prototype.indexPaths());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER from(BuilderBase<?, ?> builder) {
            this.useJaxRsSemantics(builder.useJaxRsSemantics());
            if (this.isIndexPathsMutated) {
                if (builder.isIndexPathsMutated) {
                    this.addIndexPaths(builder.indexPaths);
                }
            } else {
                this.indexPaths.clear();
                this.addIndexPaths(builder.indexPaths);
            }
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER config(Config config) {
            Objects.requireNonNull(config);
            this.config = config;
            config.get("mp.openapi.extensions.helidon.use-jaxrs-semantics").as(Boolean.class).ifPresent(this::useJaxRsSemantics);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER useJaxRsSemantics(boolean useJaxRsSemantics) {
            this.useJaxRsSemantics = useJaxRsSemantics;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER indexPaths(List<String> indexPaths) {
            Objects.requireNonNull(indexPaths);
            this.isIndexPathsMutated = true;
            this.indexPaths.clear();
            this.indexPaths.addAll(indexPaths);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addIndexPaths(List<String> indexPaths) {
            Objects.requireNonNull(indexPaths);
            this.isIndexPathsMutated = true;
            this.indexPaths.addAll(indexPaths);
            return (BUILDER)((BuilderBase)this.self());
        }

        public boolean useJaxRsSemantics() {
            return this.useJaxRsSemantics;
        }

        public List<String> indexPaths() {
            return this.indexPaths;
        }

        public Optional<Config> config() {
            return Optional.ofNullable(this.config);
        }

        public String toString() {
            return "MpOpenApiManagerConfigBuilder{useJaxRsSemantics=" + this.useJaxRsSemantics + ",indexPaths=" + String.valueOf(this.indexPaths) + "}";
        }

        protected void preBuildPrototype() {
        }

        protected void validatePrototype() {
        }

        protected static class MpOpenApiManagerConfigImpl
        implements MpOpenApiManagerConfig {
            private final boolean useJaxRsSemantics;
            private final List<String> indexPaths;

            protected MpOpenApiManagerConfigImpl(BuilderBase<?, ?> builder) {
                this.useJaxRsSemantics = builder.useJaxRsSemantics();
                this.indexPaths = List.copyOf(builder.indexPaths());
            }

            @Override
            public boolean useJaxRsSemantics() {
                return this.useJaxRsSemantics;
            }

            @Override
            public List<String> indexPaths() {
                return this.indexPaths;
            }

            public String toString() {
                return "MpOpenApiManagerConfig{useJaxRsSemantics=" + this.useJaxRsSemantics + ",indexPaths=" + String.valueOf(this.indexPaths) + "}";
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof MpOpenApiManagerConfig)) {
                    return false;
                }
                MpOpenApiManagerConfig other = (MpOpenApiManagerConfig)o;
                return this.useJaxRsSemantics == other.useJaxRsSemantics() && Objects.equals(this.indexPaths, other.indexPaths());
            }

            public int hashCode() {
                return Objects.hash(this.useJaxRsSemantics, this.indexPaths);
            }
        }
    }
}

