/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.integrations.microstream.cache;

import io.helidon.common.Builder;
import io.helidon.config.Config;
import io.helidon.integrations.microstream.cache.ConfigException;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.function.Predicate;
import javax.cache.configuration.CacheEntryListenerConfiguration;
import javax.cache.configuration.Factory;
import javax.cache.expiry.ExpiryPolicy;
import javax.cache.integration.CacheLoader;
import javax.cache.integration.CacheWriter;
import one.microstream.cache.types.CacheConfiguration;
import one.microstream.cache.types.CacheConfigurationBuilderConfigurationBased;
import one.microstream.cache.types.CacheConfigurationPropertyNames;
import one.microstream.cache.types.EvictionManager;
import one.microstream.configuration.types.Configuration;

public class MicrostreamCacheConfigurationBuilder<K, V>
implements CacheConfigurationPropertyNames,
CacheConfiguration.Builder<K, V>,
Builder<CacheConfiguration<K, V>> {
    private final CacheConfiguration.Builder<K, V> cacheConfigBuilder;

    protected MicrostreamCacheConfigurationBuilder(Class<K> keyType, Class<V> valueType) {
        this.cacheConfigBuilder = CacheConfiguration.Builder(keyType, valueType);
    }

    protected MicrostreamCacheConfigurationBuilder(Configuration configuration, Class<K> keyType, Class<V> valueType) {
        this.cacheConfigBuilder = CacheConfigurationBuilderConfigurationBased.New().buildCacheConfiguration(configuration, CacheConfiguration.Builder(keyType, valueType));
    }

    public static MicrostreamCacheConfigurationBuilder<?, ?> builder(Config config) {
        return MicrostreamCacheConfigurationBuilder.builder(config, null, null);
    }

    public static <K, V> MicrostreamCacheConfigurationBuilder<K, V> builder(Class<K> keyType, Class<V> valueType) {
        return new MicrostreamCacheConfigurationBuilder<K, V>(keyType, valueType);
    }

    public static <K, V> MicrostreamCacheConfigurationBuilder<K, V> builder(Config config, Class<K> keyType, Class<V> valueType) {
        Configuration.Builder configurationBuilder = Configuration.Builder();
        if (config.exists()) {
            ((Map)config.detach().asMap().get()).forEach((arg_0, arg_1) -> ((Configuration.Builder)configurationBuilder).set(arg_0, arg_1));
        }
        Configuration configuration = configurationBuilder.buildConfiguration();
        configuration.opt("key-type").ifPresent(s -> MicrostreamCacheConfigurationBuilder.verifyType(s, keyType));
        configuration.opt("value-type").ifPresent(s -> MicrostreamCacheConfigurationBuilder.verifyType(s, valueType));
        return new MicrostreamCacheConfigurationBuilder<K, V>(configuration, keyType, valueType);
    }

    public CacheConfiguration<K, V> build() {
        return this.cacheConfigBuilder.build();
    }

    public MicrostreamCacheConfigurationBuilder<K, V> readThrough(boolean readTrough) {
        this.cacheConfigBuilder.readThrough(readTrough);
        return this;
    }

    public MicrostreamCacheConfigurationBuilder<K, V> writeThrough(boolean writeThrough) {
        this.cacheConfigBuilder.writeThrough(writeThrough);
        return this;
    }

    public MicrostreamCacheConfigurationBuilder<K, V> storeByValue(boolean storeByValue) {
        this.cacheConfigBuilder.storeByValue(storeByValue);
        return this;
    }

    public MicrostreamCacheConfigurationBuilder<K, V> enableStatistics(boolean enableStatistics) {
        this.cacheConfigBuilder.enableStatistics(enableStatistics);
        return this;
    }

    public MicrostreamCacheConfigurationBuilder<K, V> enableManagement(boolean enableManagement) {
        this.cacheConfigBuilder.enableManagement(enableManagement);
        return this;
    }

    public MicrostreamCacheConfigurationBuilder<K, V> expiryPolicyFactory(Factory<ExpiryPolicy> expiryPolicyFactory) {
        this.cacheConfigBuilder.expiryPolicyFactory(expiryPolicyFactory);
        return this;
    }

    public MicrostreamCacheConfigurationBuilder<K, V> evictionManagerFactory(Factory<EvictionManager<K, V>> evictionManagerFactory) {
        this.cacheConfigBuilder.evictionManagerFactory(evictionManagerFactory);
        return this;
    }

    public MicrostreamCacheConfigurationBuilder<K, V> cacheLoaderFactory(Factory<CacheLoader<K, V>> cacheLoaderFactory) {
        this.cacheConfigBuilder.cacheLoaderFactory(cacheLoaderFactory);
        return this;
    }

    public MicrostreamCacheConfigurationBuilder<K, V> cacheWriterFactory(Factory<CacheWriter<? super K, ? super V>> cacheWriterFactory) {
        this.cacheConfigBuilder.cacheWriterFactory(cacheWriterFactory);
        return this;
    }

    public MicrostreamCacheConfigurationBuilder<K, V> serializerFieldPredicate(Predicate<? super Field> serializerFieldPredicate) {
        this.cacheConfigBuilder.serializerFieldPredicate(serializerFieldPredicate);
        return this;
    }

    public CacheConfiguration.Builder<K, V> addListenerConfiguration(CacheEntryListenerConfiguration<K, V> listenerConfiguration) {
        this.cacheConfigBuilder.addListenerConfiguration(listenerConfiguration);
        return this;
    }

    private static void verifyType(String typeName, Class<?> actualType) {
        if (!typeName.equals(actualType.getTypeName())) {
            throw new ConfigException("Microstream cache-config type missmatch, expected value from configuration: " + typeName + " but got: " + actualType.getTypeName());
        }
    }
}

