/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.integrations.db.pgsql;

import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.Delete;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.Properties;
import org.postgresql.ds.common.BaseDataSource;

@TargetClass(className="org.postgresql.ds.common.BaseDataSource")
public final class BaseDataSourceSubstitution {
    @Alias
    private String[] serverNames = null;
    @Alias
    private String databaseName = null;
    @Alias
    private String user = null;
    @Alias
    private String password = null;
    @Alias
    private int[] portNumbers = null;
    @Alias
    private Properties properties = null;

    @Substitute
    public void initializeFrom(BaseDataSource source) throws IOException {
        String[] serverNamesSrc = source.getServerNames();
        int[] portNumbersSrc = source.getPortNumbers();
        if (serverNamesSrc != null) {
            this.serverNames = new String[serverNamesSrc.length];
            for (int i = 0; i < serverNamesSrc.length; ++i) {
                this.serverNames[i] = serverNamesSrc[i] != null ? serverNamesSrc[i] : null;
            }
        } else {
            this.serverNames = null;
        }
        this.databaseName = source.getDatabaseName();
        this.user = source.getUser();
        this.password = source.getPassword();
        if (portNumbersSrc != null) {
            this.portNumbers = new int[portNumbersSrc.length];
            System.arraycopy(portNumbersSrc, 0, this.portNumbers, 0, portNumbersSrc.length);
        } else {
            this.portNumbers = null;
        }
        try {
            Field propertiesField = BaseDataSource.class.getDeclaredField("properties");
            boolean propertiesAcc = propertiesField.canAccess(source);
            propertiesField.setAccessible(true);
            Properties propertiesSrc = (Properties)propertiesField.get(source);
            propertiesField.setAccessible(propertiesAcc);
            this.properties = new Properties();
            this.properties.putAll((Map<?, ?>)propertiesSrc);
        }
        catch (IllegalAccessException | NoSuchFieldException | SecurityException e) {
            throw new IOException("Could not initialize Properties class", e);
        }
    }

    @Delete
    protected void writeBaseObject(ObjectOutputStream out) throws IOException {
    }

    @Delete
    protected void readBaseObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
    }

    BaseDataSourceSubstitution() {
    }
}

