/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.http.encoding;

import io.helidon.http.Headers;
import io.helidon.http.Http;
import io.helidon.http.encoding.ContentDecoder;
import io.helidon.http.encoding.ContentEncoder;
import io.helidon.http.encoding.ContentEncoding;
import io.helidon.http.encoding.ContentEncodingContext;
import io.helidon.http.encoding.ContentEncodingContextConfig;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;

class ContentEncodingSupportImpl
implements ContentEncodingContext {
    private static final String IDENTITY_ENCODING = "identity";
    private final boolean encodingEnabled;
    private final boolean decodingEnabled;
    private final Map<String, ContentEncoder> encoders;
    private final Map<String, ContentDecoder> decoders;
    private final ContentEncoder firstEncoder;
    private final ContentEncodingContextConfig config;

    ContentEncodingSupportImpl(ContentEncodingContextConfig config) {
        this.config = config;
        HashMap<String, ContentEncoder> encoders = new HashMap<String, ContentEncoder>();
        HashMap<String, ContentDecoder> decoders = new HashMap<String, ContentDecoder>();
        ContentEncoder firstEncoder = null;
        for (ContentEncoding contentEncoding : config.contentEncodings()) {
            Set<String> ids = contentEncoding.ids();
            if (contentEncoding.supportsEncoding()) {
                for (String id : ids) {
                    ContentEncoder encoder = contentEncoding.encoder();
                    if (firstEncoder == null) {
                        firstEncoder = encoder;
                    }
                    encoders.putIfAbsent(id, encoder);
                }
            }
            if (!contentEncoding.supportsDecoding()) continue;
            for (String id : ids) {
                decoders.putIfAbsent(id, contentEncoding.decoder());
            }
        }
        this.encodingEnabled = !encoders.isEmpty();
        this.decodingEnabled = !decoders.isEmpty();
        encoders.put(IDENTITY_ENCODING, ContentEncoder.NO_OP);
        decoders.put(IDENTITY_ENCODING, ContentDecoder.NO_OP);
        this.encoders = encoders;
        this.decoders = decoders;
        this.firstEncoder = firstEncoder;
    }

    @Override
    public boolean contentEncodingEnabled() {
        return this.encodingEnabled;
    }

    @Override
    public boolean contentDecodingEnabled() {
        return this.decodingEnabled;
    }

    @Override
    public boolean contentEncodingSupported(String encodingId) {
        return this.encoders.get(encodingId) != null;
    }

    @Override
    public boolean contentDecodingSupported(String encodingId) {
        return this.decoders.get(encodingId) != null;
    }

    @Override
    public ContentEncoder encoder(String encodingId) throws NoSuchElementException {
        ContentEncoder encoder = this.encoders.get(encodingId);
        if (encoder == null) {
            throw new NoSuchElementException("Encoding for " + encodingId + " not available");
        }
        return encoder;
    }

    @Override
    public ContentDecoder decoder(String encodingId) throws NoSuchElementException {
        ContentDecoder decoder = this.decoders.get(encodingId);
        if (decoder == null) {
            throw new NoSuchElementException("Decoding for " + encodingId + " not available");
        }
        return decoder;
    }

    @Override
    public ContentEncoder encoder(Headers headers) {
        if (!this.contentEncodingEnabled() || !headers.contains(Http.HeaderNames.ACCEPT_ENCODING)) {
            return ContentEncoder.NO_OP;
        }
        String acceptEncoding = headers.get(Http.HeaderNames.ACCEPT_ENCODING).value();
        List<EncodingWithQ> supported = ContentEncodingSupportImpl.encodings(acceptEncoding);
        for (EncodingWithQ encodingWithQ : supported) {
            if ("*".equals(encodingWithQ.encoding)) {
                return this.firstEncoder;
            }
            if (!this.contentEncodingSupported(encodingWithQ.encoding)) continue;
            return this.encoders.get(encodingWithQ.encoding);
        }
        return ContentEncoder.NO_OP;
    }

    public ContentEncodingContextConfig prototype() {
        return this.config;
    }

    static List<EncodingWithQ> encodings(String acceptEncoding) {
        String[] values = acceptEncoding.split(",");
        ArrayList<EncodingWithQ> supported = new ArrayList<EncodingWithQ>(values.length);
        for (String value : values) {
            supported.add(EncodingWithQ.parse(value));
        }
        Collections.sort(supported);
        return supported;
    }

    static class EncodingWithQ
    implements Comparable<EncodingWithQ> {
        private final String encoding;
        private final double q;

        EncodingWithQ(String encoding, double q) {
            this.encoding = encoding;
            this.q = q;
        }

        static EncodingWithQ parse(String value) {
            if (value.indexOf(59) != -1) {
                int index = value.indexOf(59);
                String encoding = value.substring(0, index).trim();
                String qString = value.substring(index + 1);
                if ((index = qString.indexOf(61)) == -1) {
                    throw new IllegalArgumentException("Invalid q value for Accept-Encoding");
                }
                double q = Double.parseDouble(qString.substring(index + 1));
                return new EncodingWithQ(encoding, q);
            }
            return new EncodingWithQ(value.trim(), 1.0);
        }

        @Override
        public int compareTo(EncodingWithQ o) {
            return Double.compare(o.q, this.q);
        }

        public int hashCode() {
            return Objects.hash(this.encoding, this.q);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EncodingWithQ that = (EncodingWithQ)o;
            return Double.compare(that.q, this.q) == 0 && this.encoding.equals(that.encoding);
        }

        public String toString() {
            return this.encoding + ";q=" + this.q;
        }
    }
}

