/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.declarative.codegen.faulttolerance;

import io.helidon.codegen.CodegenValidator;
import io.helidon.codegen.classmodel.ClassModel;
import io.helidon.codegen.classmodel.Constructor;
import io.helidon.codegen.classmodel.Method;
import io.helidon.codegen.classmodel.Parameter;
import io.helidon.common.types.AccessModifier;
import io.helidon.common.types.Annotation;
import io.helidon.common.types.Annotations;
import io.helidon.common.types.TypeInfo;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypeNames;
import io.helidon.common.types.TypedElementInfo;
import io.helidon.declarative.codegen.DeclarativeTypes;
import io.helidon.declarative.codegen.faulttolerance.FtHandler;
import io.helidon.declarative.codegen.faulttolerance.FtTypes;
import io.helidon.service.codegen.RegistryCodegenContext;
import io.helidon.service.codegen.RegistryRoundContext;
import io.helidon.service.codegen.ServiceCodegenTypes;
import java.time.Duration;
import java.util.function.Predicate;

class CircuitBreakerHandler
extends FtHandler {
    CircuitBreakerHandler(RegistryCodegenContext ctx) {
        super(ctx, FtTypes.CIRCUIT_BREAKER_ANNOTATION);
    }

    @Override
    void process(RegistryRoundContext roundContext, TypeInfo enclosingType, TypedElementInfo element, Annotation annotation, TypeName generatedType, ClassModel.Builder classModel) {
        TypeName enclosingTypeName = enclosingType.typeName();
        ((ClassModel.Builder)classModel.superType(FtTypes.CIRCUIT_BREAKER_GENERATED_METHOD)).addAnnotation(((Annotation.Builder)((Annotation.Builder)Annotation.builder().typeName(DeclarativeTypes.WEIGHT)).putValue("value", (Object)30.0)).build());
        this.circuitBreakerBody(classModel, enclosingTypeName, element, generatedType, element.elementName(), annotation);
        this.addType(roundContext, generatedType, classModel, enclosingTypeName, element);
    }

    private void circuitBreakerBody(ClassModel.Builder classModel, TypeName enclosingTypeName, TypedElementInfo element, TypeName generatedType, String methodName, Annotation annotation) {
        this.addErrorChecker(classModel, annotation, false);
        classModel.addField(circuitBreaker -> circuitBreaker.accessModifier(AccessModifier.PRIVATE).isFinal(true).type(FtTypes.CIRCUIT_BREAKER).name("breaker"));
        String name = annotation.stringValue("name").filter(Predicate.not(String::isBlank)).orElse(null);
        Constructor.Builder ctr = (Constructor.Builder)((Constructor.Builder)Constructor.builder().addAnnotation(Annotation.create((TypeName)ServiceCodegenTypes.SERVICE_ANNOTATION_INJECT))).accessModifier(AccessModifier.PACKAGE_PRIVATE);
        if (name == null) {
            ctr.addContentLine("this.breaker = produceBreaker();");
        } else {
            ((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)ctr.addParameter(namedCircuitBreaker -> ((Parameter.Builder)namedCircuitBreaker.name("namedBreaker")).type(((TypeName.Builder)((TypeName.Builder)TypeName.builder().from(TypeNames.OPTIONAL)).addTypeArgument(FtTypes.CIRCUIT_BREAKER)).build()).addAnnotation(this.namedAnnotation(name)))).addContent("this.breaker = namedBreaker.orElseGet(")).addContent(generatedType)).addContentLine("::produceBreaker);");
        }
        classModel.addConstructor(ctr);
        classModel.addMethod(circuitBreaker -> ((Method.Builder)((Method.Builder)((Method.Builder)circuitBreaker.name("circuitBreaker")).addAnnotation(Annotations.OVERRIDE)).returnType(FtTypes.CIRCUIT_BREAKER).accessModifier(AccessModifier.PUBLIC)).addContentLine("return breaker;"));
        String customName = name == null ? enclosingTypeName.fqName() + "." + element.signature().text() : name + "-" + enclosingTypeName.fqName() + "." + element.signature().text();
        classModel.addMethod(produceCircuitBreaker -> ((Method.Builder)((Method.Builder)produceCircuitBreaker.accessModifier(AccessModifier.PRIVATE)).isStatic(true).returnType(FtTypes.CIRCUIT_BREAKER).name("produceBreaker")).update(builder -> this.produceBreakerMethodBody(enclosingTypeName, element, (Method.Builder)builder, annotation, customName)));
    }

    private void produceBreakerMethodBody(TypeName typeName, TypedElementInfo element, Method.Builder builder, Annotation annotation, String customName) {
        String delayDuration = CodegenValidator.validateDuration((TypeName)typeName, (TypedElementInfo)element, (TypeName)FtTypes.CIRCUIT_BREAKER_ANNOTATION, (String)"delay", (String)annotation.stringValue("delay").orElse("PT5S"));
        int errorRatio = annotation.intValue("errorRatio").orElse(60);
        int volume = annotation.intValue("volume").orElse(10);
        int successThreshold = annotation.intValue("successThreshold").orElse(1);
        ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)builder.addContent("return ")).addContent(FtTypes.CIRCUIT_BREAKER)).addContentLine(".builder()")).increaseContentPadding()).increaseContentPadding()).addContentLine(".applyOn(APPLY_ON)")).addContentLine(".skipOn(SKIP_ON)")).addContent(".delay(")).addContent(Duration.class)).addContent(".parse(\"")).addContent(delayDuration)).addContentLine("\"))")).addContent(".name(\"")).addContent(customName)).addContentLine("\")")).addContent(".errorRatio(")).addContent(String.valueOf(errorRatio))).addContentLine(")")).addContent(".volume(")).addContent(String.valueOf(volume))).addContentLine(")")).addContent(".successThreshold(")).addContent(String.valueOf(successThreshold))).addContentLine(")")).addContentLine(".build();")).decreaseContentPadding()).decreaseContentPadding();
    }
}

