/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.declarative.codegen.http.webserver;

import io.helidon.codegen.classmodel.Constructor;
import io.helidon.codegen.classmodel.ContentBuilder;
import io.helidon.codegen.classmodel.Parameter;
import io.helidon.common.types.AccessModifier;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypeNames;
import io.helidon.declarative.codegen.DeclarativeTypes;
import io.helidon.declarative.codegen.http.webserver.ParameterCodegenContext;
import java.util.stream.Collectors;

abstract class AbstractParametersProvider {
    AbstractParametersProvider() {
    }

    void codegenFromParameters(ContentBuilder<?> contentBuilder, TypeName parameterType, String paramName, boolean optional) {
        if (optional) {
            TypeName realType = parameterType.isOptional() ? (TypeName)parameterType.typeArguments().getFirst() : parameterType;
            contentBuilder.addContent(".first(\"").addContent(paramName).addContent("\").");
            this.asMethod(contentBuilder, realType);
            contentBuilder.addContent(".asOptional()");
        } else if (parameterType.isList()) {
            TypeName realType = (TypeName)parameterType.typeArguments().getFirst();
            contentBuilder.addContent(".allValues(\"").addContent(paramName).addContentLine("\")").addContentLine(".stream()").addContent(".map(helidonDeclarative__it -> helidonDeclarative__it.");
            this.getMethod(contentBuilder, realType);
            contentBuilder.addContentLine(")").addContent(".collect(").addContent(Collectors.class).addContent(".toList())");
        } else {
            contentBuilder.addContent(".first(\"").addContent(paramName).addContent("\").");
            this.getMethod(contentBuilder, parameterType);
        }
    }

    void asMethod(ContentBuilder<?> content, TypeName type) {
        TypeName boxed = type.boxed();
        if (TypeNames.BOXED_BOOLEAN.equals((Object)boxed)) {
            content.addContent("asBoolean()");
            return;
        }
        if (TypeNames.BOXED_DOUBLE.equals((Object)boxed)) {
            content.addContent("asDouble()");
            return;
        }
        if (TypeNames.BOXED_INT.equals((Object)boxed)) {
            content.addContent("asInt()");
            return;
        }
        if (TypeNames.BOXED_LONG.equals((Object)boxed)) {
            content.addContent("asLong()");
            return;
        }
        if (TypeNames.STRING.equals((Object)type)) {
            content.addContent("asString()");
            return;
        }
        content.addContent("as(").addContent(boxed).addContent(".class)");
    }

    void getMethod(ContentBuilder<?> content, TypeName type) {
        TypeName boxed = type.boxed();
        if (TypeNames.BOXED_BOOLEAN.equals((Object)boxed)) {
            content.addContent("getBoolean()");
            return;
        }
        if (TypeNames.BOXED_DOUBLE.equals((Object)boxed)) {
            content.addContent("getDouble()");
            return;
        }
        if (TypeNames.BOXED_INT.equals((Object)boxed)) {
            content.addContent("getInt()");
            return;
        }
        if (TypeNames.BOXED_LONG.equals((Object)boxed)) {
            content.addContent("getLong()");
            return;
        }
        if (TypeNames.STRING.equals((Object)type)) {
            content.addContent("get()");
            return;
        }
        content.addContent("get(").addContent(boxed).addContent(".class)");
    }

    void ensureMapperField(ParameterCodegenContext ctx) {
        ctx.fieldHandler().field(DeclarativeTypes.COMMON_MAPPERS, "mappers", AccessModifier.PRIVATE, (Object)"mappers", field -> {}, (constructor, fieldName) -> ((Constructor.Builder)constructor.addParameter(param -> ((Parameter.Builder)param.name("mappers")).type(DeclarativeTypes.COMMON_MAPPERS))).addContentLine("this.mappers = mappers;"));
    }
}

