/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.declarative.codegen.http;

import io.helidon.codegen.CodegenException;
import io.helidon.codegen.classmodel.Constructor;
import io.helidon.codegen.classmodel.Parameter;
import io.helidon.common.types.AccessModifier;
import io.helidon.common.types.Annotation;
import io.helidon.common.types.Annotations;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypeNames;
import io.helidon.common.types.TypedElementInfo;
import io.helidon.declarative.codegen.http.HttpTypes;
import io.helidon.declarative.codegen.model.http.ComputedHeader;
import io.helidon.declarative.codegen.model.http.HeaderValue;
import io.helidon.declarative.codegen.model.http.HttpAnnotated;
import io.helidon.declarative.codegen.model.http.HttpMethod;
import io.helidon.declarative.codegen.model.http.RestEndpoint;
import io.helidon.declarative.codegen.model.http.RestMethod;
import io.helidon.service.codegen.FieldHandler;
import io.helidon.service.codegen.ServiceCodegenTypes;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class RestExtensionBase {
    protected RestExtensionBase() {
    }

    protected HttpMethod httpMethodFromAnnotation(TypedElementInfo element, Annotation httpMethodAnnotation) {
        String method;
        return switch (method = httpMethodAnnotation.stringValue().map(String::toUpperCase).orElseThrow(() -> new CodegenException("Could not find @HttpMethod meta annotation for method " + element.elementName(), element.originatingElementValue()))) {
            case "GET", "PUT", "POST", "DELETE", "HEAD", "OPTIONS", "PATCH", "TRACE" -> new HttpMethod(method, true);
            default -> new HttpMethod(method, false);
        };
    }

    protected void path(Set<Annotation> annotations, HttpAnnotated.BuilderBase<?, ?> builder) {
        Annotations.findFirst((TypeName)HttpTypes.HTTP_PATH_ANNOTATION, annotations).flatMap(rec$ -> ((Annotation)rec$).stringValue()).ifPresent(arg_0 -> builder.path(arg_0));
    }

    protected void consumes(Set<Annotation> annotations, HttpAnnotated.BuilderBase<?, ?> builder) {
        Annotations.findFirst((TypeName)HttpTypes.HTTP_CONSUMES_ANNOTATION, annotations).flatMap(rec$ -> ((Annotation)rec$).stringValues()).ifPresent(arg_0 -> builder.consumes(arg_0));
    }

    protected void produces(Set<Annotation> annotations, HttpAnnotated.BuilderBase<?, ?> builder) {
        Annotations.findFirst((TypeName)HttpTypes.HTTP_PRODUCES_ANNOTATION, annotations).flatMap(rec$ -> ((Annotation)rec$).stringValues()).ifPresent(arg_0 -> builder.produces(arg_0));
    }

    protected void headers(Set<Annotation> annotations, HttpAnnotated.BuilderBase<?, ?> builder, TypeName repeatedAnnotationType, TypeName singleAnnotationType) {
        AtomicBoolean found = new AtomicBoolean(false);
        Annotations.findFirst((TypeName)repeatedAnnotationType, annotations).flatMap(rec$ -> ((Annotation)rec$).annotationValues()).stream().flatMap(Collection::stream).forEach(headerAnnotation -> {
            found.set(true);
            String name = (String)headerAnnotation.stringValue("name").orElseThrow();
            String value = (String)headerAnnotation.stringValue("value").orElseThrow();
            builder.addHeader(new HeaderValue(name, value));
        });
        if (!found.get()) {
            Annotations.findFirst((TypeName)singleAnnotationType, annotations).ifPresent(headerAnnotation -> {
                String name = (String)headerAnnotation.stringValue("name").orElseThrow();
                String value = (String)headerAnnotation.stringValue("value").orElseThrow();
                builder.addHeader(new HeaderValue(name, value));
            });
        }
    }

    protected void computedHeaders(Set<Annotation> annotations, HttpAnnotated.BuilderBase<?, ?> builder, TypeName repeatedAnnotationType, TypeName singleAnnotationType) {
        AtomicBoolean found = new AtomicBoolean(false);
        Annotations.findFirst((TypeName)repeatedAnnotationType, annotations).flatMap(rec$ -> ((Annotation)rec$).annotationValues()).stream().flatMap(Collection::stream).forEach(headerAnnotation -> {
            found.set(true);
            String headerName = (String)headerAnnotation.stringValue("name").orElseThrow();
            String serviceName = (String)headerAnnotation.stringValue("function").orElseThrow();
            builder.addComputedHeader(ComputedHeader.create((String)headerName, (String)serviceName));
        });
        if (!found.get()) {
            Annotations.findFirst((TypeName)singleAnnotationType, annotations).ifPresent(headerAnnotation -> {
                String headerName = (String)headerAnnotation.stringValue("name").orElseThrow();
                String serviceName = (String)headerAnnotation.stringValue("function").orElseThrow();
                builder.addComputedHeader(ComputedHeader.create((String)headerName, (String)serviceName));
            });
        }
    }

    protected TypeName supplierOf(TypeName type) {
        return ((TypeName.Builder)TypeName.builder((TypeName)TypeNames.SUPPLIER).addTypeArgument(type)).build();
    }

    protected Map<String, String> headerProducers(FieldHandler fieldHandler, RestEndpoint endpoint) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (RestMethod method : endpoint.methods()) {
            method.computedHeaders().stream().forEach(it -> {
                String serviceName = it.serviceName();
                String fieldName = this.ensureHeaderProducerField(fieldHandler, serviceName);
                result.put(serviceName, fieldName);
            });
        }
        return result;
    }

    protected Optional<Annotation> findMetaAnnotated(TypeName metaAnnotation, Set<Annotation> annotations) {
        for (Annotation annotation : annotations) {
            if (annotation.typeName().equals((Object)metaAnnotation)) {
                return Optional.of(annotation);
            }
            if (!annotation.hasMetaAnnotation(metaAnnotation)) continue;
            return Annotations.findFirst((TypeName)metaAnnotation, (Collection)annotation.metaAnnotations());
        }
        return Optional.empty();
    }

    private String ensureHeaderProducerField(FieldHandler fieldHandler, String serviceName) {
        return fieldHandler.field(HttpTypes.HTTP_HEADER_FUNCTION, "headerProducer_", AccessModifier.PRIVATE, (Object)(HttpTypes.HTTP_HEADER_FUNCTION.fqName() + "." + serviceName), field -> {}, (constructor, fieldName) -> ((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)constructor.addParameter(param -> ((Parameter.Builder)param.type(HttpTypes.HTTP_HEADER_FUNCTION).addAnnotation(((Annotation.Builder)((Annotation.Builder)Annotation.builder().typeName(ServiceCodegenTypes.SERVICE_ANNOTATION_NAMED)).value(serviceName)).build())).name(fieldName))).addContent("this.")).addContent(fieldName)).addContent(" = ")).addContent(fieldName)).addContentLine(";"));
    }
}

