/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.declarative.codegen.http;

import io.helidon.codegen.CodegenUtil;
import io.helidon.declarative.codegen.http.HttpTypes;
import io.helidon.declarative.codegen.model.http.HeaderValue;
import io.helidon.declarative.codegen.model.http.HttpStatus;
import io.helidon.service.codegen.FieldHandler;
import java.util.Locale;

public final class HttpFields {
    private HttpFields() {
    }

    public static String ensureHeaderNameConstant(FieldHandler fieldHandler, String headerName) {
        String constantPrefix = CodegenUtil.toConstantName((String)("header_" + headerName));
        return fieldHandler.constant(constantPrefix, HttpTypes.HTTP_HEADER_NAME, (Object)headerName, content -> content.addContent(HttpTypes.HTTP_HEADER_NAMES).addContent(".create(\"").addContent(headerName).addContent("\")"));
    }

    public static String ensureHeaderValueConstant(FieldHandler fieldHandler, HeaderValue headerValue) {
        return fieldHandler.constant("HEADER_VALUE", HttpTypes.HTTP_HEADER, (Object)headerValue, content -> content.addContent(HttpTypes.HTTP_HEADER_VALUES).addContent(".create(\"").addContent(headerValue.name()).addContent("\", \"").addContent(headerValue.value()).addContent("\")"));
    }

    public static String ensureHttpMediaTypeConstant(FieldHandler fieldHandler, String mediaType) {
        return fieldHandler.constant("MEDIA_TYPE", HttpTypes.HTTP_MEDIA_TYPE, (Object)mediaType, content -> content.addContent(HttpTypes.HTTP_MEDIA_TYPE).addContent(".create(\"").addContent(mediaType).addContent("\")"));
    }

    public static String ensureHttpMethodConstant(FieldHandler fieldHandler, String httpMethod) {
        String constantName = CodegenUtil.toConstantName((String)("ENDPOINT_METHOD_" + httpMethod));
        return fieldHandler.constant(constantName, HttpTypes.HTTP_METHOD, (Object)httpMethod.toUpperCase(Locale.ROOT), content -> content.addContent(HttpTypes.HTTP_METHOD).addContent(".create(\"").addContent(httpMethod).addContent("\""));
    }

    public static String ensureHttpStatusConstant(FieldHandler fieldHandler, HttpStatus httpStatus) {
        return fieldHandler.constant("STATUS_" + httpStatus.code(), HttpTypes.HTTP_STATUS, (Object)httpStatus, content -> {
            content.addContent(HttpTypes.HTTP_STATUS).addContent(".create(").addContent(String.valueOf(httpStatus.code()));
            httpStatus.reason().ifPresent(reason -> content.addContent(", \"" + reason + "\""));
            content.addContent(")");
        });
    }
}

