/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.data.sql.testing;

import java.net.URI;

class ConfigUtils {
    private ConfigUtils() {
        throw new UnsupportedOperationException("No instances of ConfigUtils are allowed");
    }

    public static URI uriFromDbUrl(String url) {
        int authIndex = url.indexOf("://");
        if (authIndex == -1) {
            throw new IllegalArgumentException("Missing URI authority initial sequence \"://\"");
        }
        if (authIndex == 0) {
            throw new IllegalArgumentException("Missing URI segment part");
        }
        int separator = url.lastIndexOf(58, authIndex - 1);
        if (separator >= 0) {
            return URI.create(url.substring(separator + 1));
        }
        return URI.create(url);
    }

    public static String dbNameFromUri(URI dbUri) {
        String dbName;
        String dbPath = dbUri.getPath();
        if (dbPath.isEmpty()) {
            throw new IllegalArgumentException("Database name is empty");
        }
        String string = dbName = dbPath.charAt(0) == '/' ? dbPath.substring(1) : dbPath;
        if (dbName.isEmpty()) {
            throw new IllegalArgumentException("Database name is empty");
        }
        return dbName;
    }

    static String replacePortInUrl(String url, int port) {
        IndexAndLength hostSeparator = ConfigUtils.findHostSeparator(url);
        if (hostSeparator.index() >= 0) {
            int fromIndex = hostSeparator.index() + hostSeparator.length();
            int end = url.indexOf(47, fromIndex);
            int portBeg = url.indexOf(58, fromIndex);
            if (end > 0 && portBeg < end) {
                String frontPart = url.substring(0, portBeg + 1);
                String endPart = url.substring(end);
                return frontPart + port + endPart;
            }
            throw new IllegalStateException(String.format("URL %s does not contain host and port part \"://host:port/\"", url));
        }
        throw new IllegalStateException(String.format("Could not find host separator \"://\" in URL %s", url));
    }

    static int portFromDbUrl(String url) {
        IndexAndLength hostSeparator = ConfigUtils.findHostSeparator(url);
        if (hostSeparator.index() >= 0) {
            int fromIndex = hostSeparator.index() + hostSeparator.length();
            int end = url.indexOf(47, fromIndex);
            int portBeg = url.indexOf(58, fromIndex);
            if (end > 0 && portBeg < end) {
                return Integer.parseInt(url.substring(portBeg + 1, end));
            }
            throw new IllegalStateException(String.format("URL %s does not contain host and port part \"://host:port/\"", url));
        }
        throw new IllegalStateException(String.format("Could not find host separator \"://\" in URL %s", url));
    }

    private static IndexAndLength findHostSeparator(String src) {
        int jdbcSep = src.indexOf(58);
        String scheme = src.substring(0, jdbcSep);
        if (!"jdbc".equals(scheme)) {
            throw new IllegalArgumentException(String.format("Database JDBC url shall start with \"jdbc:\" prefix, but URC is %s", src));
        }
        if (src.length() > jdbcSep + 2) {
            int typeSep = src.indexOf(58, jdbcSep + 1);
            String dbType = src.substring(jdbcSep + 1, typeSep);
            if ("oracle".equals(dbType)) {
                int begin = src.indexOf(":@");
                return new IndexAndLength(begin, 2);
            }
            int begin = src.indexOf("://");
            return new IndexAndLength(begin, 3);
        }
        throw new IllegalArgumentException("Database JDBC url has nothing after \"jdbc:\" prefix");
    }

    private record IndexAndLength(int index, int length) {
    }
}

