/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.data.sql.testing;

import io.helidon.config.Config;
import io.helidon.config.MissingValueException;
import io.helidon.config.spi.ConfigSource;
import io.helidon.data.sql.testing.TestContainerHandler;
import java.util.function.Supplier;
import org.testcontainers.containers.GenericContainer;

public final class SqlTestContainerConfig {
    private SqlTestContainerConfig() {
    }

    public static TestContainerHandler configureContainer(GenericContainer<?> container, Supplier<? extends ConfigSource> configSource) {
        Config testConfig = Config.just((Supplier[])new Supplier[]{configSource}).get("test.database");
        String username = (String)testConfig.get("username").asString().orElse((Object)"");
        String password = (String)testConfig.get("password").asString().orElse((Object)"");
        String url = null;
        try {
            url = (String)testConfig.get("url").asString().get();
        }
        catch (MissingValueException e) {
            throw new IllegalStateException("Configuration key test.database.url is required for test container based tests", e);
        }
        TestContainerHandler testConnectionInfo = new TestContainerHandler(configSource, username, password, url, container);
        testConnectionInfo.configureContainer();
        return testConnectionInfo;
    }
}

