/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.data.sql.datasource.ucp;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Errors;
import io.helidon.common.Generated;
import io.helidon.config.Config;
import io.helidon.config.ConfigBuilderSupport;
import io.helidon.data.sql.common.ConnectionConfig;
import io.helidon.data.sql.datasource.ucp.UcpDataSourceConfigBlueprint;
import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;

@Generated(value="io.helidon.builder.codegen.BuilderCodegen", trigger="io.helidon.data.sql.datasource.ucp.UcpDataSourceConfigBlueprint")
public interface UcpDataSourceConfig
extends UcpDataSourceConfigBlueprint,
Prototype.Api,
ConnectionConfig {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(UcpDataSourceConfig instance) {
        return (Builder)((Object)UcpDataSourceConfig.builder().from(instance));
    }

    public static UcpDataSourceConfig create(Config config) {
        return ((Builder)UcpDataSourceConfig.builder().config(config)).buildPrototype();
    }

    @Deprecated
    public static UcpDataSourceConfig create(io.helidon.common.config.Config config) {
        return UcpDataSourceConfig.create(Config.config((io.helidon.common.config.Config)config));
    }

    public static UcpDataSourceConfig create() {
        return UcpDataSourceConfig.builder().buildPrototype();
    }

    @Override
    public String name();

    @Override
    public Optional<Boolean> xaDataSource();

    @Override
    public Optional<Integer> abandonedConnectionTimeout();

    @Override
    public Optional<Boolean> commitOnConnectionReturn();

    @Override
    public Optional<String> connectionFactoryClassName();

    @Override
    public Optional<Map<String, String>> connectionFactoryProperties();

    @Override
    public Optional<Integer> connectionHarvestMaxCount();

    @Override
    public Optional<Integer> connectionHarvestTriggerCount();

    @Override
    public Optional<Integer> connectionLabelingHighCost();

    @Override
    public Optional<String> connectionPoolName();

    @Override
    public Optional<Map<String, String>> connectionProperties();

    @Override
    public Optional<Integer> connectionRepurposeThreshold();

    @Override
    public Optional<Integer> connectionValidationTimeout();

    @Override
    public Optional<Duration> connectionWaitDuration();

    @Override
    public Optional<Boolean> createConnectionInBorrowThread();

    @Override
    public Optional<String> databaseName();

    @Override
    public Optional<String> dataSourceName();

    @Override
    public Optional<String> description();

    @Override
    public Optional<Boolean> fastConnectionFailoverEnabled();

    @Override
    public Optional<Integer> highCostConnectionReuseThreshold();

    @Override
    public Optional<Integer> inactiveConnectionTimeout();

    @Override
    public Optional<Integer> initialPoolSize();

    @Override
    public Optional<Integer> maxConnectionReuseCount();

    @Override
    public Optional<Long> maxConnectionReuseTime();

    @Override
    public Optional<Integer> maxConnectionsPerShard();

    @Override
    public Optional<Integer> maxIdleTime();

    @Override
    public Optional<Integer> maxPoolSize();

    @Override
    public Optional<Integer> minPoolSize();

    @Override
    public Optional<Integer> maxStatements();

    @Override
    public Optional<Integer> minIdle();

    @Override
    public Optional<String> networkProtocol();

    @Override
    public Optional<String> onsConfiguration();

    @Override
    public Optional<Integer> portNumber();

    @Override
    public Optional<Integer> propertyCycle();

    @Override
    public Optional<Integer> queryTimeout();

    @Override
    public Optional<Boolean> readOnlyInstanceAllowed();

    @Override
    public Optional<String> roleName();

    @Override
    public Optional<Integer> secondsToTrustIdleConnection();

    @Override
    public Optional<String> serverName();

    @Override
    public Optional<Boolean> shardingMode();

    @Override
    public Optional<String> sqlForValidateConnection();

    @Override
    public Optional<Integer> timeoutCheckInterval();

    @Override
    public Optional<Integer> timeToLiveConnectionTimeout();

    @Override
    public Optional<Boolean> validateConnectionOnBorrow();

    public static class Builder
    extends BuilderBase<Builder, UcpDataSourceConfig>
    implements io.helidon.common.Builder<Builder, UcpDataSourceConfig> {
        private Builder() {
        }

        public UcpDataSourceConfig buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.UcpDataSourceConfigImpl(this);
        }

        public UcpDataSourceConfig build() {
            return this.buildPrototype();
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends UcpDataSourceConfig>
    extends ConnectionConfig.BuilderBase<BUILDER, PROTOTYPE>
    implements ConfigBuilderSupport.ConfiguredBuilder<BUILDER, PROTOTYPE> {
        private Boolean commitOnConnectionReturn;
        private Boolean createConnectionInBorrowThread;
        private Boolean fastConnectionFailoverEnabled;
        private Boolean readOnlyInstanceAllowed;
        private Boolean shardingMode;
        private Boolean validateConnectionOnBorrow;
        private Boolean xaDataSource;
        private Config config;
        private Duration connectionWaitDuration;
        private Integer abandonedConnectionTimeout;
        private Integer connectionHarvestMaxCount;
        private Integer connectionHarvestTriggerCount;
        private Integer connectionLabelingHighCost;
        private Integer connectionRepurposeThreshold;
        private Integer connectionValidationTimeout;
        private Integer highCostConnectionReuseThreshold;
        private Integer inactiveConnectionTimeout;
        private Integer initialPoolSize;
        private Integer maxConnectionReuseCount;
        private Integer maxConnectionsPerShard;
        private Integer maxIdleTime;
        private Integer maxPoolSize;
        private Integer maxStatements;
        private Integer minIdle;
        private Integer minPoolSize;
        private Integer portNumber;
        private Integer propertyCycle;
        private Integer queryTimeout;
        private Integer secondsToTrustIdleConnection;
        private Integer timeToLiveConnectionTimeout;
        private Integer timeoutCheckInterval;
        private Long maxConnectionReuseTime;
        private Map<String, String> connectionFactoryProperties;
        private Map<String, String> connectionProperties;
        private String connectionFactoryClassName;
        private String connectionPoolName;
        private String dataSourceName;
        private String databaseName;
        private String description;
        private String name;
        private String networkProtocol;
        private String onsConfiguration;
        private String roleName;
        private String serverName;
        private String sqlForValidateConnection;

        protected BuilderBase() {
        }

        public BUILDER from(UcpDataSourceConfig prototype) {
            super.from((ConnectionConfig)prototype);
            this.name(prototype.name());
            this.xaDataSource(prototype.xaDataSource());
            this.abandonedConnectionTimeout(prototype.abandonedConnectionTimeout());
            this.commitOnConnectionReturn(prototype.commitOnConnectionReturn());
            this.connectionFactoryClassName(prototype.connectionFactoryClassName());
            this.connectionFactoryProperties(prototype.connectionFactoryProperties());
            this.connectionHarvestMaxCount(prototype.connectionHarvestMaxCount());
            this.connectionHarvestTriggerCount(prototype.connectionHarvestTriggerCount());
            this.connectionLabelingHighCost(prototype.connectionLabelingHighCost());
            this.connectionPoolName(prototype.connectionPoolName());
            this.connectionProperties(prototype.connectionProperties());
            this.connectionRepurposeThreshold(prototype.connectionRepurposeThreshold());
            this.connectionValidationTimeout(prototype.connectionValidationTimeout());
            this.connectionWaitDuration(prototype.connectionWaitDuration());
            this.createConnectionInBorrowThread(prototype.createConnectionInBorrowThread());
            this.databaseName(prototype.databaseName());
            this.dataSourceName(prototype.dataSourceName());
            this.description(prototype.description());
            this.fastConnectionFailoverEnabled(prototype.fastConnectionFailoverEnabled());
            this.highCostConnectionReuseThreshold(prototype.highCostConnectionReuseThreshold());
            this.inactiveConnectionTimeout(prototype.inactiveConnectionTimeout());
            this.initialPoolSize(prototype.initialPoolSize());
            this.maxConnectionReuseCount(prototype.maxConnectionReuseCount());
            this.maxConnectionReuseTime(prototype.maxConnectionReuseTime());
            this.maxConnectionsPerShard(prototype.maxConnectionsPerShard());
            this.maxIdleTime(prototype.maxIdleTime());
            this.maxPoolSize(prototype.maxPoolSize());
            this.minPoolSize(prototype.minPoolSize());
            this.maxStatements(prototype.maxStatements());
            this.minIdle(prototype.minIdle());
            this.networkProtocol(prototype.networkProtocol());
            this.onsConfiguration(prototype.onsConfiguration());
            this.portNumber(prototype.portNumber());
            this.propertyCycle(prototype.propertyCycle());
            this.queryTimeout(prototype.queryTimeout());
            this.readOnlyInstanceAllowed(prototype.readOnlyInstanceAllowed());
            this.roleName(prototype.roleName());
            this.secondsToTrustIdleConnection(prototype.secondsToTrustIdleConnection());
            this.serverName(prototype.serverName());
            this.shardingMode(prototype.shardingMode());
            this.sqlForValidateConnection(prototype.sqlForValidateConnection());
            this.timeoutCheckInterval(prototype.timeoutCheckInterval());
            this.timeToLiveConnectionTimeout(prototype.timeToLiveConnectionTimeout());
            this.validateConnectionOnBorrow(prototype.validateConnectionOnBorrow());
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER from(BuilderBase<?, ?> builder) {
            super.from(builder);
            builder.name().ifPresent(this::name);
            builder.xaDataSource().ifPresent(this::xaDataSource);
            builder.abandonedConnectionTimeout().ifPresent(this::abandonedConnectionTimeout);
            builder.commitOnConnectionReturn().ifPresent(this::commitOnConnectionReturn);
            builder.connectionFactoryClassName().ifPresent(this::connectionFactoryClassName);
            builder.connectionFactoryProperties().ifPresent(this::connectionFactoryProperties);
            builder.connectionHarvestMaxCount().ifPresent(this::connectionHarvestMaxCount);
            builder.connectionHarvestTriggerCount().ifPresent(this::connectionHarvestTriggerCount);
            builder.connectionLabelingHighCost().ifPresent(this::connectionLabelingHighCost);
            builder.connectionPoolName().ifPresent(this::connectionPoolName);
            builder.connectionProperties().ifPresent(this::connectionProperties);
            builder.connectionRepurposeThreshold().ifPresent(this::connectionRepurposeThreshold);
            builder.connectionValidationTimeout().ifPresent(this::connectionValidationTimeout);
            builder.connectionWaitDuration().ifPresent(this::connectionWaitDuration);
            builder.createConnectionInBorrowThread().ifPresent(this::createConnectionInBorrowThread);
            builder.databaseName().ifPresent(this::databaseName);
            builder.dataSourceName().ifPresent(this::dataSourceName);
            builder.description().ifPresent(this::description);
            builder.fastConnectionFailoverEnabled().ifPresent(this::fastConnectionFailoverEnabled);
            builder.highCostConnectionReuseThreshold().ifPresent(this::highCostConnectionReuseThreshold);
            builder.inactiveConnectionTimeout().ifPresent(this::inactiveConnectionTimeout);
            builder.initialPoolSize().ifPresent(this::initialPoolSize);
            builder.maxConnectionReuseCount().ifPresent(this::maxConnectionReuseCount);
            builder.maxConnectionReuseTime().ifPresent(this::maxConnectionReuseTime);
            builder.maxConnectionsPerShard().ifPresent(this::maxConnectionsPerShard);
            builder.maxIdleTime().ifPresent(this::maxIdleTime);
            builder.maxPoolSize().ifPresent(this::maxPoolSize);
            builder.minPoolSize().ifPresent(this::minPoolSize);
            builder.maxStatements().ifPresent(this::maxStatements);
            builder.minIdle().ifPresent(this::minIdle);
            builder.networkProtocol().ifPresent(this::networkProtocol);
            builder.onsConfiguration().ifPresent(this::onsConfiguration);
            builder.portNumber().ifPresent(this::portNumber);
            builder.propertyCycle().ifPresent(this::propertyCycle);
            builder.queryTimeout().ifPresent(this::queryTimeout);
            builder.readOnlyInstanceAllowed().ifPresent(this::readOnlyInstanceAllowed);
            builder.roleName().ifPresent(this::roleName);
            builder.secondsToTrustIdleConnection().ifPresent(this::secondsToTrustIdleConnection);
            builder.serverName().ifPresent(this::serverName);
            builder.shardingMode().ifPresent(this::shardingMode);
            builder.sqlForValidateConnection().ifPresent(this::sqlForValidateConnection);
            builder.timeoutCheckInterval().ifPresent(this::timeoutCheckInterval);
            builder.timeToLiveConnectionTimeout().ifPresent(this::timeToLiveConnectionTimeout);
            builder.validateConnectionOnBorrow().ifPresent(this::validateConnectionOnBorrow);
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        @Deprecated
        public BUILDER config(io.helidon.common.config.Config config) {
            return (BUILDER)this.config(Config.config((io.helidon.common.config.Config)config));
        }

        public BUILDER config(Config config) {
            Objects.requireNonNull(config);
            this.config = config;
            super.config(config);
            config.get("xa-data-source").as(Boolean.class).ifPresent(this::xaDataSource);
            config.get("abandoned-connection-timeout").as(Integer.class).ifPresent(this::abandonedConnectionTimeout);
            config.get("commit-on-connection-return").as(Boolean.class).ifPresent(this::commitOnConnectionReturn);
            config.get("connection-factory-class-name").as(String.class).ifPresent(this::connectionFactoryClassName);
            config.get("connection-factory-properties").as(Map.class).ifPresent(this::connectionFactoryProperties);
            config.get("connection-harvest-max-count").as(Integer.class).ifPresent(this::connectionHarvestMaxCount);
            config.get("connection-harvest-trigger-count").as(Integer.class).ifPresent(this::connectionHarvestTriggerCount);
            config.get("connection-labeling-high-cost").as(Integer.class).ifPresent(this::connectionLabelingHighCost);
            config.get("connection-pool-name").as(String.class).ifPresent(this::connectionPoolName);
            config.get("connection-properties").as(Map.class).ifPresent(this::connectionProperties);
            config.get("connection-repurpose-threshold").as(Integer.class).ifPresent(this::connectionRepurposeThreshold);
            config.get("connection-validation-timeout").as(Integer.class).ifPresent(this::connectionValidationTimeout);
            config.get("connection-wait-duration").as(Duration.class).ifPresent(this::connectionWaitDuration);
            config.get("create-connection-in-borrow-thread").as(Boolean.class).ifPresent(this::createConnectionInBorrowThread);
            config.get("database-name").as(String.class).ifPresent(this::databaseName);
            config.get("data-source-name").as(String.class).ifPresent(this::dataSourceName);
            config.get("description").as(String.class).ifPresent(this::description);
            config.get("fast-connection-failover-enabled").as(Boolean.class).ifPresent(this::fastConnectionFailoverEnabled);
            config.get("high-cost-connection-reuse-threshold").as(Integer.class).ifPresent(this::highCostConnectionReuseThreshold);
            config.get("inactive-connection-timeout").as(Integer.class).ifPresent(this::inactiveConnectionTimeout);
            config.get("initial-pool-size").as(Integer.class).ifPresent(this::initialPoolSize);
            config.get("max-connection-reuse-count").as(Integer.class).ifPresent(this::maxConnectionReuseCount);
            config.get("max-connection-reuse-time").as(Long.class).ifPresent(this::maxConnectionReuseTime);
            config.get("max-connections-per-shard").as(Integer.class).ifPresent(this::maxConnectionsPerShard);
            config.get("max-idle-time").as(Integer.class).ifPresent(this::maxIdleTime);
            config.get("max-pool-size").as(Integer.class).ifPresent(this::maxPoolSize);
            config.get("min-pool-size").as(Integer.class).ifPresent(this::minPoolSize);
            config.get("max-statements").as(Integer.class).ifPresent(this::maxStatements);
            config.get("min-idle").as(Integer.class).ifPresent(this::minIdle);
            config.get("network-protocol").as(String.class).ifPresent(this::networkProtocol);
            config.get("ons-configuration").as(String.class).ifPresent(this::onsConfiguration);
            config.get("port-number").as(Integer.class).ifPresent(this::portNumber);
            config.get("property-cycle").as(Integer.class).ifPresent(this::propertyCycle);
            config.get("query-timeout").as(Integer.class).ifPresent(this::queryTimeout);
            config.get("read-only-instance-allowed").as(Boolean.class).ifPresent(this::readOnlyInstanceAllowed);
            config.get("role-name").as(String.class).ifPresent(this::roleName);
            config.get("seconds-to-trust-idle-connection").as(Integer.class).ifPresent(this::secondsToTrustIdleConnection);
            config.get("server-name").as(String.class).ifPresent(this::serverName);
            config.get("sharding-mode").as(Boolean.class).ifPresent(this::shardingMode);
            config.get("sql-for-validate-connection").as(String.class).ifPresent(this::sqlForValidateConnection);
            config.get("timeout-check-interval").as(Integer.class).ifPresent(this::timeoutCheckInterval);
            config.get("time-to-live-connection-timeout").as(Integer.class).ifPresent(this::timeToLiveConnectionTimeout);
            config.get("validate-connection-on-borrow").as(Boolean.class).ifPresent(this::validateConnectionOnBorrow);
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER name(String name) {
            Objects.requireNonNull(name);
            this.name = name;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER clearXaDataSource() {
            this.xaDataSource = null;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER xaDataSource(boolean xaDataSource) {
            Objects.requireNonNull(xaDataSource);
            this.xaDataSource = xaDataSource;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER clearAbandonedConnectionTimeout() {
            this.abandonedConnectionTimeout = null;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER abandonedConnectionTimeout(int abandonedConnectionTimeout) {
            Objects.requireNonNull(abandonedConnectionTimeout);
            this.abandonedConnectionTimeout = abandonedConnectionTimeout;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER clearCommitOnConnectionReturn() {
            this.commitOnConnectionReturn = null;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER commitOnConnectionReturn(boolean commitOnConnectionReturn) {
            Objects.requireNonNull(commitOnConnectionReturn);
            this.commitOnConnectionReturn = commitOnConnectionReturn;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER clearConnectionFactoryClassName() {
            this.connectionFactoryClassName = null;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER connectionFactoryClassName(String connectionFactoryClassName) {
            Objects.requireNonNull(connectionFactoryClassName);
            this.connectionFactoryClassName = connectionFactoryClassName;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER clearConnectionFactoryProperties() {
            this.connectionFactoryProperties = null;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER connectionFactoryProperties(Map<String, String> connectionFactoryProperties) {
            Objects.requireNonNull(connectionFactoryProperties);
            this.connectionFactoryProperties = connectionFactoryProperties;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER clearConnectionHarvestMaxCount() {
            this.connectionHarvestMaxCount = null;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER connectionHarvestMaxCount(int connectionHarvestMaxCount) {
            Objects.requireNonNull(connectionHarvestMaxCount);
            this.connectionHarvestMaxCount = connectionHarvestMaxCount;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER clearConnectionHarvestTriggerCount() {
            this.connectionHarvestTriggerCount = null;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER connectionHarvestTriggerCount(int connectionHarvestTriggerCount) {
            Objects.requireNonNull(connectionHarvestTriggerCount);
            this.connectionHarvestTriggerCount = connectionHarvestTriggerCount;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER clearConnectionLabelingHighCost() {
            this.connectionLabelingHighCost = null;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER connectionLabelingHighCost(int connectionLabelingHighCost) {
            Objects.requireNonNull(connectionLabelingHighCost);
            this.connectionLabelingHighCost = connectionLabelingHighCost;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER clearConnectionPoolName() {
            this.connectionPoolName = null;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER connectionPoolName(String connectionPoolName) {
            Objects.requireNonNull(connectionPoolName);
            this.connectionPoolName = connectionPoolName;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER clearConnectionProperties() {
            this.connectionProperties = null;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER connectionProperties(Map<String, String> connectionProperties) {
            Objects.requireNonNull(connectionProperties);
            this.connectionProperties = connectionProperties;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER clearConnectionRepurposeThreshold() {
            this.connectionRepurposeThreshold = null;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER connectionRepurposeThreshold(int connectionRepurposeThreshold) {
            Objects.requireNonNull(connectionRepurposeThreshold);
            this.connectionRepurposeThreshold = connectionRepurposeThreshold;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER clearConnectionValidationTimeout() {
            this.connectionValidationTimeout = null;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER connectionValidationTimeout(int connectionValidationTimeout) {
            Objects.requireNonNull(connectionValidationTimeout);
            this.connectionValidationTimeout = connectionValidationTimeout;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER clearConnectionWaitDuration() {
            this.connectionWaitDuration = null;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER connectionWaitDuration(Duration connectionWaitDuration) {
            Objects.requireNonNull(connectionWaitDuration);
            this.connectionWaitDuration = connectionWaitDuration;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER clearCreateConnectionInBorrowThread() {
            this.createConnectionInBorrowThread = null;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER createConnectionInBorrowThread(boolean createConnectionInBorrowThread) {
            Objects.requireNonNull(createConnectionInBorrowThread);
            this.createConnectionInBorrowThread = createConnectionInBorrowThread;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER clearDatabaseName() {
            this.databaseName = null;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER databaseName(String databaseName) {
            Objects.requireNonNull(databaseName);
            this.databaseName = databaseName;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER clearDataSourceName() {
            this.dataSourceName = null;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER dataSourceName(String dataSourceName) {
            Objects.requireNonNull(dataSourceName);
            this.dataSourceName = dataSourceName;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER clearDescription() {
            this.description = null;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER description(String description) {
            Objects.requireNonNull(description);
            this.description = description;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER clearFastConnectionFailoverEnabled() {
            this.fastConnectionFailoverEnabled = null;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER fastConnectionFailoverEnabled(boolean fastConnectionFailoverEnabled) {
            Objects.requireNonNull(fastConnectionFailoverEnabled);
            this.fastConnectionFailoverEnabled = fastConnectionFailoverEnabled;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER clearHighCostConnectionReuseThreshold() {
            this.highCostConnectionReuseThreshold = null;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER highCostConnectionReuseThreshold(int highCostConnectionReuseThreshold) {
            Objects.requireNonNull(highCostConnectionReuseThreshold);
            this.highCostConnectionReuseThreshold = highCostConnectionReuseThreshold;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER clearInactiveConnectionTimeout() {
            this.inactiveConnectionTimeout = null;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER inactiveConnectionTimeout(int inactiveConnectionTimeout) {
            Objects.requireNonNull(inactiveConnectionTimeout);
            this.inactiveConnectionTimeout = inactiveConnectionTimeout;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER clearInitialPoolSize() {
            this.initialPoolSize = null;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER initialPoolSize(int initialPoolSize) {
            Objects.requireNonNull(initialPoolSize);
            this.initialPoolSize = initialPoolSize;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER clearMaxConnectionReuseCount() {
            this.maxConnectionReuseCount = null;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER maxConnectionReuseCount(int maxConnectionReuseCount) {
            Objects.requireNonNull(maxConnectionReuseCount);
            this.maxConnectionReuseCount = maxConnectionReuseCount;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER clearMaxConnectionReuseTime() {
            this.maxConnectionReuseTime = null;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER maxConnectionReuseTime(long maxConnectionReuseTime) {
            Objects.requireNonNull(maxConnectionReuseTime);
            this.maxConnectionReuseTime = maxConnectionReuseTime;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER clearMaxConnectionsPerShard() {
            this.maxConnectionsPerShard = null;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER maxConnectionsPerShard(int maxConnectionsPerShard) {
            Objects.requireNonNull(maxConnectionsPerShard);
            this.maxConnectionsPerShard = maxConnectionsPerShard;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER clearMaxIdleTime() {
            this.maxIdleTime = null;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER maxIdleTime(int maxIdleTime) {
            Objects.requireNonNull(maxIdleTime);
            this.maxIdleTime = maxIdleTime;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER clearMaxPoolSize() {
            this.maxPoolSize = null;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER maxPoolSize(int maxPoolSize) {
            Objects.requireNonNull(maxPoolSize);
            this.maxPoolSize = maxPoolSize;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER clearMinPoolSize() {
            this.minPoolSize = null;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER minPoolSize(int minPoolSize) {
            Objects.requireNonNull(minPoolSize);
            this.minPoolSize = minPoolSize;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER clearMaxStatements() {
            this.maxStatements = null;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER maxStatements(int maxStatements) {
            Objects.requireNonNull(maxStatements);
            this.maxStatements = maxStatements;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER clearMinIdle() {
            this.minIdle = null;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER minIdle(int minIdle) {
            Objects.requireNonNull(minIdle);
            this.minIdle = minIdle;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER clearNetworkProtocol() {
            this.networkProtocol = null;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER networkProtocol(String networkProtocol) {
            Objects.requireNonNull(networkProtocol);
            this.networkProtocol = networkProtocol;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER clearOnsConfiguration() {
            this.onsConfiguration = null;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER onsConfiguration(String onsConfiguration) {
            Objects.requireNonNull(onsConfiguration);
            this.onsConfiguration = onsConfiguration;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER clearPortNumber() {
            this.portNumber = null;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER portNumber(int portNumber) {
            Objects.requireNonNull(portNumber);
            this.portNumber = portNumber;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER clearPropertyCycle() {
            this.propertyCycle = null;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER propertyCycle(int propertyCycle) {
            Objects.requireNonNull(propertyCycle);
            this.propertyCycle = propertyCycle;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER clearQueryTimeout() {
            this.queryTimeout = null;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER queryTimeout(int queryTimeout) {
            Objects.requireNonNull(queryTimeout);
            this.queryTimeout = queryTimeout;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER clearReadOnlyInstanceAllowed() {
            this.readOnlyInstanceAllowed = null;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER readOnlyInstanceAllowed(boolean readOnlyInstanceAllowed) {
            Objects.requireNonNull(readOnlyInstanceAllowed);
            this.readOnlyInstanceAllowed = readOnlyInstanceAllowed;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER clearRoleName() {
            this.roleName = null;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER roleName(String roleName) {
            Objects.requireNonNull(roleName);
            this.roleName = roleName;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER clearSecondsToTrustIdleConnection() {
            this.secondsToTrustIdleConnection = null;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER secondsToTrustIdleConnection(int secondsToTrustIdleConnection) {
            Objects.requireNonNull(secondsToTrustIdleConnection);
            this.secondsToTrustIdleConnection = secondsToTrustIdleConnection;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER clearServerName() {
            this.serverName = null;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER serverName(String serverName) {
            Objects.requireNonNull(serverName);
            this.serverName = serverName;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER clearShardingMode() {
            this.shardingMode = null;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER shardingMode(boolean shardingMode) {
            Objects.requireNonNull(shardingMode);
            this.shardingMode = shardingMode;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER clearSqlForValidateConnection() {
            this.sqlForValidateConnection = null;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER sqlForValidateConnection(String sqlForValidateConnection) {
            Objects.requireNonNull(sqlForValidateConnection);
            this.sqlForValidateConnection = sqlForValidateConnection;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER clearTimeoutCheckInterval() {
            this.timeoutCheckInterval = null;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER timeoutCheckInterval(int timeoutCheckInterval) {
            Objects.requireNonNull(timeoutCheckInterval);
            this.timeoutCheckInterval = timeoutCheckInterval;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER clearTimeToLiveConnectionTimeout() {
            this.timeToLiveConnectionTimeout = null;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER timeToLiveConnectionTimeout(int timeToLiveConnectionTimeout) {
            Objects.requireNonNull(timeToLiveConnectionTimeout);
            this.timeToLiveConnectionTimeout = timeToLiveConnectionTimeout;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER clearValidateConnectionOnBorrow() {
            this.validateConnectionOnBorrow = null;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER validateConnectionOnBorrow(boolean validateConnectionOnBorrow) {
            Objects.requireNonNull(validateConnectionOnBorrow);
            this.validateConnectionOnBorrow = validateConnectionOnBorrow;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public Optional<String> name() {
            return Optional.ofNullable(this.name);
        }

        public Optional<Boolean> xaDataSource() {
            return Optional.ofNullable(this.xaDataSource);
        }

        public Optional<Integer> abandonedConnectionTimeout() {
            return Optional.ofNullable(this.abandonedConnectionTimeout);
        }

        public Optional<Boolean> commitOnConnectionReturn() {
            return Optional.ofNullable(this.commitOnConnectionReturn);
        }

        public Optional<String> connectionFactoryClassName() {
            return Optional.ofNullable(this.connectionFactoryClassName);
        }

        public Optional<Map<String, String>> connectionFactoryProperties() {
            return Optional.ofNullable(this.connectionFactoryProperties);
        }

        public Optional<Integer> connectionHarvestMaxCount() {
            return Optional.ofNullable(this.connectionHarvestMaxCount);
        }

        public Optional<Integer> connectionHarvestTriggerCount() {
            return Optional.ofNullable(this.connectionHarvestTriggerCount);
        }

        public Optional<Integer> connectionLabelingHighCost() {
            return Optional.ofNullable(this.connectionLabelingHighCost);
        }

        public Optional<String> connectionPoolName() {
            return Optional.ofNullable(this.connectionPoolName);
        }

        public Optional<Map<String, String>> connectionProperties() {
            return Optional.ofNullable(this.connectionProperties);
        }

        public Optional<Integer> connectionRepurposeThreshold() {
            return Optional.ofNullable(this.connectionRepurposeThreshold);
        }

        public Optional<Integer> connectionValidationTimeout() {
            return Optional.ofNullable(this.connectionValidationTimeout);
        }

        public Optional<Duration> connectionWaitDuration() {
            return Optional.ofNullable(this.connectionWaitDuration);
        }

        public Optional<Boolean> createConnectionInBorrowThread() {
            return Optional.ofNullable(this.createConnectionInBorrowThread);
        }

        public Optional<String> databaseName() {
            return Optional.ofNullable(this.databaseName);
        }

        public Optional<String> dataSourceName() {
            return Optional.ofNullable(this.dataSourceName);
        }

        public Optional<String> description() {
            return Optional.ofNullable(this.description);
        }

        public Optional<Boolean> fastConnectionFailoverEnabled() {
            return Optional.ofNullable(this.fastConnectionFailoverEnabled);
        }

        public Optional<Integer> highCostConnectionReuseThreshold() {
            return Optional.ofNullable(this.highCostConnectionReuseThreshold);
        }

        public Optional<Integer> inactiveConnectionTimeout() {
            return Optional.ofNullable(this.inactiveConnectionTimeout);
        }

        public Optional<Integer> initialPoolSize() {
            return Optional.ofNullable(this.initialPoolSize);
        }

        public Optional<Integer> maxConnectionReuseCount() {
            return Optional.ofNullable(this.maxConnectionReuseCount);
        }

        public Optional<Long> maxConnectionReuseTime() {
            return Optional.ofNullable(this.maxConnectionReuseTime);
        }

        public Optional<Integer> maxConnectionsPerShard() {
            return Optional.ofNullable(this.maxConnectionsPerShard);
        }

        public Optional<Integer> maxIdleTime() {
            return Optional.ofNullable(this.maxIdleTime);
        }

        public Optional<Integer> maxPoolSize() {
            return Optional.ofNullable(this.maxPoolSize);
        }

        public Optional<Integer> minPoolSize() {
            return Optional.ofNullable(this.minPoolSize);
        }

        public Optional<Integer> maxStatements() {
            return Optional.ofNullable(this.maxStatements);
        }

        public Optional<Integer> minIdle() {
            return Optional.ofNullable(this.minIdle);
        }

        public Optional<String> networkProtocol() {
            return Optional.ofNullable(this.networkProtocol);
        }

        public Optional<String> onsConfiguration() {
            return Optional.ofNullable(this.onsConfiguration);
        }

        public Optional<Integer> portNumber() {
            return Optional.ofNullable(this.portNumber);
        }

        public Optional<Integer> propertyCycle() {
            return Optional.ofNullable(this.propertyCycle);
        }

        public Optional<Integer> queryTimeout() {
            return Optional.ofNullable(this.queryTimeout);
        }

        public Optional<Boolean> readOnlyInstanceAllowed() {
            return Optional.ofNullable(this.readOnlyInstanceAllowed);
        }

        public Optional<String> roleName() {
            return Optional.ofNullable(this.roleName);
        }

        public Optional<Integer> secondsToTrustIdleConnection() {
            return Optional.ofNullable(this.secondsToTrustIdleConnection);
        }

        public Optional<String> serverName() {
            return Optional.ofNullable(this.serverName);
        }

        public Optional<Boolean> shardingMode() {
            return Optional.ofNullable(this.shardingMode);
        }

        public Optional<String> sqlForValidateConnection() {
            return Optional.ofNullable(this.sqlForValidateConnection);
        }

        public Optional<Integer> timeoutCheckInterval() {
            return Optional.ofNullable(this.timeoutCheckInterval);
        }

        public Optional<Integer> timeToLiveConnectionTimeout() {
            return Optional.ofNullable(this.timeToLiveConnectionTimeout);
        }

        public Optional<Boolean> validateConnectionOnBorrow() {
            return Optional.ofNullable(this.validateConnectionOnBorrow);
        }

        public Optional<io.helidon.common.config.Config> config() {
            return Optional.ofNullable(this.config);
        }

        public String toString() {
            return "UcpDataSourceConfigBuilder{name=" + this.name + ",xaDataSource=" + this.xaDataSource + ",abandonedConnectionTimeout=" + this.abandonedConnectionTimeout + ",commitOnConnectionReturn=" + this.commitOnConnectionReturn + ",connectionFactoryClassName=" + this.connectionFactoryClassName + ",connectionFactoryProperties=" + String.valueOf(this.connectionFactoryProperties) + ",connectionHarvestMaxCount=" + this.connectionHarvestMaxCount + ",connectionHarvestTriggerCount=" + this.connectionHarvestTriggerCount + ",connectionLabelingHighCost=" + this.connectionLabelingHighCost + ",connectionPoolName=" + this.connectionPoolName + ",connectionProperties=" + String.valueOf(this.connectionProperties) + ",connectionRepurposeThreshold=" + this.connectionRepurposeThreshold + ",connectionValidationTimeout=" + this.connectionValidationTimeout + ",connectionWaitDuration=" + String.valueOf(this.connectionWaitDuration) + ",createConnectionInBorrowThread=" + this.createConnectionInBorrowThread + ",databaseName=" + this.databaseName + ",dataSourceName=" + this.dataSourceName + ",description=" + this.description + ",fastConnectionFailoverEnabled=" + this.fastConnectionFailoverEnabled + ",highCostConnectionReuseThreshold=" + this.highCostConnectionReuseThreshold + ",inactiveConnectionTimeout=" + this.inactiveConnectionTimeout + ",initialPoolSize=" + this.initialPoolSize + ",maxConnectionReuseCount=" + this.maxConnectionReuseCount + ",maxConnectionReuseTime=" + this.maxConnectionReuseTime + ",maxConnectionsPerShard=" + this.maxConnectionsPerShard + ",maxIdleTime=" + this.maxIdleTime + ",maxPoolSize=" + this.maxPoolSize + ",minPoolSize=" + this.minPoolSize + ",maxStatements=" + this.maxStatements + ",minIdle=" + this.minIdle + ",networkProtocol=" + this.networkProtocol + ",onsConfiguration=" + this.onsConfiguration + ",portNumber=" + this.portNumber + ",propertyCycle=" + this.propertyCycle + ",queryTimeout=" + this.queryTimeout + ",readOnlyInstanceAllowed=" + this.readOnlyInstanceAllowed + ",roleName=" + this.roleName + ",secondsToTrustIdleConnection=" + this.secondsToTrustIdleConnection + ",serverName=" + this.serverName + ",shardingMode=" + this.shardingMode + ",sqlForValidateConnection=" + this.sqlForValidateConnection + ",timeoutCheckInterval=" + this.timeoutCheckInterval + ",timeToLiveConnectionTimeout=" + this.timeToLiveConnectionTimeout + ",validateConnectionOnBorrow=" + this.validateConnectionOnBorrow + "};" + super.toString();
        }

        protected void preBuildPrototype() {
            super.preBuildPrototype();
        }

        protected void validatePrototype() {
            super.validatePrototype();
            Errors.Collector collector = Errors.collector();
            if (this.name == null) {
                collector.fatal(((Object)((Object)this)).getClass(), "Property \"name\" must not be null, but not set");
            }
            collector.collect().checkValid();
        }

        BUILDER xaDataSource(Optional<Boolean> xaDataSource) {
            Objects.requireNonNull(xaDataSource);
            this.xaDataSource = xaDataSource.map(Boolean.class::cast).orElse(this.xaDataSource);
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        BUILDER abandonedConnectionTimeout(Optional<Integer> abandonedConnectionTimeout) {
            Objects.requireNonNull(abandonedConnectionTimeout);
            this.abandonedConnectionTimeout = abandonedConnectionTimeout.map(Integer.class::cast).orElse(this.abandonedConnectionTimeout);
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        BUILDER commitOnConnectionReturn(Optional<Boolean> commitOnConnectionReturn) {
            Objects.requireNonNull(commitOnConnectionReturn);
            this.commitOnConnectionReturn = commitOnConnectionReturn.map(Boolean.class::cast).orElse(this.commitOnConnectionReturn);
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        BUILDER connectionFactoryClassName(Optional<String> connectionFactoryClassName) {
            Objects.requireNonNull(connectionFactoryClassName);
            this.connectionFactoryClassName = connectionFactoryClassName.map(String.class::cast).orElse(this.connectionFactoryClassName);
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        BUILDER connectionFactoryProperties(Optional<Map<String, String>> connectionFactoryProperties) {
            Objects.requireNonNull(connectionFactoryProperties);
            this.connectionFactoryProperties = connectionFactoryProperties.map(Map.class::cast).orElse(this.connectionFactoryProperties);
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        BUILDER connectionHarvestMaxCount(Optional<Integer> connectionHarvestMaxCount) {
            Objects.requireNonNull(connectionHarvestMaxCount);
            this.connectionHarvestMaxCount = connectionHarvestMaxCount.map(Integer.class::cast).orElse(this.connectionHarvestMaxCount);
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        BUILDER connectionHarvestTriggerCount(Optional<Integer> connectionHarvestTriggerCount) {
            Objects.requireNonNull(connectionHarvestTriggerCount);
            this.connectionHarvestTriggerCount = connectionHarvestTriggerCount.map(Integer.class::cast).orElse(this.connectionHarvestTriggerCount);
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        BUILDER connectionLabelingHighCost(Optional<Integer> connectionLabelingHighCost) {
            Objects.requireNonNull(connectionLabelingHighCost);
            this.connectionLabelingHighCost = connectionLabelingHighCost.map(Integer.class::cast).orElse(this.connectionLabelingHighCost);
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        BUILDER connectionPoolName(Optional<String> connectionPoolName) {
            Objects.requireNonNull(connectionPoolName);
            this.connectionPoolName = connectionPoolName.map(String.class::cast).orElse(this.connectionPoolName);
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        BUILDER connectionProperties(Optional<Map<String, String>> connectionProperties) {
            Objects.requireNonNull(connectionProperties);
            this.connectionProperties = connectionProperties.map(Map.class::cast).orElse(this.connectionProperties);
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        BUILDER connectionRepurposeThreshold(Optional<Integer> connectionRepurposeThreshold) {
            Objects.requireNonNull(connectionRepurposeThreshold);
            this.connectionRepurposeThreshold = connectionRepurposeThreshold.map(Integer.class::cast).orElse(this.connectionRepurposeThreshold);
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        BUILDER connectionValidationTimeout(Optional<Integer> connectionValidationTimeout) {
            Objects.requireNonNull(connectionValidationTimeout);
            this.connectionValidationTimeout = connectionValidationTimeout.map(Integer.class::cast).orElse(this.connectionValidationTimeout);
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        BUILDER connectionWaitDuration(Optional<? extends Duration> connectionWaitDuration) {
            Objects.requireNonNull(connectionWaitDuration);
            this.connectionWaitDuration = connectionWaitDuration.map(Duration.class::cast).orElse(this.connectionWaitDuration);
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        BUILDER createConnectionInBorrowThread(Optional<Boolean> createConnectionInBorrowThread) {
            Objects.requireNonNull(createConnectionInBorrowThread);
            this.createConnectionInBorrowThread = createConnectionInBorrowThread.map(Boolean.class::cast).orElse(this.createConnectionInBorrowThread);
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        BUILDER databaseName(Optional<String> databaseName) {
            Objects.requireNonNull(databaseName);
            this.databaseName = databaseName.map(String.class::cast).orElse(this.databaseName);
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        BUILDER dataSourceName(Optional<String> dataSourceName) {
            Objects.requireNonNull(dataSourceName);
            this.dataSourceName = dataSourceName.map(String.class::cast).orElse(this.dataSourceName);
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        BUILDER description(Optional<String> description) {
            Objects.requireNonNull(description);
            this.description = description.map(String.class::cast).orElse(this.description);
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        BUILDER fastConnectionFailoverEnabled(Optional<Boolean> fastConnectionFailoverEnabled) {
            Objects.requireNonNull(fastConnectionFailoverEnabled);
            this.fastConnectionFailoverEnabled = fastConnectionFailoverEnabled.map(Boolean.class::cast).orElse(this.fastConnectionFailoverEnabled);
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        BUILDER highCostConnectionReuseThreshold(Optional<Integer> highCostConnectionReuseThreshold) {
            Objects.requireNonNull(highCostConnectionReuseThreshold);
            this.highCostConnectionReuseThreshold = highCostConnectionReuseThreshold.map(Integer.class::cast).orElse(this.highCostConnectionReuseThreshold);
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        BUILDER inactiveConnectionTimeout(Optional<Integer> inactiveConnectionTimeout) {
            Objects.requireNonNull(inactiveConnectionTimeout);
            this.inactiveConnectionTimeout = inactiveConnectionTimeout.map(Integer.class::cast).orElse(this.inactiveConnectionTimeout);
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        BUILDER initialPoolSize(Optional<Integer> initialPoolSize) {
            Objects.requireNonNull(initialPoolSize);
            this.initialPoolSize = initialPoolSize.map(Integer.class::cast).orElse(this.initialPoolSize);
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        BUILDER maxConnectionReuseCount(Optional<Integer> maxConnectionReuseCount) {
            Objects.requireNonNull(maxConnectionReuseCount);
            this.maxConnectionReuseCount = maxConnectionReuseCount.map(Integer.class::cast).orElse(this.maxConnectionReuseCount);
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        BUILDER maxConnectionReuseTime(Optional<Long> maxConnectionReuseTime) {
            Objects.requireNonNull(maxConnectionReuseTime);
            this.maxConnectionReuseTime = maxConnectionReuseTime.map(Long.class::cast).orElse(this.maxConnectionReuseTime);
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        BUILDER maxConnectionsPerShard(Optional<Integer> maxConnectionsPerShard) {
            Objects.requireNonNull(maxConnectionsPerShard);
            this.maxConnectionsPerShard = maxConnectionsPerShard.map(Integer.class::cast).orElse(this.maxConnectionsPerShard);
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        BUILDER maxIdleTime(Optional<Integer> maxIdleTime) {
            Objects.requireNonNull(maxIdleTime);
            this.maxIdleTime = maxIdleTime.map(Integer.class::cast).orElse(this.maxIdleTime);
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        BUILDER maxPoolSize(Optional<Integer> maxPoolSize) {
            Objects.requireNonNull(maxPoolSize);
            this.maxPoolSize = maxPoolSize.map(Integer.class::cast).orElse(this.maxPoolSize);
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        BUILDER minPoolSize(Optional<Integer> minPoolSize) {
            Objects.requireNonNull(minPoolSize);
            this.minPoolSize = minPoolSize.map(Integer.class::cast).orElse(this.minPoolSize);
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        BUILDER maxStatements(Optional<Integer> maxStatements) {
            Objects.requireNonNull(maxStatements);
            this.maxStatements = maxStatements.map(Integer.class::cast).orElse(this.maxStatements);
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        BUILDER minIdle(Optional<Integer> minIdle) {
            Objects.requireNonNull(minIdle);
            this.minIdle = minIdle.map(Integer.class::cast).orElse(this.minIdle);
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        BUILDER networkProtocol(Optional<String> networkProtocol) {
            Objects.requireNonNull(networkProtocol);
            this.networkProtocol = networkProtocol.map(String.class::cast).orElse(this.networkProtocol);
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        BUILDER onsConfiguration(Optional<String> onsConfiguration) {
            Objects.requireNonNull(onsConfiguration);
            this.onsConfiguration = onsConfiguration.map(String.class::cast).orElse(this.onsConfiguration);
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        BUILDER portNumber(Optional<Integer> portNumber) {
            Objects.requireNonNull(portNumber);
            this.portNumber = portNumber.map(Integer.class::cast).orElse(this.portNumber);
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        BUILDER propertyCycle(Optional<Integer> propertyCycle) {
            Objects.requireNonNull(propertyCycle);
            this.propertyCycle = propertyCycle.map(Integer.class::cast).orElse(this.propertyCycle);
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        BUILDER queryTimeout(Optional<Integer> queryTimeout) {
            Objects.requireNonNull(queryTimeout);
            this.queryTimeout = queryTimeout.map(Integer.class::cast).orElse(this.queryTimeout);
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        BUILDER readOnlyInstanceAllowed(Optional<Boolean> readOnlyInstanceAllowed) {
            Objects.requireNonNull(readOnlyInstanceAllowed);
            this.readOnlyInstanceAllowed = readOnlyInstanceAllowed.map(Boolean.class::cast).orElse(this.readOnlyInstanceAllowed);
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        BUILDER roleName(Optional<String> roleName) {
            Objects.requireNonNull(roleName);
            this.roleName = roleName.map(String.class::cast).orElse(this.roleName);
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        BUILDER secondsToTrustIdleConnection(Optional<Integer> secondsToTrustIdleConnection) {
            Objects.requireNonNull(secondsToTrustIdleConnection);
            this.secondsToTrustIdleConnection = secondsToTrustIdleConnection.map(Integer.class::cast).orElse(this.secondsToTrustIdleConnection);
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        BUILDER serverName(Optional<String> serverName) {
            Objects.requireNonNull(serverName);
            this.serverName = serverName.map(String.class::cast).orElse(this.serverName);
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        BUILDER shardingMode(Optional<Boolean> shardingMode) {
            Objects.requireNonNull(shardingMode);
            this.shardingMode = shardingMode.map(Boolean.class::cast).orElse(this.shardingMode);
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        BUILDER sqlForValidateConnection(Optional<String> sqlForValidateConnection) {
            Objects.requireNonNull(sqlForValidateConnection);
            this.sqlForValidateConnection = sqlForValidateConnection.map(String.class::cast).orElse(this.sqlForValidateConnection);
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        BUILDER timeoutCheckInterval(Optional<Integer> timeoutCheckInterval) {
            Objects.requireNonNull(timeoutCheckInterval);
            this.timeoutCheckInterval = timeoutCheckInterval.map(Integer.class::cast).orElse(this.timeoutCheckInterval);
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        BUILDER timeToLiveConnectionTimeout(Optional<Integer> timeToLiveConnectionTimeout) {
            Objects.requireNonNull(timeToLiveConnectionTimeout);
            this.timeToLiveConnectionTimeout = timeToLiveConnectionTimeout.map(Integer.class::cast).orElse(this.timeToLiveConnectionTimeout);
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        BUILDER validateConnectionOnBorrow(Optional<Boolean> validateConnectionOnBorrow) {
            Objects.requireNonNull(validateConnectionOnBorrow);
            this.validateConnectionOnBorrow = validateConnectionOnBorrow.map(Boolean.class::cast).orElse(this.validateConnectionOnBorrow);
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        protected static class UcpDataSourceConfigImpl
        extends ConnectionConfig.BuilderBase.ConnectionConfigImpl
        implements UcpDataSourceConfig {
            private final Optional<Boolean> commitOnConnectionReturn;
            private final Optional<Boolean> createConnectionInBorrowThread;
            private final Optional<Boolean> fastConnectionFailoverEnabled;
            private final Optional<Boolean> readOnlyInstanceAllowed;
            private final Optional<Boolean> shardingMode;
            private final Optional<Boolean> validateConnectionOnBorrow;
            private final Optional<Boolean> xaDataSource;
            private final Optional<Integer> abandonedConnectionTimeout;
            private final Optional<Integer> connectionHarvestMaxCount;
            private final Optional<Integer> connectionHarvestTriggerCount;
            private final Optional<Integer> connectionLabelingHighCost;
            private final Optional<Integer> connectionRepurposeThreshold;
            private final Optional<Integer> connectionValidationTimeout;
            private final Optional<Integer> highCostConnectionReuseThreshold;
            private final Optional<Integer> inactiveConnectionTimeout;
            private final Optional<Integer> initialPoolSize;
            private final Optional<Integer> maxConnectionReuseCount;
            private final Optional<Integer> maxConnectionsPerShard;
            private final Optional<Integer> maxIdleTime;
            private final Optional<Integer> maxPoolSize;
            private final Optional<Integer> maxStatements;
            private final Optional<Integer> minIdle;
            private final Optional<Integer> minPoolSize;
            private final Optional<Integer> portNumber;
            private final Optional<Integer> propertyCycle;
            private final Optional<Integer> queryTimeout;
            private final Optional<Integer> secondsToTrustIdleConnection;
            private final Optional<Integer> timeToLiveConnectionTimeout;
            private final Optional<Integer> timeoutCheckInterval;
            private final Optional<Long> maxConnectionReuseTime;
            private final Optional<String> connectionFactoryClassName;
            private final Optional<String> connectionPoolName;
            private final Optional<String> dataSourceName;
            private final Optional<String> databaseName;
            private final Optional<String> description;
            private final Optional<String> networkProtocol;
            private final Optional<String> onsConfiguration;
            private final Optional<String> roleName;
            private final Optional<String> serverName;
            private final Optional<String> sqlForValidateConnection;
            private final Optional<Duration> connectionWaitDuration;
            private final Optional<Map<String, String>> connectionFactoryProperties;
            private final Optional<Map<String, String>> connectionProperties;
            private final String name;

            protected UcpDataSourceConfigImpl(BuilderBase<?, ?> builder) {
                super(builder);
                this.name = builder.name().get();
                this.xaDataSource = builder.xaDataSource().map(Function.identity());
                this.abandonedConnectionTimeout = builder.abandonedConnectionTimeout().map(Function.identity());
                this.commitOnConnectionReturn = builder.commitOnConnectionReturn().map(Function.identity());
                this.connectionFactoryClassName = builder.connectionFactoryClassName().map(Function.identity());
                this.connectionFactoryProperties = builder.connectionFactoryProperties().map(Function.identity());
                this.connectionHarvestMaxCount = builder.connectionHarvestMaxCount().map(Function.identity());
                this.connectionHarvestTriggerCount = builder.connectionHarvestTriggerCount().map(Function.identity());
                this.connectionLabelingHighCost = builder.connectionLabelingHighCost().map(Function.identity());
                this.connectionPoolName = builder.connectionPoolName().map(Function.identity());
                this.connectionProperties = builder.connectionProperties().map(Function.identity());
                this.connectionRepurposeThreshold = builder.connectionRepurposeThreshold().map(Function.identity());
                this.connectionValidationTimeout = builder.connectionValidationTimeout().map(Function.identity());
                this.connectionWaitDuration = builder.connectionWaitDuration().map(Function.identity());
                this.createConnectionInBorrowThread = builder.createConnectionInBorrowThread().map(Function.identity());
                this.databaseName = builder.databaseName().map(Function.identity());
                this.dataSourceName = builder.dataSourceName().map(Function.identity());
                this.description = builder.description().map(Function.identity());
                this.fastConnectionFailoverEnabled = builder.fastConnectionFailoverEnabled().map(Function.identity());
                this.highCostConnectionReuseThreshold = builder.highCostConnectionReuseThreshold().map(Function.identity());
                this.inactiveConnectionTimeout = builder.inactiveConnectionTimeout().map(Function.identity());
                this.initialPoolSize = builder.initialPoolSize().map(Function.identity());
                this.maxConnectionReuseCount = builder.maxConnectionReuseCount().map(Function.identity());
                this.maxConnectionReuseTime = builder.maxConnectionReuseTime().map(Function.identity());
                this.maxConnectionsPerShard = builder.maxConnectionsPerShard().map(Function.identity());
                this.maxIdleTime = builder.maxIdleTime().map(Function.identity());
                this.maxPoolSize = builder.maxPoolSize().map(Function.identity());
                this.minPoolSize = builder.minPoolSize().map(Function.identity());
                this.maxStatements = builder.maxStatements().map(Function.identity());
                this.minIdle = builder.minIdle().map(Function.identity());
                this.networkProtocol = builder.networkProtocol().map(Function.identity());
                this.onsConfiguration = builder.onsConfiguration().map(Function.identity());
                this.portNumber = builder.portNumber().map(Function.identity());
                this.propertyCycle = builder.propertyCycle().map(Function.identity());
                this.queryTimeout = builder.queryTimeout().map(Function.identity());
                this.readOnlyInstanceAllowed = builder.readOnlyInstanceAllowed().map(Function.identity());
                this.roleName = builder.roleName().map(Function.identity());
                this.secondsToTrustIdleConnection = builder.secondsToTrustIdleConnection().map(Function.identity());
                this.serverName = builder.serverName().map(Function.identity());
                this.shardingMode = builder.shardingMode().map(Function.identity());
                this.sqlForValidateConnection = builder.sqlForValidateConnection().map(Function.identity());
                this.timeoutCheckInterval = builder.timeoutCheckInterval().map(Function.identity());
                this.timeToLiveConnectionTimeout = builder.timeToLiveConnectionTimeout().map(Function.identity());
                this.validateConnectionOnBorrow = builder.validateConnectionOnBorrow().map(Function.identity());
            }

            @Override
            public String name() {
                return this.name;
            }

            @Override
            public Optional<Boolean> xaDataSource() {
                return this.xaDataSource;
            }

            @Override
            public Optional<Integer> abandonedConnectionTimeout() {
                return this.abandonedConnectionTimeout;
            }

            @Override
            public Optional<Boolean> commitOnConnectionReturn() {
                return this.commitOnConnectionReturn;
            }

            @Override
            public Optional<String> connectionFactoryClassName() {
                return this.connectionFactoryClassName;
            }

            @Override
            public Optional<Map<String, String>> connectionFactoryProperties() {
                return this.connectionFactoryProperties;
            }

            @Override
            public Optional<Integer> connectionHarvestMaxCount() {
                return this.connectionHarvestMaxCount;
            }

            @Override
            public Optional<Integer> connectionHarvestTriggerCount() {
                return this.connectionHarvestTriggerCount;
            }

            @Override
            public Optional<Integer> connectionLabelingHighCost() {
                return this.connectionLabelingHighCost;
            }

            @Override
            public Optional<String> connectionPoolName() {
                return this.connectionPoolName;
            }

            @Override
            public Optional<Map<String, String>> connectionProperties() {
                return this.connectionProperties;
            }

            @Override
            public Optional<Integer> connectionRepurposeThreshold() {
                return this.connectionRepurposeThreshold;
            }

            @Override
            public Optional<Integer> connectionValidationTimeout() {
                return this.connectionValidationTimeout;
            }

            @Override
            public Optional<Duration> connectionWaitDuration() {
                return this.connectionWaitDuration;
            }

            @Override
            public Optional<Boolean> createConnectionInBorrowThread() {
                return this.createConnectionInBorrowThread;
            }

            @Override
            public Optional<String> databaseName() {
                return this.databaseName;
            }

            @Override
            public Optional<String> dataSourceName() {
                return this.dataSourceName;
            }

            @Override
            public Optional<String> description() {
                return this.description;
            }

            @Override
            public Optional<Boolean> fastConnectionFailoverEnabled() {
                return this.fastConnectionFailoverEnabled;
            }

            @Override
            public Optional<Integer> highCostConnectionReuseThreshold() {
                return this.highCostConnectionReuseThreshold;
            }

            @Override
            public Optional<Integer> inactiveConnectionTimeout() {
                return this.inactiveConnectionTimeout;
            }

            @Override
            public Optional<Integer> initialPoolSize() {
                return this.initialPoolSize;
            }

            @Override
            public Optional<Integer> maxConnectionReuseCount() {
                return this.maxConnectionReuseCount;
            }

            @Override
            public Optional<Long> maxConnectionReuseTime() {
                return this.maxConnectionReuseTime;
            }

            @Override
            public Optional<Integer> maxConnectionsPerShard() {
                return this.maxConnectionsPerShard;
            }

            @Override
            public Optional<Integer> maxIdleTime() {
                return this.maxIdleTime;
            }

            @Override
            public Optional<Integer> maxPoolSize() {
                return this.maxPoolSize;
            }

            @Override
            public Optional<Integer> minPoolSize() {
                return this.minPoolSize;
            }

            @Override
            public Optional<Integer> maxStatements() {
                return this.maxStatements;
            }

            @Override
            public Optional<Integer> minIdle() {
                return this.minIdle;
            }

            @Override
            public Optional<String> networkProtocol() {
                return this.networkProtocol;
            }

            @Override
            public Optional<String> onsConfiguration() {
                return this.onsConfiguration;
            }

            @Override
            public Optional<Integer> portNumber() {
                return this.portNumber;
            }

            @Override
            public Optional<Integer> propertyCycle() {
                return this.propertyCycle;
            }

            @Override
            public Optional<Integer> queryTimeout() {
                return this.queryTimeout;
            }

            @Override
            public Optional<Boolean> readOnlyInstanceAllowed() {
                return this.readOnlyInstanceAllowed;
            }

            @Override
            public Optional<String> roleName() {
                return this.roleName;
            }

            @Override
            public Optional<Integer> secondsToTrustIdleConnection() {
                return this.secondsToTrustIdleConnection;
            }

            @Override
            public Optional<String> serverName() {
                return this.serverName;
            }

            @Override
            public Optional<Boolean> shardingMode() {
                return this.shardingMode;
            }

            @Override
            public Optional<String> sqlForValidateConnection() {
                return this.sqlForValidateConnection;
            }

            @Override
            public Optional<Integer> timeoutCheckInterval() {
                return this.timeoutCheckInterval;
            }

            @Override
            public Optional<Integer> timeToLiveConnectionTimeout() {
                return this.timeToLiveConnectionTimeout;
            }

            @Override
            public Optional<Boolean> validateConnectionOnBorrow() {
                return this.validateConnectionOnBorrow;
            }

            public String toString() {
                return "UcpDataSourceConfig{name=" + this.name + ",xaDataSource=" + String.valueOf(this.xaDataSource) + ",abandonedConnectionTimeout=" + String.valueOf(this.abandonedConnectionTimeout) + ",commitOnConnectionReturn=" + String.valueOf(this.commitOnConnectionReturn) + ",connectionFactoryClassName=" + String.valueOf(this.connectionFactoryClassName) + ",connectionFactoryProperties=" + String.valueOf(this.connectionFactoryProperties) + ",connectionHarvestMaxCount=" + String.valueOf(this.connectionHarvestMaxCount) + ",connectionHarvestTriggerCount=" + String.valueOf(this.connectionHarvestTriggerCount) + ",connectionLabelingHighCost=" + String.valueOf(this.connectionLabelingHighCost) + ",connectionPoolName=" + String.valueOf(this.connectionPoolName) + ",connectionProperties=" + String.valueOf(this.connectionProperties) + ",connectionRepurposeThreshold=" + String.valueOf(this.connectionRepurposeThreshold) + ",connectionValidationTimeout=" + String.valueOf(this.connectionValidationTimeout) + ",connectionWaitDuration=" + String.valueOf(this.connectionWaitDuration) + ",createConnectionInBorrowThread=" + String.valueOf(this.createConnectionInBorrowThread) + ",databaseName=" + String.valueOf(this.databaseName) + ",dataSourceName=" + String.valueOf(this.dataSourceName) + ",description=" + String.valueOf(this.description) + ",fastConnectionFailoverEnabled=" + String.valueOf(this.fastConnectionFailoverEnabled) + ",highCostConnectionReuseThreshold=" + String.valueOf(this.highCostConnectionReuseThreshold) + ",inactiveConnectionTimeout=" + String.valueOf(this.inactiveConnectionTimeout) + ",initialPoolSize=" + String.valueOf(this.initialPoolSize) + ",maxConnectionReuseCount=" + String.valueOf(this.maxConnectionReuseCount) + ",maxConnectionReuseTime=" + String.valueOf(this.maxConnectionReuseTime) + ",maxConnectionsPerShard=" + String.valueOf(this.maxConnectionsPerShard) + ",maxIdleTime=" + String.valueOf(this.maxIdleTime) + ",maxPoolSize=" + String.valueOf(this.maxPoolSize) + ",minPoolSize=" + String.valueOf(this.minPoolSize) + ",maxStatements=" + String.valueOf(this.maxStatements) + ",minIdle=" + String.valueOf(this.minIdle) + ",networkProtocol=" + String.valueOf(this.networkProtocol) + ",onsConfiguration=" + String.valueOf(this.onsConfiguration) + ",portNumber=" + String.valueOf(this.portNumber) + ",propertyCycle=" + String.valueOf(this.propertyCycle) + ",queryTimeout=" + String.valueOf(this.queryTimeout) + ",readOnlyInstanceAllowed=" + String.valueOf(this.readOnlyInstanceAllowed) + ",roleName=" + String.valueOf(this.roleName) + ",secondsToTrustIdleConnection=" + String.valueOf(this.secondsToTrustIdleConnection) + ",serverName=" + String.valueOf(this.serverName) + ",shardingMode=" + String.valueOf(this.shardingMode) + ",sqlForValidateConnection=" + String.valueOf(this.sqlForValidateConnection) + ",timeoutCheckInterval=" + String.valueOf(this.timeoutCheckInterval) + ",timeToLiveConnectionTimeout=" + String.valueOf(this.timeToLiveConnectionTimeout) + ",validateConnectionOnBorrow=" + String.valueOf(this.validateConnectionOnBorrow) + "};" + super.toString();
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof UcpDataSourceConfig)) {
                    return false;
                }
                UcpDataSourceConfig other = (UcpDataSourceConfig)o;
                return super.equals((Object)other) && Objects.equals(this.name, other.name()) && Objects.equals(this.xaDataSource, other.xaDataSource()) && Objects.equals(this.abandonedConnectionTimeout, other.abandonedConnectionTimeout()) && Objects.equals(this.commitOnConnectionReturn, other.commitOnConnectionReturn()) && Objects.equals(this.connectionFactoryClassName, other.connectionFactoryClassName()) && Objects.equals(this.connectionFactoryProperties, other.connectionFactoryProperties()) && Objects.equals(this.connectionHarvestMaxCount, other.connectionHarvestMaxCount()) && Objects.equals(this.connectionHarvestTriggerCount, other.connectionHarvestTriggerCount()) && Objects.equals(this.connectionLabelingHighCost, other.connectionLabelingHighCost()) && Objects.equals(this.connectionPoolName, other.connectionPoolName()) && Objects.equals(this.connectionProperties, other.connectionProperties()) && Objects.equals(this.connectionRepurposeThreshold, other.connectionRepurposeThreshold()) && Objects.equals(this.connectionValidationTimeout, other.connectionValidationTimeout()) && Objects.equals(this.connectionWaitDuration, other.connectionWaitDuration()) && Objects.equals(this.createConnectionInBorrowThread, other.createConnectionInBorrowThread()) && Objects.equals(this.databaseName, other.databaseName()) && Objects.equals(this.dataSourceName, other.dataSourceName()) && Objects.equals(this.description, other.description()) && Objects.equals(this.fastConnectionFailoverEnabled, other.fastConnectionFailoverEnabled()) && Objects.equals(this.highCostConnectionReuseThreshold, other.highCostConnectionReuseThreshold()) && Objects.equals(this.inactiveConnectionTimeout, other.inactiveConnectionTimeout()) && Objects.equals(this.initialPoolSize, other.initialPoolSize()) && Objects.equals(this.maxConnectionReuseCount, other.maxConnectionReuseCount()) && Objects.equals(this.maxConnectionReuseTime, other.maxConnectionReuseTime()) && Objects.equals(this.maxConnectionsPerShard, other.maxConnectionsPerShard()) && Objects.equals(this.maxIdleTime, other.maxIdleTime()) && Objects.equals(this.maxPoolSize, other.maxPoolSize()) && Objects.equals(this.minPoolSize, other.minPoolSize()) && Objects.equals(this.maxStatements, other.maxStatements()) && Objects.equals(this.minIdle, other.minIdle()) && Objects.equals(this.networkProtocol, other.networkProtocol()) && Objects.equals(this.onsConfiguration, other.onsConfiguration()) && Objects.equals(this.portNumber, other.portNumber()) && Objects.equals(this.propertyCycle, other.propertyCycle()) && Objects.equals(this.queryTimeout, other.queryTimeout()) && Objects.equals(this.readOnlyInstanceAllowed, other.readOnlyInstanceAllowed()) && Objects.equals(this.roleName, other.roleName()) && Objects.equals(this.secondsToTrustIdleConnection, other.secondsToTrustIdleConnection()) && Objects.equals(this.serverName, other.serverName()) && Objects.equals(this.shardingMode, other.shardingMode()) && Objects.equals(this.sqlForValidateConnection, other.sqlForValidateConnection()) && Objects.equals(this.timeoutCheckInterval, other.timeoutCheckInterval()) && Objects.equals(this.timeToLiveConnectionTimeout, other.timeToLiveConnectionTimeout()) && Objects.equals(this.validateConnectionOnBorrow, other.validateConnectionOnBorrow());
            }

            public int hashCode() {
                return 31 * super.hashCode() + Objects.hash(this.name, this.xaDataSource, this.abandonedConnectionTimeout, this.commitOnConnectionReturn, this.connectionFactoryClassName, this.connectionFactoryProperties, this.connectionHarvestMaxCount, this.connectionHarvestTriggerCount, this.connectionLabelingHighCost, this.connectionPoolName, this.connectionProperties, this.connectionRepurposeThreshold, this.connectionValidationTimeout, this.connectionWaitDuration, this.createConnectionInBorrowThread, this.databaseName, this.dataSourceName, this.description, this.fastConnectionFailoverEnabled, this.highCostConnectionReuseThreshold, this.inactiveConnectionTimeout, this.initialPoolSize, this.maxConnectionReuseCount, this.maxConnectionReuseTime, this.maxConnectionsPerShard, this.maxIdleTime, this.maxPoolSize, this.minPoolSize, this.maxStatements, this.minIdle, this.networkProtocol, this.onsConfiguration, this.portNumber, this.propertyCycle, this.queryTimeout, this.readOnlyInstanceAllowed, this.roleName, this.secondsToTrustIdleConnection, this.serverName, this.shardingMode, this.sqlForValidateConnection, this.timeoutCheckInterval, this.timeToLiveConnectionTimeout, this.validateConnectionOnBorrow);
            }
        }
    }
}

