/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.data.codegen.common;

import io.helidon.codegen.CodegenContext;
import io.helidon.codegen.classmodel.ClassModel;
import io.helidon.common.types.TypeInfo;
import io.helidon.common.types.TypeName;
import io.helidon.data.codegen.common.RepositoryInfo;
import io.helidon.data.codegen.common.RepositoryInterfaceGenerator;
import io.helidon.data.codegen.common.RepositoryInterfaceInfo;
import io.helidon.data.codegen.common.TypeInfoSpliterator;
import io.helidon.data.codegen.common.spi.PersistenceGenerator;
import io.helidon.data.codegen.common.spi.RepositoryGenerator;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.StreamSupport;

public abstract class BaseRepositoryGenerator
implements RepositoryGenerator {
    protected BaseRepositoryGenerator() {
    }

    public static boolean hasInterface(TypeInfo interfaceInfo, TypeName interfaceName) {
        AtomicBoolean result = new AtomicBoolean();
        result.set(false);
        StreamSupport.stream(new TypeInfoSpliterator(interfaceInfo), false).forEach(info -> {
            if (info.typeName().equals((Object)interfaceName)) {
                result.set(true);
            }
        });
        return result.get();
    }

    @Override
    public RepositoryInfo createRepositoryInfo(TypeInfo interfaceInfo, CodegenContext codegenContext) {
        RepositoryInfo.Builder builder = this.repositoryInfoBuilder(codegenContext);
        builder.interfaceInfo(interfaceInfo);
        StreamSupport.stream(new TypeInfoSpliterator(interfaceInfo), false).forEach(info -> {
            if (!interfaceInfo.typeName().equals((Object)info.typeName()) && info.typeName().typeArguments().size() == 2) {
                builder.addInterface(info.typeName(), RepositoryInterfaceInfo.create(info));
            }
        });
        return (RepositoryInfo)builder.build();
    }

    protected abstract RepositoryInfo.Builder repositoryInfoBuilder(CodegenContext var1);

    protected static interface GeneratorFactory {
        public RepositoryInterfaceGenerator create(RepositoryInfo var1, ClassModel.Builder var2, CodegenContext var3, PersistenceGenerator var4);
    }
}

