/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.codegen;

import io.helidon.codegen.ClassCode;
import io.helidon.codegen.CodegenContext;
import io.helidon.codegen.CodegenFiler;
import io.helidon.codegen.CodegenOptions;
import io.helidon.codegen.Option;
import io.helidon.codegen.RoundContextImpl;
import io.helidon.codegen.TypeHierarchy;
import io.helidon.codegen.classmodel.ClassModel;
import io.helidon.codegen.spi.CodegenExtension;
import io.helidon.codegen.spi.CodegenExtensionProvider;
import io.helidon.common.HelidonServiceLoader;
import io.helidon.common.types.TypeInfo;
import io.helidon.common.types.TypeName;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class Codegen {
    private static final List<CodegenExtensionProvider> EXTENSIONS = HelidonServiceLoader.create(ServiceLoader.load(CodegenExtensionProvider.class, Codegen.class.getClassLoader())).asList();
    private static final Set<Option<?>> SUPPORTED_APT_OPTIONS;
    private final Map<TypeName, List<CodegenExtension>> typeToExtensions = new HashMap<TypeName, List<CodegenExtension>>();
    private final Map<CodegenExtension, Predicate<TypeName>> extensionPredicates = new IdentityHashMap<CodegenExtension, Predicate<TypeName>>();
    private final CodegenContext ctx;
    private final List<CodegenExtension> extensions;
    private final Set<TypeName> supportedAnnotations;
    private final Set<String> supportedPackagePrefixes;

    private Codegen(CodegenContext ctx, TypeName generator) {
        this.ctx = ctx;
        this.extensions = EXTENSIONS.stream().map(it -> {
            CodegenExtension extension = it.create(this.ctx, generator);
            for (TypeName typeName : it.supportedAnnotations()) {
                this.typeToExtensions.computeIfAbsent(typeName, key -> new ArrayList()).add(extension);
            }
            Set<String> packages = it.supportedAnnotationPackages();
            if (!packages.isEmpty()) {
                this.extensionPredicates.put(extension, Codegen.discoveryPredicate(packages));
            }
            return extension;
        }).toList();
        HashSet packagePrefixes = new HashSet();
        HashSet<TypeName> annotations = new HashSet<TypeName>(ctx.mapperSupportedAnnotations());
        for (CodegenExtensionProvider extension : EXTENSIONS) {
            annotations.addAll(extension.supportedAnnotations());
            ctx.mapperSupportedAnnotationPackages().stream().map(Codegen::toPackagePrefix).forEach(packagePrefixes::add);
        }
        ctx.mapperSupportedAnnotationPackages().stream().map(Codegen::toPackagePrefix).forEach(packagePrefixes::add);
        this.supportedAnnotations = Set.copyOf(annotations);
        this.supportedPackagePrefixes = Set.copyOf(packagePrefixes);
    }

    public static Codegen create(CodegenContext ctx, TypeName generator) {
        Codegen codegen = new Codegen(ctx, generator);
        HashSet allOptions = new HashSet(SUPPORTED_APT_OPTIONS);
        allOptions.addAll(ctx.supportedOptions());
        ctx.options().validate(allOptions);
        return codegen;
    }

    public static Set<Option<?>> supportedOptions() {
        return SUPPORTED_APT_OPTIONS;
    }

    public void process(List<TypeInfo> allTypes) {
        ArrayList<ClassCode> toWrite = new ArrayList<ClassCode>();
        List<TypeInfoAndAnnotations> annotatedTypes = this.annotatedTypes(allTypes);
        for (CodegenExtension extension : this.extensions) {
            RoundContextImpl roundCtx = this.createRoundContext(annotatedTypes, extension);
            extension.process(roundCtx);
            toWrite.addAll(roundCtx.newTypes());
        }
        this.writeNewTypes(toWrite);
    }

    public void processingOver() {
        ArrayList<ClassCode> toWrite = new ArrayList<ClassCode>();
        for (CodegenExtension extension : this.extensions) {
            RoundContextImpl roundCtx = this.createRoundContext(List.of(), extension);
            extension.processingOver(roundCtx);
            toWrite.addAll(roundCtx.newTypes());
        }
        this.writeNewTypes(toWrite);
    }

    public Set<TypeName> supportedAnnotations() {
        return this.supportedAnnotations;
    }

    public Set<String> supportedAnnotationPackagePrefixes() {
        return this.supportedPackagePrefixes;
    }

    private static Predicate<TypeName> discoveryPredicate(Collection<String> packages) {
        List<String> prefixes = packages.stream().map(it -> it.endsWith(".*") ? it.substring(0, it.length() - 2) : it).toList();
        return typeName -> {
            String packageName = typeName.packageName();
            for (String prefix : prefixes) {
                if (!packageName.startsWith(prefix)) continue;
                return true;
            }
            return false;
        };
    }

    private static String toPackagePrefix(String configured) {
        if (configured.endsWith(".*")) {
            return configured.substring(0, configured.length() - 1);
        }
        if (configured.endsWith(".")) {
            return configured;
        }
        return configured + ".";
    }

    private List<TypeInfoAndAnnotations> annotatedTypes(List<TypeInfo> allTypes) {
        ArrayList<TypeInfoAndAnnotations> result = new ArrayList<TypeInfoAndAnnotations>();
        for (TypeInfo typeInfo : allTypes) {
            result.add(new TypeInfoAndAnnotations(typeInfo, TypeHierarchy.nestedAnnotations(this.ctx, typeInfo)));
        }
        return result;
    }

    private void writeNewTypes(List<ClassCode> toWrite) {
        CodegenFiler filer = this.ctx.filer();
        for (ClassCode classCode : toWrite) {
            ClassModel classModel = classCode.classModel().build();
            filer.writeSourceFile(classModel, classCode.originatingElements());
        }
    }

    private RoundContextImpl createRoundContext(List<TypeInfoAndAnnotations> annotatedTypes, CodegenExtension extension) {
        HashSet<TypeName> extAnnots = new HashSet<TypeName>();
        HashMap<TypeName, List> extAnnotToType = new HashMap<TypeName, List>();
        HashMap<TypeName, TypeInfo> extTypes = new HashMap<TypeName, TypeInfo>();
        for (TypeInfoAndAnnotations annotatedType : annotatedTypes) {
            for (TypeName typeName : annotatedType.annotations()) {
                Predicate<TypeName> predicate;
                boolean added = false;
                List<CodegenExtension> validExts = this.typeToExtensions.get(typeName);
                if (validExts != null) {
                    for (CodegenExtension validExt : validExts) {
                        if (validExt != extension) continue;
                        extAnnots.add(typeName);
                        extAnnotToType.computeIfAbsent(typeName, key -> new ArrayList()).add(annotatedType.typeInfo());
                        extTypes.put(annotatedType.typeInfo().typeName(), annotatedType.typeInfo);
                        added = true;
                    }
                }
                if (added || (predicate = this.extensionPredicates.get(extension)) == null || !predicate.test(typeName)) continue;
                extAnnots.add(typeName);
                extAnnotToType.computeIfAbsent(typeName, key -> new ArrayList()).add(annotatedType.typeInfo());
                extTypes.put(annotatedType.typeInfo().typeName(), annotatedType.typeInfo);
            }
        }
        return new RoundContextImpl(this.ctx, Set.copyOf(extAnnots), Map.copyOf(extAnnotToType), List.copyOf(extTypes.values()));
    }

    static {
        Set supportedOptions = EXTENSIONS.stream().flatMap(it -> it.supportedOptions().stream()).collect(Collectors.toSet());
        supportedOptions.add(CodegenOptions.CODEGEN_SCOPE);
        supportedOptions.add(CodegenOptions.INDENT_TYPE);
        supportedOptions.add(CodegenOptions.INDENT_COUNT);
        SUPPORTED_APT_OPTIONS = Set.copyOf(supportedOptions);
    }

    private record TypeInfoAndAnnotations(TypeInfo typeInfo, Set<TypeName> annotations) {
    }
}

