/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.codegen;

import io.helidon.codegen.CodegenOptions;
import io.helidon.codegen.Option;
import io.helidon.common.GenericType;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;

final class ListOptionImpl<T>
implements Option<List<T>> {
    private final String name;
    private final String description;
    private final List<T> defaultValue;
    private final Function<String, T> mapFunction;
    private final GenericType<List<T>> type;

    ListOptionImpl(String name, String description, List<T> defaultValue, Function<String, T> mapFunction, GenericType<List<T>> type) {
        this.name = name;
        this.description = description;
        this.defaultValue = defaultValue;
        this.mapFunction = mapFunction;
        this.type = type;
    }

    @Override
    public GenericType<List<T>> type() {
        return this.type;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String description() {
        return this.description;
    }

    @Override
    public List<T> defaultValue() {
        return this.defaultValue;
    }

    @Override
    public Optional<List<T>> findValue(CodegenOptions options) {
        return options.option(this.name).map(it -> it.split(",")).map(this::toList);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListOptionImpl)) {
            return false;
        }
        ListOptionImpl option = (ListOptionImpl)o;
        return Objects.equals(this.name, option.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    private List<T> toList(String[] strings) {
        return Stream.of(strings).map(String::trim).map(this.mapFunction).toList();
    }
}

