/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.codegen.compiler;

import io.helidon.codegen.CodegenException;
import io.helidon.codegen.CodegenLogger;
import io.helidon.codegen.compiler.CompilerOptions;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticListener;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;

class JavaC {
    private final List<Path> classpath;
    private final List<Path> sourcepath;
    private final List<Path> modulepath;
    private final List<String> commandLineArgs;
    private final String source;
    private final String target;
    private final Path outputDirectory;
    private final CodegenLogger logger;

    private JavaC(CompilerOptions options) {
        this.classpath = options.classpath();
        this.sourcepath = options.sourcepath();
        this.modulepath = options.modulepath();
        this.commandLineArgs = options.commandLineArguments();
        this.source = options.source();
        this.target = options.target();
        this.outputDirectory = options.outputDirectory();
        this.logger = options.logger();
    }

    static JavaC create(CompilerOptions options) {
        return new JavaC(options);
    }

    Result compile(Path ... sourceFiles) {
        Result result = new Result();
        this.doCompile(result, sourceFiles);
        return result;
    }

    String toClasspath() {
        if (!this.classpath.isEmpty()) {
            return this.classpath.stream().map(Path::toAbsolutePath).map(Path::toString).collect(Collectors.joining(File.pathSeparator));
        }
        return null;
    }

    String toSourcepath() {
        if (!this.sourcepath.isEmpty()) {
            return this.sourcepath.stream().map(Path::toAbsolutePath).map(Path::toString).collect(Collectors.joining(File.pathSeparator));
        }
        return null;
    }

    String toModulePath() {
        if (!this.modulepath.isEmpty()) {
            return this.modulepath.stream().map(Path::toAbsolutePath).map(Path::toString).collect(Collectors.joining(File.pathSeparator));
        }
        return null;
    }

    private void doCompile(Result result, Path[] sourceFilesToCompile) {
        Boolean taskResult;
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        StandardJavaFileManager fileManager = compiler.getStandardFileManager(result, null, StandardCharsets.UTF_8);
        ArrayList<String> optionList = new ArrayList<String>();
        if (!this.classpath.isEmpty()) {
            optionList.add("-classpath");
            optionList.add(this.toClasspath());
        }
        if (!this.modulepath.isEmpty()) {
            optionList.add("--module-path");
            optionList.add(this.toModulePath());
        }
        if (!this.sourcepath.isEmpty()) {
            optionList.add("--source-path");
            optionList.add(this.toSourcepath());
        }
        if (this.source != null) {
            optionList.add("--source");
            optionList.add(this.source);
        }
        if (this.target != null) {
            optionList.add("--target");
            optionList.add(this.target);
        }
        optionList.addAll(this.commandLineArgs);
        if (this.outputDirectory != null) {
            optionList.add("-d");
            optionList.add(this.outputDirectory.toAbsolutePath().toString());
        }
        ArrayList<Path> filesToCompile = new ArrayList<Path>(Arrays.asList(sourceFilesToCompile));
        if (!this.modulepath.isEmpty()) {
            this.modulepath.forEach(path -> {
                Path pathToPossibleModuleInfo = path.resolve("module-info.java");
                if (Files.exists(pathToPossibleModuleInfo, new LinkOption[0])) {
                    filesToCompile.add(pathToPossibleModuleInfo);
                }
            });
        }
        Iterable<? extends JavaFileObject> compilationUnit = fileManager.getJavaFileObjectsFromPaths((Collection<? extends Path>)filesToCompile);
        JavaCompiler.CompilationTask task = compiler.getTask(null, fileManager, result, optionList, null, compilationUnit);
        if (this.logger != null) {
            this.logger.log(System.Logger.Level.DEBUG, "javac " + String.join((CharSequence)" ", optionList) + " " + Stream.of(sourceFilesToCompile).map(Path::toString).collect(Collectors.joining(" ")));
        }
        if ((taskResult = task.call()) != null && !taskResult.booleanValue()) {
            result.isSuccessful = false;
        }
    }

    class Result
    implements DiagnosticListener<JavaFileObject> {
        private final List<Diagnostic<?>> diagList = new ArrayList();
        private boolean isSuccessful = true;
        private boolean hasWarnings = false;

        private Result() {
        }

        public boolean isSuccessful() {
            return this.isSuccessful;
        }

        public boolean hasWarnings() {
            return this.hasWarnings;
        }

        public void maybeThrowError() {
            if (!this.isSuccessful()) {
                throw new CodegenException("Compilation error encountered:\n" + this.diagList.stream().map(Object::toString).collect(Collectors.joining("\n")));
            }
        }

        @Override
        public void report(Diagnostic<? extends JavaFileObject> diagnostic) {
            System.Logger.Level level;
            if (diagnostic.getKind() == Diagnostic.Kind.ERROR) {
                level = System.Logger.Level.ERROR;
                this.isSuccessful = false;
            } else if (Diagnostic.Kind.MANDATORY_WARNING == diagnostic.getKind() || Diagnostic.Kind.WARNING == diagnostic.getKind()) {
                level = System.Logger.Level.WARNING;
                this.hasWarnings = true;
            } else {
                level = System.Logger.Level.INFO;
            }
            this.diagList.add(diagnostic);
            JavaC.this.logger.log(level, diagnostic.toString());
        }
    }
}

