/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.codegen.apt;

import io.helidon.codegen.apt.AptTypeFactory;
import io.helidon.codegen.apt.ToAnnotationValueVisitor;
import io.helidon.common.types.Annotation;
import io.helidon.common.types.TypeName;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.util.Elements;

final class AptAnnotationFactory {
    private AptAnnotationFactory() {
    }

    public static Annotation createAnnotation(AnnotationMirror am, Elements elements) {
        TypeName val = AptTypeFactory.createTypeName(am.getAnnotationType()).orElseThrow(() -> new IllegalArgumentException("Cannot create annotation for non-existent type: " + String.valueOf(am.getAnnotationType())));
        return Annotation.create((TypeName)val, AptAnnotationFactory.extractAnnotationValues(am, elements));
    }

    private static Map<String, Object> extractAnnotationValues(AnnotationMirror am, Elements elements) {
        return AptAnnotationFactory.extractAnnotationValues(elements, elements.getElementValuesWithDefaults(am));
    }

    private static Map<String, Object> extractAnnotationValues(Elements elements, Map<? extends ExecutableElement, ? extends AnnotationValue> values) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        values.forEach((el, val) -> {
            String name = el.getSimpleName().toString();
            Object value = val.accept(new ToAnnotationValueVisitor(elements), null);
            if (value != null) {
                result.put(name, value);
            }
        });
        return result;
    }
}

