/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.builder.processor;

import io.helidon.builder.processor.AnnotationDataOption;
import io.helidon.builder.processor.FactoryMethods;
import io.helidon.builder.processor.TypeHandler;
import io.helidon.builder.processor.Types;
import io.helidon.common.processor.GeneratorTools;
import io.helidon.common.processor.classmodel.Field;
import io.helidon.common.processor.classmodel.InnerClass;
import io.helidon.common.processor.classmodel.Javadoc;
import io.helidon.common.processor.classmodel.Method;
import io.helidon.common.processor.classmodel.Parameter;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypeNames;
import java.io.File;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

abstract class TypeHandlerCollection
extends TypeHandler.OneTypeHandler {
    private static final Set<TypeName> BUILT_IN_MAPPERS = Set.of(TypeNames.STRING, TypeNames.BOXED_BOOLEAN, TypeNames.BOXED_BYTE, TypeNames.BOXED_SHORT, TypeNames.BOXED_INT, TypeNames.BOXED_LONG, TypeNames.BOXED_CHAR, TypeNames.BOXED_FLOAT, TypeNames.BOXED_DOUBLE, TypeNames.BOXED_VOID, TypeName.create(BigDecimal.class), TypeName.create(BigInteger.class), TypeName.create(Pattern.class), TypeName.create(Class.class), TypeName.create(Duration.class), TypeName.create(Period.class), TypeName.create(LocalDate.class), TypeName.create(LocalDateTime.class), TypeName.create(LocalTime.class), TypeName.create(ZonedDateTime.class), TypeName.create(ZoneId.class), TypeName.create(ZoneOffset.class), TypeName.create(Instant.class), TypeName.create(OffsetTime.class), TypeName.create(OffsetDateTime.class), TypeName.create(YearMonth.class), TypeName.create(File.class), TypeName.create(Path.class), TypeName.create(Charset.class), TypeName.create(URI.class), TypeName.create(URL.class), TypeName.create(UUID.class));
    private final TypeName collectionType;
    private final TypeName collectionImplType;
    private final String collector;
    private final Optional<String> configMapper;

    TypeHandlerCollection(String name, String getterName, String setterName, TypeName declaredType, TypeName collectionType, String collector, Optional<String> configMapper) {
        super(name, getterName, setterName, declaredType);
        this.collectionType = collectionType;
        this.collectionImplType = TypeHandlerCollection.collectionImplType(collectionType);
        this.collector = collector;
        this.configMapper = configMapper;
    }

    @Override
    Field.Builder fieldDeclaration(AnnotationDataOption configured, boolean isBuilder, boolean alwaysFinal) {
        Field.Builder builder = super.fieldDeclaration(configured, isBuilder, true);
        if (isBuilder && !configured.hasDefault()) {
            builder.defaultValue(this.newCollectionInstanceWithouParams() + "()");
        }
        return builder;
    }

    private String newCollectionInstanceWithouParams() {
        return "new @" + this.collectionImplType.fqName() + "@<>";
    }

    @Override
    String toDefaultValue(List<String> defaultValues, List<Integer> defaultInts, List<Long> defaultLongs, List<Double> defaultDoubles, List<Boolean> defaultBooleans) {
        if (defaultValues != null) {
            String defaults = defaultValues.stream().map(x$0 -> super.toDefaultValue((String)x$0)).collect(Collectors.joining(", "));
            return this.newCollectionInstanceWithouParams() + "(" + this.collectionType.fqName() + ".of(" + defaults + "))";
        }
        if (defaultInts != null) {
            return this.defaultCollection(defaultInts);
        }
        if (defaultLongs != null) {
            String defaults = defaultLongs.stream().map(String::valueOf).map(it -> it + "L").collect(Collectors.joining(", "));
            return this.newCollectionInstanceWithouParams() + "(" + this.collectionType.fqName() + ".of(" + defaults + "))";
        }
        if (defaultDoubles != null) {
            return this.defaultCollection(defaultDoubles);
        }
        if (defaultBooleans != null) {
            return this.defaultCollection(defaultBooleans);
        }
        return null;
    }

    @Override
    void generateFromConfig(Method.Builder method, AnnotationDataOption configured, FactoryMethods factoryMethods) {
        if (configured.provider()) {
            return;
        }
        TypeName actualType = this.actualType().genericTypeName();
        if (factoryMethods.createFromConfig().isPresent()) {
            FactoryMethods.FactoryMethod factoryMethod = factoryMethods.createFromConfig().get();
            TypeName returnType = factoryMethod.factoryMethodReturnType();
            boolean mapList = true;
            mapList = returnType.isList() || returnType.isSet() ? false : returnType.equals((Object)actualType);
            if (mapList) {
                method.addLine(this.configGet(configured) + ".mapList(" + this.generateMapListFromConfig(factoryMethods) + ").ifPresent(this::" + this.setterName() + ");");
            } else {
                method.addLine(this.configGet(configured) + this.generateFromConfig(factoryMethods) + ".ifPresent(this::" + this.setterName() + ");");
            }
        } else if (BUILT_IN_MAPPERS.contains(actualType)) {
            method.addLine(this.configGet(configured) + ".asList(@" + actualType.fqName() + "@.class)" + this.configMapper.orElse("") + ".ifPresent(this::" + this.setterName() + ");");
        } else {
            method.addLine(this.configGet(configured) + ".asNodeList().map(nodeList -> nodeList.stream().map(cfg -> cfg" + this.generateFromConfig(factoryMethods) + ".get())." + this.collector + ").ifPresent(this::" + this.setterName() + ");");
        }
    }

    String generateMapListFromConfig(FactoryMethods factoryMethods) {
        return factoryMethods.createFromConfig().map(it -> it.typeWithFactoryMethod().genericTypeName().fqName() + "::" + it.createMethodName()).orElseThrow(() -> new IllegalStateException("This should have been called only if factory method is present for " + String.valueOf(this.declaredType()) + " " + this.name()));
    }

    @Override
    TypeName argumentTypeName() {
        if (this.actualType().equals((Object)TypeNames.OBJECT)) {
            return ((TypeName.Builder)TypeName.builder((TypeName)this.collectionType).addTypeArgument(((TypeName.Builder)((TypeName.Builder)TypeName.builder().from(TypeNames.OBJECT)).wildcard(true)).build())).build();
        }
        return this.declaredType();
    }

    @Override
    void setters(InnerClass.Builder classBuilder, AnnotationDataOption configured, FactoryMethods factoryMethods, TypeName returnType, Javadoc blueprintJavadoc) {
        if (configured.provider()) {
            this.discoverServicesSetter(classBuilder, configured, returnType, blueprintJavadoc);
        }
        this.declaredSetters(classBuilder, configured, returnType, blueprintJavadoc);
        if (factoryMethods.createTargetType().isPresent()) {
            this.factorySetter(classBuilder, configured, returnType, blueprintJavadoc, factoryMethods.createTargetType().get());
        }
        if (configured.singular()) {
            this.singularSetter(classBuilder, configured, returnType, blueprintJavadoc, configured.singularName());
        }
        if (factoryMethods.builder().isPresent()) {
            this.factorySetterConsumer(classBuilder, configured, returnType, blueprintJavadoc, factoryMethods, factoryMethods.builder().get());
        }
    }

    private String defaultCollection(List<?> list) {
        String defaults = list.stream().map(String::valueOf).collect(Collectors.joining(", "));
        return this.newCollectionInstanceWithouParams() + "(" + this.collectionType.fqName() + ".of(" + defaults + "))";
    }

    private void discoverServicesSetter(InnerClass.Builder classBuilder, AnnotationDataOption configured, TypeName returnType, Javadoc blueprintJavadoc) {
        classBuilder.addMethod(builder -> ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)builder.name(this.setterName() + "DiscoverServices")).returnType(returnType, "updated builder instance").description(blueprintJavadoc.content())).addJavadocTag("see", "#" + this.getterName() + "()")).addParameter(param -> ((Parameter.Builder)param.name("discoverServices")).type(Boolean.TYPE).description("whether to discover implementations through service loader"))).accessModifier(TypeHandlerCollection.setterAccessModifier(configured))).addLine("this." + this.name() + "DiscoverServices = discoverServices;")).addLine("return self();"));
    }

    private void factorySetterConsumer(InnerClass.Builder classBuilder, AnnotationDataOption configured, TypeName returnType, Javadoc blueprintJavadoc, FactoryMethods factoryMethods, FactoryMethods.FactoryMethod factoryMethod) {
        TypeName builderType = factoryMethod.factoryMethodReturnType().className().equals("Builder") ? factoryMethod.factoryMethodReturnType() : TypeName.create((String)(factoryMethod.factoryMethodReturnType().fqName() + ".Builder"));
        TypeName argumentType = ((TypeName.Builder)((TypeName.Builder)TypeName.builder().type(Consumer.class)).addTypeArgument(builderType)).build();
        String argumentName = "consumer";
        Javadoc javadoc = this.setterJavadoc(blueprintJavadoc).addParameter(argumentName, blueprintJavadoc.returnDescription()).build();
        Method.Builder builder = (Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)Method.builder().name(this.setterName())).returnType(returnType).addParameter(param -> ((Parameter.Builder)param.name(argumentName)).type(argumentType))).accessModifier(TypeHandlerCollection.setterAccessModifier(configured))).typeName(Objects.class)).javadoc(javadoc)).addLine(".requireNonNull(" + argumentName + ");")).add("var builder = ")).typeName(factoryMethod.typeWithFactoryMethod().genericTypeName())).addLine("." + factoryMethod.createMethodName() + "();")).addLine("consumer.accept(builder);");
        if (factoryMethods.createTargetType().map(FactoryMethods.FactoryMethod::factoryMethodReturnType).map(m -> m.genericTypeName().equals((Object)this.collectionType)).orElse(false).booleanValue()) {
            ((Method.Builder)builder.addLine("this." + this.name() + "(builder.build());")).addLine("return self();");
            classBuilder.addMethod(builder);
        } else if (configured.singular()) {
            String singularName = configured.singularName();
            String methodName = "add" + GeneratorTools.capitalize((String)singularName);
            ((Method.Builder)((Method.Builder)builder.name(methodName)).addLine("this." + this.name() + ".add(builder.build());")).addLine("return self();");
            classBuilder.addMethod(builder);
        }
    }

    private void singularSetter(InnerClass.Builder classBuilder, AnnotationDataOption configured, TypeName returnType, Javadoc blueprintJavadoc, String singularName) {
        String methodName = "add" + GeneratorTools.capitalize((String)singularName);
        Method.Builder builder = (Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)Method.builder().name(methodName)).javadoc(this.setterJavadoc(blueprintJavadoc).addParameter(singularName, blueprintJavadoc.returnDescription()).build())).returnType(returnType).update(it -> configured.annotations().forEach(x$0 -> {
            Method.Builder cfr_ignored_0 = (Method.Builder)it.addAnnotation(x$0);
        }))).addParameter(param -> ((Parameter.Builder)param.name(singularName)).type(this.actualType()))).accessModifier(TypeHandlerCollection.setterAccessModifier(configured))).typeName(Objects.class)).addLine(".requireNonNull(" + singularName + ");")).addLine("this." + this.name() + ".add(" + singularName + ");")).addLine("return self();");
        classBuilder.addMethod(builder);
    }

    private void factorySetter(InnerClass.Builder classBuilder, AnnotationDataOption configured, TypeName returnType, Javadoc blueprintJavadoc, FactoryMethods.FactoryMethod factoryMethod) {
        if (factoryMethod.argumentType().equals((Object)Types.CONFIG_TYPE)) {
            return;
        }
        String argumentName = this.name() + "Config";
        Method.Builder builder = (Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)Method.builder().name(this.setterName())).returnType(returnType, "updated builder instance").description(blueprintJavadoc.content())).addJavadocTag("see", "#" + this.getterName() + "()")).addParameter(param -> ((Parameter.Builder)param.name(argumentName)).type(factoryMethod.argumentType()).description(blueprintJavadoc.returnDescription()))).accessModifier(TypeHandlerCollection.setterAccessModifier(configured))).typeName(Objects.class)).addLine(".requireNonNull(" + argumentName + ");")).addLine("this." + this.name() + ".clear();")).add("this." + this.name() + ".addAll(")).typeName(factoryMethod.typeWithFactoryMethod().genericTypeName())).addLine("." + factoryMethod.createMethodName() + "(" + argumentName + "));")).addLine("return self();");
        classBuilder.addMethod(builder);
    }

    private void declaredSetters(InnerClass.Builder classBuilder, AnnotationDataOption configured, TypeName returnType, Javadoc blueprintJavadoc) {
        Method.Builder builder = (Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)Method.builder().name(this.setterName())).returnType(returnType, "updated builder instance").description(blueprintJavadoc.content())).addJavadocTag("see", "#" + this.getterName() + "()")).addParameter(param -> ((Parameter.Builder)param.name(this.name())).type(this.argumentTypeName()).description(blueprintJavadoc.returnDescription()))).accessModifier(TypeHandlerCollection.setterAccessModifier(configured))).typeName(Objects.class)).addLine(".requireNonNull(" + this.name() + ");")).addLine("this." + this.name() + ".clear();")).addLine("this." + this.name() + ".addAll(" + this.name() + ");")).addLine("return self();");
        classBuilder.addMethod(builder);
        ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)builder.name("add" + GeneratorTools.capitalize((String)this.name()))).clearContent()).addLine("Objects.requireNonNull(" + this.name() + ");")).addLine("this." + this.name() + ".addAll(" + this.name() + ");")).addLine("return self();");
        classBuilder.addMethod(builder);
    }
}

