/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.builder.processor;

import io.helidon.builder.processor.AnnotationDataBlueprint;
import io.helidon.builder.processor.AnnotationDataConfigured;
import io.helidon.builder.processor.CustomMethods;
import io.helidon.builder.processor.GenerateAbstractBuilder;
import io.helidon.builder.processor.GenerateBuilder;
import io.helidon.builder.processor.ProcessingContext;
import io.helidon.builder.processor.TypeContext;
import io.helidon.builder.processor.Types;
import io.helidon.builder.processor.ValidationTask;
import io.helidon.common.Errors;
import io.helidon.common.processor.CopyrightHandler;
import io.helidon.common.processor.GeneratedAnnotationHandler;
import io.helidon.common.processor.TypeInfoFactory;
import io.helidon.common.processor.classmodel.Annotation;
import io.helidon.common.processor.classmodel.ClassModel;
import io.helidon.common.processor.classmodel.ClassType;
import io.helidon.common.processor.classmodel.Javadoc;
import io.helidon.common.processor.classmodel.Method;
import io.helidon.common.processor.classmodel.Parameter;
import io.helidon.common.processor.classmodel.TypeArgument;
import io.helidon.common.types.AccessModifier;
import io.helidon.common.types.Annotation;
import io.helidon.common.types.TypeInfo;
import io.helidon.common.types.TypeName;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;

@Deprecated(forRemoval=true, since="4.1.0")
public class BlueprintProcessor
extends AbstractProcessor {
    private static final String SOURCE_SPACING = "    ";
    private static final TypeName GENERATOR = TypeName.create(BlueprintProcessor.class);
    private final Set<ValidationTask> validationTasks = new LinkedHashSet<ValidationTask>();
    private final Set<Element> runtimeTypes = new HashSet<Element>();
    private final Set<Element> blueprintTypes = new HashSet<Element>();
    private TypeElement blueprintAnnotationType;
    private TypeElement runtimePrototypeAnnotationType;
    private Messager messager;
    private Filer filer;
    private ProcessingEnvironment env;
    private Elements elementUtils;

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return Set.of("io.helidon.builder.api.Prototype.Blueprint", "io.helidon.builder.api.RuntimeType.PrototypedBy", Types.GENERATED);
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.elementUtils = processingEnv.getElementUtils();
        this.messager = processingEnv.getMessager();
        this.blueprintAnnotationType = this.elementUtils.getTypeElement("io.helidon.builder.api.Prototype.Blueprint");
        this.runtimePrototypeAnnotationType = this.elementUtils.getTypeElement("io.helidon.builder.api.RuntimeType.PrototypedBy");
        this.filer = processingEnv.getFiler();
        this.env = processingEnv;
        if (this.blueprintAnnotationType == null || this.runtimePrototypeAnnotationType == null) {
            throw new IllegalStateException("Bug in BlueprintProcessor code, cannot find required types, probably wrong type constants. io.helidon.builder.api.Prototype.Blueprint = " + String.valueOf(this.blueprintAnnotationType) + ", io.helidon.builder.api.RuntimeType.PrototypedBy = " + String.valueOf(this.runtimePrototypeAnnotationType));
        }
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        this.runtimeTypes.addAll(roundEnv.getElementsAnnotatedWith(this.runtimePrototypeAnnotationType));
        Set<? extends Element> blueprints = roundEnv.getElementsAnnotatedWithAny(this.blueprintAnnotationType);
        this.blueprintTypes.addAll(blueprints);
        List<TypeElement> blueprintInterfaces = this.collectInterfaces(blueprints);
        ProcessingContext processingContext = ProcessingContext.create(this.processingEnv);
        for (TypeElement typeElement : blueprintInterfaces) {
            try {
                this.process(typeElement, processingContext);
            }
            catch (Throwable e) {
                this.messager.printError("Failed to process @Builder: " + e.getClass().getName() + ": " + e.getMessage(), typeElement);
                throw new IllegalStateException("Failed to code generate builders", e);
            }
        }
        if (roundEnv.processingOver()) {
            this.addRuntimeTypesForValidation(this.runtimeTypes);
            this.addBlueprintsForValidation(processingContext, this.blueprintTypes);
            Errors.Collector collector = Errors.collector();
            for (ValidationTask task : this.validationTasks) {
                task.validate(collector);
            }
            this.validationTasks.clear();
            Errors errors = collector.collect();
            if (errors.hasFatal()) {
                for (Errors.ErrorMessage error : errors) {
                    this.messager.printError(error.toString().replace('\n', ' '));
                }
            }
        }
        return annotations.size() == 1;
    }

    private void process(TypeElement definitionTypeElement, ProcessingContext processingContext) throws IOException {
        TypeInfo typeInfo = (TypeInfo)TypeInfoFactory.create((ProcessingEnvironment)this.env, (TypeElement)definitionTypeElement).orElseThrow(() -> new IllegalArgumentException("Could not process " + String.valueOf(definitionTypeElement) + ", no type info generated"));
        TypeContext typeContext = TypeContext.create(processingContext, this.elementUtils, definitionTypeElement, typeInfo);
        this.generatePrototypeWithBuilder(definitionTypeElement, typeContext);
    }

    private void addBlueprintsForValidation(ProcessingContext processingContext, Set<Element> blueprintElements) {
        for (Element element : blueprintElements) {
            TypeElement typeElement = (TypeElement)element;
            TypeInfo typeInfo = TypeInfoFactory.create((ProcessingEnvironment)this.processingEnv, (TypeElement)typeElement).orElse(null);
            if (typeInfo == null) continue;
            this.validationTasks.add(new ValidationTask.ValidateBlueprint(typeInfo));
            TypeContext typeContext = TypeContext.create(processingContext, this.elementUtils, typeElement, typeInfo);
            if (!typeContext.blueprintData().isFactory()) continue;
            this.validationTasks.add(new ValidationTask.ValidateBlueprintExtendsFactory(typeContext.typeInfo().prototype(), typeInfo, this.toTypeInfo(typeInfo, typeContext.typeInfo().runtimeObject().get())));
        }
    }

    private void addRuntimeTypesForValidation(Set<? extends Element> runtimeTypes) {
        runtimeTypes.stream().map(TypeElement.class::cast).map(it -> TypeInfoFactory.create((ProcessingEnvironment)this.processingEnv, (TypeElement)it)).flatMap(Optional::stream).forEach(it -> this.validationTasks.add(new ValidationTask.ValidateConfiguredType((TypeInfo)it, this.annotationTypeValue((TypeInfo)it, Types.RUNTIME_PROTOTYPE_TYPE))));
    }

    private TypeName annotationTypeValue(TypeInfo typeInfo, TypeName annotationType) {
        return (TypeName)typeInfo.findAnnotation(annotationType).flatMap(it -> it.value().map(TypeName::create)).orElseThrow(() -> new IllegalArgumentException("Type " + typeInfo.typeName().fqName() + " has invalid ConfiguredBy annotation"));
    }

    private TypeInfo toTypeInfo(TypeInfo typeInfo, TypeName typeName) {
        TypeElement element = this.elementUtils.getTypeElement(typeName.genericTypeName().fqName());
        return (TypeInfo)TypeInfoFactory.create((ProcessingEnvironment)this.processingEnv, (TypeElement)element).orElseThrow(() -> new IllegalArgumentException("Type " + typeName.fqName() + " is not a valid type for Factory declared on type " + typeInfo.typeName().fqName()));
    }

    private List<TypeElement> collectInterfaces(Set<? extends Element> builderTypes) {
        ArrayList<TypeElement> result = new ArrayList<TypeElement>();
        Errors.Collector errors = Errors.collector();
        for (Element element : builderTypes) {
            if (element.getKind() != ElementKind.INTERFACE) {
                errors.fatal("@Blueprint can only be defined on an interface, but is defined on: " + String.valueOf(element));
                this.messager.printMessage(Diagnostic.Kind.MANDATORY_WARNING, "io.helidon.builder.api.Prototype.Blueprint can only be defined on an interface", element);
                continue;
            }
            result.add((TypeElement)element);
        }
        errors.collect().checkValid();
        return result;
    }

    private void generatePrototypeWithBuilder(TypeElement builderInterface, TypeContext typeContext) throws IOException {
        AnnotationDataBlueprint blueprintDef = typeContext.blueprintData();
        AnnotationDataConfigured configuredData = typeContext.configuredData();
        TypeContext.PropertyData propertyData = typeContext.propertyData();
        TypeContext.TypeInformation typeInformation = typeContext.typeInfo();
        CustomMethods customMethods = typeContext.customMethods();
        TypeInfo typeInfo = typeInformation.blueprintType();
        TypeName prototype = typeContext.typeInfo().prototype();
        String ifaceName = prototype.className();
        List<TypeName> typeGenericArguments = blueprintDef.typeArguments();
        String typeArgumentString = BlueprintProcessor.createTypeArgumentString(typeGenericArguments);
        JavaFileObject generatedIface = this.filer.createSourceFile(prototype.name(), builderInterface);
        ClassModel.Builder classModel = ((ClassModel.Builder)ClassModel.builder().type(prototype).classType(ClassType.INTERFACE)).copyright(CopyrightHandler.copyright((TypeName)GENERATOR, (TypeName)typeInfo.typeName(), (TypeName)prototype));
        String javadocString = blueprintDef.javadoc();
        ArrayList<TypeArgument> typeArguments = new ArrayList<TypeArgument>();
        if (javadocString == null) {
            classModel.description("Interface generated from definition. Please add javadoc to the definition interface.");
            typeGenericArguments.forEach(arg -> typeArguments.add(TypeArgument.builder().token(arg.className()).build()));
        } else {
            Javadoc javadoc = Javadoc.parse((String)blueprintDef.javadoc());
            classModel.javadoc(javadoc);
            typeGenericArguments.forEach(arg -> {
                TypeArgument.Builder tokenBuilder = TypeArgument.builder().token(arg.className());
                if (javadoc.genericsTokens().containsKey(arg.className())) {
                    tokenBuilder.description((List)javadoc.genericsTokens().get(arg.className()));
                }
                typeArguments.add(tokenBuilder.build());
            });
        }
        typeArguments.forEach(arg_0 -> ((ClassModel.Builder)classModel).addGenericArgument(arg_0));
        if (blueprintDef.builderPublic()) {
            classModel.addJavadocTag("see", "#builder()");
        }
        if (!propertyData.hasRequired() && blueprintDef.createEmptyPublic() && blueprintDef.builderPublic()) {
            classModel.addJavadocTag("see", "#create()");
        }
        typeContext.typeInfo().annotationsToGenerate().forEach(annotation -> classModel.addAnnotation(io.helidon.common.processor.classmodel.Annotation.parse((String)annotation)));
        classModel.addAnnotation(builder -> {
            Annotation generated = GeneratedAnnotationHandler.create((TypeName)GENERATOR, (TypeName)typeInfo.typeName(), (TypeName)prototype, (String)"1", (String)"");
            builder.type(generated.typeName());
            generated.values().forEach((arg_0, arg_1) -> ((Annotation.Builder)builder).addParameter(arg_0, arg_1));
        });
        if (typeContext.blueprintData().prototypePublic()) {
            classModel.accessModifier(AccessModifier.PUBLIC);
        }
        blueprintDef.extendsList().forEach(arg_0 -> ((ClassModel.Builder)classModel).addInterface(arg_0));
        TypeName builderTypeName = ((TypeName.Builder)((TypeName.Builder)TypeName.builder().from(TypeName.create((String)(prototype.fqName() + ".Builder")))).typeArguments(prototype.typeArguments())).build();
        classModel.addMethod(builder -> {
            ((Method.Builder)((Method.Builder)builder.isStatic(true).name("builder")).description("Create a new fluent API builder to customize configuration.")).returnType(builderTypeName, "a new builder");
            typeArguments.forEach(arg_0 -> ((Method.Builder)builder).addGenericArgument(arg_0));
            if (typeArguments.isEmpty()) {
                builder.addLine("return new " + ifaceName + ".Builder();");
            } else {
                builder.addLine("return new " + ifaceName + ".Builder<>();");
            }
        });
        classModel.addMethod(builder -> {
            ((Method.Builder)((Method.Builder)builder.isStatic(true).name("builder")).description("Create a new fluent API builder from an existing instance.")).returnType(builderTypeName, "a builder based on an instance").addParameter(paramBuilder -> ((Parameter.Builder)paramBuilder.type(prototype).name("instance")).description("an existing instance used as a base for the builder"));
            typeArguments.forEach(arg_0 -> ((Method.Builder)builder).addGenericArgument(arg_0));
            builder.addLine("return " + ifaceName + "." + typeArgumentString + "builder().from(instance);");
        });
        if (blueprintDef.createFromConfigPublic() && configuredData.configured()) {
            Method.Builder method = (Method.Builder)((Method.Builder)((Method.Builder)Method.builder().name("create")).isStatic(true).description("Create a new instance from configuration.")).returnType(prototype, "a new instance configured from configuration").addParameter(paramBuilder -> ((Parameter.Builder)paramBuilder.type(Types.CONFIG_TYPE).name("config")).description("used to configure the new instance"));
            typeArguments.forEach(arg_0 -> ((Method.Builder)method).addGenericArgument(arg_0));
            if (blueprintDef.builderPublic()) {
                method.addLine("return " + ifaceName + "." + typeArgumentString + "builder().config(config).buildPrototype();");
            } else if (typeArguments.isEmpty()) {
                method.addLine("return new Builder().config(config).build();");
            } else {
                method.addLine("return new Builder()<>.config(config).build();");
            }
            classModel.addMethod(method);
        }
        if (blueprintDef.createEmptyPublic() && blueprintDef.builderPublic() && !propertyData.hasRequired()) {
            classModel.addMethod(builder -> {
                ((Method.Builder)((Method.Builder)builder.isStatic(true).name("create")).description("Create a new instance with default values.")).returnType(prototype, "a new instance").addLine("return " + ifaceName + "." + typeArgumentString + "builder().buildPrototype();");
                typeArguments.forEach(arg_0 -> ((Method.Builder)builder).addGenericArgument(arg_0));
            });
        }
        BlueprintProcessor.generateCustomMethods(customMethods, classModel);
        GenerateAbstractBuilder.generate(classModel, typeInformation.prototype(), typeInformation.runtimeObject().orElseGet(typeInformation::prototype), typeArguments, typeContext);
        GenerateBuilder.generate(classModel, typeInformation.prototype(), typeInformation.runtimeObject().orElseGet(typeInformation::prototype), typeArguments, typeContext.blueprintData().isFactory(), typeContext);
        try (PrintWriter pw = new PrintWriter(generatedIface.openWriter());){
            classModel.build().write((Writer)pw, SOURCE_SPACING);
        }
    }

    private static void generateCustomMethods(CustomMethods customMethods, ClassModel.Builder classModel) {
        Method.Builder method;
        CustomMethods.Method generated;
        for (CustomMethods.CustomMethod customMethod : customMethods.factoryMethods()) {
            generated = customMethod.generatedMethod().method();
            method = (Method.Builder)((Method.Builder)((Method.Builder)Method.builder().name(generated.name())).javadoc(Javadoc.parse(generated.javadoc()))).isStatic(true).returnType(generated.returnType()).addLine(customMethod.generatedMethod().callCode() + ";");
            for (String annotation : customMethod.generatedMethod().annotations()) {
                method.addAnnotation(io.helidon.common.processor.classmodel.Annotation.parse((String)annotation));
            }
            for (CustomMethods.Argument argument : generated.arguments()) {
                method.addParameter(param -> ((Parameter.Builder)param.name(argument.name())).type(argument.typeName()));
            }
            classModel.addMethod(method);
        }
        for (CustomMethods.CustomMethod customMethod : customMethods.prototypeMethods()) {
            generated = customMethod.generatedMethod().method();
            if (generated.javadoc().isEmpty() && customMethod.generatedMethod().annotations().contains(Types.OVERRIDE)) continue;
            method = ((Method.Builder)((Method.Builder)Method.builder().name(generated.name())).javadoc(Javadoc.parse(generated.javadoc()))).returnType(generated.returnType());
            for (String annotation : customMethod.generatedMethod().annotations()) {
                method.addAnnotation(io.helidon.common.processor.classmodel.Annotation.parse((String)annotation));
            }
            for (CustomMethods.Argument argument : generated.arguments()) {
                method.addParameter(param -> ((Parameter.Builder)param.name(argument.name())).type(argument.typeName()));
            }
            classModel.addMethod(method);
        }
    }

    static String createTypeArgumentString(List<TypeName> typeArguments) {
        if (!typeArguments.isEmpty()) {
            String arguments = typeArguments.stream().map(rec$ -> ((TypeName)rec$).className()).collect(Collectors.joining(", "));
            if ("?".equals(arguments)) {
                return "";
            }
            return "<" + arguments + ">";
        }
        return "";
    }
}

