/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.builder.codegen;

import io.helidon.builder.codegen.CustomConstant;
import io.helidon.builder.codegen.TypeContext;
import io.helidon.builder.codegen.Types;
import io.helidon.codegen.CodegenContext;
import io.helidon.codegen.CodegenException;
import io.helidon.codegen.ElementInfoPredicates;
import io.helidon.codegen.classmodel.ContentBuilder;
import io.helidon.codegen.classmodel.Javadoc;
import io.helidon.common.Errors;
import io.helidon.common.types.AccessModifier;
import io.helidon.common.types.Annotation;
import io.helidon.common.types.Modifier;
import io.helidon.common.types.TypeInfo;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypeNames;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;

record CustomMethods(List<CustomMethod> factoryMethods, List<CustomMethod> builderMethods, List<CustomMethod> prototypeMethods, List<CustomConstant> customConstants) {
    CustomMethods() {
        this(List.of(), List.of(), List.of(), List.of());
    }

    static CustomMethods create(CodegenContext ctx, TypeContext.TypeInformation typeInformation) {
        Optional annotation = typeInformation.blueprintType().findAnnotation(Types.PROTOTYPE_CUSTOM_METHODS);
        if (annotation.isEmpty()) {
            return new CustomMethods();
        }
        String customMethodType = (String)((Annotation)annotation.get()).value().orElseThrow();
        TypeInfo customMethodsInfo = (TypeInfo)ctx.typeInfo(TypeName.create((String)customMethodType)).orElseThrow(() -> new CodegenException("Failed to get type info for a type declared as custom methods type: " + customMethodType));
        Errors.Collector errors = Errors.collector();
        List<CustomMethod> factoryMethods = CustomMethods.findMethods(typeInformation, customMethodsInfo, errors, Types.PROTOTYPE_FACTORY_METHOD, CustomMethods::factoryMethod);
        List<CustomMethod> builderMethods = CustomMethods.findMethods(typeInformation, customMethodsInfo, errors, Types.PROTOTYPE_BUILDER_METHOD, CustomMethods::builderMethod);
        List<CustomMethod> prototypeMethods = CustomMethods.findMethods(typeInformation, customMethodsInfo, errors, Types.PROTOTYPE_PROTOTYPE_METHOD, CustomMethods::prototypeMethod);
        List<CustomConstant> customConstants = CustomMethods.findConstants(customMethodsInfo, errors);
        errors.collect().checkValid();
        return new CustomMethods(factoryMethods, builderMethods, prototypeMethods, customConstants);
    }

    private static GeneratedMethod prototypeMethod(Errors.Collector errors, TypeContext.TypeInformation typeInformation, TypeName customMethodsType, List<String> annotations, Method customMethod) {
        List<Argument> customMethodArgs = customMethod.arguments();
        if (customMethodArgs.isEmpty()) {
            errors.fatal((Object)customMethodsType.fqName(), "Methods annotated with @Prototype.PrototypeMethod must accept the prototype as the first parameter, but method: " + customMethod.name() + " has no parameters");
        } else if (!CustomMethods.correctType(typeInformation.prototype(), customMethodArgs.getFirst().typeName())) {
            errors.fatal((Object)customMethodsType.fqName(), "Methods annotated with @Prototype.PrototypeMethod must accept the prototype as the first parameter, but method: " + customMethod.name() + " expected: " + typeInformation.prototypeBuilder().fqName() + " actual: " + customMethodArgs.getFirst().typeName().fqName());
        }
        List<Argument> generatedArgs = customMethodArgs.subList(1, customMethodArgs.size());
        ArrayList<String> argumentNames = new ArrayList<String>();
        argumentNames.add("this");
        argumentNames.addAll(generatedArgs.stream().map(Argument::name).toList());
        Consumer<ContentBuilder<?>> codeGenerator = contentBuilder -> {
            if (!customMethod.returnType().equals((Object)TypeNames.PRIMITIVE_VOID)) {
                contentBuilder.addContent("return ");
            }
            contentBuilder.addContent(customMethodsType.genericTypeName()).addContent(".").addContent(customMethod.name()).addContent("(").addContent(String.join((CharSequence)", ", argumentNames)).addContentLine(");");
        };
        return new GeneratedMethod(new Method(typeInformation.prototypeBuilder(), customMethod.name(), customMethod.returnType(), generatedArgs, customMethod.javadoc(), customMethod.typeParameters()), annotations, codeGenerator);
    }

    private static GeneratedMethod builderMethod(Errors.Collector errors, TypeContext.TypeInformation typeInformation, TypeName customMethodsType, List<String> annotations, Method customMethod) {
        List<Argument> customMethodArgs = customMethod.arguments();
        if (customMethodArgs.isEmpty()) {
            errors.fatal((Object)customMethodsType.fqName(), "Methods annotated with @Prototype.BuilderMethod must accept the prototype builder base as the first parameter, but method: " + customMethod.name() + " has no parameters");
        } else if (!CustomMethods.correctType(typeInformation.prototypeBuilderBase(), customMethodArgs.getFirst().typeName().genericTypeName())) {
            errors.fatal((Object)customMethodsType.fqName(), "Methods annotated with @Prototype.BuilderMethod must accept the prototype builder base as the first parameter, but method: " + customMethod.name() + " expected: " + typeInformation.prototypeBuilderBase().fqName() + " actual: " + customMethodArgs.getFirst().typeName().fqName());
        }
        List<Argument> generatedArgs = customMethodArgs.subList(1, customMethodArgs.size());
        ArrayList<String> argumentNames = new ArrayList<String>();
        argumentNames.add("this");
        argumentNames.addAll(generatedArgs.stream().map(Argument::name).toList());
        Consumer<ContentBuilder<?>> codeGenerator = contentBuilder -> contentBuilder.addContent(customMethodsType.genericTypeName()).addContent(".").addContent(customMethod.name()).addContent("(").addContent(String.join((CharSequence)", ", argumentNames)).addContentLine(");").addContent("return self();");
        return new GeneratedMethod(new Method(typeInformation.prototypeBuilder(), customMethod.name(), typeInformation.prototypeBuilder(), generatedArgs, customMethod.javadoc(), customMethod.typeParameters), annotations, codeGenerator);
    }

    private static boolean correctType(TypeName knownType, TypeName processingType) {
        if (processingType.packageName().isEmpty()) {
            if (processingType.className().equals("<any>")) {
                return true;
            }
            return knownType.className().equals(processingType.className()) && knownType.enclosingNames().equals(processingType.enclosingNames());
        }
        return knownType.equals((Object)processingType);
    }

    private static GeneratedMethod factoryMethod(Errors.Collector errors, TypeContext.TypeInformation typeInformation, TypeName customMethodsType, List<String> annotations, Method customMethod) {
        Consumer<ContentBuilder<?>> codeGenerator = contentBuilder -> {
            if (!customMethod.returnType().equals((Object)TypeNames.PRIMITIVE_VOID)) {
                contentBuilder.addContent("return ");
            }
            contentBuilder.addContent(customMethodsType.genericTypeName()).addContent(".").addContent(customMethod.name()).addContent("(").addContent(customMethod.arguments().stream().map(Argument::name).collect(Collectors.joining(", "))).addContentLine(");");
        };
        return new GeneratedMethod(new Method(typeInformation.prototype(), customMethod.name(), customMethod.returnType(), customMethod.arguments(), customMethod.javadoc(), customMethod.typeParameters()), annotations, codeGenerator);
    }

    private static List<CustomConstant> findConstants(TypeInfo customMethodsType, Errors.Collector errors) {
        return customMethodsType.elementInfo().stream().filter(ElementInfoPredicates::isField).filter(ElementInfoPredicates.hasAnnotation((TypeName)Types.PROTOTYPE_CONSTANT)).map(it -> {
            if (!it.elementModifiers().contains(Modifier.STATIC)) {
                errors.fatal(it, "A field annotated with @Prototype.Constant must be static, final, and at least package local. Field \"" + it.elementName() + "\" is not static.");
            }
            if (!it.elementModifiers().contains(Modifier.FINAL)) {
                errors.fatal(it, "A field annotated with @Prototype.Constant must be static, final, and at least package local. Field \"" + it.elementName() + "\" is not final.");
            }
            if (it.accessModifier() == AccessModifier.PRIVATE) {
                errors.fatal(it, "A field annotated with @Prototype.Constant must be static, final, and at least package local. Field \"" + it.elementName() + "\" is private.");
            }
            TypeName fieldType = it.typeName();
            String name = it.elementName();
            Javadoc javadoc = it.description().map(Javadoc::parse).orElseGet(() -> Javadoc.builder().add(fieldType.equals((Object)TypeNames.STRING) ? "Constant for {@value}." : "Code generated constant.").build());
            return new CustomConstant(customMethodsType.typeName(), fieldType, name, javadoc);
        }).toList();
    }

    private static List<CustomMethod> findMethods(TypeContext.TypeInformation typeInformation, TypeInfo customMethodsType, Errors.Collector errors, TypeName requiredAnnotation, MethodProcessor methodProcessor) {
        return customMethodsType.elementInfo().stream().filter(ElementInfoPredicates::isMethod).filter(ElementInfoPredicates::isStatic).filter(ElementInfoPredicates.hasAnnotation((TypeName)requiredAnnotation)).map(it -> {
            TypeName returnType = it.typeName();
            String methodName = it.elementName();
            List<Argument> arguments = it.parameterArguments().stream().map(arg -> new Argument(arg.elementName(), arg.typeName())).toList();
            List javadoc = it.description().map(String::trim).stream().filter(Predicate.not(String::isBlank)).findAny().map(description -> description.split("\n")).map(List::of).orElseGet(List::of);
            List<String> annotations = it.findAnnotation(Types.PROTOTYPE_ANNOTATED).flatMap(rec$ -> ((Annotation)rec$).stringValues()).orElseGet(List::of).stream().map(String::trim).filter(Predicate.not(String::isBlank)).toList();
            List typeNames = it.typeParameters();
            ArrayList<TypeName> typeParametersToUse = new ArrayList<TypeName>();
            if (!typeNames.isEmpty()) {
                Set usedNames = typeInformation.blueprintType().declaredType().typeArguments().stream().map(rec$ -> ((TypeName)rec$).className()).collect(Collectors.toSet());
                typeNames.stream().filter(methodTypeParam -> !usedNames.contains(methodTypeParam.className())).forEach(typeParametersToUse::add);
            }
            Method customMethod = new Method(customMethodsType.typeName(), methodName, returnType, arguments, javadoc, typeParametersToUse);
            return new CustomMethod(customMethod, methodProcessor.process(errors, typeInformation, customMethodsType.typeName(), annotations, customMethod));
        }).toList();
    }

    static interface MethodProcessor {
        public GeneratedMethod process(Errors.Collector var1, TypeContext.TypeInformation var2, TypeName var3, List<String> var4, Method var5);
    }

    record Method(TypeName declaringType, String name, TypeName returnType, List<Argument> arguments, List<String> javadoc, List<TypeName> typeParameters) {
    }

    record Argument(String name, TypeName typeName) {
    }

    record GeneratedMethod(Method method, List<String> annotations, Consumer<ContentBuilder<?>> generateCode) {
    }

    record CustomMethod(Method declaredMethod, GeneratedMethod generatedMethod) {
    }
}

