/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.builder.codegen;

import io.helidon.builder.codegen.AnnotationDataOption;
import io.helidon.builder.codegen.FactoryMethods;
import io.helidon.builder.codegen.TypeHandler;
import io.helidon.builder.codegen.Types;
import io.helidon.codegen.classmodel.ContentBuilder;
import io.helidon.codegen.classmodel.Field;
import io.helidon.codegen.classmodel.InnerClass;
import io.helidon.codegen.classmodel.Javadoc;
import io.helidon.codegen.classmodel.Method;
import io.helidon.codegen.classmodel.Parameter;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypeNames;
import io.helidon.common.types.TypedElementInfo;
import java.util.Objects;
import java.util.function.Consumer;

class TypeHandlerSupplier
extends TypeHandler.OneTypeHandler {
    TypeHandlerSupplier(TypeName blueprintType, TypedElementInfo annotatedMethod, String name, String getterName, String setterName, TypeName declaredType) {
        super(blueprintType, annotatedMethod, name, getterName, setterName, declaredType);
    }

    @Override
    Field.Builder fieldDeclaration(AnnotationDataOption configured, boolean isBuilder, boolean alwaysFinal) {
        Field.Builder builder = ((Field.Builder)Field.builder().type(this.declaredType()).name(this.name())).isFinal(alwaysFinal || !isBuilder);
        if (isBuilder && configured.hasDefault()) {
            builder.addContent("() -> ");
            configured.defaultValue().accept((ContentBuilder<?>)builder);
        }
        return builder;
    }

    @Override
    TypeName argumentTypeName() {
        return ((TypeName.Builder)TypeName.builder((TypeName)TypeNames.SUPPLIER).addTypeArgument(TypeHandlerSupplier.toWildcard(this.actualType()))).build();
    }

    @Override
    void generateFromConfig(Method.Builder method, AnnotationDataOption configured, FactoryMethods factoryMethods) {
        if (configured.provider()) {
            return;
        }
        if (factoryMethods.createFromConfig().isPresent()) {
            method.addContent(this.configGet(configured));
            this.generateFromConfig((ContentBuilder<?>)method, factoryMethods);
            method.addContentLine(".ifPresent(this::" + this.setterName() + ");");
        } else if (this.actualType().isOptional()) {
            method.addContent(this.setterName() + "(");
            method.addContent(this.configGet(configured));
            method.addContent(this.generateFromConfigOptional(factoryMethods));
            method.addContentLine(".optionalSupplier());");
        } else {
            method.addContent(this.setterName() + "(");
            method.addContent(this.configGet(configured));
            this.generateFromConfig((ContentBuilder<?>)method, factoryMethods);
            method.addContentLine(".supplier());");
        }
    }

    String generateFromConfigOptional(FactoryMethods factoryMethods) {
        TypeName optionalType = (TypeName)this.actualType().typeArguments().get(0);
        if (optionalType.fqName().equals("char[]")) {
            return ".asString().as(String::toCharArray)";
        }
        TypeName boxed = optionalType.boxed();
        return factoryMethods.createFromConfig().map(it -> ".map(" + it.typeWithFactoryMethod().genericTypeName().fqName() + "::" + it.createMethodName() + ")").orElseGet(() -> ".as(" + boxed.fqName() + ".class)");
    }

    @Override
    void setters(InnerClass.Builder classBuilder, AnnotationDataOption configured, FactoryMethods factoryMethod, TypeName returnType, Javadoc blueprintJavadoc) {
        FactoryMethods.FactoryMethod fm;
        this.declaredSetter(classBuilder, configured, returnType, blueprintJavadoc);
        Method.Builder method = (Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)Method.builder().name(this.setterName())).description(blueprintJavadoc.content())).returnType(returnType, "updated builder instance").addParameter(param -> ((Parameter.Builder)param.name(this.name())).type(this.actualType()).description(blueprintJavadoc.returnDescription()))).addJavadocTag("see", "#" + this.getterName() + "()")).addContent(Objects.class)).addContentLine(".requireNonNull(" + this.name() + ");")).addContentLine("this." + this.name() + " = () -> " + this.name() + ";")).addContentLine("return self();");
        classBuilder.addMethod(method);
        if (this.actualType().equals((Object)Types.CHAR_ARRAY)) {
            classBuilder.addMethod(builder -> ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)builder.name(this.setterName())).returnType(returnType, "updated builder instance").description(blueprintJavadoc.content())).addJavadocTag("see", "#" + this.getterName() + "()")).addParameter(param -> ((Parameter.Builder)param.name(this.name())).type(TypeNames.STRING).description(blueprintJavadoc.returnDescription()))).accessModifier(TypeHandlerSupplier.setterAccessModifier(configured))).addContent(Objects.class)).addContentLine(".requireNonNull(" + this.name() + ");")).addContentLine("this." + this.name() + " = () -> " + this.name() + ".toCharArray();")).addContentLine("return self();"));
        }
        if (factoryMethod.createTargetType().isPresent()) {
            fm = factoryMethod.createTargetType().get();
            String argumentName = this.name() + "Config";
            classBuilder.addMethod(builder -> ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)builder.name(this.setterName())).accessModifier(TypeHandlerSupplier.setterAccessModifier(configured))).description(blueprintJavadoc.content())).returnType(returnType, "updated builder instance").addParameter(param -> ((Parameter.Builder)param.name(argumentName)).type(fm.argumentType()).description(blueprintJavadoc.returnDescription()))).addJavadocTag("see", "#" + this.getterName() + "()")).addContent(Objects.class)).addContentLine(".requireNonNull(" + argumentName + ");")).addContent("this." + this.name() + " = ")).addContent(fm.typeWithFactoryMethod().genericTypeName())).addContentLine("." + fm.createMethodName() + "(" + argumentName + ");")).addContentLine("return self();"));
        }
        if (factoryMethod.builder().isPresent()) {
            fm = factoryMethod.builder().get();
            String className = fm.factoryMethodReturnType().className();
            TypeName builderType = className.equals("Builder") || className.endsWith(".Builder") ? fm.factoryMethodReturnType() : TypeName.create((String)(fm.factoryMethodReturnType().fqName() + ".Builder"));
            String argumentName = "consumer";
            TypeName argumentType = ((TypeName.Builder)((TypeName.Builder)TypeName.builder().type(Consumer.class)).addTypeArgument(builderType)).build();
            Javadoc javadoc = this.setterJavadoc(blueprintJavadoc).addParameter(argumentName, blueprintJavadoc.returnDescription()).build();
            classBuilder.addMethod(builder -> ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)builder.name(this.setterName())).accessModifier(TypeHandlerSupplier.setterAccessModifier(configured))).returnType(returnType).addParameter(param -> ((Parameter.Builder)param.name(argumentName)).type(argumentType))).javadoc(javadoc)).addContent(Objects.class)).addContentLine(".requireNonNull(" + argumentName + ");")).addContent("var builder = ")).addContent(fm.typeWithFactoryMethod().genericTypeName())).addContentLine("." + fm.createMethodName() + "();")).addContentLine("consumer.accept(builder);")).addContentLine("this." + this.name() + "(builder.build());")).addContentLine("return self();"));
        }
    }

    @Override
    protected void declaredSetter(InnerClass.Builder classBuilder, AnnotationDataOption configured, TypeName returnType, Javadoc blueprintJavadoc) {
        classBuilder.addMethod(method -> ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)method.name(this.setterName())).returnType(returnType, "updated builder instance").description(blueprintJavadoc.content())).addJavadocTag("see", "#" + this.getterName() + "()")).addParameter(param -> ((Parameter.Builder)param.name(this.name())).type(this.argumentTypeName()).description(blueprintJavadoc.returnDescription()))).accessModifier(TypeHandlerSupplier.setterAccessModifier(configured))).addContent(Objects.class)).addContentLine(".requireNonNull(" + this.name() + ");")).addContentLine("this." + this.name() + " = " + this.name() + "::get;")).addContentLine("return self();"));
    }
}

