/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.builder.codegen;

import io.helidon.builder.codegen.MethodSignature;
import io.helidon.builder.codegen.TypeHandler;
import io.helidon.builder.codegen.Types;
import io.helidon.codegen.CodegenContext;
import io.helidon.codegen.CodegenUtil;
import io.helidon.codegen.ElementInfoPredicates;
import io.helidon.common.types.TypeInfo;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypeNames;
import io.helidon.common.types.TypedElementInfo;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;

record FactoryMethods(Optional<FactoryMethod> createTargetType, Optional<FactoryMethod> createFromConfig, Optional<FactoryMethod> builder) {
    static FactoryMethods create(CodegenContext ctx, TypeInfo blueprint, TypeHandler typeHandler) {
        Optional<FactoryMethod> targetFactory = FactoryMethods.targetTypeMethod(ctx, blueprint, typeHandler);
        LinkedHashSet<Object> configObjectCandidates = new LinkedHashSet<TypeName>();
        if (targetFactory.isPresent()) {
            configObjectCandidates.add(targetFactory.get().argumentType());
        }
        configObjectCandidates.add(typeHandler.actualType());
        configObjectCandidates.add(typeHandler.declaredType());
        Optional<FactoryMethod> configFactory = FactoryMethods.createFromConfigMethod(ctx, blueprint, typeHandler, configObjectCandidates);
        configObjectCandidates = new LinkedHashSet();
        if (targetFactory.isPresent()) {
            configObjectCandidates.add(targetFactory.get().argumentType());
        }
        if (configFactory.isPresent()) {
            configObjectCandidates.add(configFactory.get().factoryMethodReturnType());
        }
        return new FactoryMethods(targetFactory, configFactory, FactoryMethods.builder(ctx, typeHandler, configObjectCandidates));
    }

    private static Optional<FactoryMethod> builder(CodegenContext ctx, TypeHandler typeHandler, Set<TypeName> builderCandidates) {
        if (typeHandler.actualType().equals((Object)TypeNames.OBJECT)) {
            return Optional.empty();
        }
        builderCandidates.add(typeHandler.actualType());
        FactoryMethod found = null;
        FactoryMethod secondary = null;
        for (TypeName builderCandidate : builderCandidates) {
            if (typeHandler.actualType().primitive()) continue;
            TypeInfo typeInfo = ctx.typeInfo(builderCandidate.genericTypeName()).orElse(null);
            if (typeInfo == null) {
                if (secondary != null || builderCandidate.fqName().endsWith(".Builder")) continue;
                TypeName builderTypeName = ((TypeName.Builder)((TypeName.Builder)TypeName.builder((TypeName)builderCandidate).className("Builder")).enclosingNames(List.of(builderCandidate.className()))).build();
                secondary = new FactoryMethod(builderCandidate, builderTypeName, "builder", null);
                continue;
            }
            found = typeInfo.elementInfo().stream().filter(ElementInfoPredicates::isMethod).filter(ElementInfoPredicates::isStatic).filter(ElementInfoPredicates.elementName((String)"builder")).filter(ElementInfoPredicates::hasNoArgs).findFirst().map(it -> new FactoryMethod(builderCandidate, FactoryMethods.copyGenericTypes(builderCandidate, it.typeName()), "builder", null)).orElse(null);
            if (found == null) continue;
            break;
        }
        FactoryMethod secondaryMethod = secondary;
        return Optional.ofNullable(found).or(() -> Optional.ofNullable(secondaryMethod));
    }

    private static TypeName copyGenericTypes(TypeName from, TypeName to) {
        if (from.typeArguments().isEmpty()) {
            return to;
        }
        return ((TypeName.Builder)TypeName.builder((TypeName)to).typeArguments(from.typeArguments())).build();
    }

    private static Optional<FactoryMethod> createFromConfigMethod(CodegenContext ctx, TypeInfo blueprint, TypeHandler typeHandler, Set<TypeName> configObjectCandidates) {
        TypeName candidateTypeName;
        Optional<FactoryMethod> foundMethod;
        String methodName = "create" + CodegenUtil.capitalize((String)typeHandler.name());
        Optional<TypeName> returnType = FactoryMethods.findFactoryMethodByParamType(blueprint, Types.COMMON_CONFIG, methodName);
        TypeName typeWithFactoryMethod = blueprint.typeName();
        if (returnType.isEmpty() && blueprint.hasAnnotation(Types.PROTOTYPE_CUSTOM_METHODS)) {
            Optional typeInfo = blueprint.annotation(Types.PROTOTYPE_CUSTOM_METHODS).typeValue().flatMap(arg_0 -> ((CodegenContext)ctx).typeInfo(arg_0));
            if (typeInfo.isPresent()) {
                TypeInfo customMethods = (TypeInfo)typeInfo.get();
                typeWithFactoryMethod = customMethods.typeName();
                returnType = FactoryMethods.findFactoryMethodByParamType(customMethods, Types.COMMON_CONFIG, methodName);
            }
        }
        if (returnType.isPresent()) {
            return Optional.of(new FactoryMethod(typeWithFactoryMethod, returnType.get(), methodName, Types.COMMON_CONFIG));
        }
        String createMethod = "create";
        List candidates = configObjectCandidates.stream().map(arg_0 -> ((CodegenContext)ctx).typeInfo(arg_0)).flatMap(Optional::stream).toList();
        for (TypeInfo typeInfo : candidates) {
            Optional<FactoryMethod> foundMethod2;
            if (!FactoryMethods.doesImplement(typeInfo, Types.PROTOTYPE_API) || !(foundMethod2 = FactoryMethods.findMethod(new MethodSignature(typeInfo.typeName(), createMethod, List.of(Types.COMMON_CONFIG)), typeInfo, ElementInfoPredicates::isStatic).map(it -> new FactoryMethod(typeInfo.typeName(), typeInfo.typeName(), createMethod, Types.COMMON_CONFIG))).isPresent()) continue;
            return foundMethod2;
        }
        for (TypeInfo typeInfo : candidates) {
            if (!FactoryMethods.doesImplement(typeInfo, Types.RUNTIME_API) || !(foundMethod = FactoryMethods.findMethod(new MethodSignature(candidateTypeName = typeInfo.typeName(), createMethod, List.of(Types.COMMON_CONFIG)), typeInfo, ElementInfoPredicates::isStatic).map(it -> new FactoryMethod(candidateTypeName, candidateTypeName, createMethod, Types.COMMON_CONFIG))).isPresent()) continue;
            return foundMethod;
        }
        for (TypeInfo typeInfo : candidates) {
            candidateTypeName = typeInfo.typeName();
            foundMethod = FactoryMethods.findMethod(new MethodSignature(candidateTypeName, createMethod, List.of(Types.COMMON_CONFIG)), typeInfo, ElementInfoPredicates::isStatic, ElementInfoPredicates::isPublic).map(it -> new FactoryMethod(candidateTypeName, candidateTypeName, createMethod, Types.COMMON_CONFIG));
            if (!foundMethod.isPresent()) continue;
            return foundMethod;
        }
        for (TypeName configObjectCandidate : configObjectCandidates) {
            if (!configObjectCandidate.packageName().isEmpty()) continue;
            return Optional.of(new FactoryMethod(configObjectCandidate, configObjectCandidate, "create", Types.COMMON_CONFIG));
        }
        return Optional.empty();
    }

    private static boolean doesImplement(TypeInfo typeInfo, TypeName interfaceType) {
        return typeInfo.interfaceTypeInfo().stream().anyMatch(it -> interfaceType.equals((Object)it.typeName().genericTypeName()));
    }

    private static Optional<FactoryMethod> targetTypeMethod(CodegenContext ctx, TypeInfo blueprint, TypeHandler typeHandler) {
        Object createMethodName = "create" + CodegenUtil.capitalize((String)typeHandler.name());
        TypeName typeWithFactoryMethod = blueprint.typeName();
        TypeName factoryMethodReturnType = typeHandler.declaredType();
        Optional<TypeName> argumentType = FactoryMethods.findFactoryMethodByReturnType(blueprint, factoryMethodReturnType, (String)createMethodName);
        if (argumentType.isPresent()) {
            return Optional.of(new FactoryMethod(typeWithFactoryMethod, factoryMethodReturnType, (String)createMethodName, argumentType.get()));
        }
        factoryMethodReturnType = typeHandler.actualType();
        argumentType = FactoryMethods.findFactoryMethodByReturnType(blueprint, factoryMethodReturnType, (String)createMethodName);
        if (argumentType.isPresent()) {
            return Optional.of(new FactoryMethod(typeWithFactoryMethod, factoryMethodReturnType, (String)createMethodName, argumentType.get()));
        }
        Optional configuredTypeInterface = ctx.typeInfo(typeHandler.actualType()).flatMap(it -> it.interfaceTypeInfo().stream().filter(typeInfo -> Types.RUNTIME_API.equals((Object)typeInfo.typeName().genericTypeName())).findFirst());
        createMethodName = "create";
        if (configuredTypeInterface.isPresent()) {
            typeWithFactoryMethod = factoryMethodReturnType = typeHandler.actualType();
            TypeName argumentWithGenerics = (TypeName)((TypeInfo)configuredTypeInterface.get()).typeName().typeArguments().get(0);
            if (!(argumentWithGenerics.typeParameters().isEmpty() && argumentWithGenerics.typeArguments().isEmpty() || factoryMethodReturnType.typeArguments().isEmpty())) {
                TypeName finalFactoryMethodReturnType = factoryMethodReturnType;
                argumentWithGenerics = ((TypeName.Builder)((TypeName.Builder)((TypeName.Builder)TypeName.builder((TypeName)argumentWithGenerics).typeArguments(List.of())).typeParameters(List.of())).update(it -> finalFactoryMethodReturnType.typeArguments().forEach(arg_0 -> ((TypeName.Builder)it).addTypeArgument(arg_0)))).build();
            }
            argumentType = Optional.of(argumentWithGenerics);
            return Optional.of(new FactoryMethod(typeWithFactoryMethod, factoryMethodReturnType, (String)createMethodName, argumentType.get()));
        }
        return Optional.empty();
    }

    private static Optional<TypeName> findFactoryMethodByReturnType(TypeInfo declaringType, TypeName returnType, String methodName) {
        return declaringType.elementInfo().stream().filter(ElementInfoPredicates::isMethod).filter(ElementInfoPredicates::isStatic).filter(it -> it.hasAnnotation(Types.PROTOTYPE_FACTORY_METHOD)).filter(it -> methodName.equals(it.elementName())).filter(it -> it.typeName().equals((Object)returnType)).filter(it -> it.parameterArguments().size() == 1).map(it -> (TypedElementInfo)it.parameterArguments().get(0)).map(rec$ -> ((TypedElementInfo)rec$).typeName()).findFirst();
    }

    private static Optional<TypeName> findFactoryMethodByParamType(TypeInfo declaringType, TypeName paramType, String methodName) {
        return declaringType.elementInfo().stream().filter(ElementInfoPredicates::isMethod).filter(ElementInfoPredicates::isStatic).filter(ElementInfoPredicates.hasAnnotation((TypeName)Types.PROTOTYPE_FACTORY_METHOD)).filter(ElementInfoPredicates.elementName((String)methodName)).filter(ElementInfoPredicates.hasParams((TypeName[])new TypeName[]{paramType})).map(rec$ -> ((TypedElementInfo)rec$).typeName()).findFirst();
    }

    @SafeVarargs
    private static Optional<TypedElementInfo> findMethod(MethodSignature signatureFilter, TypeInfo typeInfo, Predicate<TypedElementInfo> ... predicates) {
        return typeInfo.elementInfo().stream().filter(ElementInfoPredicates::isMethod).filter(it -> {
            for (Predicate predicate : predicates) {
                boolean res = predicate.test(it);
                if (res) continue;
                return res;
            }
            return true;
        }).filter(it -> {
            if (signatureFilter.returnType() != null && !it.typeName().equals((Object)signatureFilter.returnType())) {
                return false;
            }
            if (signatureFilter.name() != null && !it.elementName().equals(signatureFilter.name())) {
                return false;
            }
            List<TypeName> expectedArguments = signatureFilter.arguments();
            if (expectedArguments != null) {
                List actualArguments = it.parameterArguments();
                if (actualArguments.size() != expectedArguments.size()) {
                    return false;
                }
                for (int i = 0; i < expectedArguments.size(); ++i) {
                    TypeName actualArgument;
                    TypeName expected = expectedArguments.get(i);
                    if (expected.equals((Object)(actualArgument = ((TypedElementInfo)actualArguments.get(i)).typeName()))) continue;
                    return false;
                }
            }
            return true;
        }).findFirst();
    }

    record FactoryMethod(TypeName typeWithFactoryMethod, TypeName factoryMethodReturnType, String createMethodName, TypeName argumentType) {
    }
}

