/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.example.spring.boot;

import io.hawt.example.spring.boot.SecurityConfig;
import jakarta.servlet.Filter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Properties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.provisioning.InMemoryUserDetailsManager;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.authentication.www.BasicAuthenticationFilter;
import org.springframework.security.web.csrf.CookieCsrfTokenRepository;
import org.springframework.security.web.csrf.CsrfTokenRepository;
import org.springframework.security.web.csrf.CsrfTokenRequestHandler;

@Configuration
@EnableWebSecurity
public class SecurityConfig {
    @Bean
    public SecurityFilterChain filterChain(HttpSecurity http) throws Exception {
        http.authorizeHttpRequests(authorize -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)authorize.anyRequest()).authenticated()).formLogin(Customizer.withDefaults()).httpBasic(Customizer.withDefaults()).csrf(csrf -> csrf.csrfTokenRepository((CsrfTokenRepository)CookieCsrfTokenRepository.withHttpOnlyFalse()).csrfTokenRequestHandler((CsrfTokenRequestHandler)new SpaCsrfTokenRequestHandler())).addFilterAfter((Filter)new CsrfCookieFilter(), BasicAuthenticationFilter.class);
        return (SecurityFilterChain)http.build();
    }

    @Bean
    public UserDetailsService userDetailsService(ResourceLoader loader) {
        InMemoryUserDetailsManager inMemoryUserDetailsManager;
        block10: {
            Resource users = loader.getResource("classpath:/users.properties");
            InputStream is = users.getInputStream();
            try {
                Properties properties = new Properties();
                properties.load(is);
                InMemoryUserDetailsManager db = new InMemoryUserDetailsManager();
                for (String userName : properties.stringPropertyNames()) {
                    String credentials = properties.getProperty(userName);
                    String[] credentialsData = credentials.split("\\s*,\\s*");
                    if (credentialsData.length == 0) continue;
                    User.UserBuilder builder = User.withUsername((String)userName);
                    builder.password((String)(credentialsData[0].startsWith("{") ? credentialsData[0] : "{noop}" + credentialsData[0]));
                    if (credentialsData.length > 1) {
                        builder.roles(Arrays.copyOfRange(credentialsData, 1, credentialsData.length));
                    }
                    db.createUser(builder.build());
                }
                inMemoryUserDetailsManager = db;
                if (is == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return new InMemoryUserDetailsManager(new UserDetails[]{User.builder().username("hawtio").password("hawtio").roles(new String[]{"admin", "viewer"}).build()});
                }
            }
            is.close();
        }
        return inMemoryUserDetailsManager;
    }
}

