/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.testing.integration;

import com.google.common.base.Preconditions;
import com.google.protobuf.ByteString;
import io.grpc.alts.internal.HandshakerReq;
import io.grpc.alts.internal.HandshakerResp;
import io.grpc.alts.internal.HandshakerResult;
import io.grpc.alts.internal.HandshakerServiceGrpc;
import io.grpc.alts.internal.Identity;
import io.grpc.alts.internal.RpcProtocolVersions;
import io.grpc.stub.StreamObserver;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AltsHandshakerTestService
extends HandshakerServiceGrpc.HandshakerServiceImplBase {
    private static final Logger log = Logger.getLogger(AltsHandshakerTestService.class.getName());
    private final Random random = new Random();
    private static final int FIXED_LENGTH_OUTPUT = 16;
    private final ByteString fakeOutput = this.data(16);
    private final ByteString secret = this.data(128);
    private State expectState = State.CLIENT_INIT;

    public StreamObserver<HandshakerReq> doHandshake(final StreamObserver<HandshakerResp> responseObserver) {
        return new StreamObserver<HandshakerReq>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onNext(HandshakerReq value) {
                log.log(Level.FINE, "request received: " + value);
                AltsHandshakerTestService altsHandshakerTestService = AltsHandshakerTestService.this;
                synchronized (altsHandshakerTestService) {
                    switch (AltsHandshakerTestService.this.expectState) {
                        case CLIENT_INIT: {
                            Preconditions.checkState((boolean)HandshakerReq.ReqOneofCase.CLIENT_START.equals((Object)value.getReqOneofCase()));
                            HandshakerResp initClient = HandshakerResp.newBuilder().setOutFrames(AltsHandshakerTestService.this.fakeOutput).build();
                            log.log(Level.FINE, "init client response " + initClient);
                            responseObserver.onNext((Object)initClient);
                            AltsHandshakerTestService.this.expectState = State.SERVER_INIT;
                            break;
                        }
                        case SERVER_INIT: {
                            Preconditions.checkState((boolean)HandshakerReq.ReqOneofCase.SERVER_START.equals((Object)value.getReqOneofCase()));
                            HandshakerResp initServer = HandshakerResp.newBuilder().setBytesConsumed(16).setOutFrames(AltsHandshakerTestService.this.fakeOutput).build();
                            log.log(Level.FINE, "init server response" + initServer);
                            responseObserver.onNext((Object)initServer);
                            AltsHandshakerTestService.this.expectState = State.CLIENT_FINISH;
                            break;
                        }
                        case CLIENT_FINISH: {
                            Preconditions.checkState((boolean)HandshakerReq.ReqOneofCase.NEXT.equals((Object)value.getReqOneofCase()));
                            HandshakerResp resp = HandshakerResp.newBuilder().setResult(AltsHandshakerTestService.this.getResult()).setBytesConsumed(16).setOutFrames(AltsHandshakerTestService.this.fakeOutput).build();
                            log.log(Level.FINE, "client finished response " + resp);
                            responseObserver.onNext((Object)resp);
                            AltsHandshakerTestService.this.expectState = State.SERVER_FINISH;
                            break;
                        }
                        case SERVER_FINISH: {
                            HandshakerResp resp = HandshakerResp.newBuilder().setResult(AltsHandshakerTestService.this.getResult()).setBytesConsumed(16).build();
                            log.log(Level.FINE, "server finished response " + resp);
                            responseObserver.onNext((Object)resp);
                            AltsHandshakerTestService.this.expectState = State.CLIENT_INIT;
                            break;
                        }
                        default: {
                            throw new RuntimeException("unknown state");
                        }
                    }
                }
            }

            public void onError(Throwable t) {
                log.log(Level.INFO, "onError " + t);
            }

            public void onCompleted() {
                responseObserver.onCompleted();
            }
        };
    }

    private HandshakerResult getResult() {
        return HandshakerResult.newBuilder().setApplicationProtocol("grpc").setRecordProtocol("ALTSRP_GCM_AES128_REKEY").setKeyData(this.secret).setMaxFrameSize(131072).setPeerIdentity(Identity.newBuilder().setServiceAccount("123456789-compute@developer.gserviceaccount.com").build()).setPeerRpcVersions(RpcProtocolVersions.newBuilder().setMaxRpcVersion(RpcProtocolVersions.Version.newBuilder().setMajor(2).setMinor(1).build()).setMinRpcVersion(RpcProtocolVersions.Version.newBuilder().setMajor(2).setMinor(1).build()).build()).build();
    }

    private ByteString data(int len) {
        byte[] k = new byte[len];
        this.random.nextBytes(k);
        return ByteString.copyFrom((byte[])k);
    }

    private static enum State {
        CLIENT_INIT,
        SERVER_INIT,
        CLIENT_FINISH,
        SERVER_FINISH;

    }
}

