/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.testing.integration;

import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.StatusRuntimeException;
import io.grpc.netty.NegotiationType;
import io.grpc.netty.NettyChannelBuilder;
import io.grpc.okhttp.OkHttpChannelBuilder;
import io.grpc.testing.integration.EmptyProtos;
import io.grpc.testing.integration.Messages;
import io.grpc.testing.integration.ReconnectServiceGrpc;
import org.junit.Assert;

public class ReconnectTestClient {
    private static final int TEST_TIME_MS = 540000;
    private int serverControlPort = 8080;
    private int serverRetryPort = 8081;
    private boolean useOkhttp = false;
    private ManagedChannel controlChannel;
    private ManagedChannel retryChannel;
    private ReconnectServiceGrpc.ReconnectServiceBlockingStub controlStub;
    private ReconnectServiceGrpc.ReconnectServiceBlockingStub retryStub;

    private void parseArgs(String[] args) {
        for (String arg : args) {
            if (!arg.startsWith("--")) {
                System.err.println("All arguments must start with '--': " + arg);
                System.exit(1);
            }
            String[] parts = arg.substring(2).split("=", 2);
            String key = parts[0];
            String value = parts[1];
            if ("server_control_port".equals(key)) {
                this.serverControlPort = Integer.parseInt(value);
                continue;
            }
            if ("server_retry_port".equals(key)) {
                this.serverRetryPort = Integer.parseInt(value);
                continue;
            }
            if ("use_okhttp".equals(key)) {
                this.useOkhttp = Boolean.parseBoolean(value);
                continue;
            }
            System.err.println("Unknown argument: " + key);
            System.exit(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runTest() throws Exception {
        try {
            this.controlChannel = NettyChannelBuilder.forAddress((String)"127.0.0.1", (int)this.serverControlPort).negotiationType(NegotiationType.PLAINTEXT).build();
            this.controlStub = ReconnectServiceGrpc.newBlockingStub((Channel)this.controlChannel);
            this.retryChannel = this.useOkhttp ? OkHttpChannelBuilder.forAddress((String)"127.0.0.1", (int)this.serverRetryPort).useTransportSecurity().build() : NettyChannelBuilder.forAddress((String)"127.0.0.1", (int)this.serverRetryPort).negotiationType(NegotiationType.TLS).build();
            this.retryStub = ReconnectServiceGrpc.newBlockingStub((Channel)this.retryChannel);
            this.controlStub.start(Messages.ReconnectParams.getDefaultInstance());
            long startTimeStamp = System.currentTimeMillis();
            while (System.currentTimeMillis() - startTimeStamp < 540000L) {
                try {
                    this.retryStub.start(Messages.ReconnectParams.getDefaultInstance());
                }
                catch (StatusRuntimeException statusRuntimeException) {
                    // empty catch block
                }
                Thread.sleep(50L);
            }
            Messages.ReconnectInfo info = this.controlStub.stop(EmptyProtos.Empty.getDefaultInstance());
            Assert.assertTrue((boolean)info.getPassed());
        }
        finally {
            this.controlChannel.shutdownNow();
            this.retryChannel.shutdownNow();
        }
    }

    public static void main(String[] args) {
        ReconnectTestClient client = new ReconnectTestClient();
        client.parseArgs(args);
        System.out.println("Starting test:");
        try {
            client.runTest();
            System.out.println("Finished successfully");
            System.exit(0);
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.err.println("Test failed!");
            System.exit(1);
        }
    }
}

