/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.testing.integration;

import io.grpc.ClientStreamTracer;
import io.grpc.ConnectivityState;
import io.grpc.LoadBalancer;
import io.grpc.LoadBalancerProvider;
import io.grpc.LoadBalancerRegistry;
import io.grpc.services.MetricReport;
import io.grpc.testing.integration.AbstractInteropTest;
import io.grpc.testing.integration.Messages;
import io.grpc.util.ForwardingLoadBalancer;
import io.grpc.util.ForwardingLoadBalancerHelper;
import io.grpc.xds.orca.OrcaOobUtil;
import io.grpc.xds.orca.OrcaPerRequestUtil;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

final class CustomBackendMetricsLoadBalancerProvider
extends LoadBalancerProvider {
    static final String TEST_ORCA_LB_POLICY_NAME = "test_backend_metrics_load_balancer";
    private volatile Messages.TestOrcaReport latestOobReport;

    CustomBackendMetricsLoadBalancerProvider() {
    }

    public LoadBalancer newLoadBalancer(LoadBalancer.Helper helper) {
        return new CustomBackendMetricsLoadBalancer(helper);
    }

    public boolean isAvailable() {
        return true;
    }

    public int getPriority() {
        return 0;
    }

    public String getPolicyName() {
        return TEST_ORCA_LB_POLICY_NAME;
    }

    private static Messages.TestOrcaReport fromCallMetricReport(MetricReport callMetricReport) {
        return Messages.TestOrcaReport.newBuilder().setCpuUtilization(callMetricReport.getCpuUtilization()).setMemoryUtilization(callMetricReport.getMemoryUtilization()).putAllRequestCost(callMetricReport.getRequestCostMetrics()).putAllUtilization(callMetricReport.getUtilizationMetrics()).build();
    }

    private final class CustomBackendMetricsLoadBalancer
    extends ForwardingLoadBalancer {
        private LoadBalancer delegate;

        public CustomBackendMetricsLoadBalancer(LoadBalancer.Helper helper) {
            this.delegate = LoadBalancerRegistry.getDefaultRegistry().getProvider("pick_first").newLoadBalancer((LoadBalancer.Helper)new CustomBackendMetricsLoadBalancerHelper(helper));
        }

        public LoadBalancer delegate() {
            return this.delegate;
        }

        private final class MayReportLoadPicker
        extends LoadBalancer.SubchannelPicker {
            private LoadBalancer.SubchannelPicker delegate;

            public MayReportLoadPicker(LoadBalancer.SubchannelPicker delegate) {
                this.delegate = delegate;
            }

            public LoadBalancer.PickResult pickSubchannel(final LoadBalancer.PickSubchannelArgs args) {
                LoadBalancer.PickResult result = this.delegate.pickSubchannel(args);
                if (result.getSubchannel() == null) {
                    return result;
                }
                AtomicReference reportRef = (AtomicReference)args.getCallOptions().getOption(AbstractInteropTest.ORCA_OOB_REPORT_KEY);
                if (reportRef != null) {
                    reportRef.set(CustomBackendMetricsLoadBalancerProvider.this.latestOobReport);
                }
                return LoadBalancer.PickResult.withSubchannel((LoadBalancer.Subchannel)result.getSubchannel(), (ClientStreamTracer.Factory)OrcaPerRequestUtil.getInstance().newOrcaClientStreamTracerFactory(new OrcaPerRequestUtil.OrcaPerRequestReportListener(){

                    public void onLoadReport(MetricReport callMetricReport) {
                        AtomicReference reportRef = (AtomicReference)args.getCallOptions().getOption(AbstractInteropTest.ORCA_RPC_REPORT_KEY);
                        if (reportRef != null) {
                            reportRef.set(CustomBackendMetricsLoadBalancerProvider.fromCallMetricReport(callMetricReport));
                        }
                    }
                }));
            }
        }

        private final class CustomBackendMetricsLoadBalancerHelper
        extends ForwardingLoadBalancerHelper {
            private final LoadBalancer.Helper orcaHelper;

            public CustomBackendMetricsLoadBalancerHelper(LoadBalancer.Helper helper) {
                this.orcaHelper = OrcaOobUtil.newOrcaReportingHelper((LoadBalancer.Helper)helper);
            }

            public LoadBalancer.Subchannel createSubchannel(LoadBalancer.CreateSubchannelArgs args) {
                LoadBalancer.Subchannel subchannel = super.createSubchannel(args);
                OrcaOobUtil.setListener((LoadBalancer.Subchannel)subchannel, (OrcaOobUtil.OrcaOobReportListener)new OrcaOobUtil.OrcaOobReportListener(){

                    public void onLoadReport(MetricReport orcaLoadReport) {
                        CustomBackendMetricsLoadBalancerProvider.this.latestOobReport = CustomBackendMetricsLoadBalancerProvider.fromCallMetricReport(orcaLoadReport);
                    }
                }, (OrcaOobUtil.OrcaReportingConfig)OrcaOobUtil.OrcaReportingConfig.newBuilder().setReportInterval(1L, TimeUnit.SECONDS).build());
                return subchannel;
            }

            public void updateBalancingState(ConnectivityState newState, LoadBalancer.SubchannelPicker newPicker) {
                this.delegate().updateBalancingState(newState, (LoadBalancer.SubchannelPicker)new MayReportLoadPicker(newPicker));
            }

            public LoadBalancer.Helper delegate() {
                return this.orcaHelper;
            }
        }
    }
}

