/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.testing.integration;

import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import io.grpc.BindableService;
import io.grpc.ForwardingServerCall;
import io.grpc.InsecureServerCredentials;
import io.grpc.Metadata;
import io.grpc.Server;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerCredentials;
import io.grpc.ServerInterceptor;
import io.grpc.ServerInterceptors;
import io.grpc.Status;
import io.grpc.health.v1.HealthCheckResponse;
import io.grpc.netty.NettyServerBuilder;
import io.grpc.protobuf.services.HealthStatusManager;
import io.grpc.protobuf.services.ProtoReflectionService;
import io.grpc.services.AdminInterface;
import io.grpc.stub.StreamObserver;
import io.grpc.testing.integration.EmptyProtos;
import io.grpc.testing.integration.Messages;
import io.grpc.testing.integration.TestServiceGrpc;
import io.grpc.testing.integration.XdsUpdateHealthServiceGrpc;
import io.grpc.xds.XdsServerBuilder;
import io.grpc.xds.XdsServerCredentials;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class XdsTestServer {
    static final Metadata.Key<String> HOSTNAME_KEY = Metadata.Key.of((String)"hostname", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    private static final Metadata.Key<String> CALL_BEHAVIOR_MD_KEY = Metadata.Key.of((String)"rpc-behavior", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    private static final Metadata.Key<String> ATTEMPT_NUM = Metadata.Key.of((String)"grpc-previous-rpc-attempts", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    private static final String CALL_BEHAVIOR_KEEP_OPEN_VALUE = "keep-open";
    private static final String CALL_BEHAVIOR_SLEEP_VALUE = "sleep-";
    private static final String CALL_BEHAVIOR_SUCCEED_ON_RETRY_ATTEMPT_VALUE = "succeed-on-retry-attempt-";
    private static final String CALL_BEHAVIOR_ERROR_CODE = "error-code-";
    private static final Splitter HEADER_VALUE_SPLITTER = Splitter.on((char)',').trimResults().omitEmptyStrings();
    private static Logger logger = Logger.getLogger(XdsTestServer.class.getName());
    private int port = 8080;
    private int maintenancePort = 8080;
    private boolean secureMode = false;
    private String serverId = "java_server";
    private HealthStatusManager health;
    private Server server;
    private Server maintenanceServer;
    private String host;

    public static void main(String[] args) throws Exception {
        XdsTestServer server = new XdsTestServer();
        server.parseArgs(args);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    System.out.println("Shutting down");
                    XdsTestServer.this.stop();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        server.start();
        System.out.println("Server started on port " + server.port);
        server.blockUntilShutdown();
    }

    private void parseArgs(String[] args) {
        boolean usage = false;
        for (String arg : args) {
            if (!arg.startsWith("--")) {
                System.err.println("All arguments must start with '--': " + arg);
                usage = true;
                break;
            }
            String[] parts = arg.substring(2).split("=", 2);
            String key = parts[0];
            if ("help".equals(key)) {
                usage = true;
                break;
            }
            if (parts.length != 2) {
                System.err.println("All arguments must be of the form --arg=value");
                usage = true;
                break;
            }
            String value = parts[1];
            if ("port".equals(key)) {
                this.port = Integer.valueOf(value);
                continue;
            }
            if ("maintenance_port".equals(key)) {
                this.maintenancePort = Integer.valueOf(value);
                continue;
            }
            if ("secure_mode".equals(key)) {
                this.secureMode = Boolean.parseBoolean(value);
                continue;
            }
            if ("server_id".equals(key)) {
                this.serverId = value;
                continue;
            }
            System.err.println("Unknown argument: " + key);
            usage = true;
            break;
        }
        if (this.secureMode && this.port == this.maintenancePort) {
            System.err.println("port and maintenance_port should be different for secure mode: port=" + this.port + ", maintenance_port=" + this.maintenancePort);
            usage = true;
        }
        if (usage) {
            XdsTestServer s = new XdsTestServer();
            System.err.println("Usage: [ARGS...]\n\n  --port=INT          listening port for test server.\n                      Default: " + s.port + "\n  --maintenance_port=INT      listening port for other servers.\n                      Default: " + s.maintenancePort + "\n  --secure_mode=BOOLEAN Use true to enable XdsCredentials. port and maintenance_port should be different for secure mode.\n                      Default: " + s.secureMode + "\n  --server_id=STRING  server ID for response.\n                      Default: " + s.serverId);
            System.exit(1);
        }
    }

    private void start() throws Exception {
        try {
            this.host = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            logger.log(Level.SEVERE, "Failed to get host", e);
            throw new RuntimeException(e);
        }
        this.health = new HealthStatusManager();
        if (this.secureMode) {
            this.server = ((XdsServerBuilder)XdsServerBuilder.forPort((int)this.port, (ServerCredentials)XdsServerCredentials.create((ServerCredentials)InsecureServerCredentials.create())).addService(ServerInterceptors.intercept((BindableService)new TestServiceImpl(this.serverId, this.host), (ServerInterceptor[])new ServerInterceptor[]{new TestInfoInterceptor(this.host)}))).build().start();
            this.maintenanceServer = ((NettyServerBuilder)((NettyServerBuilder)((NettyServerBuilder)((NettyServerBuilder)NettyServerBuilder.forPort((int)this.maintenancePort).addService((BindableService)new XdsUpdateHealthServiceImpl(this.health))).addService(this.health.getHealthService())).addService(ProtoReflectionService.newInstance())).addServices(AdminInterface.getStandardServices())).build().start();
        } else {
            this.server = ((NettyServerBuilder)((NettyServerBuilder)((NettyServerBuilder)((NettyServerBuilder)((NettyServerBuilder)NettyServerBuilder.forPort((int)this.port).addService(ServerInterceptors.intercept((BindableService)new TestServiceImpl(this.serverId, this.host), (ServerInterceptor[])new ServerInterceptor[]{new TestInfoInterceptor(this.host)}))).addService((BindableService)new XdsUpdateHealthServiceImpl(this.health))).addService(this.health.getHealthService())).addService(ProtoReflectionService.newInstance())).addServices(AdminInterface.getStandardServices())).build().start();
            this.maintenanceServer = null;
        }
        this.health.setStatus("", HealthCheckResponse.ServingStatus.SERVING);
    }

    private void stop() throws Exception {
        this.server.shutdownNow();
        if (this.maintenanceServer != null) {
            this.maintenanceServer.shutdownNow();
        }
        if (!this.server.awaitTermination(5L, TimeUnit.SECONDS)) {
            System.err.println("Timed out waiting for server shutdown");
        }
        if (this.maintenanceServer != null && !this.maintenanceServer.awaitTermination(5L, TimeUnit.SECONDS)) {
            System.err.println("Timed out waiting for maintenanceServer shutdown");
        }
    }

    private void blockUntilShutdown() throws InterruptedException {
        if (this.server != null) {
            this.server.awaitTermination();
        }
        if (this.maintenanceServer != null) {
            this.maintenanceServer.awaitTermination();
        }
    }

    private static List<String> getCallBehaviors(Metadata requestHeaders) {
        ArrayList<String> callBehaviors = new ArrayList<String>();
        Iterable values = requestHeaders.getAll(CALL_BEHAVIOR_MD_KEY);
        if (values == null) {
            return callBehaviors;
        }
        for (String value : values) {
            Iterables.addAll(callBehaviors, (Iterable)HEADER_VALUE_SPLITTER.split((CharSequence)value));
        }
        return callBehaviors;
    }

    private static class TestInfoInterceptor
    implements ServerInterceptor {
        private final String host;

        private TestInfoInterceptor(String host) {
            this.host = host;
        }

        public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> call, Metadata requestHeaders, ServerCallHandler<ReqT, RespT> next) {
            List callBehaviors = XdsTestServer.getCallBehaviors(requestHeaders);
            ForwardingServerCall.SimpleForwardingServerCall newCall = new ForwardingServerCall.SimpleForwardingServerCall<ReqT, RespT>(call){

                public void sendHeaders(Metadata responseHeaders) {
                    responseHeaders.put(HOSTNAME_KEY, (Object)TestInfoInterceptor.this.host);
                    super.sendHeaders(responseHeaders);
                }
            };
            ServerCall.Listener noopListener = new ServerCall.Listener<ReqT>(){};
            for (Object callBehavior : callBehaviors) {
                if (!((String)callBehavior).startsWith(XdsTestServer.CALL_BEHAVIOR_SLEEP_VALUE)) continue;
                try {
                    int timeout = Integer.parseInt(((String)callBehavior).substring(XdsTestServer.CALL_BEHAVIOR_SLEEP_VALUE.length()));
                    Thread.sleep(timeout * 1000);
                }
                catch (NumberFormatException e) {
                    newCall.close(Status.INVALID_ARGUMENT.withDescription(String.format("Invalid format for rpc-behavior header (%s)", callBehavior)), new Metadata());
                    return noopListener;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    newCall.close(Status.ABORTED.withDescription("execution of server interrupted"), new Metadata());
                    return noopListener;
                }
            }
            int succeedOnAttemptNum = Integer.MAX_VALUE;
            for (String callBehavior : callBehaviors) {
                if (!callBehavior.startsWith(XdsTestServer.CALL_BEHAVIOR_SUCCEED_ON_RETRY_ATTEMPT_VALUE)) continue;
                try {
                    succeedOnAttemptNum = Integer.parseInt(callBehavior.substring(XdsTestServer.CALL_BEHAVIOR_SUCCEED_ON_RETRY_ATTEMPT_VALUE.length()));
                    break;
                }
                catch (NumberFormatException e) {
                    newCall.close(Status.INVALID_ARGUMENT.withDescription(String.format("Invalid format for rpc-behavior header (%s)", callBehavior)), new Metadata());
                    return noopListener;
                }
            }
            int attemptNum = 0;
            String attemptNumHeader = (String)requestHeaders.get(ATTEMPT_NUM);
            if (attemptNumHeader != null) {
                try {
                    attemptNum = Integer.valueOf(attemptNumHeader);
                }
                catch (NumberFormatException e) {
                    newCall.close(Status.INVALID_ARGUMENT.withDescription(String.format("Invalid format for grpc-previous-rpc-attempts header (%s)", attemptNumHeader)), new Metadata());
                    return noopListener;
                }
            }
            if (attemptNum == succeedOnAttemptNum) {
                return next.startCall((ServerCall)newCall, requestHeaders);
            }
            if (callBehaviors.contains(XdsTestServer.CALL_BEHAVIOR_KEEP_OPEN_VALUE)) {
                return noopListener;
            }
            for (String callBehavior : callBehaviors) {
                if (!callBehavior.startsWith(XdsTestServer.CALL_BEHAVIOR_ERROR_CODE)) continue;
                try {
                    int codeValue = Integer.valueOf(callBehavior.substring(XdsTestServer.CALL_BEHAVIOR_ERROR_CODE.length()));
                    newCall.close(Status.fromCodeValue((int)codeValue).withDescription("Rpc failed as per the rpc-behavior header value:" + callBehaviors), new Metadata());
                    return noopListener;
                }
                catch (NumberFormatException e) {
                    newCall.close(Status.INVALID_ARGUMENT.withDescription(String.format("Invalid format for rpc-behavior header (%s)", callBehavior)), new Metadata());
                    return noopListener;
                }
            }
            return next.startCall((ServerCall)newCall, requestHeaders);
        }
    }

    private static class XdsUpdateHealthServiceImpl
    extends XdsUpdateHealthServiceGrpc.XdsUpdateHealthServiceImplBase {
        private HealthStatusManager health;

        private XdsUpdateHealthServiceImpl(HealthStatusManager health) {
            this.health = health;
        }

        @Override
        public void setServing(EmptyProtos.Empty req, StreamObserver<EmptyProtos.Empty> responseObserver) {
            this.health.setStatus("", HealthCheckResponse.ServingStatus.SERVING);
            responseObserver.onNext((Object)EmptyProtos.Empty.getDefaultInstance());
            responseObserver.onCompleted();
        }

        @Override
        public void setNotServing(EmptyProtos.Empty req, StreamObserver<EmptyProtos.Empty> responseObserver) {
            this.health.setStatus("", HealthCheckResponse.ServingStatus.NOT_SERVING);
            responseObserver.onNext((Object)EmptyProtos.Empty.getDefaultInstance());
            responseObserver.onCompleted();
        }
    }

    private static class TestServiceImpl
    extends TestServiceGrpc.TestServiceImplBase {
        private final String serverId;
        private final String host;

        private TestServiceImpl(String serverId, String host) {
            this.serverId = serverId;
            this.host = host;
        }

        @Override
        public void emptyCall(EmptyProtos.Empty req, StreamObserver<EmptyProtos.Empty> responseObserver) {
            responseObserver.onNext((Object)EmptyProtos.Empty.getDefaultInstance());
            responseObserver.onCompleted();
        }

        @Override
        public void unaryCall(Messages.SimpleRequest req, StreamObserver<Messages.SimpleResponse> responseObserver) {
            responseObserver.onNext((Object)Messages.SimpleResponse.newBuilder().setServerId(this.serverId).setHostname(this.host).build());
            responseObserver.onCompleted();
        }
    }
}

