/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.testing.integration;

import com.google.common.base.CaseFormat;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListenableScheduledFuture;
import com.google.common.util.concurrent.ListeningScheduledExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import io.grpc.BindableService;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ForwardingClientCall;
import io.grpc.ForwardingClientCallListener;
import io.grpc.Grpc;
import io.grpc.ManagedChannel;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.Server;
import io.grpc.netty.NettyChannelBuilder;
import io.grpc.netty.NettyServerBuilder;
import io.grpc.stub.StreamObserver;
import io.grpc.testing.integration.EmptyProtos;
import io.grpc.testing.integration.LoadBalancerStatsServiceGrpc;
import io.grpc.testing.integration.Messages;
import io.grpc.testing.integration.TestServiceGrpc;
import io.grpc.testing.integration.XdsTestServer;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

public final class XdsTestClient {
    private static Logger logger = Logger.getLogger(XdsTestClient.class.getName());
    private final Set<XdsStatsWatcher> watchers = new HashSet<XdsStatsWatcher>();
    private final Object lock = new Object();
    private final List<ManagedChannel> channels = new ArrayList<ManagedChannel>();
    private int numChannels = 1;
    private boolean printResponse = false;
    private int qps = 1;
    private List<RpcType> rpcTypes = ImmutableList.of((Object)((Object)RpcType.UNARY_CALL));
    private EnumMap<RpcType, Metadata> metadata = new EnumMap(RpcType.class);
    private int rpcTimeoutSec = 20;
    private String server = "localhost:8080";
    private int statsPort = 8081;
    private Server statsServer;
    private long currentRequestId;
    private ListeningScheduledExecutorService exec;

    public static void main(String[] args) {
        XdsTestClient client = new XdsTestClient();
        client.parseArgs(args);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    XdsTestClient.this.stop();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        client.run();
    }

    private void parseArgs(String[] args) {
        boolean usage = false;
        for (String arg : args) {
            if (!arg.startsWith("--")) {
                System.err.println("All arguments must start with '--': " + arg);
                usage = true;
                break;
            }
            String[] parts = arg.substring(2).split("=", 2);
            String key = parts[0];
            if ("help".equals(key)) {
                usage = true;
                break;
            }
            if (parts.length != 2) {
                System.err.println("All arguments must be of the form --arg=value");
                usage = true;
                break;
            }
            String value = parts[1];
            if ("metadata".equals(key)) {
                this.metadata = XdsTestClient.parseMetadata(value);
                continue;
            }
            if ("num_channels".equals(key)) {
                this.numChannels = Integer.valueOf(value);
                continue;
            }
            if ("print_response".equals(key)) {
                this.printResponse = Boolean.valueOf(value);
                continue;
            }
            if ("qps".equals(key)) {
                this.qps = Integer.valueOf(value);
                continue;
            }
            if ("rpc".equals(key)) {
                this.rpcTypes = XdsTestClient.parseRpcs(value);
                continue;
            }
            if ("rpc_timeout_sec".equals(key)) {
                this.rpcTimeoutSec = Integer.valueOf(value);
                continue;
            }
            if ("server".equals(key)) {
                this.server = value;
                continue;
            }
            if ("stats_port".equals(key)) {
                this.statsPort = Integer.valueOf(value);
                continue;
            }
            System.err.println("Unknown argument: " + key);
            usage = true;
            break;
        }
        if (usage) {
            XdsTestClient c = new XdsTestClient();
            System.err.println("Usage: [ARGS...]\n\n  --num_channels=INT     Default: " + c.numChannels + "\n  --print_response=BOOL  Write RPC response to stdout. Default: " + c.printResponse + "\n  --qps=INT              Qps per channel, for each type of RPC. Default: " + c.qps + "\n  --rpc=STR              Types of RPCs to make, ',' separated string. RPCs can be EmptyCall or UnaryCall. Default: UnaryCall\n  --metadata=STR         The metadata to send with each RPC, in the format EmptyCall:key1:value1,UnaryCall:key2:value2.\n  --rpc_timeout_sec=INT  Per RPC timeout seconds. Default: " + c.rpcTimeoutSec + "\n  --server=host:port     Address of server. Default: " + c.server + "\n  --stats_port=INT       Port to expose peer distribution stats service. Default: " + c.statsPort);
            System.exit(1);
        }
    }

    private static List<RpcType> parseRpcs(String rpcArg) {
        ArrayList<RpcType> rpcs = new ArrayList<RpcType>();
        for (String rpc : Splitter.on((char)',').split((CharSequence)rpcArg)) {
            rpcs.add(XdsTestClient.parseRpc(rpc));
        }
        return rpcs;
    }

    private static EnumMap<RpcType, Metadata> parseMetadata(String metadataArg) {
        EnumMap<RpcType, Metadata> rpcMetadata = new EnumMap<RpcType, Metadata>(RpcType.class);
        for (String metadata : Splitter.on((char)',').omitEmptyStrings().split((CharSequence)metadataArg)) {
            List parts = Splitter.on((char)':').splitToList((CharSequence)metadata);
            if (parts.size() != 3) {
                throw new IllegalArgumentException("Invalid metadata: '" + metadata + "'");
            }
            RpcType rpc = XdsTestClient.parseRpc((String)parts.get(0));
            String key = (String)parts.get(1);
            String value = (String)parts.get(2);
            Metadata md = new Metadata();
            md.put(Metadata.Key.of((String)key, (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER), (Object)value);
            if (rpcMetadata.containsKey((Object)rpc)) {
                rpcMetadata.get((Object)rpc).merge(md);
                continue;
            }
            rpcMetadata.put(rpc, md);
        }
        return rpcMetadata;
    }

    private static RpcType parseRpc(String rpc) {
        if ("EmptyCall".equals(rpc)) {
            return RpcType.EMPTY_CALL;
        }
        if ("UnaryCall".equals(rpc)) {
            return RpcType.UNARY_CALL;
        }
        throw new IllegalArgumentException("Unknown RPC: '" + rpc + "'");
    }

    private void run() {
        this.statsServer = ((NettyServerBuilder)NettyServerBuilder.forPort((int)this.statsPort).addService((BindableService)new XdsStatsImpl())).build();
        try {
            this.statsServer.start();
            for (int i = 0; i < this.numChannels; ++i) {
                this.channels.add(NettyChannelBuilder.forTarget((String)this.server).usePlaintext().build());
            }
            this.exec = MoreExecutors.listeningDecorator((ScheduledExecutorService)Executors.newSingleThreadScheduledExecutor());
            this.runQps();
        }
        catch (Throwable t) {
            logger.log(Level.SEVERE, "Error running client", t);
            System.exit(1);
        }
    }

    private void stop() throws InterruptedException {
        if (this.statsServer != null) {
            this.statsServer.shutdownNow();
            if (!this.statsServer.awaitTermination(5L, TimeUnit.SECONDS)) {
                System.err.println("Timed out waiting for server shutdown");
            }
        }
        for (ManagedChannel channel : this.channels) {
            channel.shutdownNow();
        }
        if (this.exec != null) {
            this.exec.shutdownNow();
        }
    }

    private void runQps() throws InterruptedException, ExecutionException {
        final SettableFuture failure = SettableFuture.create();
        long nanosPerQuery = TimeUnit.SECONDS.toNanos(1L) / (long)this.qps;
        for (RpcType rpcType : this.rpcTypes) {
            final class PeriodicRpc
            implements Runnable {
                private final RpcType rpcType;

                PeriodicRpc(RpcType rpcType) {
                    this.rpcType = rpcType;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    long requestId;
                    final HashSet savedWatchers = new HashSet();
                    Object object = XdsTestClient.this.lock;
                    synchronized (object) {
                        XdsTestClient.this.currentRequestId += 1L;
                        requestId = XdsTestClient.this.currentRequestId;
                        savedWatchers.addAll(XdsTestClient.this.watchers);
                    }
                    final Metadata headersToSend = XdsTestClient.this.metadata.containsKey((Object)this.rpcType) ? (Metadata)XdsTestClient.this.metadata.get((Object)this.rpcType) : new Metadata();
                    ManagedChannel channel = (ManagedChannel)XdsTestClient.this.channels.get((int)(requestId % (long)XdsTestClient.this.channels.size()));
                    TestServiceGrpc.TestServiceStub stub = TestServiceGrpc.newStub((Channel)channel);
                    final AtomicReference clientCallRef = new AtomicReference();
                    final AtomicReference hostnameRef = new AtomicReference();
                    stub = (TestServiceGrpc.TestServiceStub)((TestServiceGrpc.TestServiceStub)stub.withDeadlineAfter(XdsTestClient.this.rpcTimeoutSec, TimeUnit.SECONDS)).withInterceptors(new ClientInterceptor[]{new ClientInterceptor(){

                        public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
                            ClientCall call = next.newCall(method, callOptions);
                            clientCallRef.set(call);
                            return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(call){

                                public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
                                    headers.merge(headersToSend);
                                    super.start((ClientCall.Listener)new ForwardingClientCallListener.SimpleForwardingClientCallListener<RespT>(responseListener){

                                        public void onHeaders(Metadata headers) {
                                            hostnameRef.set(headers.get(XdsTestServer.HOSTNAME_KEY));
                                            super.onHeaders(headers);
                                        }
                                    }, headers);
                                }
                            };
                        }
                    }});
                    if (this.rpcType == RpcType.EMPTY_CALL) {
                        stub.emptyCall(EmptyProtos.Empty.getDefaultInstance(), new StreamObserver<EmptyProtos.Empty>(){

                            public void onCompleted() {
                                XdsTestClient.this.notifyWatchers(savedWatchers, rpcType, requestId, (String)hostnameRef.get());
                            }

                            public void onError(Throwable t) {
                                XdsTestClient.this.notifyWatchers(savedWatchers, rpcType, requestId, (String)hostnameRef.get());
                            }

                            public void onNext(EmptyProtos.Empty response) {
                            }
                        });
                    } else if (this.rpcType == RpcType.UNARY_CALL) {
                        Messages.SimpleRequest request = Messages.SimpleRequest.newBuilder().setFillServerId(true).build();
                        stub.unaryCall(request, new StreamObserver<Messages.SimpleResponse>(){

                            public void onCompleted() {
                                XdsTestClient.this.notifyWatchers(savedWatchers, rpcType, requestId, (String)hostnameRef.get());
                            }

                            public void onError(Throwable t) {
                                if (XdsTestClient.this.printResponse) {
                                    logger.log(Level.WARNING, "Rpc failed: {0}", t);
                                }
                                XdsTestClient.this.notifyWatchers(savedWatchers, rpcType, requestId, (String)hostnameRef.get());
                            }

                            public void onNext(Messages.SimpleResponse response) {
                                if (XdsTestClient.this.printResponse) {
                                    System.out.println("Greeting: Hello world, this is " + response.getHostname() + ", from " + ((ClientCall)clientCallRef.get()).getAttributes().get(Grpc.TRANSPORT_ATTR_REMOTE_ADDR));
                                }
                                if (hostnameRef.get() == null) {
                                    hostnameRef.set(response.getHostname());
                                }
                            }
                        });
                    }
                }
            }
            ListenableScheduledFuture future = this.exec.scheduleAtFixedRate((Runnable)new PeriodicRpc(rpcType), 0L, nanosPerQuery, TimeUnit.NANOSECONDS);
            Futures.addCallback((ListenableFuture)future, (FutureCallback)new FutureCallback<Object>(){

                public void onFailure(Throwable t) {
                    failure.setException(t);
                }

                public void onSuccess(Object o) {
                }
            }, (Executor)MoreExecutors.directExecutor());
        }
        failure.get();
    }

    private void notifyWatchers(Set<XdsStatsWatcher> watchers, RpcType rpcType, long requestId, String hostname) {
        for (XdsStatsWatcher watcher : watchers) {
            watcher.rpcCompleted(rpcType, requestId, hostname);
        }
    }

    private static class XdsStatsWatcher {
        private final CountDownLatch latch;
        private final long startId;
        private final long endId;
        private final Map<String, Integer> rpcsByPeer = new HashMap<String, Integer>();
        private final EnumMap<RpcType, Map<String, Integer>> rpcsByTypeAndPeer = new EnumMap(RpcType.class);
        private final Object lock = new Object();
        private int noRemotePeer;

        private XdsStatsWatcher(long startId, long endId) {
            this.latch = new CountDownLatch(Ints.checkedCast((long)(endId - startId)));
            this.startId = startId;
            this.endId = endId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void rpcCompleted(RpcType rpcType, long requestId, @Nullable String hostname) {
            Object object = this.lock;
            synchronized (object) {
                if (this.startId <= requestId && requestId < this.endId) {
                    if (hostname != null) {
                        if (this.rpcsByPeer.containsKey(hostname)) {
                            this.rpcsByPeer.put(hostname, this.rpcsByPeer.get(hostname) + 1);
                        } else {
                            this.rpcsByPeer.put(hostname, 1);
                        }
                        if (this.rpcsByTypeAndPeer.containsKey((Object)rpcType)) {
                            if (this.rpcsByTypeAndPeer.get((Object)rpcType).containsKey(hostname)) {
                                this.rpcsByTypeAndPeer.get((Object)rpcType).put(hostname, this.rpcsByTypeAndPeer.get((Object)rpcType).get(hostname) + 1);
                            } else {
                                this.rpcsByTypeAndPeer.get((Object)rpcType).put(hostname, 1);
                            }
                        } else {
                            HashMap<String, Integer> rpcMap = new HashMap<String, Integer>();
                            rpcMap.put(hostname, 1);
                            this.rpcsByTypeAndPeer.put(rpcType, rpcMap);
                        }
                    } else {
                        ++this.noRemotePeer;
                    }
                    this.latch.countDown();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Messages.LoadBalancerStatsResponse waitForRpcStats(long timeoutSeconds) {
            try {
                boolean success = this.latch.await(timeoutSeconds, TimeUnit.SECONDS);
                if (!success) {
                    logger.log(Level.INFO, "Await timed out, returning partial stats");
                }
            }
            catch (InterruptedException e) {
                logger.log(Level.INFO, "Await interrupted, returning partial stats", e);
                Thread.currentThread().interrupt();
            }
            Messages.LoadBalancerStatsResponse.Builder builder = Messages.LoadBalancerStatsResponse.newBuilder();
            Object object = this.lock;
            synchronized (object) {
                builder.putAllRpcsByPeer(this.rpcsByPeer);
                for (Map.Entry<RpcType, Map<String, Integer>> entry : this.rpcsByTypeAndPeer.entrySet()) {
                    Messages.LoadBalancerStatsResponse.RpcsByPeer.Builder rpcs = Messages.LoadBalancerStatsResponse.RpcsByPeer.newBuilder();
                    rpcs.putAllRpcsByPeer(entry.getValue());
                    builder.putRpcsByMethod(entry.getKey().toCamelCase(), rpcs.build());
                }
                builder.setNumFailures(this.noRemotePeer + (int)this.latch.getCount());
            }
            return builder.build();
        }
    }

    private class XdsStatsImpl
    extends LoadBalancerStatsServiceGrpc.LoadBalancerStatsServiceImplBase {
        private XdsStatsImpl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void getClientStats(Messages.LoadBalancerStatsRequest req, StreamObserver<Messages.LoadBalancerStatsResponse> responseObserver) {
            XdsStatsWatcher watcher;
            Object object = XdsTestClient.this.lock;
            synchronized (object) {
                long startId = XdsTestClient.this.currentRequestId + 1L;
                long endId = startId + (long)req.getNumRpcs();
                watcher = new XdsStatsWatcher(startId, endId);
                XdsTestClient.this.watchers.add(watcher);
            }
            Messages.LoadBalancerStatsResponse response = watcher.waitForRpcStats(req.getTimeoutSec());
            Object object2 = XdsTestClient.this.lock;
            synchronized (object2) {
                XdsTestClient.this.watchers.remove(watcher);
            }
            responseObserver.onNext((Object)response);
            responseObserver.onCompleted();
        }
    }

    private static enum RpcType {
        EMPTY_CALL,
        UNARY_CALL;


        public String toCamelCase() {
            return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, this.toString());
        }
    }
}

