/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.testing.integration;

import com.google.common.base.Charsets;
import com.google.common.io.CharStreams;
import io.grpc.Channel;
import io.grpc.Deadline;
import io.grpc.ManagedChannel;
import io.grpc.StatusRuntimeException;
import io.grpc.alts.ComputeEngineChannelBuilder;
import io.grpc.testing.integration.Messages;
import io.grpc.testing.integration.TestServiceGrpc;
import java.io.InputStreamReader;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.junit.Assert;

public final class GrpclbFallbackTestClient {
    private static final Logger logger = Logger.getLogger(GrpclbFallbackTestClient.class.getName());
    private String unrouteLbAndBackendAddrsCmd = "exit 1";
    private String blackholeLbAndBackendAddrsCmd = "exit 1";
    private String serverUri;
    private String customCredentialsType;
    private String testCase;
    private ManagedChannel channel;
    private TestServiceGrpc.TestServiceBlockingStub blockingStub;

    public static void main(String[] args) throws Exception {
        GrpclbFallbackTestClient client = new GrpclbFallbackTestClient();
        client.parseArgs(args);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                System.out.println("Shutting down");
                try {
                    GrpclbFallbackTestClient.this.tearDown();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        try {
            client.run();
        }
        finally {
            client.tearDown();
        }
        System.exit(0);
    }

    private void parseArgs(String[] args) {
        boolean usage = false;
        for (String arg : args) {
            if (!arg.startsWith("--")) {
                System.err.println("All arguments must start with '--': " + arg);
                usage = true;
                break;
            }
            String[] parts = arg.substring(2).split("=", 2);
            String key = parts[0];
            if ("help".equals(key)) {
                usage = true;
                break;
            }
            if (parts.length != 2) {
                System.err.println("All arguments must be of the form --arg=value");
                usage = true;
                break;
            }
            String value = parts[1];
            if ("server_uri".equals(key)) {
                this.serverUri = value;
                continue;
            }
            if ("test_case".equals(key)) {
                this.testCase = value;
                continue;
            }
            if ("unroute_lb_and_backend_addrs_cmd".equals(key)) {
                this.unrouteLbAndBackendAddrsCmd = value;
                continue;
            }
            if ("blackhole_lb_and_backend_addrs_cmd".equals(key)) {
                this.blackholeLbAndBackendAddrsCmd = value;
                continue;
            }
            if ("custom_credentials_type".equals(key)) {
                this.customCredentialsType = value;
                continue;
            }
            System.err.println("Unknown argument: " + key);
            usage = true;
            break;
        }
        if (usage) {
            GrpclbFallbackTestClient c = new GrpclbFallbackTestClient();
            System.out.println("Usage: [ARGS...]\n\n  --server_uri                          Server target. Default: " + c.serverUri + "\n  --custom_credentials_type             Name of Credentials to use. Default: " + c.customCredentialsType + "\n  --unroute_lb_and_backend_addrs_cmd    Shell command used to make LB and backend addresses unroutable. Default: " + c.unrouteLbAndBackendAddrsCmd + "\n  --blackhole_lb_and_backend_addrs_cmd  Shell command used to make LB and backend addresses black holed. Default: " + c.blackholeLbAndBackendAddrsCmd + "\n  --test_case=TEST_CASE        Test case to run. Valid options are:\n      fast_fallback_before_startup : fallback before LB connection\n      fast_fallback_after_startup : fallback after startup due to LB/backend addresses becoming unroutable\n      slow_fallback_before_startup : fallback before LB connection due to LB/backend addresses being blackholed\n      slow_fallback_after_startup : fallback after startup due to LB/backend addresses becoming blackholed\n      Default: " + c.testCase);
            System.exit(1);
        }
    }

    private ManagedChannel createChannel() {
        if (!this.customCredentialsType.equals("compute_engine_channel_creds")) {
            throw new AssertionError((Object)"This test currently only supports --custom_credentials_type=compute_engine_channel_creds. TODO: add support for other types.");
        }
        ComputeEngineChannelBuilder builder = ComputeEngineChannelBuilder.forTarget((String)this.serverUri);
        builder.keepAliveTime(3600L, TimeUnit.SECONDS);
        builder.keepAliveTimeout(20L, TimeUnit.SECONDS);
        return builder.build();
    }

    void initStub() {
        this.channel = this.createChannel();
        this.blockingStub = TestServiceGrpc.newBlockingStub((Channel)this.channel);
    }

    private void tearDown() {
        try {
            if (this.channel != null) {
                this.channel.shutdownNow();
                this.channel.awaitTermination(1L, TimeUnit.SECONDS);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private static void runShellCmd(String cmd) throws Exception {
        logger.info("Run shell command: " + cmd);
        ProcessBuilder pb = new ProcessBuilder("bash", "-c", cmd);
        pb.redirectErrorStream(true);
        Process process = pb.start();
        logger.info("Shell command merged stdout and stderr: " + CharStreams.toString((Readable)new InputStreamReader(process.getInputStream(), Charsets.UTF_8)));
        int exitCode = process.waitFor();
        logger.info("Shell command exit code: " + exitCode);
        Assert.assertEquals((long)0L, (long)exitCode);
    }

    private Messages.GrpclbRouteType doRpcAndGetPath(Deadline deadline) {
        logger.info("doRpcAndGetPath deadline: " + deadline);
        Messages.SimpleRequest request = Messages.SimpleRequest.newBuilder().setFillGrpclbRouteType(true).build();
        Messages.GrpclbRouteType result = Messages.GrpclbRouteType.GRPCLB_ROUTE_TYPE_UNKNOWN;
        try {
            Messages.SimpleResponse response = ((TestServiceGrpc.TestServiceBlockingStub)this.blockingStub.withDeadline(deadline)).unaryCall(request);
            result = response.getGrpclbRouteType();
        }
        catch (StatusRuntimeException ex) {
            logger.warning("doRpcAndGetPath failed. Status: " + (Object)((Object)ex));
            return Messages.GrpclbRouteType.GRPCLB_ROUTE_TYPE_UNKNOWN;
        }
        logger.info("doRpcAndGetPath. GrpclbRouteType result: " + (Object)((Object)result));
        if (result != Messages.GrpclbRouteType.GRPCLB_ROUTE_TYPE_FALLBACK && result != Messages.GrpclbRouteType.GRPCLB_ROUTE_TYPE_BACKEND) {
            throw new AssertionError((Object)"Received invalid LB route type. This suggests that the server hasn't implemented this test correctly.");
        }
        return result;
    }

    private void waitForFallbackAndDoRpcs(Deadline fallbackDeadline) throws Exception {
        int fallbackRetryCount = 0;
        boolean fellBack = false;
        while (!fallbackDeadline.isExpired()) {
            Messages.GrpclbRouteType grpclbRouteType = this.doRpcAndGetPath(Deadline.after((long)1L, (TimeUnit)TimeUnit.SECONDS));
            if (grpclbRouteType == Messages.GrpclbRouteType.GRPCLB_ROUTE_TYPE_BACKEND) {
                throw new AssertionError((Object)"Got grpclb route type backend. Backends are supposed to be unreachable, so this test is broken");
            }
            if (grpclbRouteType == Messages.GrpclbRouteType.GRPCLB_ROUTE_TYPE_FALLBACK) {
                logger.info("Made one successful RPC to a fallback. Now expect the same for the rest.");
                fellBack = true;
                break;
            }
            logger.info("Retryable RPC failure on iteration: " + fallbackRetryCount);
            ++fallbackRetryCount;
        }
        if (!fellBack) {
            throw new AssertionError((Object)"Didn't fall back within deadline");
        }
        for (int i = 0; i < 30; ++i) {
            Assert.assertEquals((Object)((Object)Messages.GrpclbRouteType.GRPCLB_ROUTE_TYPE_FALLBACK), (Object)((Object)this.doRpcAndGetPath(Deadline.after((long)20L, (TimeUnit)TimeUnit.SECONDS))));
            Thread.sleep(1000L);
        }
    }

    private void runFastFallbackBeforeStartup() throws Exception {
        GrpclbFallbackTestClient.runShellCmd(this.unrouteLbAndBackendAddrsCmd);
        Deadline fallbackDeadline = Deadline.after((long)5L, (TimeUnit)TimeUnit.SECONDS);
        this.initStub();
        this.waitForFallbackAndDoRpcs(fallbackDeadline);
    }

    private void runSlowFallbackBeforeStartup() throws Exception {
        GrpclbFallbackTestClient.runShellCmd(this.blackholeLbAndBackendAddrsCmd);
        Deadline fallbackDeadline = Deadline.after((long)20L, (TimeUnit)TimeUnit.SECONDS);
        this.initStub();
        this.waitForFallbackAndDoRpcs(fallbackDeadline);
    }

    private void runFastFallbackAfterStartup() throws Exception {
        this.initStub();
        Assert.assertEquals((Object)((Object)Messages.GrpclbRouteType.GRPCLB_ROUTE_TYPE_BACKEND), (Object)((Object)this.doRpcAndGetPath(Deadline.after((long)20L, (TimeUnit)TimeUnit.SECONDS))));
        GrpclbFallbackTestClient.runShellCmd(this.unrouteLbAndBackendAddrsCmd);
        Deadline fallbackDeadline = Deadline.after((long)40L, (TimeUnit)TimeUnit.SECONDS);
        this.waitForFallbackAndDoRpcs(fallbackDeadline);
    }

    private void runSlowFallbackAfterStartup() throws Exception {
        this.initStub();
        Assert.assertEquals((Object)((Object)Messages.GrpclbRouteType.GRPCLB_ROUTE_TYPE_BACKEND), (Object)((Object)this.doRpcAndGetPath(Deadline.after((long)20L, (TimeUnit)TimeUnit.SECONDS))));
        GrpclbFallbackTestClient.runShellCmd(this.blackholeLbAndBackendAddrsCmd);
        Deadline fallbackDeadline = Deadline.after((long)40L, (TimeUnit)TimeUnit.SECONDS);
        this.waitForFallbackAndDoRpcs(fallbackDeadline);
    }

    private void run() throws Exception {
        logger.info("Begin test case: " + this.testCase);
        if (this.testCase.equals("fast_fallback_before_startup")) {
            this.runFastFallbackBeforeStartup();
        } else if (this.testCase.equals("slow_fallback_before_startup")) {
            this.runSlowFallbackBeforeStartup();
        } else if (this.testCase.equals("fast_fallback_after_startup")) {
            this.runFastFallbackAfterStartup();
        } else if (this.testCase.equals("slow_fallback_after_startup")) {
            this.runSlowFallbackAfterStartup();
        } else {
            throw new RuntimeException("invalid testcase: " + this.testCase);
        }
        logger.info("Test case: " + this.testCase + " done!");
    }
}

