/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.testing.integration;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.io.Files;
import io.grpc.Channel;
import io.grpc.ClientInterceptor;
import io.grpc.ManagedChannel;
import io.grpc.alts.AltsChannelBuilder;
import io.grpc.alts.ComputeEngineChannelBuilder;
import io.grpc.alts.GoogleDefaultChannelBuilder;
import io.grpc.internal.AbstractManagedChannelImplBuilder;
import io.grpc.internal.GrpcUtil;
import io.grpc.internal.TestingAccessor;
import io.grpc.internal.testing.TestUtils;
import io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.NegotiationType;
import io.grpc.netty.NettyChannelBuilder;
import io.grpc.okhttp.OkHttpChannelBuilder;
import io.grpc.okhttp.internal.Platform;
import io.grpc.testing.integration.AbstractInteropTest;
import io.grpc.testing.integration.TestCases;
import io.grpc.testing.integration.TestServiceGrpc;
import io.netty.handler.ssl.SslContext;
import java.io.File;
import java.io.FileInputStream;
import java.nio.charset.Charset;
import java.security.Provider;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLSocketFactory;

public class TestServiceClient {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private String serverHost = "localhost";
    private String serverHostOverride;
    private int serverPort = 8080;
    private String testCase = "empty_unary";
    private boolean useTls = true;
    private boolean useAlts = false;
    private boolean useH2cUpgrade = false;
    private String customCredentialsType;
    private boolean useTestCa;
    private boolean useOkHttp;
    private String defaultServiceAccount;
    private String serviceAccountKeyFile;
    private String oauthScope;
    private boolean fullStreamDecompression;
    private Tester tester = new Tester();

    public static void main(String[] args) throws Exception {
        TestUtils.installConscryptIfAvailable();
        TestServiceClient client = new TestServiceClient();
        client.parseArgs(args);
        client.setUp();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                System.out.println("Shutting down");
                try {
                    TestServiceClient.this.tearDown();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        try {
            client.run();
        }
        finally {
            client.tearDown();
        }
        System.exit(0);
    }

    @VisibleForTesting
    void parseArgs(String[] args) {
        boolean usage = false;
        for (String arg : args) {
            if (!arg.startsWith("--")) {
                System.err.println("All arguments must start with '--': " + arg);
                usage = true;
                break;
            }
            String[] parts = arg.substring(2).split("=", 2);
            String key = parts[0];
            if ("help".equals(key)) {
                usage = true;
                break;
            }
            if (parts.length != 2) {
                System.err.println("All arguments must be of the form --arg=value");
                usage = true;
                break;
            }
            String value = parts[1];
            if ("server_host".equals(key)) {
                this.serverHost = value;
                continue;
            }
            if ("server_host_override".equals(key)) {
                this.serverHostOverride = value;
                continue;
            }
            if ("server_port".equals(key)) {
                this.serverPort = Integer.parseInt(value);
                continue;
            }
            if ("test_case".equals(key)) {
                this.testCase = value;
                continue;
            }
            if ("use_tls".equals(key)) {
                this.useTls = Boolean.parseBoolean(value);
                continue;
            }
            if ("use_upgrade".equals(key)) {
                this.useH2cUpgrade = Boolean.parseBoolean(value);
                continue;
            }
            if ("use_alts".equals(key)) {
                this.useAlts = Boolean.parseBoolean(value);
                continue;
            }
            if ("custom_credentials_type".equals(key)) {
                this.customCredentialsType = value;
                continue;
            }
            if ("use_test_ca".equals(key)) {
                this.useTestCa = Boolean.parseBoolean(value);
                continue;
            }
            if ("use_okhttp".equals(key)) {
                this.useOkHttp = Boolean.parseBoolean(value);
                continue;
            }
            if ("grpc_version".equals(key)) {
                if ("2".equals(value)) continue;
                System.err.println("Only grpc version 2 is supported");
                usage = true;
                break;
            }
            if ("default_service_account".equals(key)) {
                this.defaultServiceAccount = value;
                continue;
            }
            if ("service_account_key_file".equals(key)) {
                this.serviceAccountKeyFile = value;
                continue;
            }
            if ("oauth_scope".equals(key)) {
                this.oauthScope = value;
                continue;
            }
            if ("full_stream_decompression".equals(key)) {
                this.fullStreamDecompression = Boolean.parseBoolean(value);
                continue;
            }
            System.err.println("Unknown argument: " + key);
            usage = true;
            break;
        }
        if (this.useAlts || this.useH2cUpgrade) {
            this.useTls = false;
        }
        if (usage) {
            TestServiceClient c = new TestServiceClient();
            System.out.println("Usage: [ARGS...]\n\n  --server_host=HOST          Server to connect to. Default " + c.serverHost + "\n  --server_host_override=HOST Claimed identification expected of server.\n                              Defaults to server host\n  --server_port=PORT          Port to connect to. Default " + c.serverPort + "\n  --test_case=TESTCASE        Test case to run. Default " + c.testCase + "\n    Valid options:" + TestServiceClient.validTestCasesHelpText() + "\n  --use_tls=true|false        Whether to use TLS. Default " + c.useTls + "\n  --use_alts=true|false       Whether to use ALTS. Enable ALTS will disable TLS.\n                              Default " + c.useAlts + "\n  --use_upgrade=true|false    Whether to use the h2c Upgrade mechanism.\n                              Enabling h2c Upgrade will disable TLS.\n                              Default " + c.useH2cUpgrade + "\n  --custom_credentials_type   Custom credentials type to use. Default " + c.customCredentialsType + "\n  --use_test_ca=true|false    Whether to trust our fake CA. Requires --use_tls=true \n                              to have effect. Default " + c.useTestCa + "\n  --use_okhttp=true|false     Whether to use OkHttp instead of Netty. Default " + c.useOkHttp + "\n  --default_service_account   Email of GCE default service account. Default " + c.defaultServiceAccount + "\n  --service_account_key_file  Path to service account json key file." + c.serviceAccountKeyFile + "\n  --oauth_scope               Scope for OAuth tokens. Default " + c.oauthScope + "\n  --full_stream_decompression Enable full-stream decompression. Default " + c.fullStreamDecompression);
            System.exit(1);
        }
    }

    @VisibleForTesting
    void setUp() {
        this.tester.setUp();
    }

    private synchronized void tearDown() {
        try {
            this.tester.tearDown();
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private void run() {
        System.out.println("Running test " + this.testCase);
        try {
            this.runTest(TestCases.fromString(this.testCase));
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        System.out.println("Test completed.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runTest(TestCases testCase) throws Exception {
        switch (testCase) {
            case EMPTY_UNARY: {
                this.tester.emptyUnary();
                break;
            }
            case CACHEABLE_UNARY: {
                this.tester.cacheableUnary();
                break;
            }
            case LARGE_UNARY: {
                this.tester.largeUnary();
                break;
            }
            case CLIENT_COMPRESSED_UNARY: {
                this.tester.clientCompressedUnary(true);
                break;
            }
            case CLIENT_COMPRESSED_UNARY_NOPROBE: {
                this.tester.clientCompressedUnary(false);
                break;
            }
            case SERVER_COMPRESSED_UNARY: {
                this.tester.serverCompressedUnary();
                break;
            }
            case CLIENT_STREAMING: {
                this.tester.clientStreaming();
                break;
            }
            case CLIENT_COMPRESSED_STREAMING: {
                this.tester.clientCompressedStreaming(true);
                break;
            }
            case CLIENT_COMPRESSED_STREAMING_NOPROBE: {
                this.tester.clientCompressedStreaming(false);
                break;
            }
            case SERVER_STREAMING: {
                this.tester.serverStreaming();
                break;
            }
            case SERVER_COMPRESSED_STREAMING: {
                this.tester.serverCompressedStreaming();
                break;
            }
            case PING_PONG: {
                this.tester.pingPong();
                break;
            }
            case EMPTY_STREAM: {
                this.tester.emptyStream();
                break;
            }
            case COMPUTE_ENGINE_CREDS: {
                this.tester.computeEngineCreds(this.defaultServiceAccount, this.oauthScope);
                break;
            }
            case COMPUTE_ENGINE_CHANNEL_CREDENTIALS: {
                ManagedChannel channel = ComputeEngineChannelBuilder.forAddress((String)this.serverHost, (int)this.serverPort).build();
                try {
                    TestServiceGrpc.TestServiceBlockingStub computeEngineStub = TestServiceGrpc.newBlockingStub((Channel)channel);
                    this.tester.computeEngineChannelCredentials(this.defaultServiceAccount, computeEngineStub);
                    break;
                }
                finally {
                    channel.shutdownNow();
                    channel.awaitTermination(5L, TimeUnit.SECONDS);
                }
            }
            case SERVICE_ACCOUNT_CREDS: {
                String jsonKey = Files.asCharSource((File)new File(this.serviceAccountKeyFile), (Charset)UTF_8).read();
                FileInputStream credentialsStream = new FileInputStream(new File(this.serviceAccountKeyFile));
                this.tester.serviceAccountCreds(jsonKey, credentialsStream, this.oauthScope);
                break;
            }
            case JWT_TOKEN_CREDS: {
                FileInputStream credentialsStream = new FileInputStream(new File(this.serviceAccountKeyFile));
                this.tester.jwtTokenCreds(credentialsStream);
                break;
            }
            case OAUTH2_AUTH_TOKEN: {
                String jsonKey = Files.asCharSource((File)new File(this.serviceAccountKeyFile), (Charset)UTF_8).read();
                FileInputStream credentialsStream = new FileInputStream(new File(this.serviceAccountKeyFile));
                this.tester.oauth2AuthToken(jsonKey, credentialsStream, this.oauthScope);
                break;
            }
            case PER_RPC_CREDS: {
                String jsonKey = Files.asCharSource((File)new File(this.serviceAccountKeyFile), (Charset)UTF_8).read();
                FileInputStream credentialsStream = new FileInputStream(new File(this.serviceAccountKeyFile));
                this.tester.perRpcCreds(jsonKey, credentialsStream, this.oauthScope);
                break;
            }
            case GOOGLE_DEFAULT_CREDENTIALS: {
                ManagedChannel channel = GoogleDefaultChannelBuilder.forAddress((String)this.serverHost, (int)this.serverPort).build();
                try {
                    TestServiceGrpc.TestServiceBlockingStub googleDefaultStub = TestServiceGrpc.newBlockingStub((Channel)channel);
                    this.tester.googleDefaultCredentials(this.defaultServiceAccount, googleDefaultStub);
                    break;
                }
                finally {
                    channel.shutdownNow();
                }
            }
            case CUSTOM_METADATA: {
                this.tester.customMetadata();
                break;
            }
            case STATUS_CODE_AND_MESSAGE: {
                this.tester.statusCodeAndMessage();
                break;
            }
            case SPECIAL_STATUS_MESSAGE: {
                this.tester.specialStatusMessage();
                break;
            }
            case UNIMPLEMENTED_METHOD: {
                this.tester.unimplementedMethod();
                break;
            }
            case UNIMPLEMENTED_SERVICE: {
                this.tester.unimplementedService();
                break;
            }
            case CANCEL_AFTER_BEGIN: {
                this.tester.cancelAfterBegin();
                break;
            }
            case CANCEL_AFTER_FIRST_RESPONSE: {
                this.tester.cancelAfterFirstResponse();
                break;
            }
            case TIMEOUT_ON_SLEEPING_SERVER: {
                this.tester.timeoutOnSleepingServer();
                break;
            }
            case VERY_LARGE_REQUEST: {
                this.tester.veryLargeRequest();
                break;
            }
            case PICK_FIRST_UNARY: {
                this.tester.pickFirstUnary();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown test case: " + (Object)((Object)testCase));
            }
        }
    }

    private static String validTestCasesHelpText() {
        StringBuilder builder = new StringBuilder();
        for (TestCases testCase : TestCases.values()) {
            String strTestcase = testCase.name().toLowerCase();
            builder.append("\n      ").append(strTestcase).append(": ").append(testCase.description());
        }
        return builder.toString();
    }

    private class Tester
    extends AbstractInteropTest {
        private Tester() {
        }

        @Override
        protected ManagedChannel createChannel() {
            OkHttpChannelBuilder builder;
            if (TestServiceClient.this.customCredentialsType != null && TestServiceClient.this.customCredentialsType.equals("google_default_credentials")) {
                return GoogleDefaultChannelBuilder.forAddress((String)TestServiceClient.this.serverHost, (int)TestServiceClient.this.serverPort).build();
            }
            if (TestServiceClient.this.customCredentialsType != null && TestServiceClient.this.customCredentialsType.equals("compute_engine_channel_creds")) {
                return ComputeEngineChannelBuilder.forAddress((String)TestServiceClient.this.serverHost, (int)TestServiceClient.this.serverPort).build();
            }
            if (TestServiceClient.this.useAlts) {
                return AltsChannelBuilder.forAddress((String)TestServiceClient.this.serverHost, (int)TestServiceClient.this.serverPort).build();
            }
            if (!TestServiceClient.this.useOkHttp) {
                SslContext sslContext = null;
                if (TestServiceClient.this.useTestCa) {
                    try {
                        sslContext = GrpcSslContexts.forClient().trustManager(TestUtils.loadCert((String)"ca.pem")).build();
                    }
                    catch (Exception ex) {
                        throw new RuntimeException(ex);
                    }
                }
                NettyChannelBuilder nettyBuilder = NettyChannelBuilder.forAddress((String)TestServiceClient.this.serverHost, (int)TestServiceClient.this.serverPort).flowControlWindow(66560).negotiationType(TestServiceClient.this.useTls ? NegotiationType.TLS : (TestServiceClient.this.useH2cUpgrade ? NegotiationType.PLAINTEXT_UPGRADE : NegotiationType.PLAINTEXT)).sslContext(sslContext);
                if (TestServiceClient.this.serverHostOverride != null) {
                    nettyBuilder.overrideAuthority(TestServiceClient.this.serverHostOverride);
                }
                if (TestServiceClient.this.fullStreamDecompression) {
                    nettyBuilder.enableFullStreamDecompression();
                }
                builder = nettyBuilder;
            } else {
                OkHttpChannelBuilder okBuilder = OkHttpChannelBuilder.forAddress((String)TestServiceClient.this.serverHost, (int)TestServiceClient.this.serverPort);
                if (TestServiceClient.this.serverHostOverride != null) {
                    okBuilder.overrideAuthority(GrpcUtil.authorityFromHostAndPort((String)TestServiceClient.this.serverHostOverride, (int)TestServiceClient.this.serverPort));
                }
                if (TestServiceClient.this.useTls) {
                    if (TestServiceClient.this.useTestCa) {
                        try {
                            SSLSocketFactory factory = TestUtils.newSslSocketFactoryForCa((Provider)Platform.get().getProvider(), (File)TestUtils.loadCert((String)"ca.pem"));
                            okBuilder.sslSocketFactory(factory);
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    }
                } else {
                    okBuilder.usePlaintext();
                }
                if (TestServiceClient.this.fullStreamDecompression) {
                    okBuilder.enableFullStreamDecompression();
                }
                builder = okBuilder;
            }
            TestingAccessor.setStatsEnabled((AbstractManagedChannelImplBuilder)builder, (boolean)false);
            return builder.intercept(new ClientInterceptor[]{this.createCensusStatsClientInterceptor()}).build();
        }

        @Override
        protected boolean metricsExpected() {
            return false;
        }
    }
}

