/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.testing.integration;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.protobuf.Descriptors;
import com.google.protobuf.EmptyProtos;
import com.google.protobuf.Message;
import io.grpc.BindableService;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ExperimentalApi;
import io.grpc.MethodDescriptor;
import io.grpc.ServerServiceDefinition;
import io.grpc.ServiceDescriptor;
import io.grpc.protobuf.ProtoFileDescriptorSupplier;
import io.grpc.protobuf.ProtoMethodDescriptorSupplier;
import io.grpc.protobuf.ProtoServiceDescriptorSupplier;
import io.grpc.protobuf.ProtoUtils;
import io.grpc.stub.AbstractStub;
import io.grpc.stub.ClientCalls;
import io.grpc.stub.ServerCalls;
import io.grpc.stub.StreamObserver;
import io.grpc.testing.integration.Messages;
import io.grpc.testing.integration.Test;
import java.util.Iterator;

public final class TestServiceGrpc {
    public static final String SERVICE_NAME = "grpc.testing.TestService";
    @Deprecated
    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/1901")
    public static final MethodDescriptor<EmptyProtos.Empty, EmptyProtos.Empty> METHOD_EMPTY_CALL = TestServiceGrpc.getEmptyCallMethodHelper();
    private static volatile MethodDescriptor<EmptyProtos.Empty, EmptyProtos.Empty> getEmptyCallMethod;
    @Deprecated
    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/1901")
    public static final MethodDescriptor<Messages.SimpleRequest, Messages.SimpleResponse> METHOD_UNARY_CALL;
    private static volatile MethodDescriptor<Messages.SimpleRequest, Messages.SimpleResponse> getUnaryCallMethod;
    @Deprecated
    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/1901")
    public static final MethodDescriptor<Messages.SimpleRequest, Messages.SimpleResponse> METHOD_CACHEABLE_UNARY_CALL;
    private static volatile MethodDescriptor<Messages.SimpleRequest, Messages.SimpleResponse> getCacheableUnaryCallMethod;
    @Deprecated
    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/1901")
    public static final MethodDescriptor<Messages.StreamingOutputCallRequest, Messages.StreamingOutputCallResponse> METHOD_STREAMING_OUTPUT_CALL;
    private static volatile MethodDescriptor<Messages.StreamingOutputCallRequest, Messages.StreamingOutputCallResponse> getStreamingOutputCallMethod;
    @Deprecated
    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/1901")
    public static final MethodDescriptor<Messages.StreamingInputCallRequest, Messages.StreamingInputCallResponse> METHOD_STREAMING_INPUT_CALL;
    private static volatile MethodDescriptor<Messages.StreamingInputCallRequest, Messages.StreamingInputCallResponse> getStreamingInputCallMethod;
    @Deprecated
    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/1901")
    public static final MethodDescriptor<Messages.StreamingOutputCallRequest, Messages.StreamingOutputCallResponse> METHOD_FULL_DUPLEX_CALL;
    private static volatile MethodDescriptor<Messages.StreamingOutputCallRequest, Messages.StreamingOutputCallResponse> getFullDuplexCallMethod;
    @Deprecated
    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/1901")
    public static final MethodDescriptor<Messages.StreamingOutputCallRequest, Messages.StreamingOutputCallResponse> METHOD_HALF_DUPLEX_CALL;
    private static volatile MethodDescriptor<Messages.StreamingOutputCallRequest, Messages.StreamingOutputCallResponse> getHalfDuplexCallMethod;
    @Deprecated
    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/1901")
    public static final MethodDescriptor<EmptyProtos.Empty, EmptyProtos.Empty> METHOD_UNIMPLEMENTED_CALL;
    private static volatile MethodDescriptor<EmptyProtos.Empty, EmptyProtos.Empty> getUnimplementedCallMethod;
    private static final int METHODID_EMPTY_CALL = 0;
    private static final int METHODID_UNARY_CALL = 1;
    private static final int METHODID_CACHEABLE_UNARY_CALL = 2;
    private static final int METHODID_STREAMING_OUTPUT_CALL = 3;
    private static final int METHODID_UNIMPLEMENTED_CALL = 4;
    private static final int METHODID_STREAMING_INPUT_CALL = 5;
    private static final int METHODID_FULL_DUPLEX_CALL = 6;
    private static final int METHODID_HALF_DUPLEX_CALL = 7;
    private static volatile ServiceDescriptor serviceDescriptor;

    private TestServiceGrpc() {
    }

    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/1901")
    public static MethodDescriptor<EmptyProtos.Empty, EmptyProtos.Empty> getEmptyCallMethod() {
        return TestServiceGrpc.getEmptyCallMethodHelper();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static MethodDescriptor<EmptyProtos.Empty, EmptyProtos.Empty> getEmptyCallMethodHelper() {
        MethodDescriptor getEmptyCallMethod = TestServiceGrpc.getEmptyCallMethod;
        if (getEmptyCallMethod != null) return getEmptyCallMethod;
        Class<TestServiceGrpc> clazz = TestServiceGrpc.class;
        synchronized (TestServiceGrpc.class) {
            getEmptyCallMethod = TestServiceGrpc.getEmptyCallMethod;
            if (getEmptyCallMethod != null) return getEmptyCallMethod;
            TestServiceGrpc.getEmptyCallMethod = getEmptyCallMethod = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName(MethodDescriptor.generateFullMethodName((String)SERVICE_NAME, (String)"EmptyCall")).setSampledToLocalTracing(true).setRequestMarshaller(ProtoUtils.marshaller((Message)EmptyProtos.Empty.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)EmptyProtos.Empty.getDefaultInstance())).setSchemaDescriptor((Object)new TestServiceMethodDescriptorSupplier("EmptyCall")).build();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return getEmptyCallMethod;
        }
    }

    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/1901")
    public static MethodDescriptor<Messages.SimpleRequest, Messages.SimpleResponse> getUnaryCallMethod() {
        return TestServiceGrpc.getUnaryCallMethodHelper();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static MethodDescriptor<Messages.SimpleRequest, Messages.SimpleResponse> getUnaryCallMethodHelper() {
        MethodDescriptor getUnaryCallMethod = TestServiceGrpc.getUnaryCallMethod;
        if (getUnaryCallMethod != null) return getUnaryCallMethod;
        Class<TestServiceGrpc> clazz = TestServiceGrpc.class;
        synchronized (TestServiceGrpc.class) {
            getUnaryCallMethod = TestServiceGrpc.getUnaryCallMethod;
            if (getUnaryCallMethod != null) return getUnaryCallMethod;
            TestServiceGrpc.getUnaryCallMethod = getUnaryCallMethod = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName(MethodDescriptor.generateFullMethodName((String)SERVICE_NAME, (String)"UnaryCall")).setSampledToLocalTracing(true).setRequestMarshaller(ProtoUtils.marshaller((Message)Messages.SimpleRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Messages.SimpleResponse.getDefaultInstance())).setSchemaDescriptor((Object)new TestServiceMethodDescriptorSupplier("UnaryCall")).build();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return getUnaryCallMethod;
        }
    }

    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/1901")
    public static MethodDescriptor<Messages.SimpleRequest, Messages.SimpleResponse> getCacheableUnaryCallMethod() {
        return TestServiceGrpc.getCacheableUnaryCallMethodHelper();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static MethodDescriptor<Messages.SimpleRequest, Messages.SimpleResponse> getCacheableUnaryCallMethodHelper() {
        MethodDescriptor getCacheableUnaryCallMethod = TestServiceGrpc.getCacheableUnaryCallMethod;
        if (getCacheableUnaryCallMethod != null) return getCacheableUnaryCallMethod;
        Class<TestServiceGrpc> clazz = TestServiceGrpc.class;
        synchronized (TestServiceGrpc.class) {
            getCacheableUnaryCallMethod = TestServiceGrpc.getCacheableUnaryCallMethod;
            if (getCacheableUnaryCallMethod != null) return getCacheableUnaryCallMethod;
            TestServiceGrpc.getCacheableUnaryCallMethod = getCacheableUnaryCallMethod = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName(MethodDescriptor.generateFullMethodName((String)SERVICE_NAME, (String)"CacheableUnaryCall")).setSampledToLocalTracing(true).setRequestMarshaller(ProtoUtils.marshaller((Message)Messages.SimpleRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Messages.SimpleResponse.getDefaultInstance())).setSchemaDescriptor((Object)new TestServiceMethodDescriptorSupplier("CacheableUnaryCall")).build();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return getCacheableUnaryCallMethod;
        }
    }

    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/1901")
    public static MethodDescriptor<Messages.StreamingOutputCallRequest, Messages.StreamingOutputCallResponse> getStreamingOutputCallMethod() {
        return TestServiceGrpc.getStreamingOutputCallMethodHelper();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static MethodDescriptor<Messages.StreamingOutputCallRequest, Messages.StreamingOutputCallResponse> getStreamingOutputCallMethodHelper() {
        MethodDescriptor getStreamingOutputCallMethod = TestServiceGrpc.getStreamingOutputCallMethod;
        if (getStreamingOutputCallMethod != null) return getStreamingOutputCallMethod;
        Class<TestServiceGrpc> clazz = TestServiceGrpc.class;
        synchronized (TestServiceGrpc.class) {
            getStreamingOutputCallMethod = TestServiceGrpc.getStreamingOutputCallMethod;
            if (getStreamingOutputCallMethod != null) return getStreamingOutputCallMethod;
            TestServiceGrpc.getStreamingOutputCallMethod = getStreamingOutputCallMethod = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.SERVER_STREAMING).setFullMethodName(MethodDescriptor.generateFullMethodName((String)SERVICE_NAME, (String)"StreamingOutputCall")).setSampledToLocalTracing(true).setRequestMarshaller(ProtoUtils.marshaller((Message)Messages.StreamingOutputCallRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Messages.StreamingOutputCallResponse.getDefaultInstance())).setSchemaDescriptor((Object)new TestServiceMethodDescriptorSupplier("StreamingOutputCall")).build();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return getStreamingOutputCallMethod;
        }
    }

    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/1901")
    public static MethodDescriptor<Messages.StreamingInputCallRequest, Messages.StreamingInputCallResponse> getStreamingInputCallMethod() {
        return TestServiceGrpc.getStreamingInputCallMethodHelper();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static MethodDescriptor<Messages.StreamingInputCallRequest, Messages.StreamingInputCallResponse> getStreamingInputCallMethodHelper() {
        MethodDescriptor getStreamingInputCallMethod = TestServiceGrpc.getStreamingInputCallMethod;
        if (getStreamingInputCallMethod != null) return getStreamingInputCallMethod;
        Class<TestServiceGrpc> clazz = TestServiceGrpc.class;
        synchronized (TestServiceGrpc.class) {
            getStreamingInputCallMethod = TestServiceGrpc.getStreamingInputCallMethod;
            if (getStreamingInputCallMethod != null) return getStreamingInputCallMethod;
            TestServiceGrpc.getStreamingInputCallMethod = getStreamingInputCallMethod = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.CLIENT_STREAMING).setFullMethodName(MethodDescriptor.generateFullMethodName((String)SERVICE_NAME, (String)"StreamingInputCall")).setSampledToLocalTracing(true).setRequestMarshaller(ProtoUtils.marshaller((Message)Messages.StreamingInputCallRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Messages.StreamingInputCallResponse.getDefaultInstance())).setSchemaDescriptor((Object)new TestServiceMethodDescriptorSupplier("StreamingInputCall")).build();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return getStreamingInputCallMethod;
        }
    }

    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/1901")
    public static MethodDescriptor<Messages.StreamingOutputCallRequest, Messages.StreamingOutputCallResponse> getFullDuplexCallMethod() {
        return TestServiceGrpc.getFullDuplexCallMethodHelper();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static MethodDescriptor<Messages.StreamingOutputCallRequest, Messages.StreamingOutputCallResponse> getFullDuplexCallMethodHelper() {
        MethodDescriptor getFullDuplexCallMethod = TestServiceGrpc.getFullDuplexCallMethod;
        if (getFullDuplexCallMethod != null) return getFullDuplexCallMethod;
        Class<TestServiceGrpc> clazz = TestServiceGrpc.class;
        synchronized (TestServiceGrpc.class) {
            getFullDuplexCallMethod = TestServiceGrpc.getFullDuplexCallMethod;
            if (getFullDuplexCallMethod != null) return getFullDuplexCallMethod;
            TestServiceGrpc.getFullDuplexCallMethod = getFullDuplexCallMethod = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.BIDI_STREAMING).setFullMethodName(MethodDescriptor.generateFullMethodName((String)SERVICE_NAME, (String)"FullDuplexCall")).setSampledToLocalTracing(true).setRequestMarshaller(ProtoUtils.marshaller((Message)Messages.StreamingOutputCallRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Messages.StreamingOutputCallResponse.getDefaultInstance())).setSchemaDescriptor((Object)new TestServiceMethodDescriptorSupplier("FullDuplexCall")).build();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return getFullDuplexCallMethod;
        }
    }

    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/1901")
    public static MethodDescriptor<Messages.StreamingOutputCallRequest, Messages.StreamingOutputCallResponse> getHalfDuplexCallMethod() {
        return TestServiceGrpc.getHalfDuplexCallMethodHelper();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static MethodDescriptor<Messages.StreamingOutputCallRequest, Messages.StreamingOutputCallResponse> getHalfDuplexCallMethodHelper() {
        MethodDescriptor getHalfDuplexCallMethod = TestServiceGrpc.getHalfDuplexCallMethod;
        if (getHalfDuplexCallMethod != null) return getHalfDuplexCallMethod;
        Class<TestServiceGrpc> clazz = TestServiceGrpc.class;
        synchronized (TestServiceGrpc.class) {
            getHalfDuplexCallMethod = TestServiceGrpc.getHalfDuplexCallMethod;
            if (getHalfDuplexCallMethod != null) return getHalfDuplexCallMethod;
            TestServiceGrpc.getHalfDuplexCallMethod = getHalfDuplexCallMethod = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.BIDI_STREAMING).setFullMethodName(MethodDescriptor.generateFullMethodName((String)SERVICE_NAME, (String)"HalfDuplexCall")).setSampledToLocalTracing(true).setRequestMarshaller(ProtoUtils.marshaller((Message)Messages.StreamingOutputCallRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Messages.StreamingOutputCallResponse.getDefaultInstance())).setSchemaDescriptor((Object)new TestServiceMethodDescriptorSupplier("HalfDuplexCall")).build();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return getHalfDuplexCallMethod;
        }
    }

    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/1901")
    public static MethodDescriptor<EmptyProtos.Empty, EmptyProtos.Empty> getUnimplementedCallMethod() {
        return TestServiceGrpc.getUnimplementedCallMethodHelper();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static MethodDescriptor<EmptyProtos.Empty, EmptyProtos.Empty> getUnimplementedCallMethodHelper() {
        MethodDescriptor getUnimplementedCallMethod = TestServiceGrpc.getUnimplementedCallMethod;
        if (getUnimplementedCallMethod != null) return getUnimplementedCallMethod;
        Class<TestServiceGrpc> clazz = TestServiceGrpc.class;
        synchronized (TestServiceGrpc.class) {
            getUnimplementedCallMethod = TestServiceGrpc.getUnimplementedCallMethod;
            if (getUnimplementedCallMethod != null) return getUnimplementedCallMethod;
            TestServiceGrpc.getUnimplementedCallMethod = getUnimplementedCallMethod = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName(MethodDescriptor.generateFullMethodName((String)SERVICE_NAME, (String)"UnimplementedCall")).setSampledToLocalTracing(true).setRequestMarshaller(ProtoUtils.marshaller((Message)EmptyProtos.Empty.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)EmptyProtos.Empty.getDefaultInstance())).setSchemaDescriptor((Object)new TestServiceMethodDescriptorSupplier("UnimplementedCall")).build();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return getUnimplementedCallMethod;
        }
    }

    public static TestServiceStub newStub(Channel channel) {
        return new TestServiceStub(channel);
    }

    public static TestServiceBlockingStub newBlockingStub(Channel channel) {
        return new TestServiceBlockingStub(channel);
    }

    public static TestServiceFutureStub newFutureStub(Channel channel) {
        return new TestServiceFutureStub(channel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ServiceDescriptor getServiceDescriptor() {
        ServiceDescriptor result = serviceDescriptor;
        if (result != null) return result;
        Class<TestServiceGrpc> clazz = TestServiceGrpc.class;
        synchronized (TestServiceGrpc.class) {
            result = serviceDescriptor;
            if (result != null) return result;
            serviceDescriptor = result = ServiceDescriptor.newBuilder((String)SERVICE_NAME).setSchemaDescriptor((Object)new TestServiceFileDescriptorSupplier()).addMethod(TestServiceGrpc.getEmptyCallMethodHelper()).addMethod(TestServiceGrpc.getUnaryCallMethodHelper()).addMethod(TestServiceGrpc.getCacheableUnaryCallMethodHelper()).addMethod(TestServiceGrpc.getStreamingOutputCallMethodHelper()).addMethod(TestServiceGrpc.getStreamingInputCallMethodHelper()).addMethod(TestServiceGrpc.getFullDuplexCallMethodHelper()).addMethod(TestServiceGrpc.getHalfDuplexCallMethodHelper()).addMethod(TestServiceGrpc.getUnimplementedCallMethodHelper()).build();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return result;
        }
    }

    static {
        METHOD_UNARY_CALL = TestServiceGrpc.getUnaryCallMethodHelper();
        METHOD_CACHEABLE_UNARY_CALL = TestServiceGrpc.getCacheableUnaryCallMethodHelper();
        METHOD_STREAMING_OUTPUT_CALL = TestServiceGrpc.getStreamingOutputCallMethodHelper();
        METHOD_STREAMING_INPUT_CALL = TestServiceGrpc.getStreamingInputCallMethodHelper();
        METHOD_FULL_DUPLEX_CALL = TestServiceGrpc.getFullDuplexCallMethodHelper();
        METHOD_HALF_DUPLEX_CALL = TestServiceGrpc.getHalfDuplexCallMethodHelper();
        METHOD_UNIMPLEMENTED_CALL = TestServiceGrpc.getUnimplementedCallMethodHelper();
    }

    private static final class TestServiceMethodDescriptorSupplier
    extends TestServiceBaseDescriptorSupplier
    implements ProtoMethodDescriptorSupplier {
        private final String methodName;

        TestServiceMethodDescriptorSupplier(String methodName) {
            this.methodName = methodName;
        }

        public Descriptors.MethodDescriptor getMethodDescriptor() {
            return this.getServiceDescriptor().findMethodByName(this.methodName);
        }
    }

    private static final class TestServiceFileDescriptorSupplier
    extends TestServiceBaseDescriptorSupplier {
        TestServiceFileDescriptorSupplier() {
        }
    }

    private static abstract class TestServiceBaseDescriptorSupplier
    implements ProtoFileDescriptorSupplier,
    ProtoServiceDescriptorSupplier {
        TestServiceBaseDescriptorSupplier() {
        }

        public Descriptors.FileDescriptor getFileDescriptor() {
            return Test.getDescriptor();
        }

        public Descriptors.ServiceDescriptor getServiceDescriptor() {
            return this.getFileDescriptor().findServiceByName("TestService");
        }
    }

    private static final class MethodHandlers<Req, Resp>
    implements ServerCalls.UnaryMethod<Req, Resp>,
    ServerCalls.ServerStreamingMethod<Req, Resp>,
    ServerCalls.ClientStreamingMethod<Req, Resp>,
    ServerCalls.BidiStreamingMethod<Req, Resp> {
        private final TestServiceImplBase serviceImpl;
        private final int methodId;

        MethodHandlers(TestServiceImplBase serviceImpl, int methodId) {
            this.serviceImpl = serviceImpl;
            this.methodId = methodId;
        }

        public void invoke(Req request, StreamObserver<Resp> responseObserver) {
            switch (this.methodId) {
                case 0: {
                    this.serviceImpl.emptyCall((EmptyProtos.Empty)request, responseObserver);
                    break;
                }
                case 1: {
                    this.serviceImpl.unaryCall((Messages.SimpleRequest)request, responseObserver);
                    break;
                }
                case 2: {
                    this.serviceImpl.cacheableUnaryCall((Messages.SimpleRequest)request, responseObserver);
                    break;
                }
                case 3: {
                    this.serviceImpl.streamingOutputCall((Messages.StreamingOutputCallRequest)request, responseObserver);
                    break;
                }
                case 4: {
                    this.serviceImpl.unimplementedCall((EmptyProtos.Empty)request, responseObserver);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }

        public StreamObserver<Req> invoke(StreamObserver<Resp> responseObserver) {
            switch (this.methodId) {
                case 5: {
                    return this.serviceImpl.streamingInputCall(responseObserver);
                }
                case 6: {
                    return this.serviceImpl.fullDuplexCall(responseObserver);
                }
                case 7: {
                    return this.serviceImpl.halfDuplexCall(responseObserver);
                }
            }
            throw new AssertionError();
        }
    }

    public static final class TestServiceFutureStub
    extends AbstractStub<TestServiceFutureStub> {
        private TestServiceFutureStub(Channel channel) {
            super(channel);
        }

        private TestServiceFutureStub(Channel channel, CallOptions callOptions) {
            super(channel, callOptions);
        }

        protected TestServiceFutureStub build(Channel channel, CallOptions callOptions) {
            return new TestServiceFutureStub(channel, callOptions);
        }

        public ListenableFuture<EmptyProtos.Empty> emptyCall(EmptyProtos.Empty request) {
            return ClientCalls.futureUnaryCall((ClientCall)this.getChannel().newCall(TestServiceGrpc.getEmptyCallMethodHelper(), this.getCallOptions()), (Object)request);
        }

        public ListenableFuture<Messages.SimpleResponse> unaryCall(Messages.SimpleRequest request) {
            return ClientCalls.futureUnaryCall((ClientCall)this.getChannel().newCall(TestServiceGrpc.getUnaryCallMethodHelper(), this.getCallOptions()), (Object)request);
        }

        public ListenableFuture<Messages.SimpleResponse> cacheableUnaryCall(Messages.SimpleRequest request) {
            return ClientCalls.futureUnaryCall((ClientCall)this.getChannel().newCall(TestServiceGrpc.getCacheableUnaryCallMethodHelper(), this.getCallOptions()), (Object)request);
        }

        public ListenableFuture<EmptyProtos.Empty> unimplementedCall(EmptyProtos.Empty request) {
            return ClientCalls.futureUnaryCall((ClientCall)this.getChannel().newCall(TestServiceGrpc.getUnimplementedCallMethodHelper(), this.getCallOptions()), (Object)request);
        }
    }

    public static final class TestServiceBlockingStub
    extends AbstractStub<TestServiceBlockingStub> {
        private TestServiceBlockingStub(Channel channel) {
            super(channel);
        }

        private TestServiceBlockingStub(Channel channel, CallOptions callOptions) {
            super(channel, callOptions);
        }

        protected TestServiceBlockingStub build(Channel channel, CallOptions callOptions) {
            return new TestServiceBlockingStub(channel, callOptions);
        }

        public EmptyProtos.Empty emptyCall(EmptyProtos.Empty request) {
            return (EmptyProtos.Empty)ClientCalls.blockingUnaryCall((Channel)this.getChannel(), (MethodDescriptor)TestServiceGrpc.getEmptyCallMethodHelper(), (CallOptions)this.getCallOptions(), (Object)request);
        }

        public Messages.SimpleResponse unaryCall(Messages.SimpleRequest request) {
            return (Messages.SimpleResponse)ClientCalls.blockingUnaryCall((Channel)this.getChannel(), (MethodDescriptor)TestServiceGrpc.getUnaryCallMethodHelper(), (CallOptions)this.getCallOptions(), (Object)request);
        }

        public Messages.SimpleResponse cacheableUnaryCall(Messages.SimpleRequest request) {
            return (Messages.SimpleResponse)ClientCalls.blockingUnaryCall((Channel)this.getChannel(), (MethodDescriptor)TestServiceGrpc.getCacheableUnaryCallMethodHelper(), (CallOptions)this.getCallOptions(), (Object)request);
        }

        public Iterator<Messages.StreamingOutputCallResponse> streamingOutputCall(Messages.StreamingOutputCallRequest request) {
            return ClientCalls.blockingServerStreamingCall((Channel)this.getChannel(), (MethodDescriptor)TestServiceGrpc.getStreamingOutputCallMethodHelper(), (CallOptions)this.getCallOptions(), (Object)request);
        }

        public EmptyProtos.Empty unimplementedCall(EmptyProtos.Empty request) {
            return (EmptyProtos.Empty)ClientCalls.blockingUnaryCall((Channel)this.getChannel(), (MethodDescriptor)TestServiceGrpc.getUnimplementedCallMethodHelper(), (CallOptions)this.getCallOptions(), (Object)request);
        }
    }

    public static final class TestServiceStub
    extends AbstractStub<TestServiceStub> {
        private TestServiceStub(Channel channel) {
            super(channel);
        }

        private TestServiceStub(Channel channel, CallOptions callOptions) {
            super(channel, callOptions);
        }

        protected TestServiceStub build(Channel channel, CallOptions callOptions) {
            return new TestServiceStub(channel, callOptions);
        }

        public void emptyCall(EmptyProtos.Empty request, StreamObserver<EmptyProtos.Empty> responseObserver) {
            ClientCalls.asyncUnaryCall((ClientCall)this.getChannel().newCall(TestServiceGrpc.getEmptyCallMethodHelper(), this.getCallOptions()), (Object)request, responseObserver);
        }

        public void unaryCall(Messages.SimpleRequest request, StreamObserver<Messages.SimpleResponse> responseObserver) {
            ClientCalls.asyncUnaryCall((ClientCall)this.getChannel().newCall(TestServiceGrpc.getUnaryCallMethodHelper(), this.getCallOptions()), (Object)request, responseObserver);
        }

        public void cacheableUnaryCall(Messages.SimpleRequest request, StreamObserver<Messages.SimpleResponse> responseObserver) {
            ClientCalls.asyncUnaryCall((ClientCall)this.getChannel().newCall(TestServiceGrpc.getCacheableUnaryCallMethodHelper(), this.getCallOptions()), (Object)request, responseObserver);
        }

        public void streamingOutputCall(Messages.StreamingOutputCallRequest request, StreamObserver<Messages.StreamingOutputCallResponse> responseObserver) {
            ClientCalls.asyncServerStreamingCall((ClientCall)this.getChannel().newCall(TestServiceGrpc.getStreamingOutputCallMethodHelper(), this.getCallOptions()), (Object)request, responseObserver);
        }

        public StreamObserver<Messages.StreamingInputCallRequest> streamingInputCall(StreamObserver<Messages.StreamingInputCallResponse> responseObserver) {
            return ClientCalls.asyncClientStreamingCall((ClientCall)this.getChannel().newCall(TestServiceGrpc.getStreamingInputCallMethodHelper(), this.getCallOptions()), responseObserver);
        }

        public StreamObserver<Messages.StreamingOutputCallRequest> fullDuplexCall(StreamObserver<Messages.StreamingOutputCallResponse> responseObserver) {
            return ClientCalls.asyncBidiStreamingCall((ClientCall)this.getChannel().newCall(TestServiceGrpc.getFullDuplexCallMethodHelper(), this.getCallOptions()), responseObserver);
        }

        public StreamObserver<Messages.StreamingOutputCallRequest> halfDuplexCall(StreamObserver<Messages.StreamingOutputCallResponse> responseObserver) {
            return ClientCalls.asyncBidiStreamingCall((ClientCall)this.getChannel().newCall(TestServiceGrpc.getHalfDuplexCallMethodHelper(), this.getCallOptions()), responseObserver);
        }

        public void unimplementedCall(EmptyProtos.Empty request, StreamObserver<EmptyProtos.Empty> responseObserver) {
            ClientCalls.asyncUnaryCall((ClientCall)this.getChannel().newCall(TestServiceGrpc.getUnimplementedCallMethodHelper(), this.getCallOptions()), (Object)request, responseObserver);
        }
    }

    public static abstract class TestServiceImplBase
    implements BindableService {
        public void emptyCall(EmptyProtos.Empty request, StreamObserver<EmptyProtos.Empty> responseObserver) {
            ServerCalls.asyncUnimplementedUnaryCall((MethodDescriptor)TestServiceGrpc.getEmptyCallMethodHelper(), responseObserver);
        }

        public void unaryCall(Messages.SimpleRequest request, StreamObserver<Messages.SimpleResponse> responseObserver) {
            ServerCalls.asyncUnimplementedUnaryCall((MethodDescriptor)TestServiceGrpc.getUnaryCallMethodHelper(), responseObserver);
        }

        public void cacheableUnaryCall(Messages.SimpleRequest request, StreamObserver<Messages.SimpleResponse> responseObserver) {
            ServerCalls.asyncUnimplementedUnaryCall((MethodDescriptor)TestServiceGrpc.getCacheableUnaryCallMethodHelper(), responseObserver);
        }

        public void streamingOutputCall(Messages.StreamingOutputCallRequest request, StreamObserver<Messages.StreamingOutputCallResponse> responseObserver) {
            ServerCalls.asyncUnimplementedUnaryCall((MethodDescriptor)TestServiceGrpc.getStreamingOutputCallMethodHelper(), responseObserver);
        }

        public StreamObserver<Messages.StreamingInputCallRequest> streamingInputCall(StreamObserver<Messages.StreamingInputCallResponse> responseObserver) {
            return ServerCalls.asyncUnimplementedStreamingCall((MethodDescriptor)TestServiceGrpc.getStreamingInputCallMethodHelper(), responseObserver);
        }

        public StreamObserver<Messages.StreamingOutputCallRequest> fullDuplexCall(StreamObserver<Messages.StreamingOutputCallResponse> responseObserver) {
            return ServerCalls.asyncUnimplementedStreamingCall((MethodDescriptor)TestServiceGrpc.getFullDuplexCallMethodHelper(), responseObserver);
        }

        public StreamObserver<Messages.StreamingOutputCallRequest> halfDuplexCall(StreamObserver<Messages.StreamingOutputCallResponse> responseObserver) {
            return ServerCalls.asyncUnimplementedStreamingCall((MethodDescriptor)TestServiceGrpc.getHalfDuplexCallMethodHelper(), responseObserver);
        }

        public void unimplementedCall(EmptyProtos.Empty request, StreamObserver<EmptyProtos.Empty> responseObserver) {
            ServerCalls.asyncUnimplementedUnaryCall((MethodDescriptor)TestServiceGrpc.getUnimplementedCallMethodHelper(), responseObserver);
        }

        public final ServerServiceDefinition bindService() {
            return ServerServiceDefinition.builder((ServiceDescriptor)TestServiceGrpc.getServiceDescriptor()).addMethod(TestServiceGrpc.getEmptyCallMethodHelper(), ServerCalls.asyncUnaryCall(new MethodHandlers(this, 0))).addMethod(TestServiceGrpc.getUnaryCallMethodHelper(), ServerCalls.asyncUnaryCall(new MethodHandlers(this, 1))).addMethod(TestServiceGrpc.getCacheableUnaryCallMethodHelper(), ServerCalls.asyncUnaryCall(new MethodHandlers(this, 2))).addMethod(TestServiceGrpc.getStreamingOutputCallMethodHelper(), ServerCalls.asyncServerStreamingCall(new MethodHandlers(this, 3))).addMethod(TestServiceGrpc.getStreamingInputCallMethodHelper(), ServerCalls.asyncClientStreamingCall(new MethodHandlers(this, 5))).addMethod(TestServiceGrpc.getFullDuplexCallMethodHelper(), ServerCalls.asyncBidiStreamingCall(new MethodHandlers(this, 6))).addMethod(TestServiceGrpc.getHalfDuplexCallMethodHelper(), ServerCalls.asyncBidiStreamingCall(new MethodHandlers(this, 7))).addMethod(TestServiceGrpc.getUnimplementedCallMethodHelper(), ServerCalls.asyncUnaryCall(new MethodHandlers(this, 4))).build();
        }
    }
}

