/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.node.container.spring.env;

import io.gravitee.node.container.spring.env.GraviteeEnvironmentPropertySource;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.StandardEnvironment;

public class EnvironmentPropertySourceBeanProcessor
implements BeanFactoryPostProcessor,
Ordered {
    private static final String[] PROPERTY_PREFIXES = new String[]{"gravitee.", "gravitee_", "GRAVITEE.", "GRAVITEE_"};
    private final Environment environment;
    private final ApplicationContext applicationContext;

    EnvironmentPropertySourceBeanProcessor(Environment environment, ApplicationContext applicationContext) {
        this.environment = environment;
        this.applicationContext = applicationContext;
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) {
        ConcurrentHashMap<String, Object> source = new ConcurrentHashMap<String, Object>();
        ((StandardEnvironment)this.environment).getSystemEnvironment().forEach((key, value) -> {
            for (String propertyPrefix : PROPERTY_PREFIXES) {
                if (!key.startsWith(propertyPrefix)) continue;
                source.put(key.substring(propertyPrefix.length()), value);
            }
        });
        ((ConfigurableEnvironment)this.environment).getPropertySources().addFirst((PropertySource)new GraviteeEnvironmentPropertySource("graviteeEnvironmentPropertySource", source, this.applicationContext));
    }
}

