/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.node.container.spring;

import io.gravitee.kubernetes.client.spring.KubernetesClientConfiguration;
import io.gravitee.node.api.Node;
import io.gravitee.node.cache.spring.NodeCacheConfiguration;
import io.gravitee.node.cluster.spring.NodeClusterConfiguration;
import io.gravitee.node.container.AbstractContainer;
import io.gravitee.node.container.spring.NodeContainerConfiguration;
import io.gravitee.node.container.spring.env.EnvironmentConfiguration;
import io.gravitee.node.container.spring.env.PropertiesConfiguration;
import io.gravitee.node.management.http.spring.ManagementConfiguration;
import io.gravitee.node.monitoring.spring.NodeMonitoringConfiguration;
import io.gravitee.node.plugins.service.spring.ServiceConfiguration;
import io.gravitee.node.reporter.spring.ReporterConfiguration;
import io.gravitee.node.secrets.plugins.spring.SecretProviderBeanFactory;
import io.gravitee.node.secrets.service.spring.SecretServiceBeanFactory;
import io.gravitee.plugin.core.spring.PluginConfiguration;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;

public abstract class SpringBasedContainer
extends AbstractContainer {
    private static final Logger log = LoggerFactory.getLogger(SpringBasedContainer.class);
    private AnnotationConfigApplicationContext ctx;

    protected SpringBasedContainer() {
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.initializeContext();
    }

    protected void initializeContext() {
        this.ctx = new AnnotationConfigApplicationContext();
        List<Class<?>> classes = this.annotatedClasses();
        classes.forEach(xva$0 -> this.ctx.register(new Class[]{xva$0}));
        this.ctx.refresh();
    }

    protected List<Class<?>> annotatedClasses() {
        ArrayList classes = new ArrayList();
        classes.add(EnvironmentConfiguration.class);
        classes.add(PropertiesConfiguration.class);
        classes.add(PluginConfiguration.class);
        classes.add(ServiceConfiguration.class);
        classes.add(ManagementConfiguration.class);
        classes.add(ReporterConfiguration.class);
        classes.add(NodeContainerConfiguration.class);
        classes.add(SecretProviderBeanFactory.class);
        classes.add(SecretServiceBeanFactory.class);
        classes.add(NodeClusterConfiguration.class);
        classes.add(NodeCacheConfiguration.class);
        classes.add(NodeMonitoringConfiguration.class);
        classes.add(KubernetesClientConfiguration.class);
        return classes;
    }

    @Override
    protected void doStop() throws Exception {
        if (!this.stopped) {
            if (log.isInfoEnabled()) {
                log.info("Shutting-down {}...", (Object)this.name());
            }
            try {
                this.node().stop();
            }
            catch (Exception ex) {
                LoggerFactory.getLogger(this.getClass()).error("Unexpected error", (Throwable)ex);
            }
            finally {
                this.ctx.close();
                this.stopped = true;
            }
        }
    }

    @Override
    public Node node() {
        return (Node)this.ctx.getBean(Node.class);
    }

    public ApplicationContext applicationContext() {
        return this.ctx;
    }
}

