/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.services.subscriptions;

import io.gravitee.common.service.AbstractService;
import io.gravitee.rest.api.model.SubscriptionStatus;
import io.gravitee.rest.api.model.subscription.SubscriptionQuery;
import io.gravitee.rest.api.service.ApiService;
import io.gravitee.rest.api.service.SubscriptionService;
import java.time.Instant;
import java.util.Collections;
import java.util.Date;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.support.CronTrigger;

public class ScheduledSubscriptionsService
extends AbstractService
implements Runnable {
    private final Logger logger = LoggerFactory.getLogger(ScheduledSubscriptionsService.class);
    @Autowired
    private TaskScheduler scheduler;
    @Value(value="${services.subscriptions.cron:0 1 * * * *}")
    private String cronTrigger;
    @Value(value="${services.subscriptions.enabled:true}")
    private boolean enabled;
    private final AtomicLong counter = new AtomicLong(0L);
    @Autowired
    private ApiService apiService;
    @Autowired
    private SubscriptionService subscriptionService;

    protected String name() {
        return "Subscriptions Refresher Service";
    }

    protected void doStart() throws Exception {
        if (this.enabled) {
            super.doStart();
            this.logger.info("Subscriptions Refresher service has been initialized with cron [{}]", (Object)this.cronTrigger);
            this.scheduler.schedule((Runnable)this, (Trigger)new CronTrigger(this.cronTrigger));
        } else {
            this.logger.warn("Subscriptions Refresher service has been disabled");
        }
    }

    @Override
    public void run() {
        this.logger.debug("Refresh subscriptions #{} started at {}", (Object)this.counter.incrementAndGet(), (Object)Instant.now().toString());
        SubscriptionQuery query = new SubscriptionQuery();
        query.setStatuses(Collections.singleton(SubscriptionStatus.ACCEPTED));
        query.setEndingAtBefore(new Date().getTime());
        this.subscriptionService.search(query).forEach(subscription -> this.subscriptionService.close(subscription.getId()));
        this.logger.debug("Refresh subscriptions #{} ended at {}", (Object)this.counter.get(), (Object)Instant.now().toString());
    }
}

