/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.security.cors;

import io.gravitee.apim.core.access_point.model.AccessPoint;
import io.gravitee.apim.core.access_point.model.AccessPointEvent;
import io.gravitee.apim.core.installation.query_service.InstallationAccessQueryService;
import io.gravitee.common.event.Event;
import io.gravitee.common.event.EventListener;
import io.gravitee.common.event.EventManager;
import io.gravitee.repository.management.model.Parameter;
import io.gravitee.rest.api.model.parameters.Key;
import io.gravitee.rest.api.model.parameters.ParameterReferenceType;
import io.gravitee.rest.api.service.ParameterService;
import io.gravitee.rest.api.service.common.GraviteeContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.core.env.Environment;
import org.springframework.web.cors.CorsConfiguration;

public class GraviteeCorsConfiguration
extends CorsConfiguration {
    public static final String UNDEFINED_REFERENCE_ID = "undefined";
    private final Environment environment;
    private final ParameterService parameterService;
    private final InstallationAccessQueryService installationAccessQueryService;
    private final String referenceId;
    private final ParameterReferenceType parameterReferenceType;

    public GraviteeCorsConfiguration(Environment environment, ParameterService parameterService, InstallationAccessQueryService installationAccessQueryService, EventManager eventManager, String referenceId, ParameterReferenceType parameterReferenceType) {
        this.environment = environment;
        this.parameterService = parameterService;
        this.installationAccessQueryService = installationAccessQueryService;
        this.referenceId = referenceId;
        this.parameterReferenceType = parameterReferenceType;
        if (!this.referenceId.equals(UNDEFINED_REFERENCE_ID)) {
            eventManager.subscribeForEvents((EventListener)new ParameterKeyEventListener(this), Key.class);
        }
        eventManager.subscribeForEvents((EventListener)new AccessPointEventListener(this), AccessPointEvent.class);
        this.setAllowCredentials(true);
        this.setAllowedOriginPatterns(this.buildAllowedOriginPatterns(this.getPropertiesAsList(this.allowOriginKey())));
        this.setAllowedHeaders(this.getPropertiesAsList(this.allowHeadersKey()));
        this.setAllowedMethods(this.getPropertiesAsList(this.allowMethodsKey()));
        this.setExposedHeaders(this.getPropertiesAsList(this.exposedHeadersKey()));
        this.setMaxAge(Long.valueOf(this.getProperty(this.maxAgeKey())));
    }

    protected Key allowOriginKey() {
        if (this.parameterReferenceType == ParameterReferenceType.ORGANIZATION) {
            return Key.CONSOLE_HTTP_CORS_ALLOW_ORIGIN;
        }
        if (this.parameterReferenceType == ParameterReferenceType.ENVIRONMENT) {
            return Key.PORTAL_HTTP_CORS_ALLOW_ORIGIN;
        }
        return null;
    }

    protected Key allowHeadersKey() {
        if (this.parameterReferenceType == ParameterReferenceType.ORGANIZATION) {
            return Key.CONSOLE_HTTP_CORS_ALLOW_HEADERS;
        }
        if (this.parameterReferenceType == ParameterReferenceType.ENVIRONMENT) {
            return Key.PORTAL_HTTP_CORS_ALLOW_HEADERS;
        }
        return null;
    }

    protected Key allowMethodsKey() {
        if (this.parameterReferenceType == ParameterReferenceType.ORGANIZATION) {
            return Key.CONSOLE_HTTP_CORS_ALLOW_METHODS;
        }
        if (this.parameterReferenceType == ParameterReferenceType.ENVIRONMENT) {
            return Key.PORTAL_HTTP_CORS_ALLOW_METHODS;
        }
        return null;
    }

    protected Key exposedHeadersKey() {
        if (this.parameterReferenceType == ParameterReferenceType.ORGANIZATION) {
            return Key.CONSOLE_HTTP_CORS_EXPOSED_HEADERS;
        }
        if (this.parameterReferenceType == ParameterReferenceType.ENVIRONMENT) {
            return Key.PORTAL_HTTP_CORS_EXPOSED_HEADERS;
        }
        return null;
    }

    protected Key maxAgeKey() {
        if (this.parameterReferenceType == ParameterReferenceType.ORGANIZATION) {
            return Key.CONSOLE_HTTP_CORS_MAX_AGE;
        }
        if (this.parameterReferenceType == ParameterReferenceType.ENVIRONMENT) {
            return Key.PORTAL_HTTP_CORS_MAX_AGE;
        }
        return null;
    }

    protected String getProperty(Key propertyKey) {
        if (propertyKey != null) {
            if (this.referenceId.equals(UNDEFINED_REFERENCE_ID)) {
                return (String)this.environment.getProperty(propertyKey.key(), String.class, (Object)propertyKey.defaultValue());
            }
            String value = this.parameterService.find(GraviteeContext.getExecutionContext(), propertyKey, this.referenceId, this.parameterReferenceType);
            if (value == null) {
                value = propertyKey.defaultValue();
            }
            return value;
        }
        return null;
    }

    protected List<String> getPropertiesAsList(Key propertyKey) {
        String property = this.getProperty(propertyKey);
        return GraviteeCorsConfiguration.semicolonStringToList(property);
    }

    private static List<String> semicolonStringToList(String listStr) {
        return Arrays.asList(listStr.replaceAll("\\s+", "").split(";"));
    }

    private List<String> buildAllowedOriginPatterns(List<String> allowedOriginPatterns) {
        ArrayList<String> builtAllowedOrigins = new ArrayList<String>();
        if (allowedOriginPatterns != null) {
            builtAllowedOrigins.addAll(allowedOriginPatterns);
        }
        List<String> urls = null;
        if (this.parameterReferenceType == ParameterReferenceType.ORGANIZATION) {
            urls = this.getConsoleUrls();
        } else if (this.parameterReferenceType == ParameterReferenceType.ENVIRONMENT) {
            urls = this.getPortalUrls();
        }
        if (urls != null) {
            builtAllowedOrigins.addAll(urls);
        }
        return builtAllowedOrigins;
    }

    private List<String> getConsoleUrls() {
        if (this.referenceId.equals(UNDEFINED_REFERENCE_ID)) {
            return this.installationAccessQueryService.getConsoleUrls();
        }
        return this.installationAccessQueryService.getConsoleUrls(this.referenceId);
    }

    private List<String> getPortalUrls() {
        if (this.referenceId.equals(UNDEFINED_REFERENCE_ID)) {
            return this.installationAccessQueryService.getPortalUrls();
        }
        ArrayList<String> urls = new ArrayList<String>();
        List portalUrls = this.installationAccessQueryService.getPortalUrls(this.referenceId);
        if (portalUrls != null) {
            List consoleUrls;
            urls.addAll(portalUrls);
            if (GraviteeContext.getCurrentEnvironment().equals(this.referenceId) && GraviteeContext.getCurrentOrganization() != null && (consoleUrls = this.installationAccessQueryService.getConsoleUrls(GraviteeContext.getCurrentOrganization())) != null) {
                urls.addAll(consoleUrls);
            }
        }
        return urls;
    }

    private record ParameterKeyEventListener(GraviteeCorsConfiguration graviteeCorsConfiguration) implements EventListener<Key, Parameter>
    {
        public void onEvent(Event<Key, Parameter> event) {
            if (this.graviteeCorsConfiguration.referenceId.equals(((Parameter)event.content()).getReferenceId())) {
                if (event.type() == this.graviteeCorsConfiguration.allowOriginKey()) {
                    this.graviteeCorsConfiguration.setAllowedOriginPatterns(this.graviteeCorsConfiguration.buildAllowedOriginPatterns(GraviteeCorsConfiguration.semicolonStringToList(((Parameter)event.content()).getValue())));
                } else if (event.type() == this.graviteeCorsConfiguration.allowHeadersKey()) {
                    this.graviteeCorsConfiguration.setAllowedHeaders(GraviteeCorsConfiguration.semicolonStringToList(((Parameter)event.content()).getValue()));
                } else if (event.type() == this.graviteeCorsConfiguration.allowMethodsKey()) {
                    this.graviteeCorsConfiguration.setAllowedMethods(GraviteeCorsConfiguration.semicolonStringToList(((Parameter)event.content()).getValue()));
                } else if (event.type() == this.graviteeCorsConfiguration.exposedHeadersKey()) {
                    this.graviteeCorsConfiguration.setExposedHeaders(GraviteeCorsConfiguration.semicolonStringToList(((Parameter)event.content()).getValue()));
                } else if (event.type() == this.graviteeCorsConfiguration.maxAgeKey()) {
                    this.graviteeCorsConfiguration.setMaxAge(Long.parseLong(((Parameter)event.content()).getValue()));
                }
            }
        }
    }

    private record AccessPointEventListener(GraviteeCorsConfiguration graviteeCorsConfiguration) implements EventListener<AccessPointEvent, AccessPoint>
    {
        public void onEvent(Event<AccessPointEvent, AccessPoint> event) {
            if (this.isReferenced(event) && (this.isConsoleTarget(event) || this.isPortalTarget(event))) {
                ArrayList<String> newAllowedOriginPatterns = new ArrayList<String>();
                List allowedOriginPatterns = this.graviteeCorsConfiguration.getAllowedOriginPatterns();
                if (allowedOriginPatterns != null) {
                    newAllowedOriginPatterns.addAll(allowedOriginPatterns);
                }
                if (event.type() == AccessPointEvent.CREATED) {
                    newAllowedOriginPatterns.add(((AccessPoint)event.content()).buildInstallationAccess());
                } else if (event.type() == AccessPointEvent.DELETED) {
                    newAllowedOriginPatterns.remove(((AccessPoint)event.content()).buildInstallationAccess());
                }
                this.graviteeCorsConfiguration.setAllowedOriginPatterns(newAllowedOriginPatterns);
            }
        }

        private boolean isReferenced(Event<AccessPointEvent, AccessPoint> event) {
            return (this.graviteeCorsConfiguration.referenceId.equals(GraviteeCorsConfiguration.UNDEFINED_REFERENCE_ID) || this.graviteeCorsConfiguration.referenceId.equals(((AccessPoint)event.content()).getReferenceId())) && this.graviteeCorsConfiguration.parameterReferenceType.name().equals(((AccessPoint)event.content()).getReferenceType().name());
        }

        private boolean isPortalTarget(Event<AccessPointEvent, AccessPoint> event) {
            return this.graviteeCorsConfiguration.parameterReferenceType == ParameterReferenceType.ENVIRONMENT && ((AccessPoint)event.content()).getTarget() == AccessPoint.Target.PORTAL;
        }

        private boolean isConsoleTarget(Event<AccessPointEvent, AccessPoint> event) {
            return this.graviteeCorsConfiguration.parameterReferenceType == ParameterReferenceType.ORGANIZATION && ((AccessPoint)event.content()).getTarget() == AccessPoint.Target.CONSOLE;
        }
    }
}

