/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.security.cookies;

import javax.servlet.http.Cookie;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;

public class CookieGenerator {
    private static final boolean DEFAULT_JWT_COOKIE_SECURE = false;
    private static final String DEFAULT_JWT_COOKIE_PATH = "/";
    private static final String DEFAULT_JWT_COOKIE_DOMAIN = "";
    @Autowired
    private Environment environment;

    public Cookie generate(String name, String value, boolean httpOnly) {
        Cookie cookie = new Cookie(name, value);
        cookie.setHttpOnly(httpOnly);
        cookie.setSecure(((Boolean)this.environment.getProperty("jwt.cookie-secure", Boolean.class, (Object)false)).booleanValue());
        cookie.setPath(this.environment.getProperty("jwt.cookie-path", DEFAULT_JWT_COOKIE_PATH));
        cookie.setDomain(this.environment.getProperty("jwt.cookie-domain", DEFAULT_JWT_COOKIE_DOMAIN));
        cookie.setMaxAge(value == null ? 0 : (Integer)this.environment.getProperty("jwt.expire-after", Integer.class, (Object)604800));
        return cookie;
    }

    public Cookie generate(String name, String value) {
        return this.generate(name, value, true);
    }

    public Cookie generate(String value) {
        return this.generate("Auth-Graviteeio-APIM", value);
    }
}

