/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.security.filter;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.gravitee.rest.api.service.ReCaptchaService;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.MediaType;
import org.springframework.web.filter.GenericFilterBean;

public class RecaptchaFilter
extends GenericFilterBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(RecaptchaFilter.class);
    public static final String DEFAULT_RECAPTCHA_HEADER_NAME = "X-Recaptcha-Token";
    public static final Pattern MNG_CHANGE_PASSWORD = Pattern.compile("/users/([^/]+)/changePassword");
    private static final Set<String> RESTRICTED_PATHS = new HashSet<String>(Arrays.asList("/user/login", "/users/registration", "/users/registration/finalize", "/auth/login", "/users/_reset_password", "/users/_change_password"));
    private ReCaptchaService reCaptchaService;
    private ObjectMapper objectMapper;

    public RecaptchaFilter(ReCaptchaService reCaptchaService, ObjectMapper objectMapper) {
        this.reCaptchaService = reCaptchaService;
        this.objectMapper = objectMapper;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        if (RESTRICTED_PATHS.stream().anyMatch(path -> httpRequest.getPathInfo().contains((CharSequence)path) || MNG_CHANGE_PASSWORD.matcher(httpRequest.getPathInfo()).matches())) {
            LOGGER.debug("Checking captcha");
            String reCaptchaToken = httpRequest.getHeader(DEFAULT_RECAPTCHA_HEADER_NAME);
            if (!this.reCaptchaService.isValid(reCaptchaToken)) {
                HashMap<String, Object> error = new HashMap<String, Object>();
                error.put("message", "Something goes wrong. Please try again.");
                error.put("http_status", 400);
                httpResponse.setStatus(400);
                httpResponse.setContentType(MediaType.APPLICATION_JSON.toString());
                httpResponse.getWriter().write(this.objectMapper.writeValueAsString(error));
                httpResponse.getWriter().close();
            } else {
                chain.doFilter(request, response);
            }
        } else {
            chain.doFilter(request, response);
        }
    }
}

