/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.model.context;

import javax.annotation.Nullable;

public sealed interface OriginContext {
    public Origin origin();

    default public String name() {
        return this.origin().name().toLowerCase();
    }

    public static enum Origin {
        MANAGEMENT,
        KUBERNETES,
        INTEGRATION;

    }

    public record Integration(Origin origin, String integrationId, @Nullable String integrationName, @Nullable String provider) implements OriginContext
    {
        public Integration(String integrationId, String integrationName, String provider) {
            this(Origin.INTEGRATION, integrationId, integrationName, provider);
        }

        public Integration(String integrationId) {
            this(Origin.INTEGRATION, integrationId, null, null);
        }
    }

    public record Management(Origin origin) implements OriginContext
    {
        public Management() {
            this(Origin.MANAGEMENT);
        }
    }

    public record Kubernetes(Origin origin, Mode mode, String syncFrom) implements OriginContext
    {
        public Kubernetes(Mode mode) {
            this(mode, Origin.KUBERNETES.name());
        }

        public Kubernetes(Mode mode, String syncFrom) {
            this(Origin.KUBERNETES, mode, syncFrom);
        }

        public static enum Mode {
            FULLY_MANAGED;

        }
    }
}

