/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.gravitee.definition.model.DefinitionVersion;
import io.gravitee.definition.model.Rule;
import io.gravitee.definition.model.v4.plan.PlanMode;
import io.gravitee.definition.model.v4.plan.PlanSecurity;
import io.gravitee.rest.api.model.DeploymentRequired;
import io.gravitee.rest.api.model.PlanSecurityType;
import io.gravitee.rest.api.model.PlanStatus;
import io.gravitee.rest.api.model.PlanValidationType;
import io.gravitee.rest.api.model.v4.plan.GenericPlanEntity;
import io.gravitee.rest.api.model.v4.plan.PlanType;
import jakarta.validation.constraints.NotNull;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import lombok.Generated;

public class BasePlanEntity
implements GenericPlanEntity {
    private String id;
    private DefinitionVersion definitionVersion;
    private String crossId;
    @NotNull
    private String name;
    @NotNull
    private String description;
    @NotNull
    private PlanValidationType validation;
    @DeploymentRequired
    @NotNull
    private PlanSecurityType security;
    @DeploymentRequired
    private String securityDefinition;
    @NotNull
    private io.gravitee.rest.api.model.PlanType type;
    @DeploymentRequired
    @NotNull
    private PlanStatus status;
    @DeploymentRequired
    private String api;
    private String environmentId;
    private int order;
    @JsonProperty(value="created_at")
    private Date createdAt;
    @JsonProperty(value="updated_at")
    private Date updatedAt;
    @JsonProperty(value="published_at")
    private Date publishedAt;
    @JsonProperty(value="closed_at")
    private Date closedAt;
    @DeploymentRequired
    @JsonProperty(value="paths", required=true)
    private Map<String, List<Rule>> paths = new HashMap<String, List<Rule>>();
    private List<String> characteristics;
    @JsonProperty(value="excluded_groups")
    private List<String> excludedGroups;
    @JsonIgnore
    private Date needRedeployAt;
    @JsonProperty(value="comment_required")
    private boolean commentRequired;
    @JsonProperty(value="comment_message")
    private String commentMessage;
    @JsonProperty(value="general_conditions")
    private String generalConditions;
    @DeploymentRequired
    private Set<String> tags;
    @DeploymentRequired
    @JsonProperty(value="selection_rule")
    private String selectionRule;

    @Override
    @JsonIgnore
    public String getApiId() {
        return this.api;
    }

    @Override
    @JsonIgnore
    public PlanSecurity getPlanSecurity() {
        PlanSecurity planSecurity = new PlanSecurity();
        if (this.security != null) {
            planSecurity.setType(PlanSecurityType.valueOf(this.security.name()).name());
        }
        planSecurity.setConfiguration(this.securityDefinition);
        return planSecurity;
    }

    @Override
    @JsonIgnore
    public io.gravitee.definition.model.v4.plan.PlanStatus getPlanStatus() {
        if (this.status != null) {
            return io.gravitee.definition.model.v4.plan.PlanStatus.valueOfLabel((String)this.status.name());
        }
        return null;
    }

    @Override
    public PlanMode getPlanMode() {
        return PlanMode.STANDARD;
    }

    @Override
    @JsonIgnore
    public io.gravitee.rest.api.model.v4.plan.PlanValidationType getPlanValidation() {
        if (this.validation != null) {
            return io.gravitee.rest.api.model.v4.plan.PlanValidationType.valueOfLabel(this.validation.name());
        }
        return null;
    }

    @Override
    @JsonIgnore
    public PlanType getPlanType() {
        return PlanType.API;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BasePlanEntity that = (BasePlanEntity)o;
        return Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hashCode(this.id);
    }

    @Generated
    private static DefinitionVersion $default$definitionVersion() {
        return DefinitionVersion.V2;
    }

    @Generated
    protected BasePlanEntity(BasePlanEntityBuilder<?, ?> b) {
        this.id = b.id;
        this.definitionVersion = b.definitionVersion$set ? b.definitionVersion$value : BasePlanEntity.$default$definitionVersion();
        this.crossId = b.crossId;
        this.name = b.name;
        this.description = b.description;
        this.validation = b.validation;
        this.security = b.security;
        this.securityDefinition = b.securityDefinition;
        this.type = b.type;
        this.status = b.status;
        this.api = b.api;
        this.environmentId = b.environmentId;
        this.order = b.order;
        this.createdAt = b.createdAt;
        this.updatedAt = b.updatedAt;
        this.publishedAt = b.publishedAt;
        this.closedAt = b.closedAt;
        this.paths = b.paths;
        this.characteristics = b.characteristics;
        this.excludedGroups = b.excludedGroups;
        this.needRedeployAt = b.needRedeployAt;
        this.commentRequired = b.commentRequired;
        this.commentMessage = b.commentMessage;
        this.generalConditions = b.generalConditions;
        this.tags = b.tags;
        this.selectionRule = b.selectionRule;
    }

    @Generated
    public static BasePlanEntityBuilder<?, ?> builder() {
        return new BasePlanEntityBuilderImpl();
    }

    @Generated
    public BasePlanEntityBuilder<?, ?> toBuilder() {
        return new BasePlanEntityBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public BasePlanEntity() {
        this.definitionVersion = BasePlanEntity.$default$definitionVersion();
    }

    @Generated
    public BasePlanEntity(String id, DefinitionVersion definitionVersion, String crossId, String name, String description, PlanValidationType validation, PlanSecurityType security, String securityDefinition, io.gravitee.rest.api.model.PlanType type, PlanStatus status, String api, String environmentId, int order, Date createdAt, Date updatedAt, Date publishedAt, Date closedAt, Map<String, List<Rule>> paths, List<String> characteristics, List<String> excludedGroups, Date needRedeployAt, boolean commentRequired, String commentMessage, String generalConditions, Set<String> tags, String selectionRule) {
        this.id = id;
        this.definitionVersion = definitionVersion;
        this.crossId = crossId;
        this.name = name;
        this.description = description;
        this.validation = validation;
        this.security = security;
        this.securityDefinition = securityDefinition;
        this.type = type;
        this.status = status;
        this.api = api;
        this.environmentId = environmentId;
        this.order = order;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.publishedAt = publishedAt;
        this.closedAt = closedAt;
        this.paths = paths;
        this.characteristics = characteristics;
        this.excludedGroups = excludedGroups;
        this.needRedeployAt = needRedeployAt;
        this.commentRequired = commentRequired;
        this.commentMessage = commentMessage;
        this.generalConditions = generalConditions;
        this.tags = tags;
        this.selectionRule = selectionRule;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    @Override
    @Generated
    public DefinitionVersion getDefinitionVersion() {
        return this.definitionVersion;
    }

    @Generated
    public String getCrossId() {
        return this.crossId;
    }

    @Override
    @Generated
    public String getName() {
        return this.name;
    }

    @Override
    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public PlanValidationType getValidation() {
        return this.validation;
    }

    @Generated
    public PlanSecurityType getSecurity() {
        return this.security;
    }

    @Generated
    public String getSecurityDefinition() {
        return this.securityDefinition;
    }

    @Generated
    public io.gravitee.rest.api.model.PlanType getType() {
        return this.type;
    }

    @Generated
    public PlanStatus getStatus() {
        return this.status;
    }

    @Generated
    public String getApi() {
        return this.api;
    }

    @Override
    @Generated
    public String getEnvironmentId() {
        return this.environmentId;
    }

    @Override
    @Generated
    public int getOrder() {
        return this.order;
    }

    @Generated
    public Date getCreatedAt() {
        return this.createdAt;
    }

    @Generated
    public Date getUpdatedAt() {
        return this.updatedAt;
    }

    @Generated
    public Date getPublishedAt() {
        return this.publishedAt;
    }

    @Generated
    public Date getClosedAt() {
        return this.closedAt;
    }

    @Generated
    public Map<String, List<Rule>> getPaths() {
        return this.paths;
    }

    @Override
    @Generated
    public List<String> getCharacteristics() {
        return this.characteristics;
    }

    @Override
    @Generated
    public List<String> getExcludedGroups() {
        return this.excludedGroups;
    }

    @Override
    @Generated
    public Date getNeedRedeployAt() {
        return this.needRedeployAt;
    }

    @Override
    @Generated
    public boolean isCommentRequired() {
        return this.commentRequired;
    }

    @Override
    @Generated
    public String getCommentMessage() {
        return this.commentMessage;
    }

    @Override
    @Generated
    public String getGeneralConditions() {
        return this.generalConditions;
    }

    @Generated
    public Set<String> getTags() {
        return this.tags;
    }

    @Generated
    public String getSelectionRule() {
        return this.selectionRule;
    }

    @Override
    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setDefinitionVersion(DefinitionVersion definitionVersion) {
        this.definitionVersion = definitionVersion;
    }

    @Generated
    public void setCrossId(String crossId) {
        this.crossId = crossId;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setValidation(PlanValidationType validation) {
        this.validation = validation;
    }

    @Generated
    public void setSecurity(PlanSecurityType security) {
        this.security = security;
    }

    @Generated
    public void setSecurityDefinition(String securityDefinition) {
        this.securityDefinition = securityDefinition;
    }

    @Generated
    public void setType(io.gravitee.rest.api.model.PlanType type) {
        this.type = type;
    }

    @Generated
    public void setStatus(PlanStatus status) {
        this.status = status;
    }

    @Generated
    public void setApi(String api) {
        this.api = api;
    }

    @Generated
    public void setEnvironmentId(String environmentId) {
        this.environmentId = environmentId;
    }

    @Generated
    public void setOrder(int order) {
        this.order = order;
    }

    @JsonProperty(value="created_at")
    @Generated
    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    @JsonProperty(value="updated_at")
    @Generated
    public void setUpdatedAt(Date updatedAt) {
        this.updatedAt = updatedAt;
    }

    @JsonProperty(value="published_at")
    @Generated
    public void setPublishedAt(Date publishedAt) {
        this.publishedAt = publishedAt;
    }

    @JsonProperty(value="closed_at")
    @Generated
    public void setClosedAt(Date closedAt) {
        this.closedAt = closedAt;
    }

    @JsonProperty(value="paths", required=true)
    @Generated
    public void setPaths(Map<String, List<Rule>> paths) {
        this.paths = paths;
    }

    @Generated
    public void setCharacteristics(List<String> characteristics) {
        this.characteristics = characteristics;
    }

    @JsonProperty(value="excluded_groups")
    @Generated
    public void setExcludedGroups(List<String> excludedGroups) {
        this.excludedGroups = excludedGroups;
    }

    @JsonIgnore
    @Generated
    public void setNeedRedeployAt(Date needRedeployAt) {
        this.needRedeployAt = needRedeployAt;
    }

    @JsonProperty(value="comment_required")
    @Generated
    public void setCommentRequired(boolean commentRequired) {
        this.commentRequired = commentRequired;
    }

    @JsonProperty(value="comment_message")
    @Generated
    public void setCommentMessage(String commentMessage) {
        this.commentMessage = commentMessage;
    }

    @JsonProperty(value="general_conditions")
    @Generated
    public void setGeneralConditions(String generalConditions) {
        this.generalConditions = generalConditions;
    }

    @Generated
    public void setTags(Set<String> tags) {
        this.tags = tags;
    }

    @JsonProperty(value="selection_rule")
    @Generated
    public void setSelectionRule(String selectionRule) {
        this.selectionRule = selectionRule;
    }

    @Generated
    public BasePlanEntity withId(String id) {
        return this.id == id ? this : new BasePlanEntity(id, this.definitionVersion, this.crossId, this.name, this.description, this.validation, this.security, this.securityDefinition, this.type, this.status, this.api, this.environmentId, this.order, this.createdAt, this.updatedAt, this.publishedAt, this.closedAt, this.paths, this.characteristics, this.excludedGroups, this.needRedeployAt, this.commentRequired, this.commentMessage, this.generalConditions, this.tags, this.selectionRule);
    }

    @Generated
    public BasePlanEntity withDefinitionVersion(DefinitionVersion definitionVersion) {
        return this.definitionVersion == definitionVersion ? this : new BasePlanEntity(this.id, definitionVersion, this.crossId, this.name, this.description, this.validation, this.security, this.securityDefinition, this.type, this.status, this.api, this.environmentId, this.order, this.createdAt, this.updatedAt, this.publishedAt, this.closedAt, this.paths, this.characteristics, this.excludedGroups, this.needRedeployAt, this.commentRequired, this.commentMessage, this.generalConditions, this.tags, this.selectionRule);
    }

    @Generated
    public BasePlanEntity withCrossId(String crossId) {
        return this.crossId == crossId ? this : new BasePlanEntity(this.id, this.definitionVersion, crossId, this.name, this.description, this.validation, this.security, this.securityDefinition, this.type, this.status, this.api, this.environmentId, this.order, this.createdAt, this.updatedAt, this.publishedAt, this.closedAt, this.paths, this.characteristics, this.excludedGroups, this.needRedeployAt, this.commentRequired, this.commentMessage, this.generalConditions, this.tags, this.selectionRule);
    }

    @Generated
    public BasePlanEntity withName(String name) {
        return this.name == name ? this : new BasePlanEntity(this.id, this.definitionVersion, this.crossId, name, this.description, this.validation, this.security, this.securityDefinition, this.type, this.status, this.api, this.environmentId, this.order, this.createdAt, this.updatedAt, this.publishedAt, this.closedAt, this.paths, this.characteristics, this.excludedGroups, this.needRedeployAt, this.commentRequired, this.commentMessage, this.generalConditions, this.tags, this.selectionRule);
    }

    @Generated
    public BasePlanEntity withDescription(String description) {
        return this.description == description ? this : new BasePlanEntity(this.id, this.definitionVersion, this.crossId, this.name, description, this.validation, this.security, this.securityDefinition, this.type, this.status, this.api, this.environmentId, this.order, this.createdAt, this.updatedAt, this.publishedAt, this.closedAt, this.paths, this.characteristics, this.excludedGroups, this.needRedeployAt, this.commentRequired, this.commentMessage, this.generalConditions, this.tags, this.selectionRule);
    }

    @Generated
    public BasePlanEntity withValidation(PlanValidationType validation) {
        return this.validation == validation ? this : new BasePlanEntity(this.id, this.definitionVersion, this.crossId, this.name, this.description, validation, this.security, this.securityDefinition, this.type, this.status, this.api, this.environmentId, this.order, this.createdAt, this.updatedAt, this.publishedAt, this.closedAt, this.paths, this.characteristics, this.excludedGroups, this.needRedeployAt, this.commentRequired, this.commentMessage, this.generalConditions, this.tags, this.selectionRule);
    }

    @Generated
    public BasePlanEntity withSecurity(PlanSecurityType security) {
        return this.security == security ? this : new BasePlanEntity(this.id, this.definitionVersion, this.crossId, this.name, this.description, this.validation, security, this.securityDefinition, this.type, this.status, this.api, this.environmentId, this.order, this.createdAt, this.updatedAt, this.publishedAt, this.closedAt, this.paths, this.characteristics, this.excludedGroups, this.needRedeployAt, this.commentRequired, this.commentMessage, this.generalConditions, this.tags, this.selectionRule);
    }

    @Generated
    public BasePlanEntity withSecurityDefinition(String securityDefinition) {
        return this.securityDefinition == securityDefinition ? this : new BasePlanEntity(this.id, this.definitionVersion, this.crossId, this.name, this.description, this.validation, this.security, securityDefinition, this.type, this.status, this.api, this.environmentId, this.order, this.createdAt, this.updatedAt, this.publishedAt, this.closedAt, this.paths, this.characteristics, this.excludedGroups, this.needRedeployAt, this.commentRequired, this.commentMessage, this.generalConditions, this.tags, this.selectionRule);
    }

    @Generated
    public BasePlanEntity withType(io.gravitee.rest.api.model.PlanType type) {
        return this.type == type ? this : new BasePlanEntity(this.id, this.definitionVersion, this.crossId, this.name, this.description, this.validation, this.security, this.securityDefinition, type, this.status, this.api, this.environmentId, this.order, this.createdAt, this.updatedAt, this.publishedAt, this.closedAt, this.paths, this.characteristics, this.excludedGroups, this.needRedeployAt, this.commentRequired, this.commentMessage, this.generalConditions, this.tags, this.selectionRule);
    }

    @Generated
    public BasePlanEntity withStatus(PlanStatus status) {
        return this.status == status ? this : new BasePlanEntity(this.id, this.definitionVersion, this.crossId, this.name, this.description, this.validation, this.security, this.securityDefinition, this.type, status, this.api, this.environmentId, this.order, this.createdAt, this.updatedAt, this.publishedAt, this.closedAt, this.paths, this.characteristics, this.excludedGroups, this.needRedeployAt, this.commentRequired, this.commentMessage, this.generalConditions, this.tags, this.selectionRule);
    }

    @Generated
    public BasePlanEntity withApi(String api) {
        return this.api == api ? this : new BasePlanEntity(this.id, this.definitionVersion, this.crossId, this.name, this.description, this.validation, this.security, this.securityDefinition, this.type, this.status, api, this.environmentId, this.order, this.createdAt, this.updatedAt, this.publishedAt, this.closedAt, this.paths, this.characteristics, this.excludedGroups, this.needRedeployAt, this.commentRequired, this.commentMessage, this.generalConditions, this.tags, this.selectionRule);
    }

    @Generated
    public BasePlanEntity withEnvironmentId(String environmentId) {
        return this.environmentId == environmentId ? this : new BasePlanEntity(this.id, this.definitionVersion, this.crossId, this.name, this.description, this.validation, this.security, this.securityDefinition, this.type, this.status, this.api, environmentId, this.order, this.createdAt, this.updatedAt, this.publishedAt, this.closedAt, this.paths, this.characteristics, this.excludedGroups, this.needRedeployAt, this.commentRequired, this.commentMessage, this.generalConditions, this.tags, this.selectionRule);
    }

    @Generated
    public BasePlanEntity withOrder(int order) {
        return this.order == order ? this : new BasePlanEntity(this.id, this.definitionVersion, this.crossId, this.name, this.description, this.validation, this.security, this.securityDefinition, this.type, this.status, this.api, this.environmentId, order, this.createdAt, this.updatedAt, this.publishedAt, this.closedAt, this.paths, this.characteristics, this.excludedGroups, this.needRedeployAt, this.commentRequired, this.commentMessage, this.generalConditions, this.tags, this.selectionRule);
    }

    @Generated
    public BasePlanEntity withCreatedAt(Date createdAt) {
        return this.createdAt == createdAt ? this : new BasePlanEntity(this.id, this.definitionVersion, this.crossId, this.name, this.description, this.validation, this.security, this.securityDefinition, this.type, this.status, this.api, this.environmentId, this.order, createdAt, this.updatedAt, this.publishedAt, this.closedAt, this.paths, this.characteristics, this.excludedGroups, this.needRedeployAt, this.commentRequired, this.commentMessage, this.generalConditions, this.tags, this.selectionRule);
    }

    @Generated
    public BasePlanEntity withUpdatedAt(Date updatedAt) {
        return this.updatedAt == updatedAt ? this : new BasePlanEntity(this.id, this.definitionVersion, this.crossId, this.name, this.description, this.validation, this.security, this.securityDefinition, this.type, this.status, this.api, this.environmentId, this.order, this.createdAt, updatedAt, this.publishedAt, this.closedAt, this.paths, this.characteristics, this.excludedGroups, this.needRedeployAt, this.commentRequired, this.commentMessage, this.generalConditions, this.tags, this.selectionRule);
    }

    @Generated
    public BasePlanEntity withPublishedAt(Date publishedAt) {
        return this.publishedAt == publishedAt ? this : new BasePlanEntity(this.id, this.definitionVersion, this.crossId, this.name, this.description, this.validation, this.security, this.securityDefinition, this.type, this.status, this.api, this.environmentId, this.order, this.createdAt, this.updatedAt, publishedAt, this.closedAt, this.paths, this.characteristics, this.excludedGroups, this.needRedeployAt, this.commentRequired, this.commentMessage, this.generalConditions, this.tags, this.selectionRule);
    }

    @Generated
    public BasePlanEntity withClosedAt(Date closedAt) {
        return this.closedAt == closedAt ? this : new BasePlanEntity(this.id, this.definitionVersion, this.crossId, this.name, this.description, this.validation, this.security, this.securityDefinition, this.type, this.status, this.api, this.environmentId, this.order, this.createdAt, this.updatedAt, this.publishedAt, closedAt, this.paths, this.characteristics, this.excludedGroups, this.needRedeployAt, this.commentRequired, this.commentMessage, this.generalConditions, this.tags, this.selectionRule);
    }

    @Generated
    public BasePlanEntity withPaths(Map<String, List<Rule>> paths) {
        return this.paths == paths ? this : new BasePlanEntity(this.id, this.definitionVersion, this.crossId, this.name, this.description, this.validation, this.security, this.securityDefinition, this.type, this.status, this.api, this.environmentId, this.order, this.createdAt, this.updatedAt, this.publishedAt, this.closedAt, paths, this.characteristics, this.excludedGroups, this.needRedeployAt, this.commentRequired, this.commentMessage, this.generalConditions, this.tags, this.selectionRule);
    }

    @Generated
    public BasePlanEntity withCharacteristics(List<String> characteristics) {
        return this.characteristics == characteristics ? this : new BasePlanEntity(this.id, this.definitionVersion, this.crossId, this.name, this.description, this.validation, this.security, this.securityDefinition, this.type, this.status, this.api, this.environmentId, this.order, this.createdAt, this.updatedAt, this.publishedAt, this.closedAt, this.paths, characteristics, this.excludedGroups, this.needRedeployAt, this.commentRequired, this.commentMessage, this.generalConditions, this.tags, this.selectionRule);
    }

    @Generated
    public BasePlanEntity withExcludedGroups(List<String> excludedGroups) {
        return this.excludedGroups == excludedGroups ? this : new BasePlanEntity(this.id, this.definitionVersion, this.crossId, this.name, this.description, this.validation, this.security, this.securityDefinition, this.type, this.status, this.api, this.environmentId, this.order, this.createdAt, this.updatedAt, this.publishedAt, this.closedAt, this.paths, this.characteristics, excludedGroups, this.needRedeployAt, this.commentRequired, this.commentMessage, this.generalConditions, this.tags, this.selectionRule);
    }

    @Generated
    public BasePlanEntity withNeedRedeployAt(Date needRedeployAt) {
        return this.needRedeployAt == needRedeployAt ? this : new BasePlanEntity(this.id, this.definitionVersion, this.crossId, this.name, this.description, this.validation, this.security, this.securityDefinition, this.type, this.status, this.api, this.environmentId, this.order, this.createdAt, this.updatedAt, this.publishedAt, this.closedAt, this.paths, this.characteristics, this.excludedGroups, needRedeployAt, this.commentRequired, this.commentMessage, this.generalConditions, this.tags, this.selectionRule);
    }

    @Generated
    public BasePlanEntity withCommentRequired(boolean commentRequired) {
        return this.commentRequired == commentRequired ? this : new BasePlanEntity(this.id, this.definitionVersion, this.crossId, this.name, this.description, this.validation, this.security, this.securityDefinition, this.type, this.status, this.api, this.environmentId, this.order, this.createdAt, this.updatedAt, this.publishedAt, this.closedAt, this.paths, this.characteristics, this.excludedGroups, this.needRedeployAt, commentRequired, this.commentMessage, this.generalConditions, this.tags, this.selectionRule);
    }

    @Generated
    public BasePlanEntity withCommentMessage(String commentMessage) {
        return this.commentMessage == commentMessage ? this : new BasePlanEntity(this.id, this.definitionVersion, this.crossId, this.name, this.description, this.validation, this.security, this.securityDefinition, this.type, this.status, this.api, this.environmentId, this.order, this.createdAt, this.updatedAt, this.publishedAt, this.closedAt, this.paths, this.characteristics, this.excludedGroups, this.needRedeployAt, this.commentRequired, commentMessage, this.generalConditions, this.tags, this.selectionRule);
    }

    @Generated
    public BasePlanEntity withGeneralConditions(String generalConditions) {
        return this.generalConditions == generalConditions ? this : new BasePlanEntity(this.id, this.definitionVersion, this.crossId, this.name, this.description, this.validation, this.security, this.securityDefinition, this.type, this.status, this.api, this.environmentId, this.order, this.createdAt, this.updatedAt, this.publishedAt, this.closedAt, this.paths, this.characteristics, this.excludedGroups, this.needRedeployAt, this.commentRequired, this.commentMessage, generalConditions, this.tags, this.selectionRule);
    }

    @Generated
    public BasePlanEntity withTags(Set<String> tags) {
        return this.tags == tags ? this : new BasePlanEntity(this.id, this.definitionVersion, this.crossId, this.name, this.description, this.validation, this.security, this.securityDefinition, this.type, this.status, this.api, this.environmentId, this.order, this.createdAt, this.updatedAt, this.publishedAt, this.closedAt, this.paths, this.characteristics, this.excludedGroups, this.needRedeployAt, this.commentRequired, this.commentMessage, this.generalConditions, tags, this.selectionRule);
    }

    @Generated
    public BasePlanEntity withSelectionRule(String selectionRule) {
        return this.selectionRule == selectionRule ? this : new BasePlanEntity(this.id, this.definitionVersion, this.crossId, this.name, this.description, this.validation, this.security, this.securityDefinition, this.type, this.status, this.api, this.environmentId, this.order, this.createdAt, this.updatedAt, this.publishedAt, this.closedAt, this.paths, this.characteristics, this.excludedGroups, this.needRedeployAt, this.commentRequired, this.commentMessage, this.generalConditions, this.tags, selectionRule);
    }

    @Generated
    public String toString() {
        return "BasePlanEntity(id=" + this.getId() + ", definitionVersion=" + this.getDefinitionVersion() + ", crossId=" + this.getCrossId() + ", name=" + this.getName() + ", description=" + this.getDescription() + ", validation=" + this.getValidation() + ", security=" + this.getSecurity() + ", securityDefinition=" + this.getSecurityDefinition() + ", type=" + this.getType() + ", status=" + this.getStatus() + ", api=" + this.getApi() + ", environmentId=" + this.getEnvironmentId() + ", order=" + this.getOrder() + ", createdAt=" + this.getCreatedAt() + ", updatedAt=" + this.getUpdatedAt() + ", publishedAt=" + this.getPublishedAt() + ", closedAt=" + this.getClosedAt() + ", paths=" + this.getPaths() + ", characteristics=" + this.getCharacteristics() + ", excludedGroups=" + this.getExcludedGroups() + ", needRedeployAt=" + this.getNeedRedeployAt() + ", commentRequired=" + this.isCommentRequired() + ", commentMessage=" + this.getCommentMessage() + ", generalConditions=" + this.getGeneralConditions() + ", tags=" + this.getTags() + ", selectionRule=" + this.getSelectionRule() + ")";
    }

    @Generated
    public static abstract class BasePlanEntityBuilder<C extends BasePlanEntity, B extends BasePlanEntityBuilder<C, B>> {
        @Generated
        private String id;
        @Generated
        private boolean definitionVersion$set;
        @Generated
        private DefinitionVersion definitionVersion$value;
        @Generated
        private String crossId;
        @Generated
        private String name;
        @Generated
        private String description;
        @Generated
        private PlanValidationType validation;
        @Generated
        private PlanSecurityType security;
        @Generated
        private String securityDefinition;
        @Generated
        private io.gravitee.rest.api.model.PlanType type;
        @Generated
        private PlanStatus status;
        @Generated
        private String api;
        @Generated
        private String environmentId;
        @Generated
        private int order;
        @Generated
        private Date createdAt;
        @Generated
        private Date updatedAt;
        @Generated
        private Date publishedAt;
        @Generated
        private Date closedAt;
        @Generated
        private Map<String, List<Rule>> paths;
        @Generated
        private List<String> characteristics;
        @Generated
        private List<String> excludedGroups;
        @Generated
        private Date needRedeployAt;
        @Generated
        private boolean commentRequired;
        @Generated
        private String commentMessage;
        @Generated
        private String generalConditions;
        @Generated
        private Set<String> tags;
        @Generated
        private String selectionRule;

        @Generated
        protected B $fillValuesFrom(C instance) {
            BasePlanEntityBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(BasePlanEntity instance, BasePlanEntityBuilder<?, ?> b) {
            b.id(instance.id);
            b.definitionVersion(instance.definitionVersion);
            b.crossId(instance.crossId);
            b.name(instance.name);
            b.description(instance.description);
            b.validation(instance.validation);
            b.security(instance.security);
            b.securityDefinition(instance.securityDefinition);
            b.type(instance.type);
            b.status(instance.status);
            b.api(instance.api);
            b.environmentId(instance.environmentId);
            b.order(instance.order);
            b.createdAt(instance.createdAt);
            b.updatedAt(instance.updatedAt);
            b.publishedAt(instance.publishedAt);
            b.closedAt(instance.closedAt);
            b.paths(instance.paths);
            b.characteristics(instance.characteristics);
            b.excludedGroups(instance.excludedGroups);
            b.needRedeployAt(instance.needRedeployAt);
            b.commentRequired(instance.commentRequired);
            b.commentMessage(instance.commentMessage);
            b.generalConditions(instance.generalConditions);
            b.tags(instance.tags);
            b.selectionRule(instance.selectionRule);
        }

        @Generated
        public B id(String id) {
            this.id = id;
            return this.self();
        }

        @Generated
        public B definitionVersion(DefinitionVersion definitionVersion) {
            this.definitionVersion$value = definitionVersion;
            this.definitionVersion$set = true;
            return this.self();
        }

        @Generated
        public B crossId(String crossId) {
            this.crossId = crossId;
            return this.self();
        }

        @Generated
        public B name(String name) {
            this.name = name;
            return this.self();
        }

        @Generated
        public B description(String description) {
            this.description = description;
            return this.self();
        }

        @Generated
        public B validation(PlanValidationType validation) {
            this.validation = validation;
            return this.self();
        }

        @Generated
        public B security(PlanSecurityType security) {
            this.security = security;
            return this.self();
        }

        @Generated
        public B securityDefinition(String securityDefinition) {
            this.securityDefinition = securityDefinition;
            return this.self();
        }

        @Generated
        public B type(io.gravitee.rest.api.model.PlanType type) {
            this.type = type;
            return this.self();
        }

        @Generated
        public B status(PlanStatus status) {
            this.status = status;
            return this.self();
        }

        @Generated
        public B api(String api) {
            this.api = api;
            return this.self();
        }

        @Generated
        public B environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this.self();
        }

        @Generated
        public B order(int order) {
            this.order = order;
            return this.self();
        }

        @JsonProperty(value="created_at")
        @Generated
        public B createdAt(Date createdAt) {
            this.createdAt = createdAt;
            return this.self();
        }

        @JsonProperty(value="updated_at")
        @Generated
        public B updatedAt(Date updatedAt) {
            this.updatedAt = updatedAt;
            return this.self();
        }

        @JsonProperty(value="published_at")
        @Generated
        public B publishedAt(Date publishedAt) {
            this.publishedAt = publishedAt;
            return this.self();
        }

        @JsonProperty(value="closed_at")
        @Generated
        public B closedAt(Date closedAt) {
            this.closedAt = closedAt;
            return this.self();
        }

        @JsonProperty(value="paths", required=true)
        @Generated
        public B paths(Map<String, List<Rule>> paths) {
            this.paths = paths;
            return this.self();
        }

        @Generated
        public B characteristics(List<String> characteristics) {
            this.characteristics = characteristics;
            return this.self();
        }

        @JsonProperty(value="excluded_groups")
        @Generated
        public B excludedGroups(List<String> excludedGroups) {
            this.excludedGroups = excludedGroups;
            return this.self();
        }

        @JsonIgnore
        @Generated
        public B needRedeployAt(Date needRedeployAt) {
            this.needRedeployAt = needRedeployAt;
            return this.self();
        }

        @JsonProperty(value="comment_required")
        @Generated
        public B commentRequired(boolean commentRequired) {
            this.commentRequired = commentRequired;
            return this.self();
        }

        @JsonProperty(value="comment_message")
        @Generated
        public B commentMessage(String commentMessage) {
            this.commentMessage = commentMessage;
            return this.self();
        }

        @JsonProperty(value="general_conditions")
        @Generated
        public B generalConditions(String generalConditions) {
            this.generalConditions = generalConditions;
            return this.self();
        }

        @Generated
        public B tags(Set<String> tags) {
            this.tags = tags;
            return this.self();
        }

        @JsonProperty(value="selection_rule")
        @Generated
        public B selectionRule(String selectionRule) {
            this.selectionRule = selectionRule;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "BasePlanEntity.BasePlanEntityBuilder(id=" + this.id + ", definitionVersion$value=" + this.definitionVersion$value + ", crossId=" + this.crossId + ", name=" + this.name + ", description=" + this.description + ", validation=" + this.validation + ", security=" + this.security + ", securityDefinition=" + this.securityDefinition + ", type=" + this.type + ", status=" + this.status + ", api=" + this.api + ", environmentId=" + this.environmentId + ", order=" + this.order + ", createdAt=" + this.createdAt + ", updatedAt=" + this.updatedAt + ", publishedAt=" + this.publishedAt + ", closedAt=" + this.closedAt + ", paths=" + this.paths + ", characteristics=" + this.characteristics + ", excludedGroups=" + this.excludedGroups + ", needRedeployAt=" + this.needRedeployAt + ", commentRequired=" + this.commentRequired + ", commentMessage=" + this.commentMessage + ", generalConditions=" + this.generalConditions + ", tags=" + this.tags + ", selectionRule=" + this.selectionRule + ")";
        }
    }

    @Generated
    private static final class BasePlanEntityBuilderImpl
    extends BasePlanEntityBuilder<BasePlanEntity, BasePlanEntityBuilderImpl> {
        @Generated
        private BasePlanEntityBuilderImpl() {
        }

        @Override
        @Generated
        protected BasePlanEntityBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public BasePlanEntity build() {
            return new BasePlanEntity(this);
        }
    }
}

