/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.gravitee.definition.model.Rule;
import io.gravitee.definition.model.flow.Flow;
import io.gravitee.definition.model.v4.plan.PlanSecurity;
import io.gravitee.rest.api.model.DeploymentRequired;
import io.gravitee.rest.api.model.PlanSecurityType;
import io.gravitee.rest.api.model.PlanStatus;
import io.gravitee.rest.api.model.PlanValidationType;
import io.gravitee.rest.api.model.v4.plan.GenericPlanEntity;
import io.gravitee.rest.api.model.v4.plan.PlanMode;
import io.gravitee.rest.api.model.v4.plan.PlanType;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;

public class PlanEntity
implements GenericPlanEntity {
    private String id;
    private String crossId;
    @NotNull
    private String name;
    @NotNull
    private String description;
    @NotNull
    private PlanValidationType validation;
    @DeploymentRequired
    @NotNull
    private PlanSecurityType security;
    @DeploymentRequired
    private String securityDefinition;
    @NotNull
    private io.gravitee.rest.api.model.PlanType type;
    @DeploymentRequired
    @NotNull
    private PlanStatus status;
    @DeploymentRequired
    private String api;
    private int order;
    @JsonProperty(value="created_at")
    private Date createdAt;
    @JsonProperty(value="updated_at")
    private Date updatedAt;
    @JsonProperty(value="published_at")
    private Date publishedAt;
    @JsonProperty(value="closed_at")
    private Date closedAt;
    @DeploymentRequired
    @JsonProperty(value="paths", required=true)
    private Map<String, List<Rule>> paths = new HashMap<String, List<Rule>>();
    @DeploymentRequired
    @JsonProperty(value="flows", required=true)
    private List<Flow> flows = new ArrayList<Flow>();
    private List<String> characteristics;
    @JsonProperty(value="excluded_groups")
    private List<String> excludedGroups;
    @JsonIgnore
    private Date needRedeployAt;
    @JsonProperty(value="comment_required")
    private boolean commentRequired;
    @JsonProperty(value="comment_message")
    private String commentMessage;
    @JsonProperty(value="general_conditions")
    private String generalConditions;
    @DeploymentRequired
    private Set<String> tags;
    @DeploymentRequired
    @JsonProperty(value="selection_rule")
    private String selectionRule;

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public PlanValidationType getValidation() {
        return this.validation;
    }

    public void setValidation(PlanValidationType validation) {
        this.validation = validation;
    }

    public io.gravitee.rest.api.model.PlanType getType() {
        return this.type;
    }

    public void setType(io.gravitee.rest.api.model.PlanType type) {
        this.type = type;
    }

    public String getApi() {
        return this.api;
    }

    public void setApi(String api) {
        this.api = api;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    public Date getUpdatedAt() {
        return this.updatedAt;
    }

    public void setUpdatedAt(Date updatedAt) {
        this.updatedAt = updatedAt;
    }

    public Map<String, List<Rule>> getPaths() {
        return this.paths;
    }

    public void setPaths(Map<String, List<Rule>> paths) {
        this.paths = paths;
    }

    public List<Flow> getFlows() {
        return this.flows;
    }

    public void setFlows(List<Flow> flows) {
        this.flows = flows;
    }

    @Override
    public List<String> getCharacteristics() {
        return this.characteristics;
    }

    public void setCharacteristics(List<String> characteristics) {
        this.characteristics = characteristics;
    }

    @Override
    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public PlanStatus getStatus() {
        return this.status;
    }

    public void setStatus(PlanStatus status) {
        this.status = status;
    }

    public Date getPublishedAt() {
        return this.publishedAt;
    }

    public void setPublishedAt(Date publishedAt) {
        this.publishedAt = publishedAt;
    }

    public Date getClosedAt() {
        return this.closedAt;
    }

    public void setClosedAt(Date closedAt) {
        this.closedAt = closedAt;
    }

    public PlanSecurityType getSecurity() {
        return this.security;
    }

    public void setSecurity(PlanSecurityType security) {
        this.security = security;
    }

    public String getSecurityDefinition() {
        return this.securityDefinition;
    }

    public void setSecurityDefinition(String securityDefinition) {
        this.securityDefinition = securityDefinition;
    }

    @Override
    public List<String> getExcludedGroups() {
        return this.excludedGroups;
    }

    public void setExcludedGroups(List<String> excludedGroups) {
        this.excludedGroups = excludedGroups;
    }

    @Override
    public Date getNeedRedeployAt() {
        return this.needRedeployAt;
    }

    public void setNeedRedeployAt(Date needRedeployAt) {
        this.needRedeployAt = needRedeployAt;
    }

    @Override
    public boolean isCommentRequired() {
        return this.commentRequired;
    }

    public void setCommentRequired(boolean commentRequired) {
        this.commentRequired = commentRequired;
    }

    @Override
    public String getCommentMessage() {
        return this.commentMessage;
    }

    public void setCommentMessage(String commentMessage) {
        this.commentMessage = commentMessage;
    }

    public Set<String> getTags() {
        return this.tags;
    }

    public void setTags(Set<String> tags) {
        this.tags = tags;
    }

    public String getSelectionRule() {
        return this.selectionRule;
    }

    public void setSelectionRule(String selectionRule) {
        this.selectionRule = selectionRule;
    }

    @Override
    public String getGeneralConditions() {
        return this.generalConditions;
    }

    public void setGeneralConditions(String generalConditions) {
        this.generalConditions = generalConditions;
    }

    public String getCrossId() {
        return this.crossId;
    }

    public void setCrossId(String crossId) {
        this.crossId = crossId;
    }

    @Override
    @JsonIgnore
    public String getApiId() {
        return this.api;
    }

    @Override
    @JsonIgnore
    public PlanSecurity getPlanSecurity() {
        PlanSecurity planSecurity = new PlanSecurity();
        if (this.security != null) {
            planSecurity.setType(PlanSecurityType.valueOf(this.security.name()).name());
        }
        planSecurity.setConfiguration(this.securityDefinition);
        return planSecurity;
    }

    @Override
    @JsonIgnore
    public io.gravitee.definition.model.v4.plan.PlanStatus getPlanStatus() {
        if (this.status != null) {
            return io.gravitee.definition.model.v4.plan.PlanStatus.valueOfLabel((String)this.status.name());
        }
        return null;
    }

    @Override
    public PlanMode getPlanMode() {
        return PlanMode.STANDARD;
    }

    @Override
    @JsonIgnore
    public io.gravitee.rest.api.model.v4.plan.PlanValidationType getPlanValidation() {
        if (this.validation != null) {
            return io.gravitee.rest.api.model.v4.plan.PlanValidationType.valueOfLabel(this.validation.name());
        }
        return null;
    }

    @Override
    @JsonIgnore
    public PlanType getPlanType() {
        return PlanType.API;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PlanEntity that = (PlanEntity)o;
        return this.id.equals(that.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    @Generated
    public static PlanEntityBuilder builder() {
        return new PlanEntityBuilder();
    }

    @Generated
    public PlanEntityBuilder toBuilder() {
        return new PlanEntityBuilder().id(this.id).crossId(this.crossId).name(this.name).description(this.description).validation(this.validation).security(this.security).securityDefinition(this.securityDefinition).type(this.type).status(this.status).api(this.api).order(this.order).createdAt(this.createdAt).updatedAt(this.updatedAt).publishedAt(this.publishedAt).closedAt(this.closedAt).paths(this.paths).flows(this.flows).characteristics(this.characteristics).excludedGroups(this.excludedGroups).needRedeployAt(this.needRedeployAt).commentRequired(this.commentRequired).commentMessage(this.commentMessage).generalConditions(this.generalConditions).tags(this.tags).selectionRule(this.selectionRule);
    }

    @Generated
    public PlanEntity() {
    }

    @Generated
    public PlanEntity(String id, String crossId, String name, String description, PlanValidationType validation, PlanSecurityType security, String securityDefinition, io.gravitee.rest.api.model.PlanType type, PlanStatus status, String api, int order, Date createdAt, Date updatedAt, Date publishedAt, Date closedAt, Map<String, List<Rule>> paths, List<Flow> flows, List<String> characteristics, List<String> excludedGroups, Date needRedeployAt, boolean commentRequired, String commentMessage, String generalConditions, Set<String> tags, String selectionRule) {
        this.id = id;
        this.crossId = crossId;
        this.name = name;
        this.description = description;
        this.validation = validation;
        this.security = security;
        this.securityDefinition = securityDefinition;
        this.type = type;
        this.status = status;
        this.api = api;
        this.order = order;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.publishedAt = publishedAt;
        this.closedAt = closedAt;
        this.paths = paths;
        this.flows = flows;
        this.characteristics = characteristics;
        this.excludedGroups = excludedGroups;
        this.needRedeployAt = needRedeployAt;
        this.commentRequired = commentRequired;
        this.commentMessage = commentMessage;
        this.generalConditions = generalConditions;
        this.tags = tags;
        this.selectionRule = selectionRule;
    }

    @Generated
    public static class PlanEntityBuilder {
        @Generated
        private String id;
        @Generated
        private String crossId;
        @Generated
        private String name;
        @Generated
        private String description;
        @Generated
        private PlanValidationType validation;
        @Generated
        private PlanSecurityType security;
        @Generated
        private String securityDefinition;
        @Generated
        private io.gravitee.rest.api.model.PlanType type;
        @Generated
        private PlanStatus status;
        @Generated
        private String api;
        @Generated
        private int order;
        @Generated
        private Date createdAt;
        @Generated
        private Date updatedAt;
        @Generated
        private Date publishedAt;
        @Generated
        private Date closedAt;
        @Generated
        private Map<String, List<Rule>> paths;
        @Generated
        private List<Flow> flows;
        @Generated
        private List<String> characteristics;
        @Generated
        private List<String> excludedGroups;
        @Generated
        private Date needRedeployAt;
        @Generated
        private boolean commentRequired;
        @Generated
        private String commentMessage;
        @Generated
        private String generalConditions;
        @Generated
        private Set<String> tags;
        @Generated
        private String selectionRule;

        @Generated
        PlanEntityBuilder() {
        }

        @Generated
        public PlanEntityBuilder id(String id) {
            this.id = id;
            return this;
        }

        @Generated
        public PlanEntityBuilder crossId(String crossId) {
            this.crossId = crossId;
            return this;
        }

        @Generated
        public PlanEntityBuilder name(String name) {
            this.name = name;
            return this;
        }

        @Generated
        public PlanEntityBuilder description(String description) {
            this.description = description;
            return this;
        }

        @Generated
        public PlanEntityBuilder validation(PlanValidationType validation) {
            this.validation = validation;
            return this;
        }

        @Generated
        public PlanEntityBuilder security(PlanSecurityType security) {
            this.security = security;
            return this;
        }

        @Generated
        public PlanEntityBuilder securityDefinition(String securityDefinition) {
            this.securityDefinition = securityDefinition;
            return this;
        }

        @Generated
        public PlanEntityBuilder type(io.gravitee.rest.api.model.PlanType type) {
            this.type = type;
            return this;
        }

        @Generated
        public PlanEntityBuilder status(PlanStatus status) {
            this.status = status;
            return this;
        }

        @Generated
        public PlanEntityBuilder api(String api) {
            this.api = api;
            return this;
        }

        @Generated
        public PlanEntityBuilder order(int order) {
            this.order = order;
            return this;
        }

        @JsonProperty(value="created_at")
        @Generated
        public PlanEntityBuilder createdAt(Date createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        @JsonProperty(value="updated_at")
        @Generated
        public PlanEntityBuilder updatedAt(Date updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @JsonProperty(value="published_at")
        @Generated
        public PlanEntityBuilder publishedAt(Date publishedAt) {
            this.publishedAt = publishedAt;
            return this;
        }

        @JsonProperty(value="closed_at")
        @Generated
        public PlanEntityBuilder closedAt(Date closedAt) {
            this.closedAt = closedAt;
            return this;
        }

        @JsonProperty(value="paths", required=true)
        @Generated
        public PlanEntityBuilder paths(Map<String, List<Rule>> paths) {
            this.paths = paths;
            return this;
        }

        @JsonProperty(value="flows", required=true)
        @Generated
        public PlanEntityBuilder flows(List<Flow> flows) {
            this.flows = flows;
            return this;
        }

        @Generated
        public PlanEntityBuilder characteristics(List<String> characteristics) {
            this.characteristics = characteristics;
            return this;
        }

        @JsonProperty(value="excluded_groups")
        @Generated
        public PlanEntityBuilder excludedGroups(List<String> excludedGroups) {
            this.excludedGroups = excludedGroups;
            return this;
        }

        @JsonIgnore
        @Generated
        public PlanEntityBuilder needRedeployAt(Date needRedeployAt) {
            this.needRedeployAt = needRedeployAt;
            return this;
        }

        @JsonProperty(value="comment_required")
        @Generated
        public PlanEntityBuilder commentRequired(boolean commentRequired) {
            this.commentRequired = commentRequired;
            return this;
        }

        @JsonProperty(value="comment_message")
        @Generated
        public PlanEntityBuilder commentMessage(String commentMessage) {
            this.commentMessage = commentMessage;
            return this;
        }

        @JsonProperty(value="general_conditions")
        @Generated
        public PlanEntityBuilder generalConditions(String generalConditions) {
            this.generalConditions = generalConditions;
            return this;
        }

        @Generated
        public PlanEntityBuilder tags(Set<String> tags) {
            this.tags = tags;
            return this;
        }

        @JsonProperty(value="selection_rule")
        @Generated
        public PlanEntityBuilder selectionRule(String selectionRule) {
            this.selectionRule = selectionRule;
            return this;
        }

        @Generated
        public PlanEntity build() {
            return new PlanEntity(this.id, this.crossId, this.name, this.description, this.validation, this.security, this.securityDefinition, this.type, this.status, this.api, this.order, this.createdAt, this.updatedAt, this.publishedAt, this.closedAt, this.paths, this.flows, this.characteristics, this.excludedGroups, this.needRedeployAt, this.commentRequired, this.commentMessage, this.generalConditions, this.tags, this.selectionRule);
        }

        @Generated
        public String toString() {
            return "PlanEntity.PlanEntityBuilder(id=" + this.id + ", crossId=" + this.crossId + ", name=" + this.name + ", description=" + this.description + ", validation=" + this.validation + ", security=" + this.security + ", securityDefinition=" + this.securityDefinition + ", type=" + this.type + ", status=" + this.status + ", api=" + this.api + ", order=" + this.order + ", createdAt=" + this.createdAt + ", updatedAt=" + this.updatedAt + ", publishedAt=" + this.publishedAt + ", closedAt=" + this.closedAt + ", paths=" + this.paths + ", flows=" + this.flows + ", characteristics=" + this.characteristics + ", excludedGroups=" + this.excludedGroups + ", needRedeployAt=" + this.needRedeployAt + ", commentRequired=" + this.commentRequired + ", commentMessage=" + this.commentMessage + ", generalConditions=" + this.generalConditions + ", tags=" + this.tags + ", selectionRule=" + this.selectionRule + ")";
        }
    }
}

