/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.plugin.endpoint.http.proxy.configuration;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.gravitee.common.http.HttpHeader;
import io.gravitee.definition.model.v4.http.HttpProxyType;
import io.gravitee.definition.model.v4.http.ProtocolVersion;
import io.gravitee.definition.model.v4.ssl.KeyStore;
import io.gravitee.definition.model.v4.ssl.KeyStoreType;
import io.gravitee.definition.model.v4.ssl.TrustStore;
import io.gravitee.definition.model.v4.ssl.TrustStoreType;
import io.gravitee.definition.model.v4.ssl.jks.JKSKeyStore;
import io.gravitee.definition.model.v4.ssl.jks.JKSTrustStore;
import io.gravitee.definition.model.v4.ssl.none.NoneKeyStore;
import io.gravitee.definition.model.v4.ssl.none.NoneTrustStore;
import io.gravitee.definition.model.v4.ssl.pem.PEMKeyStore;
import io.gravitee.definition.model.v4.ssl.pem.PEMTrustStore;
import io.gravitee.definition.model.v4.ssl.pkcs12.PKCS12KeyStore;
import io.gravitee.definition.model.v4.ssl.pkcs12.PKCS12TrustStore;
import io.gravitee.gateway.reactive.api.ExecutionFailure;
import io.gravitee.gateway.reactive.api.context.DeploymentContext;
import io.gravitee.gateway.reactive.api.context.base.BaseExecutionContext;
import io.gravitee.gateway.reactive.api.context.http.HttpPlainExecutionContext;
import io.gravitee.plugin.endpoint.http.proxy.configuration.HttpProxyEndpointConnectorSharedConfiguration;
import io.gravitee.secrets.api.el.FieldKind;
import io.gravitee.secrets.api.el.SecretFieldAccessControl;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.CompletableSource;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Maybe;
import io.reactivex.rxjava3.core.Single;
import jakarta.validation.MessageInterpolator;
import jakarta.validation.Validation;
import jakarta.validation.Validator;
import jakarta.validation.ValidatorFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import org.hibernate.validator.HibernateValidator;
import org.hibernate.validator.HibernateValidatorConfiguration;
import org.hibernate.validator.messageinterpolation.ParameterMessageInterpolator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpProxyEndpointConnectorSharedConfigurationEvaluator {
    private static final String FAILURE_CONFIGURATION_INVALID = "FAILURE_CONFIGURATION_INVALID";
    private final Logger logger = LoggerFactory.getLogger(HttpProxyEndpointConnectorSharedConfigurationEvaluator.class);
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final HttpProxyEndpointConnectorSharedConfiguration configuration;
    private static final Validator validator;
    private final String attributePrefix = "gravitee.attributes.endpoint.httpProxy";
    private final String internalId;

    public HttpProxyEndpointConnectorSharedConfigurationEvaluator(HttpProxyEndpointConnectorSharedConfiguration configuration) {
        this.configuration = configuration;
        this.internalId = UUID.randomUUID().toString();
    }

    private String buildAttributeName(String attributePrefix, String name) {
        return attributePrefix.concat(".").concat(name);
    }

    private String buildFieldName(String attributeName) {
        return attributeName.substring(this.attributePrefix.length() + 1);
    }

    private Maybe<String> evalStringProperty(String name, String value, String attributePrefix, BaseExecutionContext ctx, String secretKind) {
        String attributeName = this.buildAttributeName(attributePrefix, name);
        String attribute = (String)ctx.getAttribute(attributeName);
        if (attribute != null) {
            value = attribute;
        }
        if (value == null) {
            return Maybe.empty();
        }
        SecretFieldAccessControl accessControl = secretKind.isEmpty() ? new SecretFieldAccessControl(false, null, null) : new SecretFieldAccessControl(true, FieldKind.valueOf((String)secretKind), this.buildFieldName(attributeName));
        String finalValue = value;
        return ctx.getTemplateEngine().eval(value, String.class).doOnSubscribe(d -> ctx.getTemplateEngine().getTemplateContext().setVariable("secret_field_access_control_var", (Object)accessControl)).doOnTerminate(() -> ctx.getTemplateEngine().getTemplateContext().setVariable("secret_field_access_control_var", null)).doOnError(throwable -> this.logger.error("Unable to evaluate property [{}] with expression [{}].", (Object)name, (Object)finalValue));
    }

    private Maybe<String> evalStringProperty(String name, String value, String attributePrefix, DeploymentContext ctx, String secretKind) {
        if (value == null) {
            return Maybe.empty();
        }
        String property = this.buildFieldName(this.buildAttributeName(attributePrefix, name));
        SecretFieldAccessControl accessControl = secretKind.isEmpty() ? new SecretFieldAccessControl(false, null, null) : new SecretFieldAccessControl(true, FieldKind.valueOf((String)secretKind), property);
        return ctx.getTemplateEngine().eval(value, String.class).doOnSubscribe(d -> ctx.getTemplateEngine().getTemplateContext().setVariable("secret_field_access_control_var", (Object)accessControl)).doOnTerminate(() -> ctx.getTemplateEngine().getTemplateContext().setVariable("secret_field_access_control_var", null)).doOnError(throwable -> this.logger.error("Unable to evaluate property [{}] with expression [{}].", (Object)property, (Object)value));
    }

    private <T extends Enum<T>> T evalEnumProperty(String name, T value, Class<T> enumClass, String attributePrefix, BaseExecutionContext ctx) {
        String attribute = (String)ctx.getAttribute(this.buildAttributeName(attributePrefix, name));
        if (attribute != null) {
            return Enum.valueOf(enumClass, attribute);
        }
        return value;
    }

    private Integer evalIntegerProperty(String name, Integer value, String attributePrefix, BaseExecutionContext ctx) {
        Integer attribute = (Integer)ctx.getAttribute(this.buildAttributeName(attributePrefix, name));
        if (attribute != null) {
            return attribute;
        }
        return value;
    }

    private Long evalLongProperty(String name, Long value, String attributePrefix, BaseExecutionContext ctx) {
        Long attribute = (Long)ctx.getAttribute(this.buildAttributeName(attributePrefix, name));
        if (attribute != null) {
            return attribute;
        }
        return value;
    }

    private Boolean evalBooleanProperty(String name, Boolean value, String attributePrefix, BaseExecutionContext ctx) {
        Boolean attribute = (Boolean)ctx.getAttribute(this.buildAttributeName(attributePrefix, name));
        if (attribute != null) {
            return attribute;
        }
        return value;
    }

    private <T> Set<T> evalSetProperty(String name, Set<T> value, String attributePrefix, BaseExecutionContext ctx) {
        block3: {
            try {
                Set attribute = (Set)ctx.getAttribute(this.buildAttributeName(attributePrefix, name));
                if (attribute != null) {
                    return attribute;
                }
            }
            catch (ClassCastException cce) {
                List attribute = ctx.getAttributeAsList(this.buildAttributeName(attributePrefix, name));
                if (attribute == null) break block3;
                return Set.copyOf(attribute);
            }
        }
        return value;
    }

    private <T> List<T> evalListProperty(String name, List<T> value, String attributePrefix, BaseExecutionContext ctx) {
        List attribute = ctx.getAttributeAsList(this.buildAttributeName(attributePrefix, name));
        if (attribute != null) {
            return attribute;
        }
        return value;
    }

    private Maybe<List<String>> evalListStringProperty(String name, List<String> value, String attributePrefix, BaseExecutionContext ctx) {
        List attribute = ctx.getAttributeAsList(this.buildAttributeName(attributePrefix, name));
        if (attribute != null) {
            value = attribute;
        }
        if (value == null) {
            return Maybe.empty();
        }
        return Flowable.fromIterable((Iterable)value).filter(Objects::nonNull).flatMapMaybe(v -> ctx.getTemplateEngine().eval(v, String.class).doOnError(throwable -> this.logger.error("Unable to evaluate property [{}] with expression [{}].", (Object)name, v))).toList().toMaybe();
    }

    private Maybe<List<String>> evalListStringProperty(String name, List<String> value, String attributePrefix, DeploymentContext ctx) {
        if (value == null) {
            return Maybe.empty();
        }
        return Flowable.fromIterable(value).filter(Objects::nonNull).flatMapMaybe(v -> ctx.getTemplateEngine().eval(v, String.class).doOnError(throwable -> this.logger.error("Unable to evaluate property [{}] with expression [{}].", (Object)name, v))).toList().toMaybe();
    }

    private Maybe<List<HttpHeader>> evalListHeaderProperty(String name, List<HttpHeader> headers, String attributePrefix, BaseExecutionContext ctx) {
        String attributeName = this.buildAttributeName(attributePrefix, name);
        List attribute = (List)ctx.getAttribute(attributeName);
        if (attribute != null) {
            headers = attribute;
        }
        if (headers == null) {
            return Maybe.empty();
        }
        return Flowable.fromIterable((Iterable)headers).filter(Objects::nonNull).flatMapMaybe(header -> {
            SecretFieldAccessControl accessControl = new SecretFieldAccessControl(true, FieldKind.HEADER, header.getName());
            return ctx.getTemplateEngine().eval(header.getValue(), String.class).doOnSubscribe(d -> ctx.getTemplateEngine().getTemplateContext().setVariable("secret_field_access_control_var", (Object)accessControl)).doOnTerminate(() -> ctx.getTemplateEngine().getTemplateContext().setVariable("secret_field_access_control_var", null)).map(evaluatedValue -> new HttpHeader(header.getName(), evaluatedValue)).doOnError(throwable -> this.logger.error("Unable to evaluate property [{}] with expression [{}].", (Object)name, (Object)header.getValue()));
        }).toList().toMaybe();
    }

    private Maybe<List<HttpHeader>> evalListHeaderProperty(String name, List<HttpHeader> headers, String attributePrefix, DeploymentContext ctx) {
        if (headers == null) {
            return Maybe.empty();
        }
        return Flowable.fromIterable(headers).filter(Objects::nonNull).flatMapMaybe(header -> {
            SecretFieldAccessControl accessControl = new SecretFieldAccessControl(true, FieldKind.HEADER, header.getName());
            return ctx.getTemplateEngine().eval(header.getValue(), String.class).doOnSubscribe(d -> ctx.getTemplateEngine().getTemplateContext().setVariable("secret_field_access_control_var", (Object)accessControl)).doOnTerminate(() -> ctx.getTemplateEngine().getTemplateContext().setVariable("secret_field_access_control_var", null)).map(evaluatedValue -> new HttpHeader(header.getName(), evaluatedValue)).doOnError(throwable -> this.logger.error("Unable to evaluate property [{}] with expression [{}].", (Object)name, (Object)header.getValue()));
        }).toList().toMaybe();
    }

    private Maybe<Map<String, String>> evalMapStringProperty(String name, Map<String, String> value, String attributePrefix, BaseExecutionContext ctx) {
        Map attribute = (Map)ctx.getAttribute(this.buildAttributeName(attributePrefix, name));
        if (attribute != null) {
            value = attribute;
        }
        if (value == null) {
            return Maybe.empty();
        }
        return Flowable.fromIterable(value.entrySet()).filter(Objects::nonNull).flatMapMaybe(entry -> {
            SecretFieldAccessControl accessControl = new SecretFieldAccessControl(true, FieldKind.GENERIC, (String)entry.getKey());
            return ctx.getTemplateEngine().eval((String)entry.getValue(), String.class).doOnSubscribe(d -> ctx.getTemplateEngine().getTemplateContext().setVariable("secret_field_access_control_var", (Object)accessControl)).doOnTerminate(() -> ctx.getTemplateEngine().getTemplateContext().setVariable("secret_field_access_control_var", null)).map(evaluatedValue -> Map.entry((String)entry.getKey(), evaluatedValue)).doOnError(throwable -> this.logger.error("Unable to evaluate property [{}] with expression [{}].", (Object)name, entry.getValue()));
        }).collect(() -> new HashMap(), (map, entry) -> map.put((String)entry.getKey(), (String)entry.getValue())).toMaybe();
    }

    private Maybe<Map<String, String>> evalMapStringProperty(String name, Map<String, String> value, String attributePrefix, DeploymentContext ctx) {
        if (value == null) {
            return Maybe.empty();
        }
        return Flowable.fromIterable(value.entrySet()).filter(Objects::nonNull).flatMapMaybe(entry -> {
            SecretFieldAccessControl accessControl = new SecretFieldAccessControl(true, FieldKind.GENERIC, (String)entry.getKey());
            return ctx.getTemplateEngine().eval((String)entry.getValue(), String.class).doOnSubscribe(d -> ctx.getTemplateEngine().getTemplateContext().setVariable("secret_field_access_control_var", (Object)accessControl)).doOnTerminate(() -> ctx.getTemplateEngine().getTemplateContext().setVariable("secret_field_access_control_var", null)).map(evaluatedValue -> Map.entry((String)entry.getKey(), evaluatedValue)).doOnError(throwable -> this.logger.error("Unable to evaluate property [{}] with expression [{}].", (Object)name, entry.getValue()));
        }).collect(() -> new HashMap(), (map, entry) -> map.put((String)entry.getKey(), (String)entry.getValue())).toMaybe();
    }

    private <T> void validateConfiguration(T configuration) {
        Set constraintViolations = validator.validate(configuration, new Class[0]);
        if (!constraintViolations.isEmpty()) {
            StringBuilder exceptionMessage = new StringBuilder(constraintViolations.size() + " constraint violations found : ");
            constraintViolations.forEach(violation -> exceptionMessage.append("[attribute[").append(violation.getPropertyPath()).append("] reason[").append(violation.getMessage()).append("]]"));
            this.logger.error(exceptionMessage.toString());
            throw new IllegalStateException(exceptionMessage.toString());
        }
    }

    public HttpProxyEndpointConnectorSharedConfiguration evalNow(BaseExecutionContext ctx) {
        return (HttpProxyEndpointConnectorSharedConfiguration)this.eval(ctx).blockingGet();
    }

    public HttpProxyEndpointConnectorSharedConfiguration evalNow(DeploymentContext ctx) {
        return (HttpProxyEndpointConnectorSharedConfiguration)this.eval(ctx).blockingGet();
    }

    public Single<HttpProxyEndpointConnectorSharedConfiguration> eval(BaseExecutionContext ctx) {
        return this.eval(ctx, null);
    }

    public Single<HttpProxyEndpointConnectorSharedConfiguration> eval(DeploymentContext ctx) {
        return this.eval(null, ctx);
    }

    private Single<HttpProxyEndpointConnectorSharedConfiguration> eval(BaseExecutionContext baseExecutionContext, DeploymentContext deploymentContext) {
        HttpProxyEndpointConnectorSharedConfiguration evaluatedConfiguration;
        if (baseExecutionContext != null) {
            if ("gravitee.attributes.endpoint.httpProxy".isEmpty()) {
                return Single.error((Throwable)new IllegalArgumentException("@ConfigurationEvaluator(attributePrefix=\"...\") is required when using BaseExecutionContext."));
            }
            HttpProxyEndpointConnectorSharedConfiguration evaluatedConf = (HttpProxyEndpointConnectorSharedConfiguration)baseExecutionContext.getInternalAttribute("httpProxyEndpointConnectorSharedConfiguration-" + this.internalId);
            if (evaluatedConf != null) {
                return Single.just((Object)evaluatedConf);
            }
        }
        try {
            this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            evaluatedConfiguration = (HttpProxyEndpointConnectorSharedConfiguration)this.objectMapper.readValue(this.objectMapper.writeValueAsString((Object)this.configuration), HttpProxyEndpointConnectorSharedConfiguration.class);
        }
        catch (JsonProcessingException e) {
            this.logger.error("Unable to clone configuration", (Throwable)e);
            return Single.error((Throwable)e);
        }
        String currentAttributePrefix = "gravitee.attributes.endpoint.httpProxy";
        ArrayList<Maybe> toEval = new ArrayList<Maybe>();
        ArrayList toEvalList = new ArrayList();
        ArrayList<Maybe> toEvalHeaderList = new ArrayList<Maybe>();
        ArrayList toEvalMap = new ArrayList();
        if (baseExecutionContext != null) {
            toEvalHeaderList.add(this.evalListHeaderProperty("headers", this.configuration.getHeaders(), currentAttributePrefix, baseExecutionContext).doOnSuccess(value -> evaluatedConfiguration.setHeaders((List<HttpHeader>)value)));
        } else if (deploymentContext != null) {
            toEvalHeaderList.add(this.evalListHeaderProperty("headers", this.configuration.getHeaders(), currentAttributePrefix, deploymentContext).doOnSuccess(value -> evaluatedConfiguration.setHeaders((List<HttpHeader>)value)));
        }
        if (evaluatedConfiguration.getProxyOptions() != null) {
            currentAttributePrefix = "gravitee.attributes.endpoint.httpProxy".concat(".proxyOptions");
            if (baseExecutionContext != null) {
                evaluatedConfiguration.getProxyOptions().setEnabled(this.evalBooleanProperty("enabled", this.configuration.getProxyOptions().isEnabled(), currentAttributePrefix, baseExecutionContext).booleanValue());
            } else if (deploymentContext != null) {
                // empty if block
            }
            if (baseExecutionContext != null) {
                evaluatedConfiguration.getProxyOptions().setUseSystemProxy(this.evalBooleanProperty("useSystemProxy", this.configuration.getProxyOptions().isUseSystemProxy(), currentAttributePrefix, baseExecutionContext).booleanValue());
            } else if (deploymentContext != null) {
                // empty if block
            }
            if (baseExecutionContext != null) {
                toEval.add(this.evalStringProperty("host", this.configuration.getProxyOptions().getHost(), currentAttributePrefix, baseExecutionContext, "").doOnSuccess(value -> evaluatedConfiguration.getProxyOptions().setHost(value)));
            } else if (deploymentContext != null) {
                toEval.add(this.evalStringProperty("host", this.configuration.getProxyOptions().getHost(), currentAttributePrefix, deploymentContext, "").doOnSuccess(value -> evaluatedConfiguration.getProxyOptions().setHost(value)));
            }
            if (baseExecutionContext != null) {
                evaluatedConfiguration.getProxyOptions().setPort(this.evalIntegerProperty("port", this.configuration.getProxyOptions().getPort(), currentAttributePrefix, baseExecutionContext).intValue());
            } else if (deploymentContext != null) {
                // empty if block
            }
            if (baseExecutionContext != null) {
                toEval.add(this.evalStringProperty("username", this.configuration.getProxyOptions().getUsername(), currentAttributePrefix, baseExecutionContext, "GENERIC").doOnSuccess(value -> evaluatedConfiguration.getProxyOptions().setUsername(value)));
            } else if (deploymentContext != null) {
                toEval.add(this.evalStringProperty("username", this.configuration.getProxyOptions().getUsername(), currentAttributePrefix, deploymentContext, "GENERIC").doOnSuccess(value -> evaluatedConfiguration.getProxyOptions().setUsername(value)));
            }
            if (baseExecutionContext != null) {
                toEval.add(this.evalStringProperty("password", this.configuration.getProxyOptions().getPassword(), currentAttributePrefix, baseExecutionContext, "PASSWORD").doOnSuccess(value -> evaluatedConfiguration.getProxyOptions().setPassword(value)));
            } else if (deploymentContext != null) {
                toEval.add(this.evalStringProperty("password", this.configuration.getProxyOptions().getPassword(), currentAttributePrefix, deploymentContext, "PASSWORD").doOnSuccess(value -> evaluatedConfiguration.getProxyOptions().setPassword(value)));
            }
            if (baseExecutionContext != null) {
                evaluatedConfiguration.getProxyOptions().setType(this.evalEnumProperty("type", this.configuration.getProxyOptions().getType(), HttpProxyType.class, currentAttributePrefix, baseExecutionContext));
            } else if (deploymentContext != null) {
                // empty if block
            }
        }
        if (evaluatedConfiguration.getHttpOptions() != null) {
            currentAttributePrefix = "gravitee.attributes.endpoint.httpProxy".concat(".httpOptions");
            if (baseExecutionContext != null) {
                evaluatedConfiguration.getHttpOptions().setHttp2MultiplexingLimit(this.evalIntegerProperty("http2MultiplexingLimit", this.configuration.getHttpOptions().getHttp2MultiplexingLimit(), currentAttributePrefix, baseExecutionContext).intValue());
            } else if (deploymentContext != null) {
                // empty if block
            }
            if (baseExecutionContext != null) {
                evaluatedConfiguration.getHttpOptions().setHttp2ConnectionWindowSize(this.evalIntegerProperty("http2ConnectionWindowSize", this.configuration.getHttpOptions().getHttp2ConnectionWindowSize(), currentAttributePrefix, baseExecutionContext).intValue());
            } else if (deploymentContext != null) {
                // empty if block
            }
            if (baseExecutionContext != null) {
                evaluatedConfiguration.getHttpOptions().setHttp2StreamWindowSize(this.evalIntegerProperty("http2StreamWindowSize", this.configuration.getHttpOptions().getHttp2StreamWindowSize(), currentAttributePrefix, baseExecutionContext).intValue());
            } else if (deploymentContext != null) {
                // empty if block
            }
            if (baseExecutionContext != null) {
                evaluatedConfiguration.getHttpOptions().setHttp2MaxFrameSize(this.evalIntegerProperty("http2MaxFrameSize", this.configuration.getHttpOptions().getHttp2MaxFrameSize(), currentAttributePrefix, baseExecutionContext).intValue());
            } else if (deploymentContext != null) {
                // empty if block
            }
            if (baseExecutionContext != null) {
                evaluatedConfiguration.getHttpOptions().setIdleTimeout(this.evalLongProperty("idleTimeout", this.configuration.getHttpOptions().getIdleTimeout(), currentAttributePrefix, baseExecutionContext).longValue());
            } else if (deploymentContext != null) {
                // empty if block
            }
            if (baseExecutionContext != null) {
                evaluatedConfiguration.getHttpOptions().setKeepAliveTimeout(this.evalLongProperty("keepAliveTimeout", this.configuration.getHttpOptions().getKeepAliveTimeout(), currentAttributePrefix, baseExecutionContext).longValue());
            } else if (deploymentContext != null) {
                // empty if block
            }
            if (baseExecutionContext != null) {
                evaluatedConfiguration.getHttpOptions().setConnectTimeout(this.evalLongProperty("connectTimeout", this.configuration.getHttpOptions().getConnectTimeout(), currentAttributePrefix, baseExecutionContext).longValue());
            } else if (deploymentContext != null) {
                // empty if block
            }
            if (baseExecutionContext != null) {
                evaluatedConfiguration.getHttpOptions().setKeepAlive(this.evalBooleanProperty("keepAlive", this.configuration.getHttpOptions().isKeepAlive(), currentAttributePrefix, baseExecutionContext).booleanValue());
            } else if (deploymentContext != null) {
                // empty if block
            }
            if (baseExecutionContext != null) {
                evaluatedConfiguration.getHttpOptions().setReadTimeout(this.evalLongProperty("readTimeout", this.configuration.getHttpOptions().getReadTimeout(), currentAttributePrefix, baseExecutionContext).longValue());
            } else if (deploymentContext != null) {
                // empty if block
            }
            if (baseExecutionContext != null) {
                evaluatedConfiguration.getHttpOptions().setPipelining(this.evalBooleanProperty("pipelining", this.configuration.getHttpOptions().isPipelining(), currentAttributePrefix, baseExecutionContext).booleanValue());
            } else if (deploymentContext != null) {
                // empty if block
            }
            if (baseExecutionContext != null) {
                evaluatedConfiguration.getHttpOptions().setMaxConcurrentConnections(this.evalIntegerProperty("maxConcurrentConnections", this.configuration.getHttpOptions().getMaxConcurrentConnections(), currentAttributePrefix, baseExecutionContext).intValue());
            } else if (deploymentContext != null) {
                // empty if block
            }
            if (baseExecutionContext != null) {
                evaluatedConfiguration.getHttpOptions().setUseCompression(this.evalBooleanProperty("useCompression", this.configuration.getHttpOptions().isUseCompression(), currentAttributePrefix, baseExecutionContext).booleanValue());
            } else if (deploymentContext != null) {
                // empty if block
            }
            if (baseExecutionContext != null) {
                evaluatedConfiguration.getHttpOptions().setPropagateClientAcceptEncoding(this.evalBooleanProperty("propagateClientAcceptEncoding", this.configuration.getHttpOptions().isPropagateClientAcceptEncoding(), currentAttributePrefix, baseExecutionContext).booleanValue());
            } else if (deploymentContext != null) {
                // empty if block
            }
            if (baseExecutionContext != null) {
                evaluatedConfiguration.getHttpOptions().setPropagateClientHost(this.evalBooleanProperty("propagateClientHost", this.configuration.getHttpOptions().isPropagateClientHost(), currentAttributePrefix, baseExecutionContext).booleanValue());
            } else if (deploymentContext != null) {
                // empty if block
            }
            if (baseExecutionContext != null) {
                evaluatedConfiguration.getHttpOptions().setFollowRedirects(this.evalBooleanProperty("followRedirects", this.configuration.getHttpOptions().isFollowRedirects(), currentAttributePrefix, baseExecutionContext).booleanValue());
            } else if (deploymentContext != null) {
                // empty if block
            }
            if (baseExecutionContext != null) {
                evaluatedConfiguration.getHttpOptions().setClearTextUpgrade(this.evalBooleanProperty("clearTextUpgrade", this.configuration.getHttpOptions().isClearTextUpgrade(), currentAttributePrefix, baseExecutionContext).booleanValue());
            } else if (deploymentContext != null) {
                // empty if block
            }
            if (baseExecutionContext != null) {
                evaluatedConfiguration.getHttpOptions().setVersion(this.evalEnumProperty("version", this.configuration.getHttpOptions().getVersion(), ProtocolVersion.class, currentAttributePrefix, baseExecutionContext));
            } else if (deploymentContext != null) {
                // empty if block
            }
        }
        if (evaluatedConfiguration.getSslOptions() != null) {
            TrustStoreType type;
            currentAttributePrefix = "gravitee.attributes.endpoint.httpProxy".concat(".sslOptions");
            if (baseExecutionContext != null) {
                evaluatedConfiguration.getSslOptions().setTrustAll(this.evalBooleanProperty("trustAll", this.configuration.getSslOptions().isTrustAll(), currentAttributePrefix, baseExecutionContext).booleanValue());
            } else if (deploymentContext != null) {
                // empty if block
            }
            if (baseExecutionContext != null) {
                evaluatedConfiguration.getSslOptions().setHostnameVerifier(this.evalBooleanProperty("hostnameVerifier", this.configuration.getSslOptions().isHostnameVerifier(), currentAttributePrefix, baseExecutionContext).booleanValue());
            } else if (deploymentContext != null) {
                // empty if block
            }
            if (evaluatedConfiguration.getSslOptions().getTrustStore() != null) {
                currentAttributePrefix = "gravitee.attributes.endpoint.httpProxy".concat(".sslOptions.trustStore");
                type = this.configuration.getSslOptions().getTrustStore().getType();
                if (baseExecutionContext != null) {
                    type = this.evalEnumProperty("type", this.configuration.getSslOptions().getTrustStore().getType(), TrustStoreType.class, currentAttributePrefix, baseExecutionContext);
                }
                switch (type) {
                    case PEM: {
                        if (type != this.configuration.getSslOptions().getTrustStore().getType()) {
                            this.configuration.getSslOptions().setTrustStore((TrustStore)new PEMTrustStore());
                        }
                        if (baseExecutionContext != null) {
                            toEval.add(this.evalStringProperty("path", ((PEMTrustStore)this.configuration.getSslOptions().getTrustStore()).getPath(), currentAttributePrefix, baseExecutionContext, "GENERIC").doOnSuccess(value -> ((PEMTrustStore)evaluatedConfiguration.getSslOptions().getTrustStore()).setPath(value)));
                        } else if (deploymentContext != null) {
                            toEval.add(this.evalStringProperty("path", ((PEMTrustStore)this.configuration.getSslOptions().getTrustStore()).getPath(), currentAttributePrefix, deploymentContext, "GENERIC").doOnSuccess(value -> ((PEMTrustStore)evaluatedConfiguration.getSslOptions().getTrustStore()).setPath(value)));
                        }
                        if (baseExecutionContext != null) {
                            toEval.add(this.evalStringProperty("content", ((PEMTrustStore)this.configuration.getSslOptions().getTrustStore()).getContent(), currentAttributePrefix, baseExecutionContext, "GENERIC").doOnSuccess(value -> ((PEMTrustStore)evaluatedConfiguration.getSslOptions().getTrustStore()).setContent(value)));
                            break;
                        }
                        if (deploymentContext == null) break;
                        toEval.add(this.evalStringProperty("content", ((PEMTrustStore)this.configuration.getSslOptions().getTrustStore()).getContent(), currentAttributePrefix, deploymentContext, "GENERIC").doOnSuccess(value -> ((PEMTrustStore)evaluatedConfiguration.getSslOptions().getTrustStore()).setContent(value)));
                        break;
                    }
                    case PKCS12: {
                        if (type != this.configuration.getSslOptions().getTrustStore().getType()) {
                            this.configuration.getSslOptions().setTrustStore((TrustStore)new PKCS12TrustStore());
                        }
                        if (baseExecutionContext != null) {
                            toEval.add(this.evalStringProperty("path", ((PKCS12TrustStore)this.configuration.getSslOptions().getTrustStore()).getPath(), currentAttributePrefix, baseExecutionContext, "GENERIC").doOnSuccess(value -> ((PKCS12TrustStore)evaluatedConfiguration.getSslOptions().getTrustStore()).setPath(value)));
                        } else if (deploymentContext != null) {
                            toEval.add(this.evalStringProperty("path", ((PKCS12TrustStore)this.configuration.getSslOptions().getTrustStore()).getPath(), currentAttributePrefix, deploymentContext, "GENERIC").doOnSuccess(value -> ((PKCS12TrustStore)evaluatedConfiguration.getSslOptions().getTrustStore()).setPath(value)));
                        }
                        if (baseExecutionContext != null) {
                            toEval.add(this.evalStringProperty("content", ((PKCS12TrustStore)this.configuration.getSslOptions().getTrustStore()).getContent(), currentAttributePrefix, baseExecutionContext, "GENERIC").doOnSuccess(value -> ((PKCS12TrustStore)evaluatedConfiguration.getSslOptions().getTrustStore()).setContent(value)));
                        } else if (deploymentContext != null) {
                            toEval.add(this.evalStringProperty("content", ((PKCS12TrustStore)this.configuration.getSslOptions().getTrustStore()).getContent(), currentAttributePrefix, deploymentContext, "GENERIC").doOnSuccess(value -> ((PKCS12TrustStore)evaluatedConfiguration.getSslOptions().getTrustStore()).setContent(value)));
                        }
                        if (baseExecutionContext != null) {
                            toEval.add(this.evalStringProperty("password", ((PKCS12TrustStore)this.configuration.getSslOptions().getTrustStore()).getPassword(), currentAttributePrefix, baseExecutionContext, "PASSWORD").doOnSuccess(value -> ((PKCS12TrustStore)evaluatedConfiguration.getSslOptions().getTrustStore()).setPassword(value)));
                        } else if (deploymentContext != null) {
                            toEval.add(this.evalStringProperty("password", ((PKCS12TrustStore)this.configuration.getSslOptions().getTrustStore()).getPassword(), currentAttributePrefix, deploymentContext, "PASSWORD").doOnSuccess(value -> ((PKCS12TrustStore)evaluatedConfiguration.getSslOptions().getTrustStore()).setPassword(value)));
                        }
                        if (baseExecutionContext != null) {
                            toEval.add(this.evalStringProperty("alias", ((PKCS12TrustStore)this.configuration.getSslOptions().getTrustStore()).getAlias(), currentAttributePrefix, baseExecutionContext, "GENERIC").doOnSuccess(value -> ((PKCS12TrustStore)evaluatedConfiguration.getSslOptions().getTrustStore()).setAlias(value)));
                            break;
                        }
                        if (deploymentContext == null) break;
                        toEval.add(this.evalStringProperty("alias", ((PKCS12TrustStore)this.configuration.getSslOptions().getTrustStore()).getAlias(), currentAttributePrefix, deploymentContext, "GENERIC").doOnSuccess(value -> ((PKCS12TrustStore)evaluatedConfiguration.getSslOptions().getTrustStore()).setAlias(value)));
                        break;
                    }
                    case JKS: {
                        if (type != this.configuration.getSslOptions().getTrustStore().getType()) {
                            this.configuration.getSslOptions().setTrustStore((TrustStore)new JKSTrustStore());
                        }
                        if (baseExecutionContext != null) {
                            toEval.add(this.evalStringProperty("path", ((JKSTrustStore)this.configuration.getSslOptions().getTrustStore()).getPath(), currentAttributePrefix, baseExecutionContext, "GENERIC").doOnSuccess(value -> ((JKSTrustStore)evaluatedConfiguration.getSslOptions().getTrustStore()).setPath(value)));
                        } else if (deploymentContext != null) {
                            toEval.add(this.evalStringProperty("path", ((JKSTrustStore)this.configuration.getSslOptions().getTrustStore()).getPath(), currentAttributePrefix, deploymentContext, "GENERIC").doOnSuccess(value -> ((JKSTrustStore)evaluatedConfiguration.getSslOptions().getTrustStore()).setPath(value)));
                        }
                        if (baseExecutionContext != null) {
                            toEval.add(this.evalStringProperty("content", ((JKSTrustStore)this.configuration.getSslOptions().getTrustStore()).getContent(), currentAttributePrefix, baseExecutionContext, "GENERIC").doOnSuccess(value -> ((JKSTrustStore)evaluatedConfiguration.getSslOptions().getTrustStore()).setContent(value)));
                        } else if (deploymentContext != null) {
                            toEval.add(this.evalStringProperty("content", ((JKSTrustStore)this.configuration.getSslOptions().getTrustStore()).getContent(), currentAttributePrefix, deploymentContext, "GENERIC").doOnSuccess(value -> ((JKSTrustStore)evaluatedConfiguration.getSslOptions().getTrustStore()).setContent(value)));
                        }
                        if (baseExecutionContext != null) {
                            toEval.add(this.evalStringProperty("password", ((JKSTrustStore)this.configuration.getSslOptions().getTrustStore()).getPassword(), currentAttributePrefix, baseExecutionContext, "PASSWORD").doOnSuccess(value -> ((JKSTrustStore)evaluatedConfiguration.getSslOptions().getTrustStore()).setPassword(value)));
                        } else if (deploymentContext != null) {
                            toEval.add(this.evalStringProperty("password", ((JKSTrustStore)this.configuration.getSslOptions().getTrustStore()).getPassword(), currentAttributePrefix, deploymentContext, "PASSWORD").doOnSuccess(value -> ((JKSTrustStore)evaluatedConfiguration.getSslOptions().getTrustStore()).setPassword(value)));
                        }
                        if (baseExecutionContext != null) {
                            toEval.add(this.evalStringProperty("alias", ((JKSTrustStore)this.configuration.getSslOptions().getTrustStore()).getAlias(), currentAttributePrefix, baseExecutionContext, "GENERIC").doOnSuccess(value -> ((JKSTrustStore)evaluatedConfiguration.getSslOptions().getTrustStore()).setAlias(value)));
                            break;
                        }
                        if (deploymentContext == null) break;
                        toEval.add(this.evalStringProperty("alias", ((JKSTrustStore)this.configuration.getSslOptions().getTrustStore()).getAlias(), currentAttributePrefix, deploymentContext, "GENERIC").doOnSuccess(value -> ((JKSTrustStore)evaluatedConfiguration.getSslOptions().getTrustStore()).setAlias(value)));
                        break;
                    }
                    case NONE: {
                        if (type == this.configuration.getSslOptions().getTrustStore().getType()) break;
                        this.configuration.getSslOptions().setTrustStore((TrustStore)new NoneTrustStore());
                    }
                }
            }
            if (evaluatedConfiguration.getSslOptions().getKeyStore() != null) {
                currentAttributePrefix = "gravitee.attributes.endpoint.httpProxy".concat(".sslOptions.keyStore");
                type = this.configuration.getSslOptions().getKeyStore().getType();
                if (baseExecutionContext != null) {
                    type = this.evalEnumProperty("type", this.configuration.getSslOptions().getKeyStore().getType(), KeyStoreType.class, currentAttributePrefix, baseExecutionContext);
                }
                switch (1.$SwitchMap$io$gravitee$definition$model$v4$ssl$KeyStoreType[type.ordinal()]) {
                    case 1: {
                        if (type != this.configuration.getSslOptions().getKeyStore().getType()) {
                            this.configuration.getSslOptions().setKeyStore((KeyStore)new PEMKeyStore());
                        }
                        if (baseExecutionContext != null) {
                            toEval.add(this.evalStringProperty("keyPath", ((PEMKeyStore)this.configuration.getSslOptions().getKeyStore()).getKeyPath(), currentAttributePrefix, baseExecutionContext, "GENERIC").doOnSuccess(value -> ((PEMKeyStore)evaluatedConfiguration.getSslOptions().getKeyStore()).setKeyPath(value)));
                        } else if (deploymentContext != null) {
                            toEval.add(this.evalStringProperty("keyPath", ((PEMKeyStore)this.configuration.getSslOptions().getKeyStore()).getKeyPath(), currentAttributePrefix, deploymentContext, "GENERIC").doOnSuccess(value -> ((PEMKeyStore)evaluatedConfiguration.getSslOptions().getKeyStore()).setKeyPath(value)));
                        }
                        if (baseExecutionContext != null) {
                            toEval.add(this.evalStringProperty("keyContent", ((PEMKeyStore)this.configuration.getSslOptions().getKeyStore()).getKeyContent(), currentAttributePrefix, baseExecutionContext, "PRIVATE_KEY").doOnSuccess(value -> ((PEMKeyStore)evaluatedConfiguration.getSslOptions().getKeyStore()).setKeyContent(value)));
                        } else if (deploymentContext != null) {
                            toEval.add(this.evalStringProperty("keyContent", ((PEMKeyStore)this.configuration.getSslOptions().getKeyStore()).getKeyContent(), currentAttributePrefix, deploymentContext, "PRIVATE_KEY").doOnSuccess(value -> ((PEMKeyStore)evaluatedConfiguration.getSslOptions().getKeyStore()).setKeyContent(value)));
                        }
                        if (baseExecutionContext != null) {
                            toEval.add(this.evalStringProperty("certPath", ((PEMKeyStore)this.configuration.getSslOptions().getKeyStore()).getCertPath(), currentAttributePrefix, baseExecutionContext, "GENERIC").doOnSuccess(value -> ((PEMKeyStore)evaluatedConfiguration.getSslOptions().getKeyStore()).setCertPath(value)));
                        } else if (deploymentContext != null) {
                            toEval.add(this.evalStringProperty("certPath", ((PEMKeyStore)this.configuration.getSslOptions().getKeyStore()).getCertPath(), currentAttributePrefix, deploymentContext, "GENERIC").doOnSuccess(value -> ((PEMKeyStore)evaluatedConfiguration.getSslOptions().getKeyStore()).setCertPath(value)));
                        }
                        if (baseExecutionContext != null) {
                            toEval.add(this.evalStringProperty("certContent", ((PEMKeyStore)this.configuration.getSslOptions().getKeyStore()).getCertContent(), currentAttributePrefix, baseExecutionContext, "PUBLIC_KEY").doOnSuccess(value -> ((PEMKeyStore)evaluatedConfiguration.getSslOptions().getKeyStore()).setCertContent(value)));
                            break;
                        }
                        if (deploymentContext == null) break;
                        toEval.add(this.evalStringProperty("certContent", ((PEMKeyStore)this.configuration.getSslOptions().getKeyStore()).getCertContent(), currentAttributePrefix, deploymentContext, "PUBLIC_KEY").doOnSuccess(value -> ((PEMKeyStore)evaluatedConfiguration.getSslOptions().getKeyStore()).setCertContent(value)));
                        break;
                    }
                    case 2: {
                        if (type != this.configuration.getSslOptions().getKeyStore().getType()) {
                            this.configuration.getSslOptions().setKeyStore((KeyStore)new PKCS12KeyStore());
                        }
                        if (baseExecutionContext != null) {
                            toEval.add(this.evalStringProperty("path", ((PKCS12KeyStore)this.configuration.getSslOptions().getKeyStore()).getPath(), currentAttributePrefix, baseExecutionContext, "GENERIC").doOnSuccess(value -> ((PKCS12KeyStore)evaluatedConfiguration.getSslOptions().getKeyStore()).setPath(value)));
                        } else if (deploymentContext != null) {
                            toEval.add(this.evalStringProperty("path", ((PKCS12KeyStore)this.configuration.getSslOptions().getKeyStore()).getPath(), currentAttributePrefix, deploymentContext, "GENERIC").doOnSuccess(value -> ((PKCS12KeyStore)evaluatedConfiguration.getSslOptions().getKeyStore()).setPath(value)));
                        }
                        if (baseExecutionContext != null) {
                            toEval.add(this.evalStringProperty("content", ((PKCS12KeyStore)this.configuration.getSslOptions().getKeyStore()).getContent(), currentAttributePrefix, baseExecutionContext, "GENERIC").doOnSuccess(value -> ((PKCS12KeyStore)evaluatedConfiguration.getSslOptions().getKeyStore()).setContent(value)));
                        } else if (deploymentContext != null) {
                            toEval.add(this.evalStringProperty("content", ((PKCS12KeyStore)this.configuration.getSslOptions().getKeyStore()).getContent(), currentAttributePrefix, deploymentContext, "GENERIC").doOnSuccess(value -> ((PKCS12KeyStore)evaluatedConfiguration.getSslOptions().getKeyStore()).setContent(value)));
                        }
                        if (baseExecutionContext != null) {
                            toEval.add(this.evalStringProperty("password", ((PKCS12KeyStore)this.configuration.getSslOptions().getKeyStore()).getPassword(), currentAttributePrefix, baseExecutionContext, "PASSWORD").doOnSuccess(value -> ((PKCS12KeyStore)evaluatedConfiguration.getSslOptions().getKeyStore()).setPassword(value)));
                        } else if (deploymentContext != null) {
                            toEval.add(this.evalStringProperty("password", ((PKCS12KeyStore)this.configuration.getSslOptions().getKeyStore()).getPassword(), currentAttributePrefix, deploymentContext, "PASSWORD").doOnSuccess(value -> ((PKCS12KeyStore)evaluatedConfiguration.getSslOptions().getKeyStore()).setPassword(value)));
                        }
                        if (baseExecutionContext != null) {
                            toEval.add(this.evalStringProperty("alias", ((PKCS12KeyStore)this.configuration.getSslOptions().getKeyStore()).getAlias(), currentAttributePrefix, baseExecutionContext, "GENERIC").doOnSuccess(value -> ((PKCS12KeyStore)evaluatedConfiguration.getSslOptions().getKeyStore()).setAlias(value)));
                        } else if (deploymentContext != null) {
                            toEval.add(this.evalStringProperty("alias", ((PKCS12KeyStore)this.configuration.getSslOptions().getKeyStore()).getAlias(), currentAttributePrefix, deploymentContext, "GENERIC").doOnSuccess(value -> ((PKCS12KeyStore)evaluatedConfiguration.getSslOptions().getKeyStore()).setAlias(value)));
                        }
                        if (baseExecutionContext != null) {
                            toEval.add(this.evalStringProperty("keyPassword", ((PKCS12KeyStore)this.configuration.getSslOptions().getKeyStore()).getKeyPassword(), currentAttributePrefix, baseExecutionContext, "").doOnSuccess(value -> ((PKCS12KeyStore)evaluatedConfiguration.getSslOptions().getKeyStore()).setKeyPassword(value)));
                            break;
                        }
                        if (deploymentContext == null) break;
                        toEval.add(this.evalStringProperty("keyPassword", ((PKCS12KeyStore)this.configuration.getSslOptions().getKeyStore()).getKeyPassword(), currentAttributePrefix, deploymentContext, "").doOnSuccess(value -> ((PKCS12KeyStore)evaluatedConfiguration.getSslOptions().getKeyStore()).setKeyPassword(value)));
                        break;
                    }
                    case 3: {
                        if (type != this.configuration.getSslOptions().getKeyStore().getType()) {
                            this.configuration.getSslOptions().setKeyStore((KeyStore)new JKSKeyStore());
                        }
                        if (baseExecutionContext != null) {
                            toEval.add(this.evalStringProperty("path", ((JKSKeyStore)this.configuration.getSslOptions().getKeyStore()).getPath(), currentAttributePrefix, baseExecutionContext, "GENERIC").doOnSuccess(value -> ((JKSKeyStore)evaluatedConfiguration.getSslOptions().getKeyStore()).setPath(value)));
                        } else if (deploymentContext != null) {
                            toEval.add(this.evalStringProperty("path", ((JKSKeyStore)this.configuration.getSslOptions().getKeyStore()).getPath(), currentAttributePrefix, deploymentContext, "GENERIC").doOnSuccess(value -> ((JKSKeyStore)evaluatedConfiguration.getSslOptions().getKeyStore()).setPath(value)));
                        }
                        if (baseExecutionContext != null) {
                            toEval.add(this.evalStringProperty("content", ((JKSKeyStore)this.configuration.getSslOptions().getKeyStore()).getContent(), currentAttributePrefix, baseExecutionContext, "GENERIC").doOnSuccess(value -> ((JKSKeyStore)evaluatedConfiguration.getSslOptions().getKeyStore()).setContent(value)));
                        } else if (deploymentContext != null) {
                            toEval.add(this.evalStringProperty("content", ((JKSKeyStore)this.configuration.getSslOptions().getKeyStore()).getContent(), currentAttributePrefix, deploymentContext, "GENERIC").doOnSuccess(value -> ((JKSKeyStore)evaluatedConfiguration.getSslOptions().getKeyStore()).setContent(value)));
                        }
                        if (baseExecutionContext != null) {
                            toEval.add(this.evalStringProperty("password", ((JKSKeyStore)this.configuration.getSslOptions().getKeyStore()).getPassword(), currentAttributePrefix, baseExecutionContext, "PASSWORD").doOnSuccess(value -> ((JKSKeyStore)evaluatedConfiguration.getSslOptions().getKeyStore()).setPassword(value)));
                        } else if (deploymentContext != null) {
                            toEval.add(this.evalStringProperty("password", ((JKSKeyStore)this.configuration.getSslOptions().getKeyStore()).getPassword(), currentAttributePrefix, deploymentContext, "PASSWORD").doOnSuccess(value -> ((JKSKeyStore)evaluatedConfiguration.getSslOptions().getKeyStore()).setPassword(value)));
                        }
                        if (baseExecutionContext != null) {
                            toEval.add(this.evalStringProperty("alias", ((JKSKeyStore)this.configuration.getSslOptions().getKeyStore()).getAlias(), currentAttributePrefix, baseExecutionContext, "GENERIC").doOnSuccess(value -> ((JKSKeyStore)evaluatedConfiguration.getSslOptions().getKeyStore()).setAlias(value)));
                        } else if (deploymentContext != null) {
                            toEval.add(this.evalStringProperty("alias", ((JKSKeyStore)this.configuration.getSslOptions().getKeyStore()).getAlias(), currentAttributePrefix, deploymentContext, "GENERIC").doOnSuccess(value -> ((JKSKeyStore)evaluatedConfiguration.getSslOptions().getKeyStore()).setAlias(value)));
                        }
                        if (baseExecutionContext != null) {
                            toEval.add(this.evalStringProperty("keyPassword", ((JKSKeyStore)this.configuration.getSslOptions().getKeyStore()).getKeyPassword(), currentAttributePrefix, baseExecutionContext, "PASSWORD").doOnSuccess(value -> ((JKSKeyStore)evaluatedConfiguration.getSslOptions().getKeyStore()).setKeyPassword(value)));
                            break;
                        }
                        if (deploymentContext == null) break;
                        toEval.add(this.evalStringProperty("keyPassword", ((JKSKeyStore)this.configuration.getSslOptions().getKeyStore()).getKeyPassword(), currentAttributePrefix, deploymentContext, "PASSWORD").doOnSuccess(value -> ((JKSKeyStore)evaluatedConfiguration.getSslOptions().getKeyStore()).setKeyPassword(value)));
                        break;
                    }
                    case 4: {
                        if (type == this.configuration.getSslOptions().getKeyStore().getType()) break;
                        this.configuration.getSslOptions().setKeyStore((KeyStore)new NoneKeyStore());
                    }
                }
            }
        }
        Completable toEvalCompletable = Flowable.fromIterable(toEval).concatMapMaybe(m -> m).ignoreElements();
        Completable toEvalListCompletable = Flowable.fromIterable(toEvalList).concatMapMaybe(m -> m).ignoreElements();
        Completable toEvalHeaderListCompletable = Flowable.fromIterable(toEvalHeaderList).concatMapMaybe(m -> m).ignoreElements();
        Completable toEvalMapCompletable = Flowable.fromIterable(toEvalMap).concatMapMaybe(m -> m).ignoreElements();
        return Completable.concatArray((CompletableSource[])new CompletableSource[]{toEvalCompletable, toEvalListCompletable, toEvalHeaderListCompletable, toEvalMapCompletable}).andThen((CompletableSource)Completable.fromRunnable(() -> this.validateConfiguration(evaluatedConfiguration))).andThen((CompletableSource)Completable.fromRunnable(() -> {
            if (baseExecutionContext != null) {
                baseExecutionContext.setInternalAttribute("httpProxyEndpointConnectorSharedConfiguration-" + this.internalId, (Object)evaluatedConfiguration);
            }
        })).onErrorResumeNext(t -> {
            if (baseExecutionContext != null && baseExecutionContext instanceof HttpPlainExecutionContext) {
                HttpPlainExecutionContext httpPlainExecutionContext = (HttpPlainExecutionContext)baseExecutionContext;
                return httpPlainExecutionContext.interruptWith(new ExecutionFailure(500).message("Invalid configuration").key(FAILURE_CONFIGURATION_INVALID));
            }
            return Completable.error((Throwable)t);
        }).toSingle(() -> evaluatedConfiguration);
    }

    static {
        ValidatorFactory factory = ((HibernateValidatorConfiguration)((HibernateValidatorConfiguration)Validation.byProvider(HibernateValidator.class).configure()).messageInterpolator((MessageInterpolator)new ParameterMessageInterpolator())).buildValidatorFactory();
        validator = factory.getValidator();
    }
}

