/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.plugin.endpoint.http.proxy;

import io.gravitee.common.http.HttpHeader;
import io.gravitee.definition.model.v4.http.HttpProxyOptions;
import io.gravitee.el.TemplateEngine;
import io.gravitee.gateway.reactive.api.ConnectorMode;
import io.gravitee.gateway.reactive.api.connector.endpoint.sync.EndpointSyncConnectorFactory;
import io.gravitee.gateway.reactive.api.context.DeploymentContext;
import io.gravitee.gateway.reactive.api.helper.PluginConfigurationHelper;
import io.gravitee.plugin.endpoint.http.proxy.HttpProxyEndpointConnector;
import io.gravitee.plugin.endpoint.http.proxy.configuration.HttpProxyEndpointConnectorConfiguration;
import io.gravitee.plugin.endpoint.http.proxy.configuration.HttpProxyEndpointConnectorSharedConfiguration;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpProxyEndpointConnectorFactory
implements EndpointSyncConnectorFactory<HttpProxyEndpointConnector> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HttpProxyEndpointConnectorFactory.class);
    private final PluginConfigurationHelper connectorFactoryHelper;
    private final Set<ConnectorMode> SUPPORTED_MODES = Set.of(ConnectorMode.REQUEST_RESPONSE);

    public Set<ConnectorMode> supportedModes() {
        return this.SUPPORTED_MODES;
    }

    public HttpProxyEndpointConnector createConnector(DeploymentContext deploymentContext, String configuration, String sharedConfiguration) {
        try {
            return new HttpProxyEndpointConnector(this.eval(deploymentContext, (HttpProxyEndpointConnectorConfiguration)this.connectorFactoryHelper.readConfiguration(HttpProxyEndpointConnectorConfiguration.class, configuration)), this.eval(deploymentContext, (HttpProxyEndpointConnectorSharedConfiguration)this.connectorFactoryHelper.readConfiguration(HttpProxyEndpointConnectorSharedConfiguration.class, sharedConfiguration)));
        }
        catch (Exception e) {
            log.error("Can't create connector because no valid configuration", (Throwable)e);
            return null;
        }
    }

    private HttpProxyEndpointConnectorConfiguration eval(DeploymentContext deploymentContext, HttpProxyEndpointConnectorConfiguration configuration) {
        configuration.setTarget(this.eval(deploymentContext.getTemplateEngine(), configuration.getTarget()));
        return configuration;
    }

    private HttpProxyEndpointConnectorSharedConfiguration eval(DeploymentContext deploymentContext, HttpProxyEndpointConnectorSharedConfiguration groupConfiguration) {
        TemplateEngine templateEngine = deploymentContext.getTemplateEngine();
        HttpProxyOptions proxyOptions = groupConfiguration.getProxyOptions();
        List<HttpHeader> headers = groupConfiguration.getHeaders();
        if (proxyOptions != null) {
            proxyOptions.setHost(this.eval(templateEngine, proxyOptions.getHost()));
            proxyOptions.setUsername(this.eval(templateEngine, proxyOptions.getUsername()));
            proxyOptions.setPassword(this.eval(templateEngine, proxyOptions.getPassword()));
        }
        if (headers != null && !headers.isEmpty()) {
            headers.forEach(httpHeader -> httpHeader.setValue(this.eval(templateEngine, httpHeader.getValue())));
        }
        return groupConfiguration;
    }

    private String eval(TemplateEngine templateEngine, String value) {
        if (value != null && !value.isEmpty()) {
            return templateEngine.convert(value);
        }
        return value;
    }

    @Generated
    public HttpProxyEndpointConnectorFactory(PluginConfigurationHelper connectorFactoryHelper) {
        this.connectorFactoryHelper = connectorFactoryHelper;
    }
}

