/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.plugin.endpoint.http.proxy.client;

import io.gravitee.gateway.reactive.api.context.ExecutionContext;
import io.gravitee.gateway.reactive.http.vertx.client.VertxHttpClient;
import io.gravitee.node.api.configuration.Configuration;
import io.gravitee.plugin.endpoint.http.proxy.configuration.HttpProxyEndpointConnectorConfiguration;
import io.gravitee.plugin.endpoint.http.proxy.configuration.HttpProxyEndpointConnectorSharedConfiguration;
import io.vertx.rxjava3.core.Vertx;
import io.vertx.rxjava3.core.http.HttpClient;
import java.util.concurrent.atomic.AtomicBoolean;

public class HttpClientFactory {
    private HttpClient httpClient;
    private final AtomicBoolean httpClientCreated = new AtomicBoolean(false);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpClient getOrBuildHttpClient(ExecutionContext ctx, HttpProxyEndpointConnectorConfiguration configuration, HttpProxyEndpointConnectorSharedConfiguration sharedConfiguration) {
        if (this.httpClient == null) {
            HttpClientFactory httpClientFactory = this;
            synchronized (httpClientFactory) {
                if (this.httpClientCreated.compareAndSet(false, true)) {
                    this.httpClient = this.buildHttpClient(ctx, configuration, sharedConfiguration).build().createHttpClient();
                }
            }
        }
        return this.httpClient;
    }

    protected VertxHttpClient.VertxHttpClientBuilder buildHttpClient(ExecutionContext ctx, HttpProxyEndpointConnectorConfiguration configuration, HttpProxyEndpointConnectorSharedConfiguration sharedConfiguration) {
        return VertxHttpClient.builder().vertx((Vertx)ctx.getComponent(Vertx.class)).nodeConfiguration((Configuration)ctx.getComponent(Configuration.class)).defaultTarget(configuration.getTarget()).httpOptions(sharedConfiguration.getHttpOptions()).sslOptions(sharedConfiguration.getSslOptions()).proxyOptions(sharedConfiguration.getProxyOptions());
    }

    public void close() {
        if (this.httpClient != null) {
            this.httpClient.close();
            this.httpClient = null;
        }
    }
}

