/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.plugin.endpoint.internal;

import io.gravitee.gateway.reactive.api.connector.endpoint.BaseEndpointConnectorFactory;
import io.gravitee.gateway.reactive.api.helper.PluginConfigurationHelper;
import io.gravitee.plugin.core.api.AbstractConfigurablePluginManager;
import io.gravitee.plugin.core.api.PluginClassLoader;
import io.gravitee.plugin.endpoint.EndpointConnectorClassLoaderFactory;
import io.gravitee.plugin.endpoint.EndpointConnectorPlugin;
import io.gravitee.plugin.endpoint.EndpointConnectorPluginManager;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultEndpointConnectorPluginManager
extends AbstractConfigurablePluginManager<EndpointConnectorPlugin<?, ?>>
implements EndpointConnectorPluginManager {
    private static final Logger logger = LoggerFactory.getLogger(DefaultEndpointConnectorPluginManager.class);
    private final EndpointConnectorClassLoaderFactory classLoaderFactory;
    private final Map<String, BaseEndpointConnectorFactory<?>> factories = new HashMap();
    private final Map<String, BaseEndpointConnectorFactory<?>> notDeployedPluginFactories = new HashMap();
    private final PluginConfigurationHelper pluginConfigurationHelper;

    public DefaultEndpointConnectorPluginManager(EndpointConnectorClassLoaderFactory classLoaderFactory, PluginConfigurationHelper pluginConfigurationHelper) {
        this.classLoaderFactory = classLoaderFactory;
        this.pluginConfigurationHelper = pluginConfigurationHelper;
    }

    public void register(EndpointConnectorPlugin<?, ?> plugin) {
        super.register(plugin);
        PluginClassLoader pluginClassLoader = this.classLoaderFactory.getOrCreateClassLoader(plugin);
        try {
            Class connectorFactoryClass = pluginClassLoader.loadClass(plugin.clazz());
            BaseEndpointConnectorFactory<?> factory = this.createFactory(connectorFactoryClass);
            if (plugin.deployed()) {
                this.factories.put(plugin.id(), factory);
            } else {
                this.notDeployedPluginFactories.put(plugin.id(), factory);
            }
        }
        catch (Exception ex) {
            logger.error("Unexpected error while loading endpoint plugin: {}", (Object)plugin.clazz(), (Object)ex);
        }
    }

    private BaseEndpointConnectorFactory<?> createFactory(Class<BaseEndpointConnectorFactory<?>> connectorFactoryClass) throws InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        BaseEndpointConnectorFactory<?> factory;
        try {
            Constructor<BaseEndpointConnectorFactory<?>> constructorWithConfigurationHelper = connectorFactoryClass.getDeclaredConstructor(PluginConfigurationHelper.class);
            factory = constructorWithConfigurationHelper.newInstance(this.pluginConfigurationHelper);
        }
        catch (NoSuchMethodException e) {
            Constructor<BaseEndpointConnectorFactory<?>> emptyConstructor = connectorFactoryClass.getDeclaredConstructor(new Class[0]);
            factory = emptyConstructor.newInstance(new Object[0]);
        }
        return factory;
    }

    public BaseEndpointConnectorFactory<?> getFactoryById(String endpointPluginId) {
        return this.getFactoryById(endpointPluginId, false);
    }

    public BaseEndpointConnectorFactory<?> getFactoryById(String endpointPluginId, boolean includeNotDeployed) {
        BaseEndpointConnectorFactory<?> factory = this.factories.get(endpointPluginId);
        if (factory == null && includeNotDeployed) {
            return this.notDeployedPluginFactories.get(endpointPluginId);
        }
        return factory;
    }

    @Override
    public String getSharedConfigurationSchema(String pluginId, boolean includeNotDeployed) throws IOException {
        String schemaByPropertyKey = this.getSchema(pluginId, "schema.sharedConfiguration", false, includeNotDeployed);
        if (schemaByPropertyKey != null) {
            return schemaByPropertyKey;
        }
        return this.getSchema(pluginId, "sharedConfiguration", includeNotDeployed);
    }
}

