/*
 * Decompiled with CFR 0.152.
 */
package com.android.base.image.glide;

import android.os.SystemClock;
import androidx.annotation.NonNull;
import com.android.base.image.ProgressInfo;
import java.io.IOException;
import okhttp3.MediaType;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSource;
import okio.ForwardingSource;
import okio.Okio;
import okio.Source;

abstract class ProgressResponseBody
extends ResponseBody {
    private final int mRefreshTime;
    private final ResponseBody mDelegate;
    private BufferedSource mBufferedSource;
    private final ProgressInfo mProgressInfo;

    ProgressResponseBody(ResponseBody responseBody, int refreshTime) {
        this.mDelegate = responseBody;
        this.mRefreshTime = refreshTime;
        this.mProgressInfo = new ProgressInfo(System.currentTimeMillis());
    }

    public MediaType contentType() {
        return this.mDelegate.contentType();
    }

    public long contentLength() {
        return this.mDelegate.contentLength();
    }

    @NonNull
    public BufferedSource source() {
        if (this.mBufferedSource == null) {
            this.mBufferedSource = Okio.buffer((Source)this.source((Source)this.mDelegate.source()));
        }
        return this.mBufferedSource;
    }

    private Source source(Source source) {
        return new ForwardingSource(source){
            private long mContentLength;
            private long totalBytesRead;
            private long lastRefreshTime;
            {
                this.totalBytesRead = 0L;
                this.lastRefreshTime = 0L;
            }

            public long read(@NonNull Buffer sink, long byteCount) throws IOException {
                long bytesRead;
                try {
                    bytesRead = super.read(sink, byteCount);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    ProgressResponseBody.this.onError(ProgressResponseBody.this.mProgressInfo.getId(), e);
                    throw e;
                }
                if (this.mContentLength == 0L) {
                    this.mContentLength = ProgressResponseBody.this.contentLength();
                    ProgressResponseBody.this.mProgressInfo.setContentLength(this.mContentLength);
                }
                this.totalBytesRead += bytesRead != -1L ? bytesRead : 0L;
                long curTime = SystemClock.elapsedRealtime();
                long intervalTime = curTime - this.lastRefreshTime;
                if (intervalTime >= (long)ProgressResponseBody.this.mRefreshTime || bytesRead == -1L || this.totalBytesRead == this.mContentLength) {
                    boolean finish = bytesRead == -1L && this.totalBytesRead == this.mContentLength;
                    ProgressResponseBody.this.mProgressInfo.setCurrentBytes(this.totalBytesRead);
                    ProgressResponseBody.this.mProgressInfo.setIntervalTime(intervalTime);
                    ProgressResponseBody.this.mProgressInfo.setFinish(finish);
                    ProgressResponseBody.this.mProgressInfo.setEachBytes(bytesRead);
                    ProgressResponseBody.this.onProgress(ProgressResponseBody.this.mProgressInfo);
                    this.lastRefreshTime = curTime;
                }
                return bytesRead;
            }
        };
    }

    protected abstract void onError(long var1, Exception var3);

    abstract void onProgress(ProgressInfo var1);
}

